//: version "2.0"
//: property prefix = "_GG"
//: property title = "edwire_tut.v"
//: property useExtBars = 0
//: property discardChanges = 1

//: /netlistBegin main
module main;    //: root_module
wire w32;    //: /sn:0 {0}(631,288)(641,288){1}
wire w6;    //: /sn:0 {0}(483,145)(523,145)(523,128)(548,128)(548,140)(573,140)(573,190)(499,190)(499,160){1}
wire w7;    //: /sn:0 {0}(477,423)(487,423){1}
wire w46;    //: /sn:0 {0}(731,563)(688,563)(688,554){1}
//: {2}(690,552)(704,552)(704,514)(729,514){3}
//: {4}(686,552)(653,552){5}
wire w16;    //: /sn:0 {0}(550,96)(560,96){1}
wire w14;    //: /sn:0 {0}(529,93)(519,93)(519,74)(538,74)(538,41)(485,41){1}
wire w19;    //: /sn:0 {0}(611,425)(621,425){1}
wire w15;    //: /sn:0 {0}(519,98)(529,98){1}
wire w4;    //: /sn:0 {0}(452,147)(462,147){1}
wire w38;    //: /sn:0 {0}(754,387)(764,387){1}
wire w0;    //: /sn:0 {0}(452,142)(462,142){1}
wire w3;    //: /sn:0 {0}(482,280)(523,280){1}
//: {2}(527,280)(580,280){3}
//: {4}(525,278)(525,234)(555,234){5}
wire w37;    //: /sn:0 {0}(728,387)(738,387){1}
wire w34;    //: /sn:0 {0}(751,356)(761,356){1}
wire w43;    //: /sn:0 {0}(622,549)(632,549){1}
wire w21;    //: /sn:0 {0}(611,463)(621,463){1}
wire w31;    //: /sn:0 {0}(631,283)(641,283){1}
wire w28;    //: /sn:0 {0}(662,286)(703,286){1}
//: {2}(707,286)(760,286){3}
//: {4}(705,284)(705,240)(735,240){5}
wire w36;    //: /sn:0 {0}(639,358)(649,358){1}
wire w41;    //: /sn:0 {0}(499,551)(509,551){1}
wire w23;    //: /sn:0 {0}(544,383)(554,383){1}
wire w24;    //: /sn:0 {0}(554,355)(531,355){1}
//: {2}(529,353)(529,324)(555,324){3}
//: {4}(527,355)(489,355){5}
wire w20;    //: /sn:0 {0}(595,463)(583,463)(583,425)(595,425){1}
wire w1;    //: /sn:0 {0}(451,277)(461,277){1}
wire w25;    //: /sn:0 {0}(571,324)(581,324){1}
wire w35;    //: /sn:0 {0}(639,353)(649,353){1}
wire w8;    //: /sn:0 {0}(576,232)(586,232){1}
wire w18;    //: /sn:0 {0}(530,472)(540,472){1}
wire w40;    //: /sn:0 {0}(561,470)(571,470){1}
wire w30;    //: /sn:0 {0}(756,238)(766,238){1}
wire w22;    //: /sn:0 {0}(458,357)(468,357){1}
wire w17;    //: /sn:0 {0}(540,467)(524,467)(524,426)(508,426){1}
wire w44;    //: /sn:0 {0}(622,554)(632,554){1}
wire w12;    //: /sn:0 {0}(454,43)(464,43){1}
wire w11;    //: /sn:0 {0}(454,38)(464,38){1}
wire w2;    //: /sn:0 {0}(451,282)(461,282){1}
wire w10;    //: /sn:0 {0}(458,352)(468,352){1}
wire w13;    //: /sn:0 {0}(499,546)(509,546){1}
wire w27;    //: /sn:0 {0}(570,383)(580,383){1}
wire w48;    //: /sn:0 {0}(745,514)(755,514){1}
wire w33;    //: /sn:0 {0}(735,356)(712,356){1}
//: {2}(710,354)(710,325)(736,325){3}
//: {4}(708,356)(670,356){5}
wire w5;    //: /sn:0 {0}(545,229)(555,229){1}
wire w47;    //: /sn:0 {0}(747,563)(757,563){1}
wire w29;    //: /sn:0 {0}(725,235)(735,235){1}
wire w42;    //: /sn:0 {0}(530,549)(548,549)(548,513){1}
wire w9;    //: /sn:0 {0}(477,428)(487,428){1}
wire w39;    //: /sn:0 {0}(752,325)(762,325){1}
wire w26;    //: /sn:0 {0}(570,355)(580,355){1}
//: enddecls

  //: comment g4 @(16,548) /sn:0 /R:14
  //: /line:"<font color=gray>&lt;PREVIOUS</font>    <a href=\"index.v\">UP</a>   <a href=\"module:PART1\">NEXT></a>"
  //: /end
  _GGXOR2 #(8) g8 (.I0(w0), .I1(w4), .Z(w6));   //: @(473,145) /sn:0 /w:[ 1 1 0 ]
  //: frame g51 @(449,500) /sn:0 /anc:1 /wi:145 /ht:74 /tx:"Fig. 6a"
  //: joint g37 (w33) @(710, 356) /w:[ 1 2 4 -1 ]
  //: frame g34 @(444,312) /sn:0 /anc:1 /wi:160 /ht:88 /tx:"Fig. 4a"
  //: joint g3 (w3) @(525, 280) /w:[ 2 4 1 -1 ]
  _GGOR2 #(6) g13 (.I0(w17), .I1(w18), .Z(w40));   //: @(551,470) /sn:0 /w:[ 0 1 0 ]
  _GGAND2 #(6) g2 (.I0(w5), .I1(w3), .Z(w8));   //: @(566,232) /sn:0 /w:[ 1 5 0 ]
  //: comment g1 @(549,50) /sn:0
  //: /line:"&lt;---"
  //: /end
  _GGAND2 #(6) g11 (.I0(w14), .I1(w15), .Z(w16));   //: @(540,96) /sn:0 /w:[ 0 1 0 ]
  //: joint g50 (w46) @(688, 552) /w:[ 2 -1 4 1 ]
  _GGBUF #(4) g28 (.I(w24), .Z(w26));   //: @(560,355) /sn:0 /w:[ 0 0 ]
  _GGAND2 #(6) g10 (.I0(w11), .I1(w12), .Z(w14));   //: @(475,41) /sn:0 /w:[ 1 1 1 ]
  _GGAND2 #(6) g32 (.I0(w29), .I1(w28), .Z(w30));   //: @(746,238) /sn:0 /w:[ 1 5 0 ]
  //: joint g27 (w24) @(529, 355) /w:[ 1 2 4 -1 ]
  _GGBUF #(4) g19 (.I(w20), .Z(w19));   //: @(601,425) /sn:0 /w:[ 1 0 ]
  _GGAND2 #(6) g38 (.I0(w35), .I1(w36), .Z(w33));   //: @(660,356) /sn:0 /w:[ 1 1 5 ]
  //: comment g9 @(23,10) /anc:1
  //: /line:"<h3>Wire Editing</h3>"
  //: /line:""
  //: /line:"1) Click on the wire in Fig. 1, drag it until it is nearly alligned"
  //: /line:"with the other vertical segment and release it.  \"Gravity\" will cause"
  //: /line:"them to snap together into a single segment."
  //: /line:""
  //: /line:"2) Grab the endpoint of the XOR output wire in Fig. 2, drag it up so that"
  //: /line:"it crosses the horizontal segment next to the gate and release it.  TkGate"
  //: /line:"will automatically remove the loop."
  //: /line:""
  //: /line:"3) Press <img src=\"cut_curs.gif\"> and click on the vertical wire segment in Fig. 3a.  TkGate will"
  //: /line:"automatically remove the wire joint.  Now, click at the point indicated by"
  //: /line:"the arrow in Fig. 3b.  The free wire end is automatically deleted."
  //: /line:""
  //: /line:"4) Press <img src=\"mov_curs.gif\"> then select and drag the input of the bottom buffer in Fig. 4a"
  //: /line:"next to the wire joint and release it to connect it to the joint.  Try again in"
  //: /line:"Fig. 4b, this time releasing it between the AND gate and the joint to"
  //: /line:"create a new joint."
  //: /line:""
  //: /line:"5) Right click on the vertical segment indicated by the arrow in Fig. 5"
  //: /line:"and select <font color=blue>Add Wire Segment</font> from the popup menu.  Grab the new wire"
  //: /line:"end and drag it to the other horizontal segment and release it."
  //: /line:""
  //: /line:"6) In Figs. 6a and 6b, select the wire at the point indicated by the"
  //: /line:"arrows and drag them left past the output point of the AND gate and"
  //: /line:"past the position of the joint.  Tkgate will reroute the wires as necessary."
  //: /line:""
  //: /line:""
  //: /line:""
  //: /line:"  <font color=green4>Hint: You can disable the automatic cleanup features in wire"
  //: /line:"  editing by holding the Alt key while moving wires.</font>"
  //: /end
  //: joint g31 (w28) @(705, 286) /w:[ 2 4 1 -1 ]
  _GGAND2 #(6) g39 (.I0(w13), .I1(w41), .Z(w42));   //: @(520,549) /sn:0 /w:[ 1 1 0 ]
  _GGBUF #(4) g48 (.I(w46), .Z(w47));   //: @(737,563) /sn:0 /w:[ 0 0 ]
  //: frame g43 @(624,217) /sn:0 /anc:1 /wi:160 /ht:85 /tx:"Fig. 3b"
  _GGBUF #(4) g29 (.I(w23), .Z(w27));   //: @(560,383) /sn:0 /w:[ 1 0 ]
  _GGAND2 #(6) g25 (.I0(w10), .I1(w22), .Z(w24));   //: @(479,355) /sn:0 /w:[ 1 1 5 ]
  //: frame g52 @(604,502) /sn:0 /anc:1 /wi:189 /ht:73 /tx:"Fig. 6b"
  //: frame g42 @(444,216) /sn:0 /anc:1 /wi:163 /ht:83 /tx:"Fig. 3a"
  _GGAND2 #(6) g5 (.I0(w7), .I1(w9), .Z(w17));   //: @(498,426) /sn:0 /w:[ 1 1 1 ]
  _GGAND2 #(6) g47 (.I0(w43), .I1(w44), .Z(w46));   //: @(643,552) /sn:0 /w:[ 1 1 5 ]
  _GGBUF #(4) g44 (.I(w37), .Z(w38));   //: @(744,387) /sn:0 /w:[ 1 0 ]
  _GGBUF #(4) g36 (.I(w33), .Z(w34));   //: @(741,356) /sn:0 /w:[ 0 0 ]
  //: comment g24 @(492,437) /sn:0 /anc:1
  //: /line:"--->"
  //: /end
  //: frame g41 @(442,122) /sn:0 /anc:1 /wi:142 /ht:86 /tx:"Fig. 2"
  _GGBUF #(4) g23 (.I(w20), .Z(w21));   //: @(601,463) /sn:0 /w:[ 0 0 ]
  //: frame g40 @(441,25) /sn:0 /anc:1 /wi:147 /ht:86 /tx:"Fig. 1"
  //: frame g46 @(447,411) /sn:0 /anc:1 /wi:190 /ht:75 /tx:"Fig. 5"
  _GGBUF #(4) g45 (.I(w33), .Z(w39));   //: @(742,325) /sn:0 /w:[ 3 0 ]
  //: frame g35 @(625,313) /sn:0 /anc:1 /wi:159 /ht:88 /tx:"Fig. 4b"
  _GGBUF #(4) g26 (.I(w24), .Z(w25));   //: @(561,324) /sn:0 /w:[ 3 0 ]
  _GGAND2 #(6) g0 (.I0(w1), .I1(w2), .Z(w3));   //: @(472,280) /sn:0 /w:[ 1 1 0 ]
  _GGAND2 #(6) g33 (.I0(w31), .I1(w32), .Z(w28));   //: @(652,286) /sn:0 /w:[ 1 1 0 ]
  //: comment g30 @(730,252) /sn:0 /anc:1
  //: /line:"|"
  //: /line:"v"
  //: /end
  _GGBUF #(4) g49 (.I(w46), .Z(w48));   //: @(735,514) /sn:0 /w:[ 3 0 ]

endmodule
//: /netlistEnd

//: /builtinBegin
module _GGXOR2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 ^ I1;

endmodule
//: /builtinEnd

//: /builtinBegin
module _GGBUF #(.Diz(1)) (I, Z);
input I;
output Z;
  assign #Diz Z = I;

endmodule
//: /builtinEnd

//: /builtinBegin
module _GGAND2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 & I1;

endmodule
//: /builtinEnd

//: /builtinBegin
module _GGOR2 #(.Diz(1)) (I0, I1, Z);
output Z;
input I0;
input I1;

  assign #Diz Z = I0 | I1;

endmodule
//: /builtinEnd
