/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame3.driver;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.PooledConnection;
import org.openrdf.model.BNodeFactory;
import org.openrdf.model.LiteralFactory;
import org.openrdf.model.URIFactory;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeFactoryImpl;
import org.openrdf.model.impl.LiteralFactoryImpl;
import org.openrdf.model.impl.URIFactoryImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryMetaData;
import org.openrdf.store.StoreException;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.sesame3.driver.VirtuosoRepositoryConnection;
import virtuoso.sesame3.driver.VirtuosoRepositoryMetaData;

public class VirtuosoRepository
implements Repository {
    private URIFactory uf = new URIFactoryImpl();
    private LiteralFactory lf = new LiteralFactoryImpl();
    private BNodeFactory bf = new BNodeFactoryImpl();
    File dataDir;
    private boolean readOnly;
    private RepositoryMetaData metadata;
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private String url;
    private String user;
    private String password;
    private String host = "localhost";
    private int port = 1111;
    private String charset = "UTF-8";
    private boolean roundrobin = false;
    String defGraph;
    boolean useLazyAdd = false;
    int prefetchSize = 200;
    int queryTimeout = 0;
    private boolean initialized = false;
    String ruleSet;

    public VirtuosoRepository(String string, String string2, String string3, String string4, boolean bl) {
        this.host = string;
        this.user = string2;
        this.password = string3;
        this.defGraph = string4;
        this.useLazyAdd = bl;
    }

    public VirtuosoRepository(String string, int n, String string2, String string3, String string4, boolean bl) {
        this.port = n;
        this.host = string;
        this.user = string2;
        this.password = string3;
        this.defGraph = string4;
        this.useLazyAdd = bl;
    }

    public VirtuosoRepository(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, "sesame:nil", bl);
    }

    public VirtuosoRepository(String string, int n, String string2, String string3, boolean bl) {
        this(string, n, string2, string3, "sesame:nil", bl);
    }

    public VirtuosoRepository(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, false);
    }

    public VirtuosoRepository(String string, int n, String string2, String string3, String string4) {
        this(string, n, string2, string3, string4, false);
    }

    public VirtuosoRepository(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public VirtuosoRepository(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, false);
    }

    public RepositoryConnection getConnection() throws StoreException {
        try {
            this.pds.setServerName(this.host);
            this.pds.setPortNumber(this.port);
            this.pds.setUser(this.user);
            this.pds.setPassword(this.password);
            this.pds.setCharset(this.charset);
            this.pds.setRoundrobin(this.roundrobin);
            PooledConnection pooledConnection = this.pds.getPooledConnection();
            Connection connection = pooledConnection.getConnection();
            return new VirtuosoRepositoryConnection(this, connection);
        }
        catch (SQLException sQLException) {
            System.out.println("Connection to " + this.host + " is FAILED.");
            throw new StoreException((Throwable)sQLException);
        }
    }

    public void setFetchSize(int n) {
        this.prefetchSize = n;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setRoundrobin(boolean bl) {
        this.roundrobin = bl;
    }

    public boolean getRoundrobin() {
        return this.roundrobin;
    }

    public RepositoryMetaData getMetaData() throws StoreException {
        if (this.metadata == null) {
            this.metadata = new VirtuosoRepositoryMetaData(this);
        }
        return this.metadata;
    }

    @Deprecated
    public ValueFactory getValueFactory() {
        return new ValueFactoryImpl(this.bf, this.uf, this.lf);
    }

    public URIFactory getURIFactory() {
        return this.uf;
    }

    public LiteralFactory getLiteralFactory() {
        return this.lf;
    }

    public void initialize() throws StoreException {
        this.initialized = true;
    }

    public void setRuleSet(String string) {
        if (string != null && string.equals("null")) {
            string = null;
        }
        this.ruleSet = string;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File file) {
        this.dataDir = file;
    }

    public void shutDown() throws StoreException {
        this.initialized = false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void createRuleSet(String string, String string2) throws StoreException {
        Connection connection = ((VirtuosoRepositoryConnection)this.getConnection()).getQuadStoreConnection();
        try {
            Statement statement = connection.createStatement();
            statement.execute("rdfs_rule_set('" + string + "', '" + string2 + "')");
            statement.close();
        }
        catch (Exception exception) {
            throw new StoreException((Throwable)exception);
        }
    }
}

