<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authnz_fcgi - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authnz_fcgi</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authnz_fcgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authnz_fcgi.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Permet  une application d'autorisation FastCGI de grer
l'authentification et l'autorisation httpd.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authnz_fcgi_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authnz_fcgi.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.10 du serveur HTTP
Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet aux applications d'autorisation FastCGI
    d'authentifier les utilisateurs et de contrler leur accs aux
    ressources. Il supporte les systmes d'autorisation FastCGI
    gnriques qui participent en une seule phase  l'authentification
    et  l'autorisation, ainsi que les processus d'authentification et
    d'autorisation spcifiques  Apache httpd qui interviennent en une
    ou plusieurs phases.</p>

    <p>Les processus d'autorisation FastCGI peuvent authentifier un
    utilisateur via son identificateur et son mot de passe comme dans le
    processus d'authentification basique, ou via un mcanisme
    arbitraire.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#invocations">Modes d'invocation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples supplmentaires</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#limitations">Limitations</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#logging">Journalisation</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authnzfcgicheckauthnprovider">AuthnzFcgiCheckAuthnProvider</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authnzfcgidefineprovider">AuthnzFcgiDefineProvider</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_authnz_fcgi">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_authnz_fcgi">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
<li><code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code></li>
<li><code class="program"><a href="../programs/fcgistarter.html">fcgistarter</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="invocations" id="invocations">Modes d'invocation</a></h2>

    <p>Les modes d'invocation des processus d'autorisation FastCGI que
    ce module supporte se distinguent par deux caractristiques : le
    <em>type</em> et le <em>mcanisme</em> d'authentification.</p>

    <p>Le <em>Type</em> est simplement <code>authn</code> pour
    l'authentification, <code>authz</code> pour l'autorisation et
    <code>authnz</code> l'authentification et l'autorisation.</p>

    <p>Le <em>mcanisme</em> d'authentification fait rfrence aux
    mcanismes d'authentification et aux phases de traitement de la
    configuration de Apache httpd, et peut tre
    <code>AuthBasicProvider</code>, <code>Require</code>, ou
    <code>check_user_id</code>. Les deux premiers mcanismes
    correspondent aux directives utilises pour participer aux phases de
    traitement appropries.</p>

    <p>Description de chaque mode:</p>

    <dl>
      <dt><em>Type</em> <code>authn</code>, <em>mechanism</em>
      <code>AuthBasicProvider</code></dt>

      <dd>Dans ce mode, la variable <code>FCGI_ROLE</code> est dfinie 
      <code>AUTHORIZER</code>, et la variable
      <code>FCGI_APACHE_ROLE</code>  <code>AUTHENTICATOR</code>.
      L'application doit tre spcifie en tant que fournisseur de type
      <em>authn</em> via la directive <code class="directive"><a href="#authnzfcgidefineprovider">AuthnzFcgiDefineProvider</a></code>, et
      active via la directive <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>. Lorsqu'elle
      est invoque, l'application est cense authentifier le client 
      l'aide de l'identifiant et du mot de passe de l'utilisateur.
      Exemple d'application :

<pre class="prettyprint lang-perl">#!/usr/bin/perl
use FCGI;
my $request = FCGI::Request();
while ($request-&gt;Accept() &gt;= 0) {
    die if $ENV{'FCGI_APACHE_ROLE'} ne "AUTHENTICATOR";
    die if $ENV{'FCGI_ROLE'}        ne "AUTHORIZER";
    die if !$ENV{'REMOTE_PASSWD'};
    die if !$ENV{'REMOTE_USER'};

    print STDERR "This text is written to the web server error log.\n";

    if ( ($ENV{'REMOTE_USER' } eq "foo" || $ENV{'REMOTE_USER'} eq "foo1") &amp;&amp;
        $ENV{'REMOTE_PASSWD'} eq "bar" ) {
        print "Status: 200\n";
        print "Variable-AUTHN_1: authn_01\n";
        print "Variable-AUTHN_2: authn_02\n";
        print "\n";
    }
    else {
        print "Status: 401\n\n";
    }
}</pre>


      Exemple de configuration httpd :
<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authn FooAuthn fcgi://localhost:10102/
&lt;Location "/protected/"&gt;
  AuthType Basic
  AuthName "Restricted"
  AuthBasicProvider FooAuthn
  Require ...
&lt;/Location&gt;</pre>

      </dd>

      <dt><em>Type</em> <code>authz</code>, <em>mechanism</em>
      <code>Require</code></dt>
      <dd>Dans ce mode, la variable <code>FCGI_ROLE</code> est dfinie 
      <code>AUTHORIZER</code> et <code>FCGI_APACHE_ROLE</code> 
      <code>AUTHORIZER</code>. L'application doit tre spcifie en tant
      que fournisseur de type <em>authz</em> via la directive <code class="directive"><a href="#authnzfcgidefineprovider">AuthnzFcgiDefineProvider</a></code>.
      Lorsqu'elle est invoque, l'application est cense contrler les
      accs du client  l'aide de l'identifiant utilisateur et d'autres
      donnes contenues dans la requte. Exemple d'application :
<pre class="prettyprint lang-perl">#!/usr/bin/perl
use FCGI;
my $request = FCGI::Request();
while ($request-&gt;Accept() &gt;= 0) {
    die if $ENV{'FCGI_APACHE_ROLE'} ne "AUTHORIZER";
    die if $ENV{'FCGI_ROLE'}        ne "AUTHORIZER";
    die if $ENV{'REMOTE_PASSWD'};

    print STDERR "This text is written to the web server error log.\n";

    if ($ENV{'REMOTE_USER'} eq "foo1") {
        print "Status: 200\n";
        print "Variable-AUTHZ_1: authz_01\n";
        print "Variable-AUTHZ_2: authz_02\n";
        print "\n";
    }
    else {
        print "Status: 403\n\n";
    }
}</pre>


      Exemple de configuration httpd :
<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authz FooAuthz fcgi://localhost:10103/
&lt;Location "/protected/"&gt;
  AuthType ...
  AuthName ...
  AuthBasicProvider ...
  Require FooAuthz
&lt;/Location&gt;</pre>

      </dd>

      <dt><em>Type</em> <code>authnz</code>, <em>mechanism</em>
      <code>AuthBasicProvider</code> <em>+</em> <code>Require</code></dt>

      <dd>Dans ce mode qui supporte le protocole d'autorisation web
      server-agnostic FastCGI, la variable <code>FCGI_ROLE</code> est
      dfinie  <code>AUTHORIZER</code> et <code>FCGI_APACHE_ROLE</code>
      n'est pas dfinie. L'application doit tre spcifie en tant que
      fournisseur de type <em>authnz</em> via la directive <code class="directive"><a href="#authnzfcgidefineprovider">AuthnzFcgiDefineProvider</a></code>.
      L'application est cense assurer l'authentification et
      l'autorisation au cours d'une mme invocation  l'aide de
      l'identifiant et du mot de passe de l'utilisateur et d'autres
      donnes contenues dans la requte. L'invocation de l'application
      intervient au cours de la phase d'authentification de l'API Apache
      httpd. Si l'application renvoie le code 200, et si le mme
      fournisseur est invoqu au cours de la phase d'autorisation (via
      une directive <code class="directive">Require</code>), mod_authnz_fcgi
      renverra un code de type success pour la phase d'autorisation sans
      invoquer l'application. Exemple d'application :
<pre class="prettyprint lang-perl">#!/usr/bin/perl
use FCGI;
my $request = FCGI::Request();
while ($request-&gt;Accept() &gt;= 0) {
    die if $ENV{'FCGI_APACHE_ROLE'};
    die if $ENV{'FCGI_ROLE'} ne "AUTHORIZER";
    die if !$ENV{'REMOTE_PASSWD'};
    die if !$ENV{'REMOTE_USER'};

    print STDERR "This text is written to the web server error log.\n";

    if ( ($ENV{'REMOTE_USER' } eq "foo" || $ENV{'REMOTE_USER'} eq "foo1") &amp;&amp;
        $ENV{'REMOTE_PASSWD'} eq "bar" &amp;&amp;
        $ENV{'REQUEST_URI'} =~ m%/bar/.*%) {
        print "Status: 200\n";
        print "Variable-AUTHNZ_1: authnz_01\n";
        print "Variable-AUTHNZ_2: authnz_02\n";
        print "\n";
    }
    else {
        print "Status: 401\n\n";
    }
}</pre>


      Exemple de configuration httpd :
<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authnz FooAuthnz fcgi://localhost:10103/
&lt;Location "/protected/"&gt;
  AuthType Basic
  AuthName "Restricted"
  AuthBasicProvider FooAuthnz
  Require FooAuthnz
&lt;/Location&gt;</pre>

      </dd>

      <dt><em>Type</em> <code>authn</code>, <em>mechanism</em>
      <code>check_user_id</code></dt>

      <dd>Dans ce mode, la variable <code>FCGI_ROLE</code> est dfinie 
      <code>AUTHORIZER</code> et <code>FCGI_APACHE_ROLE</code> 
      <code>AUTHENTICATOR</code>. L'application doit tre spcifie en
      tant que fournisseur de type <em>authn</em> via une directive
      <code class="directive"><a href="#authnzfcgidefineprovider">AuthnzFcgiDefineProvider</a></code>. La
      directive <code class="directive"><a href="#authnzfcgicheckauthnprovider">AuthnzFcgiCheckAuthnProvider</a></code>
      permet de l'invoquer. Exemple d'application :
<pre class="prettyprint lang-perl">#!/usr/bin/perl
use FCGI;
my $request = FCGI::Request();
while ($request-&gt;Accept() &gt;= 0) {
    die if $ENV{'FCGI_APACHE_ROLE'} ne "AUTHENTICATOR";
    die if $ENV{'FCGI_ROLE'} ne "AUTHORIZER";

    # This authorizer assumes that the RequireBasicAuth option of 
    # AuthnzFcgiCheckAuthnProvider is On:
    die if !$ENV{'REMOTE_PASSWD'};
    die if !$ENV{'REMOTE_USER'};

    print STDERR "This text is written to the web server error log.\n";

    if ( ($ENV{'REMOTE_USER' } eq "foo" || $ENV{'REMOTE_USER'} eq "foo1") &amp;&amp;
        $ENV{'REMOTE_PASSWD'} eq "bar" ) {
        print "Status: 200\n";
        print "Variable-AUTHNZ_1: authnz_01\n";
        print "Variable-AUTHNZ_2: authnz_02\n";
        print "\n";
    }
    else {
        print "Status: 401\n\n";
        # If a response body is written here, it will be returned to
        # the client.
    }
}</pre>


      Exemple de configuration httpd :
<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authn FooAuthn fcgi://localhost:10103/
&lt;Location "/protected/"&gt;
  AuthType ...
  AuthName ...
  AuthnzFcgiCheckAuthnProvider FooAuthn \
                               Authoritative On \
                               RequireBasicAuth Off \
                               UserExpr "%{reqenv:REMOTE_USER}"
  Require ...
&lt;/Location&gt;</pre>

      </dd>

    </dl>
    
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples supplmentaires</a></h2>

  <ol>
    <li>Si votre application supporte sparment les rles
    d'authentification et d'autorisation (<code>AUTHENTICATOR</code> et
    <code>AUTHORIZER</code>), vous pouvez dfinir des fournisseurs
    spars comme suit, mme s'ils correspondent  la mme application :

<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authn  FooAuthn  fcgi://localhost:10102/
AuthnzFcgiDefineProvider authz  FooAuthz  fcgi://localhost:10102/</pre>


    Spcifie le fournisseur authn via la directive 
    <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code>
    et le fournisseur authz via la directive
    <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>:

<pre class="prettyprint lang-config">AuthType Basic
AuthName "Restricted"
AuthBasicProvider FooAuthn
Require FooAuthz</pre>

    </li>

    <li>Si votre application supporte le rle gnrique
    <code>AUTHORIZER</code> (authentification et autorisation en une
    seule invocation), vous pouvez dfinir un fournisseur unique comme
    suit :

<pre class="prettyprint lang-config">AuthnzFcgiDefineProvider authnz FooAuthnz fcgi://localhost:10103/</pre>


    Spcifie le fournisseur authnz via les directives
    <code class="directive">AuthBasicProvider</code> et
    <code class="directive">Require</code> :

<pre class="prettyprint lang-config">AuthType Basic
AuthName "Restricted"
AuthBasicProvider FooAuthnz
Require FooAuthnz</pre>

    </li>
</ol>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="limitations" id="limitations">Limitations</a></h2>

    <p>Les fonctionnalits suivantes ne sont pas encore implmentes :</p>

    <dl>
      <dt>Vrificateur d'accs d'Apache httpd</dt>
      <dd>La phase <em>access check</em> de l'API Apache httpd est
      distincte des phases d'authentification et d'autorisation.
      Certaines autres implmentations de FastCGI supportent cette phase
      et lorsque c'est le cas, la variable <code>FCGI_APACHE_ROLE</code>
      est dfinie  <code>ACCESS_CHECKER</code>.</dd>

      <dt>Redirections (pipes) ou sockets locaux (Unix)</dt>
      <dd>Seuls les sockets TCP sont actuellement supports.</dd>

      <dt>Support de mod_authn_socache</dt>
      <dd>Le support de l'interaction avec mod_authn_socache pour les
      applications qui interviennent dans le processus
      d'authentification d'Apache httpd serait souhaitable.</dd>

      <dt>Support de l'authentification de type digest  l'aide de AuthDigestProvider</dt>
      <dd>Cette limitation ne sera probablement jamais franchie car il
      n'existe aucun flux de donnes d'autorisation capable de lire dans
      un condens de type hash.</dd>

      <dt>Gestion des processus applicatifs</dt>
      <dd>Cette fonctionnalit restera probablement hors de porte de ce
      module. Il faudra donc grer les processus applicatifs d'une autre
      manire ; par exemple, <code class="program"><a href="../programs/fcgistarter.html">fcgistarter</a></code> permet de
      les dmarrer.</dd>

      <dt>AP_AUTH_INTERNAL_PER_URI</dt>
      <dd>Tous les fournisseurs sont actuellement enregistrs en tant
      que AP_AUTH_INTERNAL_PER_CONF, ce qui signifie que les
      vrifications ne sont pas effectues pour les
      sous-requtes internes avec la mme configuration de contrle
      d'accs que la requte initiale.</dd>

      <dt>Conversion du jeu de caractres des donnes de protocole</dt>
      <dd>Si mod_authnz_fcgi s'excute dans un environnement de
      compilation EBCDIC, toutes les donnes de protocole FastCGI sont
      crites en EBCDIC et doivent tre disponibles en EBCDIC.</dd>

      <dt>Plusieurs requtes pour une connexion</dt>
      <dd>Actuellement, la connexion au fournisseur d'autorisation
      FastCGI est ferme aprs chaque phase de traitement. Par exemple,
      si le fournisseur d'autorisation gre sparment les phases
      <em>authn</em> et <em>authz</em>, deux connexions seront
      ncessaires.</dd>

      <dt>Redirection de certains URIs</dt>
      <dd>Les URIs en provenance des clients ne peuvent pas tre
      redirigs selon une table de redirection, comme avec la directive
      <code class="directive">ProxyPass</code> utilise avec les rpondeurs
      FastCGI.</dd>

    </dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="logging" id="logging">Journalisation</a></h2>

    <ol>
        <li>Les erreurs de traitement sont journalises  un niveau
	<code>error</code> ou suprieur.</li>
        <li>Les messages envoys par l'application sont journaliss au
	niveau <code>warn</code>.</li>
        <li>Les messages de deboguage  caractre gnral sont
	journaliss au niveau <code>debug</code>.</li>
        <li>Les variables d'environnement transmises  l'application
	sont journalises au niveau <code>trace2</code>. La valeur de la
	variable <code>REMOTE_PASSWD</code> sera occulte, mais
	<strong>toute autre donne sensible sera visible dans le
	journal</strong>.</li>
        <li>Toutes les entres/sorties entre le module et l'application
	FastCGI, y compris les variables d'environnement, seront
	journalises au format imprimable et hexadcimal au niveau
	<code>trace5</code>. <strong>Toutes les donnes sensibles seront
	visibles dans le journal.</strong></li>
    </ol>

    <p>La directive <code class="directive"><a href="../mod/core.html#loglevel">LogLevel</a></code> permet
    de configurer un niveau de journalisation spcifique 
    mod_authnz_fcgi. Par exemple :</p>

<pre class="prettyprint lang-config">LogLevel info authnz_fcgi:trace8</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authnzfcgicheckauthnprovider" id="authnzfcgicheckauthnprovider">Directive</a> <a name="AuthnzFcgiCheckAuthnProvider" id="AuthnzFcgiCheckAuthnProvider">AuthnzFcgiCheckAuthnProvider</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Permet  une application FastCGI de grer l'accroche
d'authentification check_authn.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnzFcgiCheckAuthnProvider <em>provider-name</em>|<code>None</code>
<em>option</em> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_fcgi</td></tr>
</table>
    <p>Cette directive permet de confier  une application FastCGI la
    gestion d'une phase spcifique du processus d'authentification ou
    d'autorisation.</p>

    <p>Certaines fonctionnalits des fournisseurs d'autorisation FastCGI
    ncessitent cette directive en lieu et place de
    <code class="directive">AuthBasicProvider</code> pour pouvoir tre actives :</p>

    <ul>
      <li>L'authentification de type autre que basique ; en gnral,
      dtermination de l'identifiant utilisateur et renvoi de sa valeur
      depuis le fournisseur d'autorisation ; voir l'option
      <code>UserExpr</code> ci-dessous</li>
      <li>Slection d'un code de rponse personnalis ; en cas de
      code de rponse autre que 200 en provenance du fournisseur
      d'autorisation, c'est ce code qui sera utilis comme code d'tat
      de la rponse</li>
      <li>Dfinition du corps d'une rponse autre que 200 ; si le
      fournisseur d'autorisation renvoie un corps de rponse avec un
      code autre que 200, c'est ce corps de rponse qui sera renvoy au
      client ; la longueur du texte est limite  8192 octets</li>
    </ul>

    <dl>
      <dt><em>provider-name</em></dt>
      <dd>C'est le nom du fournisseur dfini au pralable via la
      directive <code class="directive">AuthnzFcgiDefineProvider</code>.</dd>

      <dt><code>None</code></dt>
      <dd>Spcifiez <code>None</code> pour dsactiver un fournisseur
      activ avec cette mme directive dans une autre porte, par
      exemple dans un rpertoire parent.</dd>

      <dt><em>option</em></dt>
      <dd>Les options suivantes sont supportes :
      
      <dl>
         <dt>Authoritative On|Off (par dfaut On)</dt>
         <dd>Cette option permet de dfinir si l'appel  d'autres
	 modules est autoris lorsqu'un fournisseur d'autorisation FastCGI a
	 t configur et si la requte choue.</dd>

         <dt>DefaultUser <em>id utilisateur</em></dt>
         <dd>Lorsque le fournisseur d'autorisation donne son accord, et
	 si <code>UserExpr</code> est dfini et correspond  une chane
	 vide, (par exemple, si le fournisseur d'autorisation ne renvoie
	 aucune variable), c'est cette valeur qui sera utilise comme id
	 utilisateur par dfaut. Cela se produit souvent lorsqu'on se trouve dans
	 un contexte d'invit, ou d'utilisateur non authentifi ;
	 les utilisateurs et invits se voient alors attribu un id
	 utilisateur spcifique qui permettra de se connecter et
	 d'accder  certaines ressources.</dd>

         <dt>RequireBasicAuth On|Off (par dfaut Off)</dt>
         <dd>Cette option permet de dfinir si l'authentification
	 basique est requise avant de transmettre la requte au
	 fournisseur d'autorisation. Dans l'affirmative, le fournisseur
	 d'autorisation ne sera invoqu qu'en prsence d'un id
	 utilisateur et d'un mot de passe ; si ces deux lments ne sont
	 pas prsents, un code d'erreur 401 sera renvoy</dd>

         <dt>UserExpr <em>expr</em> (pas de valeur par dfaut)</dt>
         <dd>Lorsque le client ne fournit pas l'authentification basique
	 et si le fournisseur d'autorisation dtermine l'id utilisateur,
	 cette expression, value aprs l'appel au fournisseur
	 d'autorisation, permet de dterminer l'id utilisateur. Cette
	 expression se conforme  la <a href="../expr.html">syntaxe
	 ap_expr</a> et doit correspondre  une chane de caractres.
	 Une utilisation courante consiste  rfrencer la dfinition
	 d'une <code>Variable-<em>XXX</em></code> renvoye par le
	 fournisseur d'autorisation via une option du style
	 <code>UserExpr "%{reqenv:<em>XXX</em>}"</code>. Si cette option
	 est spcifie, et si l'id utilisateur ne peut pas tre dfinie
	 via l'expression aprs une authentification russie, la requte
	 sera rejete avec un code d'erreur 500.</dd>

       </dl>
      </dd>
     </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authnzfcgidefineprovider" id="authnzfcgidefineprovider">Directive</a> <a name="AuthnzFcgiDefineProvider" id="AuthnzFcgiDefineProvider">AuthnzFcgiDefineProvider</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une application FastCGI en tant que fournisseur
d'authentification et/ou autorisation</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthnzFcgiDefineProvider <em>type</em> <em>provider-name</em>
<em>backend-address</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>none</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authnz_fcgi</td></tr>
</table>
    <p>Cette directive permet de dfinir une application FastCGI en tant
    que fournisseur pour une phase particulire d'authentification ou
    d'autorisation.</p>

    <dl>
      <dt><em>type</em></dt>
      <dd>Les valeurs de ce paramtre sont <em>authn</em> pour
      l'authentification, <em>authz</em> pour l'autorisation, ou
      <em>authnz</em> pour un fournisseur d'autorisation gnrique
      FastCGI qui effectue les deux vrifications.</dd>

      <dt><em>provider-name</em></dt>
      <dd>Ce paramtre permet d'associer un nom au fournisseur ; ce nom
      pourra tre utilis dans des directives comme <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> et
      <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>.</dd>

      <dt><em>backend-address</em></dt>
      <dd>Ce paramtre permet de spcifier l'adresse de l'application
      sous la forme <em>fcgi://hostname:port/</em>. Le ou les processus
      de l'application doivent tre grs indpendamment comme avec
      <code class="program"><a href="../programs/fcgistarter.html">fcgistarter</a></code>.</dd>
    </dl>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authnz_fcgi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authnz_fcgi.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authnz_fcgi.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>