#
# Command specific completions for the xgettext command.
# These completions where generated from the commands
# man page by the make_completions.py script, but may
# have been hand edited since.
#

complete -c xgettext -s f -l files-from --description 'Get list of input files from FILE'
complete -c xgettext -s D -l directory --description 'Add DIRECTORY to list for input files search'
complete -c xgettext -s d -l default-domain --description 'Use NAME'
complete -c xgettext -s o -l output --description 'Write output to specified file'
complete -c xgettext -s p -l output-dir --description 'Output files will be placed in directory DIR'
complete -c xgettext -s L -l language --description 'Recognise the specified language (C, C++, ObjectiveC, PO, Shell, Python, Lisp, EmacsLisp, librep, Scheme, Smalltalk, Java, JavaProperties, C#, awk, YCP, Tcl, Perl, PHP, GCC-source, NXStringTable, RST, Glade)'
complete -c xgettext -s C -l c++ --description 'Shorthand for --language=C++'
complete -c xgettext -l from-code --description 'Encoding of input files (except for Python, Tcl, Glade)'
complete -c xgettext -s j -l join-existing --description 'Join messages with existing file'
complete -c xgettext -s x -l exclude-file --description 'Entries from FILE'
complete -c xgettext -s c -l add-comments --description 'Place comment block with TAG (or those preceding keyword lines) in output file'
complete -c xgettext -s a -l extract-all --description 'Extract all strings (only languages C, C++, ObjectiveC, Shell, Python, Lisp, EmacsLisp, librep, Scheme, Java, C#, awk, Tcl, Perl, PHP, GCC-source, Glade)'
complete -c xgettext -s k -l keyword --description 'Additional keyword to be looked for (without WORD means not to use default keywords)'
complete -c xgettext -l flag --description 'Additional flag for strings inside the argument number ARG of keyword WORD'
complete -c xgettext -s T -l trigraphs --description 'Understand ANSI C trigraphs for input (only languages C, C++, ObjectiveC)'
complete -c xgettext -l qt --description 'Recognize Qt format strings (only language C++)'
complete -c xgettext -l boost --description 'Recognize Boost format strings (only language C++)'
complete -c xgettext -l debug --description 'More detailed formatstring recognition result'
complete -c xgettext -s e -l no-escape --description 'Do not use C escapes in output (default)'
complete -c xgettext -s E -l escape --description 'Use C escapes in output, no extended chars'
complete -c xgettext -l force-po --description 'Write PO file even if empty'
complete -c xgettext -s i -l indent --description 'Write the'
complete -c xgettext -l no-location --description 'Do not write #: filename:line lines'
complete -c xgettext -s n -l add-location --description 'Generate #: filename:line lines (default)'
complete -c xgettext -l strict --description 'Write out strict Uniforum conforming'
complete -c xgettext -l properties-output --description 'Write out a Java'
complete -c xgettext -l stringtable-output --description 'Write out a NeXTstep/GNUstep'
complete -c xgettext -s w -l width --description 'Set output page width'
complete -c xgettext -l no-wrap --description 'Do not break long message lines, longer than the output page width, into several lines'
complete -c xgettext -s s -l sort-output --description 'Generate sorted output'
complete -c xgettext -s F -l sort-by-file --description 'Sort output by file location'
complete -c xgettext -l omit-header --description 'Dont write header with msgid "" entry'
complete -c xgettext -l copyright-holder --description 'Set copyright holder in output'
complete -c xgettext -l foreign-user --description 'Omit FSF copyright in output for foreign user'
complete -c xgettext -l msgid-bugs-address --description 'Set report address for msgid bugs'
complete -c xgettext -s m -l msgstr-prefix --description 'Use STRING or "" as prefix for msgstr entries'
complete -c xgettext -s M -l msgstr-suffix --description 'Use STRING or "" as suffix for msgstr entries'
complete -c xgettext -s h -l help --description 'Display this help and exit'
complete -c xgettext -s V -l version --description 'Output version information and exit'
