'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAccordion = exports.PADDING_SIZES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _icon = require('../icon');

var _flex = require('../flex');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var paddingSizeToClassNameMap = {
  none: null,
  xs: 'euiAccordion__padding--xs',
  s: 'euiAccordion__padding--s',
  m: 'euiAccordion__padding--m',
  l: 'euiAccordion__padding--l',
  xl: 'euiAccordion__padding--xl'
};

var PADDING_SIZES = exports.PADDING_SIZES = Object.keys(paddingSizeToClassNameMap);

var EuiAccordion = exports.EuiAccordion = function (_Component) {
  _inherits(EuiAccordion, _Component);

  function EuiAccordion(props) {
    _classCallCheck(this, EuiAccordion);

    var _this = _possibleConstructorReturn(this, (EuiAccordion.__proto__ || Object.getPrototypeOf(EuiAccordion)).call(this, props));

    _this.setChildContentHeight = function () {
      requestAnimationFrame(function () {
        var height = _this.childContent && _this.state.isOpen ? _this.childContent.clientHeight : 0;
        _this.childWrapper && _this.childWrapper.setAttribute('style', 'height: ' + height + 'px');
      });
    };

    _this.setChildContentRef = function (node) {
      _this.childContent = node;

      if (_this.observer) {
        _this.observer.disconnect();
        _this.observer = null;
      }

      if (node) {
        _this.observer = new MutationObserver(_this.setChildContentHeight);
        _this.observer.observe(_this.childContent, { childList: true, subtree: true });
      }
    };

    _this.state = {
      isOpen: props.initialIsOpen
    };

    _this.onToggle = _this.onToggle.bind(_this);
    return _this;
  }

  _createClass(EuiAccordion, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this.setChildContentHeight();
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this.setChildContentHeight();
    }
  }, {
    key: 'onToggle',
    value: function onToggle() {
      this.setState(function (prevState) {
        return {
          isOpen: !prevState.isOpen
        };
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          children = _props.children,
          buttonContent = _props.buttonContent,
          className = _props.className,
          id = _props.id,
          buttonClassName = _props.buttonClassName,
          buttonContentClassName = _props.buttonContentClassName,
          extraAction = _props.extraAction,
          paddingSize = _props.paddingSize,
          initialIsOpen = _props.initialIsOpen,
          rest = _objectWithoutProperties(_props, ['children', 'buttonContent', 'className', 'id', 'buttonClassName', 'buttonContentClassName', 'extraAction', 'paddingSize', 'initialIsOpen']);

      var classes = (0, _classnames2.default)('euiAccordion', {
        'euiAccordion-isOpen': this.state.isOpen
      }, className);

      var paddingClass = (0, _classnames2.default)(paddingSizeToClassNameMap[paddingSize]);

      var buttonClasses = (0, _classnames2.default)('euiAccordion__button', buttonClassName);

      var buttonContentClasses = (0, _classnames2.default)('euiAccordion__buttonContent', buttonContentClassName);

      var icon = _react2.default.createElement(_icon.EuiIcon, { type: this.state.isOpen ? 'arrowDown' : 'arrowRight', size: 'm' });

      var optionalAction = null;

      if (extraAction) {
        optionalAction = _react2.default.createElement(
          _flex.EuiFlexItem,
          { grow: false },
          extraAction
        );
      }

      return _react2.default.createElement(
        'div',
        _extends({
          className: classes
        }, rest),
        _react2.default.createElement(
          _flex.EuiFlexGroup,
          { gutterSize: 'none', alignItems: 'center' },
          _react2.default.createElement(
            _flex.EuiFlexItem,
            null,
            _react2.default.createElement(
              'button',
              {
                'aria-controls': id,
                'aria-expanded': !!this.state.isOpen,
                onClick: this.onToggle,
                className: buttonClasses
              },
              _react2.default.createElement(
                _flex.EuiFlexGroup,
                { gutterSize: 's', alignItems: 'center', responsive: false },
                _react2.default.createElement(
                  _flex.EuiFlexItem,
                  { grow: false, className: 'euiAccordion__iconWrapper' },
                  icon
                ),
                _react2.default.createElement(
                  _flex.EuiFlexItem,
                  { className: buttonContentClasses },
                  buttonContent
                )
              )
            )
          ),
          optionalAction
        ),
        _react2.default.createElement(
          'div',
          {
            className: 'euiAccordion__childWrapper',
            ref: function ref(node) {
              _this2.childWrapper = node;
            },
            id: id
          },
          _react2.default.createElement(
            'div',
            { ref: this.setChildContentRef },
            _react2.default.createElement(
              'div',
              { className: paddingClass },
              children
            )
          )
        )
      );
    }
  }]);

  return EuiAccordion;
}(_react.Component);

EuiAccordion.propTypes = {
  /**
   * The content of the exposed accordion.
   */
  children: _propTypes2.default.node,
  id: _propTypes2.default.string.isRequired,
  /**
   * Class that will apply to the entire accordion.
   */
  className: _propTypes2.default.string,
  /**
   * Class that will apply to the trigger for the accordion.
   */
  buttonContentClassName: _propTypes2.default.string,
  /**
   * The content of the clickable trigger
   */
  buttonContent: _propTypes2.default.node,
  /**
   * Will appear right aligned against the button. Useful for separate actions like deletions.
   */
  extraAction: _propTypes2.default.node,
  /**
   * The accordion will start in the open state.
   */
  initialIsOpen: _propTypes2.default.bool,
  /**
   * The padding around the exposed accordion content.
   */
  paddingSize: _propTypes2.default.oneOf(PADDING_SIZES)
};

EuiAccordion.defaultProps = {
  initialIsOpen: false,
  paddingSize: 'none'
};
EuiAccordion.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiAccordion',
  'methods': [{
    'name': 'setChildContentHeight',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'onToggle',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'setChildContentRef',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'node',
      'type': null
    }],
    'returns': null
  }],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'The content of the exposed accordion.'
    },
    'id': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Class that will apply to the entire accordion.'
    },
    'buttonContentClassName': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Class that will apply to the trigger for the accordion.'
    },
    'buttonContent': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'The content of the clickable trigger'
    },
    'extraAction': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Will appear right aligned against the button. Useful for separate actions like deletions.'
    },
    'initialIsOpen': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'The accordion will start in the open state.',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'paddingSize': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '"none"',
          'computed': false
        }, {
          'value': '"xs"',
          'computed': false
        }, {
          'value': '"s"',
          'computed': false
        }, {
          'value': '"m"',
          'computed': false
        }, {
          'value': '"l"',
          'computed': false
        }, {
          'value': '"xl"',
          'computed': false
        }]
      },
      'required': false,
      'description': 'The padding around the exposed accordion content.',
      'defaultValue': {
        'value': '\'none\'',
        'computed': false
      }
    }
  }
}];