'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBasicTable = exports.SelectionType = exports.ItemIdType = exports.ColumnType = exports.ComputedColumnType = exports.FieldDataColumnType = exports.FieldDataColumnTypeShape = exports.ActionsColumnType = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.getItemId = getItemId;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _services = require('../../services');

var _predicate = require('../../services/predicate');

var _objects = require('../../services/objects');

var _table = require('../table/table');

var _table_header_cell_checkbox = require('../table/table_header_cell_checkbox');

var _checkbox = require('../form/checkbox/checkbox');

var _table_header_cell = require('../table/table_header_cell');

var _table_header = require('../table/table_header');

var _table_body = require('../table/table_body');

var _table_row_cell_checkbox = require('../table/table_row_cell_checkbox');

var _button_icon = require('../button/button_icon/button_icon');

var _icon = require('../icon');

var _collapsed_item_actions = require('./collapsed_item_actions');

var _expanded_item_actions = require('./expanded_item_actions');

var _table_row_cell = require('../table/table_row_cell');

var _table_row = require('../table/table_row');

var _pagination_bar = require('./pagination_bar');

var _icon2 = require('../icon/icon');

var _loading_table_body = require('./loading_table_body');

var _table_header_mobile = require('../table/mobile/table_header_mobile');

var _table_sort_mobile = require('../table/mobile/table_sort_mobile');

var _with_required_prop = require('../../utils/prop_types/with_required_prop');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var dataTypesProfiles = {
  auto: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatAuto)(value);
    }
  },
  string: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatText)(value);
    }
  },
  number: {
    align: _services.RIGHT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatNumber)(value);
    }
  },
  boolean: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatBoolean)(value);
    }
  },
  date: {
    align: _services.LEFT_ALIGNMENT,
    render: function render(value) {
      return (0, _services.formatDate)(value);
    }
  }
};

var DATA_TYPES = Object.keys(dataTypesProfiles);

var DefaultItemActionType = _propTypes2.default.shape({
  type: _propTypes2.default.oneOf(['icon', 'button']), // default is 'button'
  name: _propTypes2.default.string.isRequired,
  description: _propTypes2.default.string.isRequired,
  onClick: _propTypes2.default.func.isRequired, // (item) => void,
  available: _propTypes2.default.func, // (item) => boolean;
  enabled: _propTypes2.default.func, // (item) => boolean;
  icon: _propTypes2.default.oneOfType([// required when type is 'icon'
  _propTypes2.default.oneOf(_icon.ICON_TYPES), _propTypes2.default.func // (item) => oneOf(ICON_TYPES)
  ]),
  color: _propTypes2.default.oneOfType([_propTypes2.default.oneOf(_button_icon.COLORS), _propTypes2.default.func // (item) => oneOf(ICON_BUTTON_COLORS)
  ])
});

var CustomItemActionType = _propTypes2.default.shape({
  render: _propTypes2.default.func.isRequired, // (item, enabled) => PropTypes.node;
  available: _propTypes2.default.func, // (item) => boolean;
  enabled: _propTypes2.default.func // (item) => boolean;
});

var SupportedItemActionType = _propTypes2.default.oneOfType([DefaultItemActionType, CustomItemActionType]);

var ActionsColumnType = exports.ActionsColumnType = _propTypes2.default.shape({
  actions: _propTypes2.default.arrayOf(SupportedItemActionType).isRequired,
  name: _propTypes2.default.string,
  description: _propTypes2.default.string,
  width: _propTypes2.default.string
});

var FieldDataColumnTypeShape = exports.FieldDataColumnTypeShape = {
  field: _propTypes2.default.string.isRequired,
  name: _propTypes2.default.string.isRequired,
  description: _propTypes2.default.string,
  dataType: _propTypes2.default.oneOf(DATA_TYPES),
  width: _propTypes2.default.string,
  sortable: _propTypes2.default.bool,
  align: _propTypes2.default.oneOf([_services.LEFT_ALIGNMENT, _services.RIGHT_ALIGNMENT]),
  truncateText: _propTypes2.default.bool,
  render: _propTypes2.default.func // ((value, record) => PropTypes.node (also see [services/value_renderer] for basic implementations)
};
var FieldDataColumnType = exports.FieldDataColumnType = _propTypes2.default.shape(FieldDataColumnTypeShape);

var ComputedColumnType = exports.ComputedColumnType = _propTypes2.default.shape({
  render: _propTypes2.default.func.isRequired, // (record) => PropTypes.node
  name: _propTypes2.default.string,
  description: _propTypes2.default.string,
  width: _propTypes2.default.string,
  truncateText: _propTypes2.default.bool
});

var ColumnType = exports.ColumnType = _propTypes2.default.oneOfType([FieldDataColumnType, ComputedColumnType, ActionsColumnType]);

var ItemIdType = exports.ItemIdType = _propTypes2.default.oneOfType([_propTypes2.default.string, // the name of the item id property
_propTypes2.default.func // (item) => string
]);

var SelectionType = exports.SelectionType = _propTypes2.default.shape({
  onSelectionChange: _propTypes2.default.func, // (selection: item[]) => void;,
  selectable: _propTypes2.default.func, // (item) => boolean;
  selectableMessage: _propTypes2.default.func // (selectable, item) => boolean;
});

var SortingType = _propTypes2.default.shape({
  sort: _services.PropertySortType
});

var BasicTablePropTypes = {
  items: _propTypes2.default.array.isRequired,
  itemId: ItemIdType,
  columns: _propTypes2.default.arrayOf(ColumnType).isRequired,
  pagination: _pagination_bar.PaginationType,
  sorting: SortingType,
  selection: (0, _with_required_prop.withRequiredProp)(SelectionType, 'itemId', 'row selection uses the itemId prop to identify each row'),
  onChange: _propTypes2.default.func,
  error: _propTypes2.default.string,
  loading: _propTypes2.default.bool,
  noItemsMessage: _propTypes2.default.node,
  className: _propTypes2.default.string,
  compressed: _propTypes2.default.bool,
  itemIdToExpandedRowMap: (0, _with_required_prop.withRequiredProp)(_propTypes2.default.object, 'itemId', 'row expansion uses the itemId prop to identify each row'),
  responsive: _propTypes2.default.bool,
  isSelectable: _propTypes2.default.bool,
  isExpandable: _propTypes2.default.bool,
  hasActions: _propTypes2.default.bool,
  rowProps: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.object]),
  cellProps: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.object])
};

function getItemId(item, itemId) {
  if (itemId) {
    if ((0, _predicate.isFunction)(itemId)) {
      return itemId(item);
    }
    return item[itemId];
  }
}

function getRowProps(item, rowProps) {
  if (rowProps) {
    if ((0, _predicate.isFunction)(rowProps)) {
      return rowProps(item);
    }
    return rowProps;
  }

  return {};
}

function getCellProps(item, column, cellProps) {
  if (cellProps) {
    if ((0, _predicate.isFunction)(cellProps)) {
      return cellProps(item, column);
    }
    return cellProps;
  }

  return {};
}

var EuiBasicTable = exports.EuiBasicTable = function (_Component) {
  _inherits(EuiBasicTable, _Component);

  _createClass(EuiBasicTable, null, [{
    key: 'getDerivedStateFromProps',
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (!nextProps.selection) {
        // next props doesn't have a selection, reset our state
        return { selection: [] };
      }

      var itemId = nextProps.itemId;

      var selection = prevState.selection.filter(function (selectedItem) {
        return nextProps.items.findIndex(function (item) {
          return getItemId(item, itemId) === getItemId(selectedItem, itemId);
        }) !== -1;
      });

      return { selection: selection };
    }
  }]);

  function EuiBasicTable(props) {
    _classCallCheck(this, EuiBasicTable);

    var _this = _possibleConstructorReturn(this, (EuiBasicTable.__proto__ || Object.getPrototypeOf(EuiBasicTable)).call(this, props));

    _this.resolveColumnSortDirection = function (column) {
      var sorting = _this.props.sorting;

      if (!sorting || !sorting.sort || !column.sortable) {
        return;
      }
      if (sorting.sort.field === column.field) {
        return sorting.sort.direction;
      }
    };

    _this.resolveColumnOnSort = function (column) {
      var sorting = _this.props.sorting;

      if (!sorting || !column.sortable) {
        return;
      }
      if (!_this.props.onChange) {
        throw new Error('BasicTable is configured to be sortable on column [' + column.field + '] but\n          [onChange] is not configured. This callback must be implemented to handle the sort requests');
      }
      return function () {
        return _this.onColumnSortChange(column);
      };
    };

    _this.state = {
      selection: []
    };
    return _this;
  }

  _createClass(EuiBasicTable, [{
    key: 'changeSelection',
    value: function changeSelection(selection) {
      if (!this.props.selection) {
        return;
      }
      this.setState({ selection: selection });
      if (this.props.selection.onSelectionChange) {
        this.props.selection.onSelectionChange(selection);
      }
    }
  }, {
    key: 'clearSelection',
    value: function clearSelection() {
      this.changeSelection([]);
    }
  }, {
    key: 'onPageSizeChange',
    value: function onPageSizeChange(size) {
      this.clearSelection();
      var currentCriteria = EuiBasicTable.buildCriteria(this.props);
      var criteria = _extends({}, currentCriteria, {
        page: {
          index: 0, // when page size changes, we take the user back to the first page
          size: size
        }
      });
      this.props.onChange(criteria);
    }
  }, {
    key: 'onPageChange',
    value: function onPageChange(index) {
      this.clearSelection();
      var currentCriteria = EuiBasicTable.buildCriteria(this.props);
      var criteria = _extends({}, currentCriteria, {
        page: _extends({}, currentCriteria.page, {
          index: index
        })
      });
      this.props.onChange(criteria);
    }
  }, {
    key: 'onColumnSortChange',
    value: function onColumnSortChange(column) {
      this.clearSelection();
      var currentCriteria = EuiBasicTable.buildCriteria(this.props);
      var direction = _services.SortDirection.ASC;
      if (currentCriteria && currentCriteria.sort && currentCriteria.sort.field === column.field) {
        direction = _services.SortDirection.reverse(currentCriteria.sort.direction);
      }
      var criteria = _extends({}, currentCriteria, {
        // resetting the page if the criteria has one
        page: !currentCriteria.page ? undefined : {
          index: 0,
          size: currentCriteria.page.size
        },
        sort: {
          field: column.field,
          direction: direction
        }
      });
      this.props.onChange(criteria);
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          loading = _props.loading,
          items = _props.items,
          itemId = _props.itemId,
          columns = _props.columns,
          pagination = _props.pagination,
          sorting = _props.sorting,
          selection = _props.selection,
          onChange = _props.onChange,
          error = _props.error,
          noItemsMessage = _props.noItemsMessage,
          compressed = _props.compressed,
          itemIdToExpandedRowMap = _props.itemIdToExpandedRowMap,
          responsive = _props.responsive,
          isSelectable = _props.isSelectable,
          isExpandable = _props.isExpandable,
          hasActions = _props.hasActions,
          rowProps = _props.rowProps,
          cellProps = _props.cellProps,
          rest = _objectWithoutProperties(_props, ['className', 'loading', 'items', 'itemId', 'columns', 'pagination', 'sorting', 'selection', 'onChange', 'error', 'noItemsMessage', 'compressed', 'itemIdToExpandedRowMap', 'responsive', 'isSelectable', 'isExpandable', 'hasActions', 'rowProps', 'cellProps']);

      var classes = (0, _classnames2.default)('euiBasicTable', {
        'euiBasicTable-loading': loading
      }, className);

      var table = this.renderTable();
      var paginationBar = this.renderPaginationBar();

      return _react2.default.createElement(
        'div',
        _extends({ className: classes }, rest),
        table,
        paginationBar
      );
    }
  }, {
    key: 'renderTable',
    value: function renderTable() {
      var _this2 = this;

      var _props2 = this.props,
          compressed = _props2.compressed,
          responsive = _props2.responsive;


      var mobileHeader = responsive ? _react2.default.createElement(
        _table_header_mobile.EuiTableHeaderMobile,
        null,
        this.renderTableMobileSort()
      ) : undefined;
      var head = this.renderTableHead();
      var body = this.renderTableBody();
      return _react2.default.createElement(
        'div',
        {
          ref: function ref(element) {
            _this2.tableElement = element;
          }
        },
        mobileHeader,
        _react2.default.createElement(
          _table.EuiTable,
          { responsive: responsive, compressed: compressed },
          head,
          body
        )
      );
    }
  }, {
    key: 'renderTableMobileSort',
    value: function renderTableMobileSort() {
      var _this3 = this;

      var _props3 = this.props,
          columns = _props3.columns,
          sorting = _props3.sorting;

      var items = [];

      if (!sorting) {
        return null;
      }

      columns.forEach(function (column, index) {
        if (!column.sortable || column.hideForMobile) {
          return;
        }

        var sortDirection = _this3.resolveColumnSortDirection(column);

        items.push({
          name: column.name,
          key: '_data_s_' + column.field + '_' + index,
          onSort: _this3.resolveColumnOnSort(column),
          isSorted: !!sortDirection,
          isSortAscending: sortDirection ? _services.SortDirection.isAsc(sortDirection) : undefined
        });
      });

      return items.length ? _react2.default.createElement(_table_sort_mobile.EuiTableSortMobile, { items: items }) : null;
    }
  }, {
    key: 'renderTableHead',
    value: function renderTableHead() {
      var _this4 = this;

      var _props4 = this.props,
          items = _props4.items,
          columns = _props4.columns,
          selection = _props4.selection;


      var headers = [];

      if (selection) {
        var selectableItems = items.filter(function (item) {
          return !selection.selectable || selection.selectable(item);
        });

        var checked = this.state.selection && selectableItems.length > 0 && this.state.selection.length === selectableItems.length;

        var disabled = selectableItems.length === 0;

        var onChange = function onChange(event) {
          if (event.target.checked) {
            _this4.changeSelection(selectableItems);
          } else {
            _this4.changeSelection([]);
          }
        };

        headers.push(_react2.default.createElement(
          _table_header_cell_checkbox.EuiTableHeaderCellCheckbox,
          { key: '_selection_column_h', width: '24px' },
          _react2.default.createElement(_checkbox.EuiCheckbox, {
            id: '_selection_column-checkbox',
            type: 'inList',
            checked: checked,
            disabled: disabled,
            onChange: onChange,
            'data-test-subj': 'checkboxSelectAll',
            'aria-label': 'Select all rows'
          })
        ));
      }

      columns.forEach(function (column, index) {
        var actions = column.actions,
            width = column.width,
            name = column.name,
            field = column.field,
            align = column.align,
            dataType = column.dataType,
            sortable = column.sortable,
            isMobileHeader = column.isMobileHeader,
            hideForMobile = column.hideForMobile;


        var columnAlign = align || _this4.getAlignForDataType(dataType);

        // actions column
        if (actions) {
          headers.push(_react2.default.createElement(
            _table_header_cell.EuiTableHeaderCell,
            {
              key: '_actions_h_' + index,
              align: 'right',
              width: width
            },
            name
          ));
          return;
        }

        // computed column
        if (!field) {
          headers.push(_react2.default.createElement(
            _table_header_cell.EuiTableHeaderCell,
            {
              key: '_computed_column_h_' + index,
              align: columnAlign,
              width: width
            },
            name
          ));
          return;
        }

        // field data column
        var sorting = {};
        if (_this4.props.sorting && sortable) {
          var sortDirection = _this4.resolveColumnSortDirection(column);
          sorting.isSorted = !!sortDirection;
          sorting.isSortAscending = sortDirection ? _services.SortDirection.isAsc(sortDirection) : undefined;
          sorting.onSort = _this4.resolveColumnOnSort(column);
        }
        headers.push(_react2.default.createElement(
          _table_header_cell.EuiTableHeaderCell,
          _extends({
            key: '_data_h_' + field + '_' + index,
            align: columnAlign,
            width: width,
            isMobileHeader: isMobileHeader,
            hideForMobile: hideForMobile
          }, sorting),
          name
        ));
      });

      return _react2.default.createElement(
        _table_header.EuiTableHeader,
        null,
        headers
      );
    }
  }, {
    key: 'renderTableBody',
    value: function renderTableBody() {
      var _this5 = this;

      if (this.props.error) {
        return this.renderErrorBody(this.props.error);
      }
      var items = this.props.items;

      if (items.length === 0) {
        return this.renderEmptyBody();
      }
      var rows = items.map(function (item, index) {
        // if there's pagination the item's index must be adjusted to the where it is in the whole dataset
        var tableItemIndex = _this5.props.pagination ? _this5.props.pagination.pageIndex * _this5.props.pagination.pageSize + index : index;
        return _this5.renderItemRow(item, tableItemIndex);
      });
      if (this.props.loading) {
        return _react2.default.createElement(
          _loading_table_body.LoadingTableBody,
          null,
          rows
        );
      }
      return _react2.default.createElement(
        _table_body.EuiTableBody,
        null,
        rows
      );
    }
  }, {
    key: 'renderErrorBody',
    value: function renderErrorBody(error) {
      var colSpan = this.props.columns.length + (this.props.selection ? 1 : 0);
      return _react2.default.createElement(
        _table_body.EuiTableBody,
        null,
        _react2.default.createElement(
          _table_row.EuiTableRow,
          null,
          _react2.default.createElement(
            _table_row_cell.EuiTableRowCell,
            { align: 'center', colSpan: colSpan, isMobileFullWidth: true },
            _react2.default.createElement(_icon2.EuiIcon, { type: 'minusInCircle', color: 'danger' }),
            ' ',
            error
          )
        )
      );
    }
  }, {
    key: 'renderEmptyBody',
    value: function renderEmptyBody() {
      var _props5 = this.props,
          columns = _props5.columns,
          selection = _props5.selection,
          noItemsMessage = _props5.noItemsMessage;

      var colSpan = columns.length + (selection ? 1 : 0);
      return _react2.default.createElement(
        _table_body.EuiTableBody,
        null,
        _react2.default.createElement(
          _table_row.EuiTableRow,
          null,
          _react2.default.createElement(
            _table_row_cell.EuiTableRowCell,
            { align: 'center', colSpan: colSpan, isMobileFullWidth: true },
            noItemsMessage
          )
        )
      );
    }
  }, {
    key: 'renderItemRow',
    value: function renderItemRow(item, rowIndex) {
      var _this6 = this;

      var _props6 = this.props,
          columns = _props6.columns,
          selection = _props6.selection,
          isSelectable = _props6.isSelectable,
          hasActions = _props6.hasActions,
          _props6$itemIdToExpan = _props6.itemIdToExpandedRowMap,
          itemIdToExpandedRowMap = _props6$itemIdToExpan === undefined ? {} : _props6$itemIdToExpan,
          isExpandable = _props6.isExpandable;


      var cells = [];

      var itemIdCallback = this.props.itemId;

      var itemId = getItemId(item, itemIdCallback) || rowIndex;
      var selected = !selection ? false : this.state.selection && !!this.state.selection.find(function (selectedItem) {
        return getItemId(selectedItem, itemIdCallback) === itemId;
      });

      if (selection) {
        cells.push(this.renderItemSelectionCell(itemId, item, selected));
      }

      columns.forEach(function (column, columnIndex) {
        if (column.actions) {
          cells.push(_this6.renderItemActionsCell(itemId, item, column, columnIndex, rowIndex));
        } else if (column.field) {
          cells.push(_this6.renderItemFieldDataCell(itemId, item, column, columnIndex));
        } else {
          cells.push(_this6.renderItemComputedCell(itemId, item, column, columnIndex));
        }
      });

      // Occupy full width of table, taking checkbox & mobile only columns into account.
      var expandedRowColSpan = selection ? columns.length + 1 : columns.length;

      var mobileOnlyCols = columns.reduce(function (num, column) {
        return column.isMobileHeader ? num + 1 : num + 0;
      }, 0);

      expandedRowColSpan = expandedRowColSpan - mobileOnlyCols;

      // We'll use the ID to associate the expanded row with the original.
      var hasExpandedRow = itemIdToExpandedRowMap.hasOwnProperty(itemId);
      var expandedRowId = hasExpandedRow ? 'row_' + itemId + '_expansion' : undefined;
      var expandedRow = hasExpandedRow ? _react2.default.createElement(
        _table_row.EuiTableRow,
        { id: expandedRowId, isExpandedRow: true, isSelectable: isSelectable },
        _react2.default.createElement(
          _table_row_cell.EuiTableRowCell,
          { colSpan: expandedRowColSpan },
          itemIdToExpandedRowMap[itemId]
        )
      ) : undefined;

      var rowPropsCallback = this.props.rowProps;

      var rowProps = getRowProps(item, rowPropsCallback);

      return _react2.default.createElement(
        _react.Fragment,
        { key: 'row_' + itemId },
        _react2.default.createElement(
          _table_row.EuiTableRow,
          _extends({
            'aria-owns': expandedRowId,
            isSelectable: isSelectable,
            isSelected: selected,
            hasActions: hasActions,
            isExpandable: isExpandable
          }, rowProps),
          cells
        ),
        expandedRow
      );
    }
  }, {
    key: 'renderItemSelectionCell',
    value: function renderItemSelectionCell(itemId, item, selected) {
      var _this7 = this;

      var selection = this.props.selection;

      var key = '_selection_column_' + itemId;
      var checked = selected;
      var disabled = selection.selectable && !selection.selectable(item);
      var title = selection.selectableMessage && selection.selectableMessage(!disabled, item);
      var onChange = function onChange(event) {
        if (event.target.checked) {
          _this7.changeSelection([].concat(_toConsumableArray(_this7.state.selection), [item]));
        } else {
          var itemIdCallback = _this7.props.itemId;

          _this7.changeSelection(_this7.state.selection.reduce(function (selection, selectedItem) {
            if (getItemId(selectedItem, itemIdCallback) !== itemId) {
              selection.push(selectedItem);
            }
            return selection;
          }, []));
        }
      };
      return _react2.default.createElement(
        _table_row_cell_checkbox.EuiTableRowCellCheckbox,
        { key: key },
        _react2.default.createElement(_checkbox.EuiCheckbox, {
          id: key + '-checkbox',
          type: 'inList',
          disabled: disabled,
          checked: checked,
          onChange: onChange,
          title: title,
          'aria-label': 'Select this row',
          'data-test-subj': 'checkboxSelectRow-' + itemId
        })
      );
    }
  }, {
    key: 'renderItemActionsCell',
    value: function renderItemActionsCell(itemId, item, column, columnIndex) {
      var _this8 = this;

      var actionEnabled = function actionEnabled(action) {
        return _this8.state.selection.length === 0 && (!action.enabled || action.enabled(item));
      };

      var actualActions = column.actions;
      if (column.actions.length > 1) {

        // if we have more than 1 action, we don't show them all in the cell, instead we
        // put them all in a popover tool. This effectively means we can only have a maximum
        // of one tool per row (it's either and normal action, or it's a popover that shows multiple actions)
        //
        // here we create a single custom action that triggers the popover with all the configured actions

        actualActions = [{
          name: 'Actions',
          render: function render(item) {
            return _react2.default.createElement(_collapsed_item_actions.CollapsedItemActions, {
              actions: column.actions,
              itemId: itemId,
              item: item,
              actionEnabled: actionEnabled
            });
          }
        }];
      }

      var tools = _react2.default.createElement(_expanded_item_actions.ExpandedItemActions, {
        actions: actualActions,
        itemId: itemId,
        item: item,
        actionEnabled: actionEnabled
      });

      var key = 'record_actions_' + itemId + '_' + columnIndex;
      return _react2.default.createElement(
        _table_row_cell.EuiTableRowCell,
        {
          showOnHover: true,
          key: key,
          align: 'right',
          textOnly: false,
          hasActions: true
        },
        tools
      );
    }
  }, {
    key: 'renderItemFieldDataCell',
    value: function renderItemFieldDataCell(itemId, item, column, columnIndex) {
      var field = column.field,
          render = column.render,
          dataType = column.dataType;


      var key = '_data_column_' + field + '_' + itemId + '_' + columnIndex;
      var contentRenderer = render || this.getRendererForDataType(dataType);
      var value = (0, _objects.get)(item, field);
      var content = contentRenderer(value, item);

      return this.renderItemCell(item, column, key, content);
    }
  }, {
    key: 'renderItemComputedCell',
    value: function renderItemComputedCell(itemId, item, column, columnIndex) {
      var render = column.render,
          dataType = column.dataType;


      var key = '_computed_column_' + itemId + '_' + columnIndex;
      var contentRenderer = render || this.getRendererForDataType(dataType);
      var content = contentRenderer(item);

      return this.renderItemCell(item, column, key, content);
    }
  }, {
    key: 'renderItemCell',
    value: function renderItemCell(item, column, key, content) {
      var align = column.align,
          render = column.render,
          dataType = column.dataType,
          isExpander = column.isExpander,
          name = column.name,
          textOnly = column.textOnly,
          field = column.field,
          description = column.description,
          sortable = column.sortable,
          rest = _objectWithoutProperties(column, ['align', 'render', 'dataType', 'isExpander', 'name', 'textOnly', 'field', 'description', 'sortable']);

      var columnAlign = align || this.getAlignForDataType(dataType);
      var cellPropsCallback = this.props.cellProps;

      var cellProps = getCellProps(item, column, cellPropsCallback);

      return _react2.default.createElement(
        _table_row_cell.EuiTableRowCell,
        _extends({
          key: key,
          align: columnAlign,
          header: name,
          isExpander: isExpander,
          textOnly: textOnly || !render
        }, cellProps, rest),
        content
      );
    }
  }, {
    key: 'getRendererForDataType',
    value: function getRendererForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';

      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error('Unknown dataType [' + dataType + ']. The supported data types are [' + DATA_TYPES.join(', ') + ']');
      }
      return profile.render;
    }
  }, {
    key: 'getAlignForDataType',
    value: function getAlignForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';

      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error('Unknown dataType [' + dataType + ']. The supported data types are [' + DATA_TYPES.join(', ') + ']');
      }
      return profile.align;
    }
  }, {
    key: 'renderPaginationBar',
    value: function renderPaginationBar() {
      var _props7 = this.props,
          error = _props7.error,
          pagination = _props7.pagination,
          onChange = _props7.onChange;

      if (!error && pagination) {
        if (!onChange) {
          throw new Error('The Basic Table is configured with pagination but [onChange] is\n        not configured. This callback must be implemented to handle pagination changes');
        }
        return _react2.default.createElement(_pagination_bar.PaginationBar, {
          pagination: pagination,
          onPageSizeChange: this.onPageSizeChange.bind(this),
          onPageChange: this.onPageChange.bind(this)
        });
      }
    }
  }], [{
    key: 'buildCriteria',
    value: function buildCriteria(props) {
      var criteria = {};
      if (props.pagination) {
        criteria.page = {
          index: props.pagination.pageIndex,
          size: props.pagination.pageSize
        };
      }
      if (props.sorting) {
        criteria.sort = props.sorting.sort;
      }
      return criteria;
    }
  }]);

  return EuiBasicTable;
}(_react.Component);

EuiBasicTable.propTypes = BasicTablePropTypes;
EuiBasicTable.defaultProps = {
  responsive: true,
  noItemsMessage: 'No items found'
};
EuiBasicTable.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiBasicTable',
  'methods': [{
    'name': 'getDerivedStateFromProps',
    'docblock': null,
    'modifiers': ['static'],
    'params': [{
      'name': 'nextProps',
      'type': null
    }, {
      'name': 'prevState',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'buildCriteria',
    'docblock': null,
    'modifiers': ['static'],
    'params': [{
      'name': 'props',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'changeSelection',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'selection',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'clearSelection',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'onPageSizeChange',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'size',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'onPageChange',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'index',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'onColumnSortChange',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'column',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderTable',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'renderTableMobileSort',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'renderTableHead',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'renderTableBody',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'renderErrorBody',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'error',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderEmptyBody',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': 'renderItemRow',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'item',
      'type': null
    }, {
      'name': 'rowIndex',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderItemSelectionCell',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'itemId',
      'type': null
    }, {
      'name': 'item',
      'type': null
    }, {
      'name': 'selected',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderItemActionsCell',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'itemId',
      'type': null
    }, {
      'name': 'item',
      'type': null
    }, {
      'name': 'column',
      'type': null
    }, {
      'name': 'columnIndex',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderItemFieldDataCell',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'itemId',
      'type': null
    }, {
      'name': 'item',
      'type': null
    }, {
      'name': 'column',
      'type': null
    }, {
      'name': 'columnIndex',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderItemComputedCell',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'itemId',
      'type': null
    }, {
      'name': 'item',
      'type': null
    }, {
      'name': 'column',
      'type': null
    }, {
      'name': 'columnIndex',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderItemCell',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'item',
      'type': null
    }, {
      'name': 'column',
      'type': null
    }, {
      'name': 'key',
      'type': null
    }, {
      'name': 'content',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'resolveColumnSortDirection',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'column',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'resolveColumnOnSort',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'column',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'getRendererForDataType',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'dataType',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'getAlignForDataType',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'dataType',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'renderPaginationBar',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }],
  'props': {
    'items': {
      'type': {
        'name': 'array'
      },
      'required': true,
      'description': ''
    },
    'itemId': {
      'type': {
        'name': 'custom',
        'raw': 'ItemIdType'
      },
      'required': false,
      'description': ''
    },
    'columns': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'custom',
          'raw': 'ColumnType'
        }
      },
      'required': true,
      'description': ''
    },
    'pagination': {
      'type': {
        'name': 'custom',
        'raw': 'PaginationType'
      },
      'required': false,
      'description': ''
    },
    'sorting': {
      'type': {
        'name': 'custom',
        'raw': 'SortingType'
      },
      'required': false,
      'description': ''
    },
    'selection': {
      'type': {
        'name': 'custom',
        'raw': 'withRequiredProp(SelectionType, \'itemId\', \'row selection uses the itemId prop to identify each row\')'
      },
      'required': false,
      'description': ''
    },
    'onChange': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    },
    'error': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'loading': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'noItemsMessage': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': '\'No items found\'',
        'computed': false
      }
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'compressed': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'itemIdToExpandedRowMap': {
      'type': {
        'name': 'custom',
        'raw': 'withRequiredProp(PropTypes.object, \'itemId\', \'row expansion uses the itemId prop to identify each row\')'
      },
      'required': false,
      'description': ''
    },
    'responsive': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'true',
        'computed': false
      }
    },
    'isSelectable': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'isExpandable': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'hasActions': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'rowProps': {
      'type': {
        'name': 'union',
        'value': [{
          'name': 'func'
        }, {
          'name': 'object'
        }]
      },
      'required': false,
      'description': ''
    },
    'cellProps': {
      'type': {
        'name': 'union',
        'value': [{
          'name': 'func'
        }, {
          'name': 'object'
        }]
      },
      'required': false,
      'description': ''
    }
  }
}];