'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSeriesChild = isSeriesChild;
exports.getSeriesChildren = getSeriesChildren;
exports.rotateDataSeries = rotateDataSeries;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactVis = require('react-vis');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Check if the component is series or not.
 * @param {React.Component} child Component.
 * @returns {boolean} True if the child is series, false otherwise.
 */
function isSeriesChild(child) {
  var prototype = child.type.prototype;

  return prototype instanceof _reactVis.AbstractSeries;
}

/**
 * Get all series from the 'children' object of the component.
 * @param {Object} children Children.
 * @returns {Array} Array of children.
 */
function getSeriesChildren(children) {
  return _react2.default.Children.toArray(children).filter(function (child) {
    return child && isSeriesChild(child);
  });
}

function rotateDataSeries(data) {
  return data.map(function (d) {
    return {
      x: d.y,
      y: d.x,
      x0: d.y0,
      y0: d.x0
    };
  });
}