'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenActionCreators = exports.flattenReducerMap = exports.flattenActionMap = undefined;

var _camelCase = require('./camelCase');

var _camelCase2 = _interopRequireDefault(_camelCase);

var _ownKeys = require('./ownKeys');

var _ownKeys2 = _interopRequireDefault(_ownKeys);

var _hasGeneratorInterface = require('./hasGeneratorInterface');

var _hasGeneratorInterface2 = _interopRequireDefault(_hasGeneratorInterface);

var _isPlainObject = require('lodash/isPlainObject');

var _isPlainObject2 = _interopRequireDefault(_isPlainObject);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var defaultNamespace = '/';

var flattenWhenNode = function flattenWhenNode(predicate) {
  return function flatten(map) {
    var namespace = arguments.length <= 1 || arguments[1] === undefined ? defaultNamespace : arguments[1];
    var partialFlatMap = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];
    var partialFlatActionType = arguments.length <= 3 || arguments[3] === undefined ? '' : arguments[3];

    function connectNamespace(type) {
      return partialFlatActionType ? '' + partialFlatActionType + namespace + type : type;
    }

    (0, _ownKeys2.default)(map).forEach(function (type) {
      var nextNamespace = connectNamespace(type);
      var mapValue = map[type];

      if (!predicate(mapValue)) {
        partialFlatMap[nextNamespace] = map[type];
      } else {
        flatten(map[type], namespace, partialFlatMap, nextNamespace);
      }
    });

    return partialFlatMap;
  };
};

var flattenActionMap = flattenWhenNode(_isPlainObject2.default);
var flattenReducerMap = flattenWhenNode(function (node) {
  return (0, _isPlainObject2.default)(node) && !(0, _hasGeneratorInterface2.default)(node);
});

function unflattenActionCreators(flatActionCreators) {
  var namespace = arguments.length <= 1 || arguments[1] === undefined ? defaultNamespace : arguments[1];

  function unflatten(flatActionType) {
    var partialNestedActionCreators = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var partialFlatActionTypePath = arguments.length <= 2 || arguments[2] === undefined ? [] : arguments[2];

    var nextNamespace = (0, _camelCase2.default)(partialFlatActionTypePath.shift());
    if (partialFlatActionTypePath.length) {
      if (!partialNestedActionCreators[nextNamespace]) {
        partialNestedActionCreators[nextNamespace] = {};
      }
      unflatten(flatActionType, partialNestedActionCreators[nextNamespace], partialFlatActionTypePath);
    } else {
      partialNestedActionCreators[nextNamespace] = flatActionCreators[flatActionType];
    }
  }

  var nestedActionCreators = {};
  Object.getOwnPropertyNames(flatActionCreators).forEach(function (type) {
    return unflatten(type, nestedActionCreators, type.split(namespace));
  });
  return nestedActionCreators;
}

exports.flattenActionMap = flattenActionMap;
exports.flattenReducerMap = flattenReducerMap;
exports.unflattenActionCreators = unflattenActionCreators;