"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var mark_1 = require("./../mark");
var boxplot_1 = require("./boxplot");
var errorbar_1 = require("./errorbar");
/**
 * Registry index for all composite mark's normalizer
 */
var normalizerRegistry = {};
function add(mark, normalizer) {
    normalizerRegistry[mark] = normalizer;
}
exports.add = add;
function remove(mark) {
    delete normalizerRegistry[mark];
}
exports.remove = remove;
exports.COMPOSITE_MARK_STYLES = boxplot_1.BOXPLOT_STYLES;
exports.VL_ONLY_COMPOSITE_MARK_SPECIFIC_CONFIG_PROPERTY_INDEX = tslib_1.__assign({}, boxplot_1.VL_ONLY_BOXPLOT_CONFIG_PROPERTY_INDEX);
add(boxplot_1.BOXPLOT, boxplot_1.normalizeBoxPlot);
add(errorbar_1.ERRORBAR, errorbar_1.normalizeErrorBar);
/**
 * Transform a unit spec with composite mark into a normal layer spec.
 */
function normalize(
// This GenericUnitSpec has any as Encoding because unit specs with composite mark can have additional encoding channels.
spec, config) {
    var mark = mark_1.isMarkDef(spec.mark) ? spec.mark.type : spec.mark;
    var normalizer = normalizerRegistry[mark];
    if (normalizer) {
        return normalizer(spec, config);
    }
    throw new Error("Invalid mark type \"" + mark + "\"");
}
exports.normalize = normalize;
//# sourceMappingURL=data:application/json;base64,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