module.exports = (function() {
  "use strict";

  /*
   * Generated by PEG.js 0.9.0.
   *
   * http://pegjs.org/
   */

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.location = location;
    this.name     = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  function peg$parse(input) {
    var options = arguments.length > 1 ? arguments[1] : {},
        parser  = this,

        peg$FAILED = {},

        peg$startRuleFunctions = { start: peg$parsestart, Literal: peg$parseLiteral },
        peg$startRuleFunction  = peg$parsestart,

        peg$c0 = function(query, trailing) {
            if (trailing.type === 'cursor') {
              return {
                ...trailing,
                suggestionTypes: ['conjunction']
              };
            }
            if (query !== null) return query;
            return nodeTypes.function.buildNode('is', '*', '*');
          },
        peg$c1 = function(left, right) {
            const cursor = [left, right].find(node => node.type === 'cursor');
            if (cursor) return cursor;
            return buildFunctionNode('or', [left, right]);
          },
        peg$c2 = function(left, right) {
            const cursor = [left, right].find(node => node.type === 'cursor');
            if (cursor) return cursor;
            return buildFunctionNode('and', [left, right]);
          },
        peg$c3 = function(query) {
            if (query.type === 'cursor') return query;
            return buildFunctionNode('not', [query]);
          },
        peg$c4 = "(",
        peg$c5 = { type: "literal", value: "(", description: "\"(\"" },
        peg$c6 = ")",
        peg$c7 = { type: "literal", value: ")", description: "\")\"" },
        peg$c8 = function(query, trailing) {
            if (trailing.type === 'cursor') {
              return {
                ...trailing,
                suggestionTypes: ['conjunction']
              };
            }
            return query;
          },
        peg$c9 = function(field, operator, value) {
            if (value.type === 'cursor') {
              return {
                ...value,
                suggestionTypes: ['conjunction']
              };
            }
            const range = buildNamedArgNode(operator, value);
            return buildFunctionNode('range', [field, range]);
          },
        peg$c10 = ":",
        peg$c11 = { type: "literal", value: ":", description: "\":\"" },
        peg$c12 = function(field, partial) {
            if (partial.type === 'cursor') {
              return {
                ...partial,
                fieldName: field.value,
                suggestionTypes: ['value', 'conjunction']
              };
            }
            return partial(field);
          },
        peg$c13 = function(partial) {
            if (partial.type === 'cursor') {
              const fieldName = `${partial.prefix}${partial.suffix}`.trim();
              return {
                ...partial,
                fieldName,
                suggestionTypes: ['field', 'operator', 'conjunction']
              };
            }
            const field = buildLiteralNode(null);
            return partial(field);
          },
        peg$c14 = function(partial, trailing) {
            if (trailing.type === 'cursor') {
              return {
                ...trailing,
                suggestionTypes: ['conjunction']
              };
            }
            return partial;
          },
        peg$c15 = function(partialLeft, partialRight) {
            const cursor = [partialLeft, partialRight].find(node => node.type === 'cursor');
            if (cursor) {
              return {
                ...cursor,
                suggestionTypes: ['value']
              };
            }
            return (field) => buildFunctionNode('or', [partialLeft(field), partialRight(field)]);
          },
        peg$c16 = function(partialLeft, partialRight) {
            const cursor = [partialLeft, partialRight].find(node => node.type === 'cursor');
            if (cursor) {
              return {
                ...cursor,
                suggestionTypes: ['value']
              };
            }
            return (field) => buildFunctionNode('and', [partialLeft(field), partialRight(field)]);
          },
        peg$c17 = function(partial) {
            if (partial.type === 'cursor') {
              return {
                ...list,
                suggestionTypes: ['value']
              };
            }
            return (field) => buildFunctionNode('not', [partial(field)]);
          },
        peg$c18 = function(value) {
            if (value.type === 'cursor') return value;
            const isPhrase = buildLiteralNode(true);
            return (field) => buildFunctionNode('is', [field, value, isPhrase]);
          },
        peg$c19 = function(value) {
            if (value.type === 'cursor') return value;

            if (!allowLeadingWildcards && value.type === 'wildcard' && nodeTypes.wildcard.hasLeadingWildcard(value)) {
              throw new errors.NoLeadingWildcardsError();
            }

            const isPhrase = buildLiteralNode(false);
            return (field) => buildFunctionNode('is', [field, value, isPhrase]);
          },
        peg$c20 = "or",
        peg$c21 = { type: "literal", value: "or", description: "\"or\"" },
        peg$c22 = "and",
        peg$c23 = { type: "literal", value: "and", description: "\"and\"" },
        peg$c24 = "not",
        peg$c25 = { type: "literal", value: "not", description: "\"not\"" },
        peg$c26 = "\"",
        peg$c27 = { type: "literal", value: "\"", description: "\"\\\"\"" },
        peg$c28 = function(prefix, cursor, suffix) {
            const { start, end } = location();
            return {
              type: 'cursor',
              start: start.offset,
              end: end.offset - cursor.length,
              prefix: prefix.join(''),
              suffix: suffix.join(''),
              text: text().replace(cursor, '')
            };
          },
        peg$c29 = function(chars) {
            return buildLiteralNode(chars.join(''));
          },
        peg$c30 = "\\",
        peg$c31 = { type: "literal", value: "\\", description: "\"\\\\\"" },
        peg$c32 = /^[\\"]/,
        peg$c33 = { type: "class", value: "[\\\\\"]", description: "[\\\\\"]" },
        peg$c34 = function(char) { return char; },
        peg$c35 = /^[^"]/,
        peg$c36 = { type: "class", value: "[^\"]", description: "[^\"]" },
        peg$c37 = function(chars) {
            const sequence = chars.join('').trim();
            if (sequence === 'null') return buildLiteralNode(null);
            if (sequence === 'true') return buildLiteralNode(true);
            if (sequence === 'false') return buildLiteralNode(false);
            if (chars.includes(wildcardSymbol)) return buildWildcardNode(sequence);
            const number = Number(sequence);
            const value = isNaN(number) ? sequence : number;
            return buildLiteralNode(value);
          },
        peg$c38 = { type: "any", description: "any character" },
        peg$c39 = "*",
        peg$c40 = { type: "literal", value: "*", description: "\"*\"" },
        peg$c41 = function() { return wildcardSymbol; },
        peg$c42 = function(keyword) { return keyword; },
        peg$c43 = /^[\\():<>"*]/,
        peg$c44 = { type: "class", value: "[\\\\():<>\"*]", description: "[\\\\():<>\"*]" },
        peg$c45 = "<=",
        peg$c46 = { type: "literal", value: "<=", description: "\"<=\"" },
        peg$c47 = function() { return 'lte'; },
        peg$c48 = ">=",
        peg$c49 = { type: "literal", value: ">=", description: "\">=\"" },
        peg$c50 = function() { return 'gte'; },
        peg$c51 = "<",
        peg$c52 = { type: "literal", value: "<", description: "\"<\"" },
        peg$c53 = function() { return 'lt'; },
        peg$c54 = ">",
        peg$c55 = { type: "literal", value: ">", description: "\">\"" },
        peg$c56 = function() { return 'gt'; },
        peg$c57 = /^[ \t\r\n]/,
        peg$c58 = { type: "class", value: "[\\ \\t\\r\\n]", description: "[\\ \\t\\r\\n]" },
        peg$c59 = function() { return parseCursor; },
        peg$c60 = "@kuery-cursor@",
        peg$c61 = { type: "literal", value: "@kuery-cursor@", description: "\"@kuery-cursor@\"" },
        peg$c62 = function() { return cursorSymbol; },

        peg$currPos          = 0,
        peg$savedPos         = 0,
        peg$posDetailsCache  = [{ line: 1, column: 1, seenCR: false }],
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description) {
      throw peg$buildException(
        null,
        [{ type: "other", description: description }],
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function error(message) {
      throw peg$buildException(
        message,
        null,
        input.substring(peg$savedPos, peg$currPos),
        peg$computeLocation(peg$savedPos, peg$currPos)
      );
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos],
          p, ch;

      if (details) {
        return details;
      } else {
        p = pos - 1;
        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line:   details.line,
          column: details.column,
          seenCR: details.seenCR
        };

        while (p < pos) {
          ch = input.charAt(p);
          if (ch === "\n") {
            if (!details.seenCR) { details.line++; }
            details.column = 1;
            details.seenCR = false;
          } else if (ch === "\r" || ch === "\u2028" || ch === "\u2029") {
            details.line++;
            details.column = 1;
            details.seenCR = true;
          } else {
            details.column++;
            details.seenCR = false;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails   = peg$computePosDetails(endPos);

      return {
        start: {
          offset: startPos,
          line:   startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line:   endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildException(message, expected, found, location) {
      function cleanupExpected(expected) {
        var i = 1;

        expected.sort(function(a, b) {
          if (a.description < b.description) {
            return -1;
          } else if (a.description > b.description) {
            return 1;
          } else {
            return 0;
          }
        });

        while (i < expected.length) {
          if (expected[i - 1] === expected[i]) {
            expected.splice(i, 1);
          } else {
            i++;
          }
        }
      }

      function buildMessage(expected, found) {
        function stringEscape(s) {
          function hex(ch) { return ch.charCodeAt(0).toString(16).toUpperCase(); }

          return s
            .replace(/\\/g,   '\\\\')
            .replace(/"/g,    '\\"')
            .replace(/\x08/g, '\\b')
            .replace(/\t/g,   '\\t')
            .replace(/\n/g,   '\\n')
            .replace(/\f/g,   '\\f')
            .replace(/\r/g,   '\\r')
            .replace(/[\x00-\x07\x0B\x0E\x0F]/g, function(ch) { return '\\x0' + hex(ch); })
            .replace(/[\x10-\x1F\x80-\xFF]/g,    function(ch) { return '\\x'  + hex(ch); })
            .replace(/[\u0100-\u0FFF]/g,         function(ch) { return '\\u0' + hex(ch); })
            .replace(/[\u1000-\uFFFF]/g,         function(ch) { return '\\u'  + hex(ch); });
        }

        var expectedDescs = new Array(expected.length),
            expectedDesc, foundDesc, i;

        for (i = 0; i < expected.length; i++) {
          expectedDescs[i] = expected[i].description;
        }

        expectedDesc = expected.length > 1
          ? expectedDescs.slice(0, -1).join(", ")
              + " or "
              + expectedDescs[expected.length - 1]
          : expectedDescs[0];

        foundDesc = found ? "\"" + stringEscape(found) + "\"" : "end of input";

        return "Expected " + expectedDesc + " but " + foundDesc + " found.";
      }

      if (expected !== null) {
        cleanupExpected(expected);
      }

      return new peg$SyntaxError(
        message !== null ? message : buildMessage(expected, found),
        expected,
        found,
        location
      );
    }

    function peg$parsestart() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseOrQuery();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOptionalSpace();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c0(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseOrQuery() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseAndQuery();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseOr();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrQuery();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c1(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseAndQuery();
      }

      return s0;
    }

    function peg$parseAndQuery() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseNotQuery();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseAnd();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseAndQuery();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c2(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseNotQuery();
      }

      return s0;
    }

    function peg$parseNotQuery() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseNot();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseSubQuery();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c3(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseSubQuery();
      }

      return s0;
    }

    function peg$parseSubQuery() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c4;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c5); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrQuery();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c6;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c7); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c8(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseExpression();
      }

      return s0;
    }

    function peg$parseExpression() {
      var s0;

      s0 = peg$parseFieldRangeExpression();
      if (s0 === peg$FAILED) {
        s0 = peg$parseFieldValueExpression();
        if (s0 === peg$FAILED) {
          s0 = peg$parseValueExpression();
        }
      }

      return s0;
    }

    function peg$parseFieldRangeExpression() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseLiteral();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseRangeOperator();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseQuotedString();
              if (s5 === peg$FAILED) {
                s5 = peg$parseUnquotedLiteral();
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c9(s1, s3, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseFieldValueExpression() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      s1 = peg$parseLiteral();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s3 = peg$c10;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c11); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseSpace();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseSpace();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseListOfValues();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c12(s1, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseValueExpression() {
      var s0, s1;

      s0 = peg$currPos;
      s1 = peg$parseValue();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c13(s1);
      }
      s0 = s1;

      return s0;
    }

    function peg$parseListOfValues() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c4;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c5); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseSpace();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrListOfValues();
          if (s3 !== peg$FAILED) {
            s4 = peg$parseOptionalSpace();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c6;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c7); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c14(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseValue();
      }

      return s0;
    }

    function peg$parseOrListOfValues() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseAndListOfValues();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseOr();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrListOfValues();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c15(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseAndListOfValues();
      }

      return s0;
    }

    function peg$parseAndListOfValues() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      s1 = peg$parseNotListOfValues();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseAnd();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseAndListOfValues();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c16(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseNotListOfValues();
      }

      return s0;
    }

    function peg$parseNotListOfValues() {
      var s0, s1, s2;

      s0 = peg$currPos;
      s1 = peg$parseNot();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseListOfValues();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c17(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$parseListOfValues();
      }

      return s0;
    }

    function peg$parseValue() {
      var s0, s1;

      s0 = peg$currPos;
      s1 = peg$parseQuotedString();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c18(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseUnquotedLiteral();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c19(s1);
        }
        s0 = s1;
      }

      return s0;
    }

    function peg$parseOr() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c20) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c21); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();
          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseAnd() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseSpace();
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c22) {
          s2 = input.substr(peg$currPos, 3);
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c23); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();
          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseSpace();
            }
          } else {
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseNot() {
      var s0, s1, s2, s3;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c24) {
        s1 = input.substr(peg$currPos, 3);
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c25); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseSpace();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseSpace();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseLiteral() {
      var s0;

      s0 = peg$parseQuotedString();
      if (s0 === peg$FAILED) {
        s0 = peg$parseUnquotedLiteral();
      }

      return s0;
    }

    function peg$parseQuotedString() {
      var s0, s1, s2, s3, s4, s5;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c26;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c27); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseQuotedCharacter();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseQuotedCharacter();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseCursor();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseQuotedCharacter();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseQuotedCharacter();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 34) {
                s5 = peg$c26;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c27); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c28(s2, s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 34) {
          s1 = peg$c26;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c27); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseQuotedCharacter();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseQuotedCharacter();
          }
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 34) {
              s3 = peg$c26;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c27); }
            }
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c29(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      return s0;
    }

    function peg$parseQuotedCharacter() {
      var s0, s1, s2;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c30;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c31); }
      }
      if (s1 !== peg$FAILED) {
        if (peg$c32.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c33); }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c34(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$currPos;
        peg$silentFails++;
        s2 = peg$parseCursor();
        peg$silentFails--;
        if (s2 === peg$FAILED) {
          s1 = void 0;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          if (peg$c35.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c36); }
          }
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c34(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      return s0;
    }

    function peg$parseUnquotedLiteral() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseUnquotedCharacter();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseUnquotedCharacter();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseCursor();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseUnquotedCharacter();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseUnquotedCharacter();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c28(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseUnquotedCharacter();
        if (s2 !== peg$FAILED) {
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parseUnquotedCharacter();
          }
        } else {
          s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c37(s1);
        }
        s0 = s1;
      }

      return s0;
    }

    function peg$parseUnquotedCharacter() {
      var s0, s1, s2, s3, s4;

      s0 = peg$parseEscapedSpecialCharacter();
      if (s0 === peg$FAILED) {
        s0 = peg$parseEscapedKeyword();
        if (s0 === peg$FAILED) {
          s0 = peg$parseWildcard();
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$currPos;
            peg$silentFails++;
            s2 = peg$parseSpecialCharacter();
            peg$silentFails--;
            if (s2 === peg$FAILED) {
              s1 = void 0;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
            if (s1 !== peg$FAILED) {
              s2 = peg$currPos;
              peg$silentFails++;
              s3 = peg$parseKeyword();
              peg$silentFails--;
              if (s3 === peg$FAILED) {
                s2 = void 0;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 !== peg$FAILED) {
                s3 = peg$currPos;
                peg$silentFails++;
                s4 = peg$parseCursor();
                peg$silentFails--;
                if (s4 === peg$FAILED) {
                  s3 = void 0;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 !== peg$FAILED) {
                  if (input.length > peg$currPos) {
                    s4 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s4 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c38); }
                  }
                  if (s4 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c34(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }

      return s0;
    }

    function peg$parseWildcard() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 42) {
        s1 = peg$c39;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c40); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c41();
      }
      s0 = s1;

      return s0;
    }

    function peg$parseOptionalSpace() {
      var s0, s1, s2, s3, s4;

      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseSpace();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseSpace();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseCursor();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseSpace();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseSpace();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c28(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = [];
        s1 = peg$parseSpace();
        while (s1 !== peg$FAILED) {
          s0.push(s1);
          s1 = peg$parseSpace();
        }
      }

      return s0;
    }

    function peg$parseEscapedSpecialCharacter() {
      var s0, s1, s2;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c30;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c31); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseSpecialCharacter();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c34(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseEscapedKeyword() {
      var s0, s1, s2;

      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c30;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c31); }
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c20) {
          s2 = input.substr(peg$currPos, 2);
          peg$currPos += 2;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c21); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c22) {
            s2 = input.substr(peg$currPos, 3);
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c23); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c24) {
              s2 = input.substr(peg$currPos, 3);
              peg$currPos += 3;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c25); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c42(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }

    function peg$parseKeyword() {
      var s0;

      s0 = peg$parseOr();
      if (s0 === peg$FAILED) {
        s0 = peg$parseAnd();
        if (s0 === peg$FAILED) {
          s0 = peg$parseNot();
        }
      }

      return s0;
    }

    function peg$parseSpecialCharacter() {
      var s0;

      if (peg$c43.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c44); }
      }

      return s0;
    }

    function peg$parseRangeOperator() {
      var s0, s1;

      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c45) {
        s1 = peg$c45;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c46); }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c47();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c48) {
          s1 = peg$c48;
          peg$currPos += 2;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c49); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c50();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 60) {
            s1 = peg$c51;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c52); }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c53();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 62) {
              s1 = peg$c54;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c55); }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c56();
            }
            s0 = s1;
          }
        }
      }

      return s0;
    }

    function peg$parseSpace() {
      var s0;

      if (peg$c57.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c58); }
      }

      return s0;
    }

    function peg$parseCursor() {
      var s0, s1, s2;

      s0 = peg$currPos;
      peg$savedPos = peg$currPos;
      s1 = peg$c59();
      if (s1) {
        s1 = void 0;
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 14) === peg$c60) {
          s2 = peg$c60;
          peg$currPos += 14;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c61); }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c62();
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }

      return s0;
    }


      const { parseCursor, cursorSymbol, allowLeadingWildcards = true, helpers: { nodeTypes, errors } } = options;
      const buildFunctionNode = nodeTypes.function.buildNodeWithArgumentNodes;
      const buildLiteralNode = nodeTypes.literal.buildNode;
      const buildWildcardNode = nodeTypes.wildcard.buildNode;
      const buildNamedArgNode = nodeTypes.namedArg.buildNode;
      const { wildcardSymbol } = nodeTypes.wildcard;


    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail({ type: "end", description: "end of input" });
      }

      throw peg$buildException(
        null,
        peg$maxFailExpected,
        peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
        peg$maxFailPos < input.length
          ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
          : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
      );
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse:       peg$parse
  };
})();