# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
This module gives access to an iPod's content. It provides an easy to
use API to retrieve the list of files and playlists stored on an iPod,
modify them, and save them back to the iPod.

This module implements the libgpod C API as directly as possible in
Python.  See the main gpod module for a more traditional Python
interface.
"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_gpod')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_gpod')
    _gpod = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_gpod', [dirname(__file__)])
        except ImportError:
            import _gpod
            return _gpod
        try:
            _mod = imp.load_module('_gpod', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _gpod = swig_import_helper()
    del swig_import_helper
else:
    import _gpod
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


version_info = (0, 
		8, 
		0)
version = '.'.join(map(str, version_info))  

GETTEXT_PACKAGE = _gpod.GETTEXT_PACKAGE
HAVE_DLFCN_H = _gpod.HAVE_DLFCN_H
HAVE_GDKPIXBUF = _gpod.HAVE_GDKPIXBUF
HAVE_INTTYPES_H = _gpod.HAVE_INTTYPES_H
HAVE_LC_MESSAGES = _gpod.HAVE_LC_MESSAGES
HAVE_LIBUSB = _gpod.HAVE_LIBUSB
HAVE_LIBXML = _gpod.HAVE_LIBXML
HAVE_LOCALE_H = _gpod.HAVE_LOCALE_H
HAVE_LOCALTIME_R = _gpod.HAVE_LOCALTIME_R
HAVE_MEMORY_H = _gpod.HAVE_MEMORY_H
HAVE_PYGOBJECT = _gpod.HAVE_PYGOBJECT
HAVE_STDINT_H = _gpod.HAVE_STDINT_H
HAVE_STDLIB_H = _gpod.HAVE_STDLIB_H
HAVE_STRINGS_H = _gpod.HAVE_STRINGS_H
HAVE_STRING_H = _gpod.HAVE_STRING_H
HAVE_STRUCT_TM_TM_GMTOFF = _gpod.HAVE_STRUCT_TM_TM_GMTOFF
HAVE_SYS_STAT_H = _gpod.HAVE_SYS_STAT_H
HAVE_SYS_TYPES_H = _gpod.HAVE_SYS_TYPES_H
HAVE_UNISTD_H = _gpod.HAVE_UNISTD_H
HAVE_ZLIB = _gpod.HAVE_ZLIB
LT_OBJDIR = _gpod.LT_OBJDIR
PACKAGE = _gpod.PACKAGE
PACKAGE_BUGREPORT = _gpod.PACKAGE_BUGREPORT
PACKAGE_NAME = _gpod.PACKAGE_NAME
PACKAGE_STRING = _gpod.PACKAGE_STRING
PACKAGE_TARNAME = _gpod.PACKAGE_TARNAME
PACKAGE_URL = _gpod.PACKAGE_URL
PACKAGE_VERSION = _gpod.PACKAGE_VERSION
STDC_HEADERS = _gpod.STDC_HEADERS
TMPMOUNTDIR = _gpod.TMPMOUNTDIR
_ALL_SOURCE = _gpod._ALL_SOURCE
_GNU_SOURCE = _gpod._GNU_SOURCE
_POSIX_PTHREAD_SEMANTICS = _gpod._POSIX_PTHREAD_SEMANTICS
_TANDEM_SOURCE = _gpod._TANDEM_SOURCE
__EXTENSIONS__ = _gpod.__EXTENSIONS__
VERSION = _gpod.VERSION

def sw_get_tracks(itdb):
    """
    sw_get_tracks(Itdb_iTunesDB itdb) -> [Itdb_Track, ...]


    Get tracks in itdb.

    Parameters
    itdb: an Itdb_iTunesDB
    Returns: a list of Itdb_Track objects

    """
    return _gpod.sw_get_tracks(itdb)

def sw_get_track(list, index):
    """
    sw_get_track(GList list, gint index) -> Itdb_Track


    Get a track

    Parameters
    list: a GList
    index: position of the track
    Returns: an Itdb_Track

    """
    return _gpod.sw_get_track(list, index)

def sw_get_rule(list, index):
    """
    sw_get_rule(GList list, gint index) -> Itdb_SPLRule


    Get a rule

    Parameters
    list: a GList
    index: position of the rule
    Returns: an Itdb_SPLRule

    """
    return _gpod.sw_get_rule(list, index)

def sw_get_playlist(list, index):
    """
    sw_get_playlist(GList list, gint index) -> Itdb_Playlist


    Get a playlist

    Parameters
    list: a GList
    index: position of the playlist
    Returns: an Itdb_Playlist

    """
    return _gpod.sw_get_playlist(list, index)

def sw_get_list_len(list):
    """
    sw_get_list_len(GList list) -> Int


    Get the length of list

    Parameters
    list: a GList
    Returns: length of list

    """
    return _gpod.sw_get_list_len(list)

def sw_get_playlists(itdb):
    """
    sw_get_playlists(Itdb_iTunesDB itdb) -> [Itdb_Playlist, ...]


    Get playlists

    Parameters
    itdb: an Itdb_iTunesDB
    Returns: a list of Itdb_Playlist objects

    """
    return _gpod.sw_get_playlists(itdb)

def sw_get_playlist_tracks(pl):
    """
    sw_get_playlist_tracks(Itdb_Playlist pl) -> [Itdb_Track, ...]


    Get tracks in playlist

    pl: an Itdb_Playlist
    Returns: a list of Itdb_Track objects

    """
    return _gpod.sw_get_playlist_tracks(pl)

def sw_set_track_userdata(track, data):
    """
    sw_set_track_userdata(Itdb_Track track, Dictionary userdata)


    Set a tracks userdata

    Parameters
    track: an Itdb_Track
    userdata: a dictionary.  Note that userdata can be None, in order to
    clear all userdata.

    """
    return _gpod.sw_set_track_userdata(track, data)

def sw_get_track_userdata(track):
    """
    sw_get_track_userdata(Itdb_Track track) -> Dictionary


    Get track userdata

    Parameters
    track: an Itdb_Track
    Returns: a dictionary containing any userdata for track

    """
    return _gpod.sw_get_track_userdata(track)

def sw_get_photoalbums(db):
    """sw_get_photoalbums(_Itdb_PhotoDB db) -> PyObject *"""
    return _gpod.sw_get_photoalbums(db)

def sw_get_photoalbum(list, index):
    """sw_get_photoalbum(GList * list, gint index) -> PyObject *"""
    return _gpod.sw_get_photoalbum(list, index)

def sw_get_photos(db):
    """sw_get_photos(_Itdb_PhotoDB db) -> PyObject *"""
    return _gpod.sw_get_photos(db)

def sw_get_photo(list, index):
    """sw_get_photo(GList * list, gint index) -> PyObject *"""
    return _gpod.sw_get_photo(list, index)

def sw_get_photoalbum_members(album):
    """sw_get_photoalbum_members(_Itdb_PhotoAlbum album) -> PyObject *"""
    return _gpod.sw_get_photoalbum_members(album)

def sw_ipod_device_to_dict(device):
    """sw_ipod_device_to_dict(Itdb_Device * device) -> PyObject *"""
    return _gpod.sw_ipod_device_to_dict(device)
ITDB_IPOD_GENERATION_UNKNOWN = _gpod.ITDB_IPOD_GENERATION_UNKNOWN
ITDB_IPOD_GENERATION_FIRST = _gpod.ITDB_IPOD_GENERATION_FIRST
ITDB_IPOD_GENERATION_SECOND = _gpod.ITDB_IPOD_GENERATION_SECOND
ITDB_IPOD_GENERATION_THIRD = _gpod.ITDB_IPOD_GENERATION_THIRD
ITDB_IPOD_GENERATION_FOURTH = _gpod.ITDB_IPOD_GENERATION_FOURTH
ITDB_IPOD_GENERATION_PHOTO = _gpod.ITDB_IPOD_GENERATION_PHOTO
ITDB_IPOD_GENERATION_MOBILE = _gpod.ITDB_IPOD_GENERATION_MOBILE
ITDB_IPOD_GENERATION_MINI_1 = _gpod.ITDB_IPOD_GENERATION_MINI_1
ITDB_IPOD_GENERATION_MINI_2 = _gpod.ITDB_IPOD_GENERATION_MINI_2
ITDB_IPOD_GENERATION_SHUFFLE_1 = _gpod.ITDB_IPOD_GENERATION_SHUFFLE_1
ITDB_IPOD_GENERATION_SHUFFLE_2 = _gpod.ITDB_IPOD_GENERATION_SHUFFLE_2
ITDB_IPOD_GENERATION_SHUFFLE_3 = _gpod.ITDB_IPOD_GENERATION_SHUFFLE_3
ITDB_IPOD_GENERATION_NANO_1 = _gpod.ITDB_IPOD_GENERATION_NANO_1
ITDB_IPOD_GENERATION_NANO_2 = _gpod.ITDB_IPOD_GENERATION_NANO_2
ITDB_IPOD_GENERATION_NANO_3 = _gpod.ITDB_IPOD_GENERATION_NANO_3
ITDB_IPOD_GENERATION_NANO_4 = _gpod.ITDB_IPOD_GENERATION_NANO_4
ITDB_IPOD_GENERATION_VIDEO_1 = _gpod.ITDB_IPOD_GENERATION_VIDEO_1
ITDB_IPOD_GENERATION_VIDEO_2 = _gpod.ITDB_IPOD_GENERATION_VIDEO_2
ITDB_IPOD_GENERATION_CLASSIC_1 = _gpod.ITDB_IPOD_GENERATION_CLASSIC_1
ITDB_IPOD_GENERATION_CLASSIC_2 = _gpod.ITDB_IPOD_GENERATION_CLASSIC_2
ITDB_IPOD_GENERATION_TOUCH_1 = _gpod.ITDB_IPOD_GENERATION_TOUCH_1
ITDB_IPOD_GENERATION_IPHONE_1 = _gpod.ITDB_IPOD_GENERATION_IPHONE_1
ITDB_IPOD_GENERATION_SHUFFLE_4 = _gpod.ITDB_IPOD_GENERATION_SHUFFLE_4
ITDB_IPOD_GENERATION_TOUCH_2 = _gpod.ITDB_IPOD_GENERATION_TOUCH_2
ITDB_IPOD_GENERATION_IPHONE_2 = _gpod.ITDB_IPOD_GENERATION_IPHONE_2
ITDB_IPOD_GENERATION_IPHONE_3 = _gpod.ITDB_IPOD_GENERATION_IPHONE_3
ITDB_IPOD_GENERATION_CLASSIC_3 = _gpod.ITDB_IPOD_GENERATION_CLASSIC_3
ITDB_IPOD_GENERATION_NANO_5 = _gpod.ITDB_IPOD_GENERATION_NANO_5
ITDB_IPOD_GENERATION_TOUCH_3 = _gpod.ITDB_IPOD_GENERATION_TOUCH_3
ITDB_IPOD_GENERATION_IPAD_1 = _gpod.ITDB_IPOD_GENERATION_IPAD_1
ITDB_IPOD_GENERATION_IPHONE_4 = _gpod.ITDB_IPOD_GENERATION_IPHONE_4
ITDB_IPOD_GENERATION_TOUCH_4 = _gpod.ITDB_IPOD_GENERATION_TOUCH_4
ITDB_IPOD_GENERATION_NANO_6 = _gpod.ITDB_IPOD_GENERATION_NANO_6
ITDB_IPOD_MODEL_INVALID = _gpod.ITDB_IPOD_MODEL_INVALID
ITDB_IPOD_MODEL_UNKNOWN = _gpod.ITDB_IPOD_MODEL_UNKNOWN
ITDB_IPOD_MODEL_COLOR = _gpod.ITDB_IPOD_MODEL_COLOR
ITDB_IPOD_MODEL_COLOR_U2 = _gpod.ITDB_IPOD_MODEL_COLOR_U2
ITDB_IPOD_MODEL_REGULAR = _gpod.ITDB_IPOD_MODEL_REGULAR
ITDB_IPOD_MODEL_REGULAR_U2 = _gpod.ITDB_IPOD_MODEL_REGULAR_U2
ITDB_IPOD_MODEL_MINI = _gpod.ITDB_IPOD_MODEL_MINI
ITDB_IPOD_MODEL_MINI_BLUE = _gpod.ITDB_IPOD_MODEL_MINI_BLUE
ITDB_IPOD_MODEL_MINI_PINK = _gpod.ITDB_IPOD_MODEL_MINI_PINK
ITDB_IPOD_MODEL_MINI_GREEN = _gpod.ITDB_IPOD_MODEL_MINI_GREEN
ITDB_IPOD_MODEL_MINI_GOLD = _gpod.ITDB_IPOD_MODEL_MINI_GOLD
ITDB_IPOD_MODEL_SHUFFLE = _gpod.ITDB_IPOD_MODEL_SHUFFLE
ITDB_IPOD_MODEL_NANO_WHITE = _gpod.ITDB_IPOD_MODEL_NANO_WHITE
ITDB_IPOD_MODEL_NANO_BLACK = _gpod.ITDB_IPOD_MODEL_NANO_BLACK
ITDB_IPOD_MODEL_VIDEO_WHITE = _gpod.ITDB_IPOD_MODEL_VIDEO_WHITE
ITDB_IPOD_MODEL_VIDEO_BLACK = _gpod.ITDB_IPOD_MODEL_VIDEO_BLACK
ITDB_IPOD_MODEL_MOBILE_1 = _gpod.ITDB_IPOD_MODEL_MOBILE_1
ITDB_IPOD_MODEL_VIDEO_U2 = _gpod.ITDB_IPOD_MODEL_VIDEO_U2
ITDB_IPOD_MODEL_NANO_SILVER = _gpod.ITDB_IPOD_MODEL_NANO_SILVER
ITDB_IPOD_MODEL_NANO_BLUE = _gpod.ITDB_IPOD_MODEL_NANO_BLUE
ITDB_IPOD_MODEL_NANO_GREEN = _gpod.ITDB_IPOD_MODEL_NANO_GREEN
ITDB_IPOD_MODEL_NANO_PINK = _gpod.ITDB_IPOD_MODEL_NANO_PINK
ITDB_IPOD_MODEL_NANO_RED = _gpod.ITDB_IPOD_MODEL_NANO_RED
ITDB_IPOD_MODEL_NANO_YELLOW = _gpod.ITDB_IPOD_MODEL_NANO_YELLOW
ITDB_IPOD_MODEL_NANO_PURPLE = _gpod.ITDB_IPOD_MODEL_NANO_PURPLE
ITDB_IPOD_MODEL_NANO_ORANGE = _gpod.ITDB_IPOD_MODEL_NANO_ORANGE
ITDB_IPOD_MODEL_IPHONE_1 = _gpod.ITDB_IPOD_MODEL_IPHONE_1
ITDB_IPOD_MODEL_SHUFFLE_SILVER = _gpod.ITDB_IPOD_MODEL_SHUFFLE_SILVER
ITDB_IPOD_MODEL_SHUFFLE_PINK = _gpod.ITDB_IPOD_MODEL_SHUFFLE_PINK
ITDB_IPOD_MODEL_SHUFFLE_BLUE = _gpod.ITDB_IPOD_MODEL_SHUFFLE_BLUE
ITDB_IPOD_MODEL_SHUFFLE_GREEN = _gpod.ITDB_IPOD_MODEL_SHUFFLE_GREEN
ITDB_IPOD_MODEL_SHUFFLE_ORANGE = _gpod.ITDB_IPOD_MODEL_SHUFFLE_ORANGE
ITDB_IPOD_MODEL_SHUFFLE_PURPLE = _gpod.ITDB_IPOD_MODEL_SHUFFLE_PURPLE
ITDB_IPOD_MODEL_SHUFFLE_RED = _gpod.ITDB_IPOD_MODEL_SHUFFLE_RED
ITDB_IPOD_MODEL_CLASSIC_SILVER = _gpod.ITDB_IPOD_MODEL_CLASSIC_SILVER
ITDB_IPOD_MODEL_CLASSIC_BLACK = _gpod.ITDB_IPOD_MODEL_CLASSIC_BLACK
ITDB_IPOD_MODEL_TOUCH_SILVER = _gpod.ITDB_IPOD_MODEL_TOUCH_SILVER
ITDB_IPOD_MODEL_SHUFFLE_BLACK = _gpod.ITDB_IPOD_MODEL_SHUFFLE_BLACK
ITDB_IPOD_MODEL_IPHONE_WHITE = _gpod.ITDB_IPOD_MODEL_IPHONE_WHITE
ITDB_IPOD_MODEL_IPHONE_BLACK = _gpod.ITDB_IPOD_MODEL_IPHONE_BLACK
ITDB_IPOD_MODEL_SHUFFLE_GOLD = _gpod.ITDB_IPOD_MODEL_SHUFFLE_GOLD
ITDB_IPOD_MODEL_SHUFFLE_STAINLESS = _gpod.ITDB_IPOD_MODEL_SHUFFLE_STAINLESS
ITDB_IPOD_MODEL_IPAD = _gpod.ITDB_IPOD_MODEL_IPAD
class _Itdb_IpodInfo(_object):
    """Proxy of C _Itdb_IpodInfo struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_IpodInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_IpodInfo, name)
    __repr__ = _swig_repr
    __swig_setmethods__["model_number"] = _gpod._Itdb_IpodInfo_model_number_set
    __swig_getmethods__["model_number"] = _gpod._Itdb_IpodInfo_model_number_get
    if _newclass:
        model_number = _swig_property(_gpod._Itdb_IpodInfo_model_number_get, _gpod._Itdb_IpodInfo_model_number_set)
    __swig_getmethods__["capacity"] = _gpod._Itdb_IpodInfo_capacity_get
    if _newclass:
        capacity = _swig_property(_gpod._Itdb_IpodInfo_capacity_get)
    __swig_getmethods__["ipod_model"] = _gpod._Itdb_IpodInfo_ipod_model_get
    if _newclass:
        ipod_model = _swig_property(_gpod._Itdb_IpodInfo_ipod_model_get)
    __swig_getmethods__["ipod_generation"] = _gpod._Itdb_IpodInfo_ipod_generation_get
    if _newclass:
        ipod_generation = _swig_property(_gpod._Itdb_IpodInfo_ipod_generation_get)
    __swig_getmethods__["musicdirs"] = _gpod._Itdb_IpodInfo_musicdirs_get
    if _newclass:
        musicdirs = _swig_property(_gpod._Itdb_IpodInfo_musicdirs_get)
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_IpodInfo_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_IpodInfo_reserved_int1_get)
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_IpodInfo_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_IpodInfo_reserved_int2_get)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_IpodInfo_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_IpodInfo_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_IpodInfo_reserved1_get, _gpod._Itdb_IpodInfo_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_IpodInfo_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_IpodInfo_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_IpodInfo_reserved2_get, _gpod._Itdb_IpodInfo_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_IpodInfo self) -> _Itdb_IpodInfo"""
        this = _gpod.new__Itdb_IpodInfo()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_IpodInfo
    __del__ = lambda self: None
_Itdb_IpodInfo_swigregister = _gpod._Itdb_IpodInfo_swigregister
_Itdb_IpodInfo_swigregister(_Itdb_IpodInfo)

ITDB_SPL_STRING_MAXLEN = _gpod.ITDB_SPL_STRING_MAXLEN
ITDB_SPLMATCH_AND = _gpod.ITDB_SPLMATCH_AND
ITDB_SPLMATCH_OR = _gpod.ITDB_SPLMATCH_OR
ITDB_LIMITTYPE_MINUTES = _gpod.ITDB_LIMITTYPE_MINUTES
ITDB_LIMITTYPE_MB = _gpod.ITDB_LIMITTYPE_MB
ITDB_LIMITTYPE_SONGS = _gpod.ITDB_LIMITTYPE_SONGS
ITDB_LIMITTYPE_HOURS = _gpod.ITDB_LIMITTYPE_HOURS
ITDB_LIMITTYPE_GB = _gpod.ITDB_LIMITTYPE_GB
ITDB_LIMITSORT_RANDOM = _gpod.ITDB_LIMITSORT_RANDOM
ITDB_LIMITSORT_SONG_NAME = _gpod.ITDB_LIMITSORT_SONG_NAME
ITDB_LIMITSORT_ALBUM = _gpod.ITDB_LIMITSORT_ALBUM
ITDB_LIMITSORT_ARTIST = _gpod.ITDB_LIMITSORT_ARTIST
ITDB_LIMITSORT_GENRE = _gpod.ITDB_LIMITSORT_GENRE
ITDB_LIMITSORT_MOST_RECENTLY_ADDED = _gpod.ITDB_LIMITSORT_MOST_RECENTLY_ADDED
ITDB_LIMITSORT_LEAST_RECENTLY_ADDED = _gpod.ITDB_LIMITSORT_LEAST_RECENTLY_ADDED
ITDB_LIMITSORT_MOST_OFTEN_PLAYED = _gpod.ITDB_LIMITSORT_MOST_OFTEN_PLAYED
ITDB_LIMITSORT_LEAST_OFTEN_PLAYED = _gpod.ITDB_LIMITSORT_LEAST_OFTEN_PLAYED
ITDB_LIMITSORT_MOST_RECENTLY_PLAYED = _gpod.ITDB_LIMITSORT_MOST_RECENTLY_PLAYED
ITDB_LIMITSORT_LEAST_RECENTLY_PLAYED = _gpod.ITDB_LIMITSORT_LEAST_RECENTLY_PLAYED
ITDB_LIMITSORT_HIGHEST_RATING = _gpod.ITDB_LIMITSORT_HIGHEST_RATING
ITDB_LIMITSORT_LOWEST_RATING = _gpod.ITDB_LIMITSORT_LOWEST_RATING
ITDB_SPLACTION_IS_INT = _gpod.ITDB_SPLACTION_IS_INT
ITDB_SPLACTION_IS_GREATER_THAN = _gpod.ITDB_SPLACTION_IS_GREATER_THAN
ITDB_SPLACTION_IS_LESS_THAN = _gpod.ITDB_SPLACTION_IS_LESS_THAN
ITDB_SPLACTION_IS_IN_THE_RANGE = _gpod.ITDB_SPLACTION_IS_IN_THE_RANGE
ITDB_SPLACTION_IS_IN_THE_LAST = _gpod.ITDB_SPLACTION_IS_IN_THE_LAST
ITDB_SPLACTION_BINARY_AND = _gpod.ITDB_SPLACTION_BINARY_AND
ITDB_SPLACTION_BINARY_UNKNOWN1 = _gpod.ITDB_SPLACTION_BINARY_UNKNOWN1
ITDB_SPLACTION_IS_STRING = _gpod.ITDB_SPLACTION_IS_STRING
ITDB_SPLACTION_CONTAINS = _gpod.ITDB_SPLACTION_CONTAINS
ITDB_SPLACTION_STARTS_WITH = _gpod.ITDB_SPLACTION_STARTS_WITH
ITDB_SPLACTION_ENDS_WITH = _gpod.ITDB_SPLACTION_ENDS_WITH
ITDB_SPLACTION_IS_NOT_INT = _gpod.ITDB_SPLACTION_IS_NOT_INT
ITDB_SPLACTION_IS_NOT_GREATER_THAN = _gpod.ITDB_SPLACTION_IS_NOT_GREATER_THAN
ITDB_SPLACTION_IS_NOT_LESS_THAN = _gpod.ITDB_SPLACTION_IS_NOT_LESS_THAN
ITDB_SPLACTION_IS_NOT_IN_THE_RANGE = _gpod.ITDB_SPLACTION_IS_NOT_IN_THE_RANGE
ITDB_SPLACTION_IS_NOT_IN_THE_LAST = _gpod.ITDB_SPLACTION_IS_NOT_IN_THE_LAST
ITDB_SPLACTION_NOT_BINARY_AND = _gpod.ITDB_SPLACTION_NOT_BINARY_AND
ITDB_SPLACTION_BINARY_UNKNOWN2 = _gpod.ITDB_SPLACTION_BINARY_UNKNOWN2
ITDB_SPLACTION_IS_NOT = _gpod.ITDB_SPLACTION_IS_NOT
ITDB_SPLACTION_DOES_NOT_CONTAIN = _gpod.ITDB_SPLACTION_DOES_NOT_CONTAIN
ITDB_SPLACTION_DOES_NOT_START_WITH = _gpod.ITDB_SPLACTION_DOES_NOT_START_WITH
ITDB_SPLACTION_DOES_NOT_END_WITH = _gpod.ITDB_SPLACTION_DOES_NOT_END_WITH
ITDB_SPLFT_STRING = _gpod.ITDB_SPLFT_STRING
ITDB_SPLFT_INT = _gpod.ITDB_SPLFT_INT
ITDB_SPLFT_BOOLEAN = _gpod.ITDB_SPLFT_BOOLEAN
ITDB_SPLFT_DATE = _gpod.ITDB_SPLFT_DATE
ITDB_SPLFT_PLAYLIST = _gpod.ITDB_SPLFT_PLAYLIST
ITDB_SPLFT_UNKNOWN = _gpod.ITDB_SPLFT_UNKNOWN
ITDB_SPLFT_BINARY_AND = _gpod.ITDB_SPLFT_BINARY_AND
ITDB_SPLAT_STRING = _gpod.ITDB_SPLAT_STRING
ITDB_SPLAT_INT = _gpod.ITDB_SPLAT_INT
ITDB_SPLAT_DATE = _gpod.ITDB_SPLAT_DATE
ITDB_SPLAT_RANGE_INT = _gpod.ITDB_SPLAT_RANGE_INT
ITDB_SPLAT_RANGE_DATE = _gpod.ITDB_SPLAT_RANGE_DATE
ITDB_SPLAT_INTHELAST = _gpod.ITDB_SPLAT_INTHELAST
ITDB_SPLAT_PLAYLIST = _gpod.ITDB_SPLAT_PLAYLIST
ITDB_SPLAT_NONE = _gpod.ITDB_SPLAT_NONE
ITDB_SPLAT_INVALID = _gpod.ITDB_SPLAT_INVALID
ITDB_SPLAT_UNKNOWN = _gpod.ITDB_SPLAT_UNKNOWN
ITDB_SPLAT_BINARY_AND = _gpod.ITDB_SPLAT_BINARY_AND
ITDB_SPLACTION_LAST_DAYS_VALUE = _gpod.ITDB_SPLACTION_LAST_DAYS_VALUE
ITDB_SPLACTION_LAST_WEEKS_VALUE = _gpod.ITDB_SPLACTION_LAST_WEEKS_VALUE
ITDB_SPLACTION_LAST_MONTHS_VALUE = _gpod.ITDB_SPLACTION_LAST_MONTHS_VALUE
ITDB_SPLFIELD_SONG_NAME = _gpod.ITDB_SPLFIELD_SONG_NAME
ITDB_SPLFIELD_ALBUM = _gpod.ITDB_SPLFIELD_ALBUM
ITDB_SPLFIELD_ARTIST = _gpod.ITDB_SPLFIELD_ARTIST
ITDB_SPLFIELD_BITRATE = _gpod.ITDB_SPLFIELD_BITRATE
ITDB_SPLFIELD_SAMPLE_RATE = _gpod.ITDB_SPLFIELD_SAMPLE_RATE
ITDB_SPLFIELD_YEAR = _gpod.ITDB_SPLFIELD_YEAR
ITDB_SPLFIELD_GENRE = _gpod.ITDB_SPLFIELD_GENRE
ITDB_SPLFIELD_KIND = _gpod.ITDB_SPLFIELD_KIND
ITDB_SPLFIELD_DATE_MODIFIED = _gpod.ITDB_SPLFIELD_DATE_MODIFIED
ITDB_SPLFIELD_TRACKNUMBER = _gpod.ITDB_SPLFIELD_TRACKNUMBER
ITDB_SPLFIELD_SIZE = _gpod.ITDB_SPLFIELD_SIZE
ITDB_SPLFIELD_TIME = _gpod.ITDB_SPLFIELD_TIME
ITDB_SPLFIELD_COMMENT = _gpod.ITDB_SPLFIELD_COMMENT
ITDB_SPLFIELD_DATE_ADDED = _gpod.ITDB_SPLFIELD_DATE_ADDED
ITDB_SPLFIELD_COMPOSER = _gpod.ITDB_SPLFIELD_COMPOSER
ITDB_SPLFIELD_PLAYCOUNT = _gpod.ITDB_SPLFIELD_PLAYCOUNT
ITDB_SPLFIELD_LAST_PLAYED = _gpod.ITDB_SPLFIELD_LAST_PLAYED
ITDB_SPLFIELD_DISC_NUMBER = _gpod.ITDB_SPLFIELD_DISC_NUMBER
ITDB_SPLFIELD_RATING = _gpod.ITDB_SPLFIELD_RATING
ITDB_SPLFIELD_COMPILATION = _gpod.ITDB_SPLFIELD_COMPILATION
ITDB_SPLFIELD_BPM = _gpod.ITDB_SPLFIELD_BPM
ITDB_SPLFIELD_GROUPING = _gpod.ITDB_SPLFIELD_GROUPING
ITDB_SPLFIELD_PLAYLIST = _gpod.ITDB_SPLFIELD_PLAYLIST
ITDB_SPLFIELD_PURCHASE = _gpod.ITDB_SPLFIELD_PURCHASE
ITDB_SPLFIELD_DESCRIPTION = _gpod.ITDB_SPLFIELD_DESCRIPTION
ITDB_SPLFIELD_CATEGORY = _gpod.ITDB_SPLFIELD_CATEGORY
ITDB_SPLFIELD_PODCAST = _gpod.ITDB_SPLFIELD_PODCAST
ITDB_SPLFIELD_VIDEO_KIND = _gpod.ITDB_SPLFIELD_VIDEO_KIND
ITDB_SPLFIELD_TVSHOW = _gpod.ITDB_SPLFIELD_TVSHOW
ITDB_SPLFIELD_SEASON_NR = _gpod.ITDB_SPLFIELD_SEASON_NR
ITDB_SPLFIELD_SKIPCOUNT = _gpod.ITDB_SPLFIELD_SKIPCOUNT
ITDB_SPLFIELD_LAST_SKIPPED = _gpod.ITDB_SPLFIELD_LAST_SKIPPED
ITDB_SPLFIELD_ALBUMARTIST = _gpod.ITDB_SPLFIELD_ALBUMARTIST
ITDB_SPLFIELD_SORT_SONG_NAME = _gpod.ITDB_SPLFIELD_SORT_SONG_NAME
ITDB_SPLFIELD_SORT_ALBUM = _gpod.ITDB_SPLFIELD_SORT_ALBUM
ITDB_SPLFIELD_SORT_ARTIST = _gpod.ITDB_SPLFIELD_SORT_ARTIST
ITDB_SPLFIELD_SORT_ALBUMARTIST = _gpod.ITDB_SPLFIELD_SORT_ALBUMARTIST
ITDB_SPLFIELD_SORT_COMPOSER = _gpod.ITDB_SPLFIELD_SORT_COMPOSER
ITDB_SPLFIELD_SORT_TVSHOW = _gpod.ITDB_SPLFIELD_SORT_TVSHOW
ITDB_SPLFIELD_ALBUM_RATING = _gpod.ITDB_SPLFIELD_ALBUM_RATING
class _Itdb_SPLPref(_object):
    """Proxy of C _Itdb_SPLPref struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_SPLPref, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_SPLPref, name)
    __repr__ = _swig_repr
    __swig_setmethods__["liveupdate"] = _gpod._Itdb_SPLPref_liveupdate_set
    __swig_getmethods__["liveupdate"] = _gpod._Itdb_SPLPref_liveupdate_get
    if _newclass:
        liveupdate = _swig_property(_gpod._Itdb_SPLPref_liveupdate_get, _gpod._Itdb_SPLPref_liveupdate_set)
    __swig_setmethods__["checkrules"] = _gpod._Itdb_SPLPref_checkrules_set
    __swig_getmethods__["checkrules"] = _gpod._Itdb_SPLPref_checkrules_get
    if _newclass:
        checkrules = _swig_property(_gpod._Itdb_SPLPref_checkrules_get, _gpod._Itdb_SPLPref_checkrules_set)
    __swig_setmethods__["checklimits"] = _gpod._Itdb_SPLPref_checklimits_set
    __swig_getmethods__["checklimits"] = _gpod._Itdb_SPLPref_checklimits_get
    if _newclass:
        checklimits = _swig_property(_gpod._Itdb_SPLPref_checklimits_get, _gpod._Itdb_SPLPref_checklimits_set)
    __swig_setmethods__["limittype"] = _gpod._Itdb_SPLPref_limittype_set
    __swig_getmethods__["limittype"] = _gpod._Itdb_SPLPref_limittype_get
    if _newclass:
        limittype = _swig_property(_gpod._Itdb_SPLPref_limittype_get, _gpod._Itdb_SPLPref_limittype_set)
    __swig_setmethods__["limitsort"] = _gpod._Itdb_SPLPref_limitsort_set
    __swig_getmethods__["limitsort"] = _gpod._Itdb_SPLPref_limitsort_get
    if _newclass:
        limitsort = _swig_property(_gpod._Itdb_SPLPref_limitsort_get, _gpod._Itdb_SPLPref_limitsort_set)
    __swig_setmethods__["limitvalue"] = _gpod._Itdb_SPLPref_limitvalue_set
    __swig_getmethods__["limitvalue"] = _gpod._Itdb_SPLPref_limitvalue_get
    if _newclass:
        limitvalue = _swig_property(_gpod._Itdb_SPLPref_limitvalue_get, _gpod._Itdb_SPLPref_limitvalue_set)
    __swig_setmethods__["matchcheckedonly"] = _gpod._Itdb_SPLPref_matchcheckedonly_set
    __swig_getmethods__["matchcheckedonly"] = _gpod._Itdb_SPLPref_matchcheckedonly_get
    if _newclass:
        matchcheckedonly = _swig_property(_gpod._Itdb_SPLPref_matchcheckedonly_get, _gpod._Itdb_SPLPref_matchcheckedonly_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_SPLPref_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_SPLPref_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_SPLPref_reserved_int1_get, _gpod._Itdb_SPLPref_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_SPLPref_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_SPLPref_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_SPLPref_reserved_int2_get, _gpod._Itdb_SPLPref_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_SPLPref_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_SPLPref_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_SPLPref_reserved1_get, _gpod._Itdb_SPLPref_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_SPLPref_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_SPLPref_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_SPLPref_reserved2_get, _gpod._Itdb_SPLPref_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_SPLPref self) -> _Itdb_SPLPref"""
        this = _gpod.new__Itdb_SPLPref()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_SPLPref
    __del__ = lambda self: None
_Itdb_SPLPref_swigregister = _gpod._Itdb_SPLPref_swigregister
_Itdb_SPLPref_swigregister(_Itdb_SPLPref)

class _Itdb_SPLRule(_object):
    """Proxy of C _Itdb_SPLRule struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_SPLRule, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_SPLRule, name)
    __repr__ = _swig_repr
    __swig_setmethods__["field"] = _gpod._Itdb_SPLRule_field_set
    __swig_getmethods__["field"] = _gpod._Itdb_SPLRule_field_get
    if _newclass:
        field = _swig_property(_gpod._Itdb_SPLRule_field_get, _gpod._Itdb_SPLRule_field_set)
    __swig_setmethods__["action"] = _gpod._Itdb_SPLRule_action_set
    __swig_getmethods__["action"] = _gpod._Itdb_SPLRule_action_get
    if _newclass:
        action = _swig_property(_gpod._Itdb_SPLRule_action_get, _gpod._Itdb_SPLRule_action_set)
    __swig_setmethods__["string"] = _gpod._Itdb_SPLRule_string_set
    __swig_getmethods__["string"] = _gpod._Itdb_SPLRule_string_get
    if _newclass:
        string = _swig_property(_gpod._Itdb_SPLRule_string_get, _gpod._Itdb_SPLRule_string_set)
    __swig_setmethods__["fromvalue"] = _gpod._Itdb_SPLRule_fromvalue_set
    __swig_getmethods__["fromvalue"] = _gpod._Itdb_SPLRule_fromvalue_get
    if _newclass:
        fromvalue = _swig_property(_gpod._Itdb_SPLRule_fromvalue_get, _gpod._Itdb_SPLRule_fromvalue_set)
    __swig_setmethods__["fromdate"] = _gpod._Itdb_SPLRule_fromdate_set
    __swig_getmethods__["fromdate"] = _gpod._Itdb_SPLRule_fromdate_get
    if _newclass:
        fromdate = _swig_property(_gpod._Itdb_SPLRule_fromdate_get, _gpod._Itdb_SPLRule_fromdate_set)
    __swig_setmethods__["fromunits"] = _gpod._Itdb_SPLRule_fromunits_set
    __swig_getmethods__["fromunits"] = _gpod._Itdb_SPLRule_fromunits_get
    if _newclass:
        fromunits = _swig_property(_gpod._Itdb_SPLRule_fromunits_get, _gpod._Itdb_SPLRule_fromunits_set)
    __swig_setmethods__["tovalue"] = _gpod._Itdb_SPLRule_tovalue_set
    __swig_getmethods__["tovalue"] = _gpod._Itdb_SPLRule_tovalue_get
    if _newclass:
        tovalue = _swig_property(_gpod._Itdb_SPLRule_tovalue_get, _gpod._Itdb_SPLRule_tovalue_set)
    __swig_setmethods__["todate"] = _gpod._Itdb_SPLRule_todate_set
    __swig_getmethods__["todate"] = _gpod._Itdb_SPLRule_todate_get
    if _newclass:
        todate = _swig_property(_gpod._Itdb_SPLRule_todate_get, _gpod._Itdb_SPLRule_todate_set)
    __swig_setmethods__["tounits"] = _gpod._Itdb_SPLRule_tounits_set
    __swig_getmethods__["tounits"] = _gpod._Itdb_SPLRule_tounits_get
    if _newclass:
        tounits = _swig_property(_gpod._Itdb_SPLRule_tounits_get, _gpod._Itdb_SPLRule_tounits_set)
    __swig_setmethods__["unk052"] = _gpod._Itdb_SPLRule_unk052_set
    __swig_getmethods__["unk052"] = _gpod._Itdb_SPLRule_unk052_get
    if _newclass:
        unk052 = _swig_property(_gpod._Itdb_SPLRule_unk052_get, _gpod._Itdb_SPLRule_unk052_set)
    __swig_setmethods__["unk056"] = _gpod._Itdb_SPLRule_unk056_set
    __swig_getmethods__["unk056"] = _gpod._Itdb_SPLRule_unk056_get
    if _newclass:
        unk056 = _swig_property(_gpod._Itdb_SPLRule_unk056_get, _gpod._Itdb_SPLRule_unk056_set)
    __swig_setmethods__["unk060"] = _gpod._Itdb_SPLRule_unk060_set
    __swig_getmethods__["unk060"] = _gpod._Itdb_SPLRule_unk060_get
    if _newclass:
        unk060 = _swig_property(_gpod._Itdb_SPLRule_unk060_get, _gpod._Itdb_SPLRule_unk060_set)
    __swig_setmethods__["unk064"] = _gpod._Itdb_SPLRule_unk064_set
    __swig_getmethods__["unk064"] = _gpod._Itdb_SPLRule_unk064_get
    if _newclass:
        unk064 = _swig_property(_gpod._Itdb_SPLRule_unk064_get, _gpod._Itdb_SPLRule_unk064_set)
    __swig_setmethods__["unk068"] = _gpod._Itdb_SPLRule_unk068_set
    __swig_getmethods__["unk068"] = _gpod._Itdb_SPLRule_unk068_get
    if _newclass:
        unk068 = _swig_property(_gpod._Itdb_SPLRule_unk068_get, _gpod._Itdb_SPLRule_unk068_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_SPLRule_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_SPLRule_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_SPLRule_reserved_int1_get, _gpod._Itdb_SPLRule_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_SPLRule_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_SPLRule_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_SPLRule_reserved_int2_get, _gpod._Itdb_SPLRule_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_SPLRule_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_SPLRule_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_SPLRule_reserved1_get, _gpod._Itdb_SPLRule_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_SPLRule_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_SPLRule_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_SPLRule_reserved2_get, _gpod._Itdb_SPLRule_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_SPLRule self) -> _Itdb_SPLRule"""
        this = _gpod.new__Itdb_SPLRule()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_SPLRule
    __del__ = lambda self: None
_Itdb_SPLRule_swigregister = _gpod._Itdb_SPLRule_swigregister
_Itdb_SPLRule_swigregister(_Itdb_SPLRule)

class _Itdb_SPLRules(_object):
    """Proxy of C _Itdb_SPLRules struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_SPLRules, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_SPLRules, name)
    __repr__ = _swig_repr
    __swig_setmethods__["unk004"] = _gpod._Itdb_SPLRules_unk004_set
    __swig_getmethods__["unk004"] = _gpod._Itdb_SPLRules_unk004_get
    if _newclass:
        unk004 = _swig_property(_gpod._Itdb_SPLRules_unk004_get, _gpod._Itdb_SPLRules_unk004_set)
    __swig_setmethods__["match_operator"] = _gpod._Itdb_SPLRules_match_operator_set
    __swig_getmethods__["match_operator"] = _gpod._Itdb_SPLRules_match_operator_get
    if _newclass:
        match_operator = _swig_property(_gpod._Itdb_SPLRules_match_operator_get, _gpod._Itdb_SPLRules_match_operator_set)
    __swig_setmethods__["rules"] = _gpod._Itdb_SPLRules_rules_set
    __swig_getmethods__["rules"] = _gpod._Itdb_SPLRules_rules_get
    if _newclass:
        rules = _swig_property(_gpod._Itdb_SPLRules_rules_get, _gpod._Itdb_SPLRules_rules_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_SPLRules_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_SPLRules_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_SPLRules_reserved_int1_get, _gpod._Itdb_SPLRules_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_SPLRules_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_SPLRules_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_SPLRules_reserved_int2_get, _gpod._Itdb_SPLRules_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_SPLRules_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_SPLRules_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_SPLRules_reserved1_get, _gpod._Itdb_SPLRules_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_SPLRules_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_SPLRules_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_SPLRules_reserved2_get, _gpod._Itdb_SPLRules_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_SPLRules self) -> _Itdb_SPLRules"""
        this = _gpod.new__Itdb_SPLRules()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_SPLRules
    __del__ = lambda self: None
_Itdb_SPLRules_swigregister = _gpod._Itdb_SPLRules_swigregister
_Itdb_SPLRules_swigregister(_Itdb_SPLRules)

class _Itdb_Chapter(_object):
    """Proxy of C _Itdb_Chapter struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_Chapter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_Chapter, name)
    __repr__ = _swig_repr
    __swig_setmethods__["startpos"] = _gpod._Itdb_Chapter_startpos_set
    __swig_getmethods__["startpos"] = _gpod._Itdb_Chapter_startpos_get
    if _newclass:
        startpos = _swig_property(_gpod._Itdb_Chapter_startpos_get, _gpod._Itdb_Chapter_startpos_set)
    __swig_setmethods__["chaptertitle"] = _gpod._Itdb_Chapter_chaptertitle_set
    __swig_getmethods__["chaptertitle"] = _gpod._Itdb_Chapter_chaptertitle_get
    if _newclass:
        chaptertitle = _swig_property(_gpod._Itdb_Chapter_chaptertitle_get, _gpod._Itdb_Chapter_chaptertitle_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_Chapter_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_Chapter_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_Chapter_reserved_int1_get, _gpod._Itdb_Chapter_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_Chapter_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_Chapter_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_Chapter_reserved_int2_get, _gpod._Itdb_Chapter_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_Chapter_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_Chapter_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_Chapter_reserved1_get, _gpod._Itdb_Chapter_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_Chapter_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_Chapter_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_Chapter_reserved2_get, _gpod._Itdb_Chapter_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_Chapter self) -> _Itdb_Chapter"""
        this = _gpod.new__Itdb_Chapter()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_Chapter
    __del__ = lambda self: None
_Itdb_Chapter_swigregister = _gpod._Itdb_Chapter_swigregister
_Itdb_Chapter_swigregister(_Itdb_Chapter)

class _Itdb_Chapterdata(_object):
    """Proxy of C _Itdb_Chapterdata struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_Chapterdata, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_Chapterdata, name)
    __repr__ = _swig_repr
    __swig_setmethods__["chapters"] = _gpod._Itdb_Chapterdata_chapters_set
    __swig_getmethods__["chapters"] = _gpod._Itdb_Chapterdata_chapters_get
    if _newclass:
        chapters = _swig_property(_gpod._Itdb_Chapterdata_chapters_get, _gpod._Itdb_Chapterdata_chapters_set)
    __swig_setmethods__["unk024"] = _gpod._Itdb_Chapterdata_unk024_set
    __swig_getmethods__["unk024"] = _gpod._Itdb_Chapterdata_unk024_get
    if _newclass:
        unk024 = _swig_property(_gpod._Itdb_Chapterdata_unk024_get, _gpod._Itdb_Chapterdata_unk024_set)
    __swig_setmethods__["unk028"] = _gpod._Itdb_Chapterdata_unk028_set
    __swig_getmethods__["unk028"] = _gpod._Itdb_Chapterdata_unk028_get
    if _newclass:
        unk028 = _swig_property(_gpod._Itdb_Chapterdata_unk028_get, _gpod._Itdb_Chapterdata_unk028_set)
    __swig_setmethods__["unk032"] = _gpod._Itdb_Chapterdata_unk032_set
    __swig_getmethods__["unk032"] = _gpod._Itdb_Chapterdata_unk032_get
    if _newclass:
        unk032 = _swig_property(_gpod._Itdb_Chapterdata_unk032_get, _gpod._Itdb_Chapterdata_unk032_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_Chapterdata_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_Chapterdata_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_Chapterdata_reserved_int1_get, _gpod._Itdb_Chapterdata_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_Chapterdata_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_Chapterdata_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_Chapterdata_reserved_int2_get, _gpod._Itdb_Chapterdata_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_Chapterdata_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_Chapterdata_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_Chapterdata_reserved1_get, _gpod._Itdb_Chapterdata_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_Chapterdata_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_Chapterdata_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_Chapterdata_reserved2_get, _gpod._Itdb_Chapterdata_reserved2_set)

    def __init__(self):
        """__init__(_Itdb_Chapterdata self) -> _Itdb_Chapterdata"""
        this = _gpod.new__Itdb_Chapterdata()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_Chapterdata
    __del__ = lambda self: None
_Itdb_Chapterdata_swigregister = _gpod._Itdb_Chapterdata_swigregister
_Itdb_Chapterdata_swigregister(_Itdb_Chapterdata)

ITDB_RATING_STEP = _gpod.ITDB_RATING_STEP
class _Itdb_Artwork(_object):
    """Proxy of C _Itdb_Artwork struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_Artwork, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_Artwork, name)
    __repr__ = _swig_repr
    __swig_setmethods__["thumbnail"] = _gpod._Itdb_Artwork_thumbnail_set
    __swig_getmethods__["thumbnail"] = _gpod._Itdb_Artwork_thumbnail_get
    if _newclass:
        thumbnail = _swig_property(_gpod._Itdb_Artwork_thumbnail_get, _gpod._Itdb_Artwork_thumbnail_set)
    __swig_setmethods__["id"] = _gpod._Itdb_Artwork_id_set
    __swig_getmethods__["id"] = _gpod._Itdb_Artwork_id_get
    if _newclass:
        id = _swig_property(_gpod._Itdb_Artwork_id_get, _gpod._Itdb_Artwork_id_set)
    __swig_setmethods__["dbid"] = _gpod._Itdb_Artwork_dbid_set
    __swig_getmethods__["dbid"] = _gpod._Itdb_Artwork_dbid_get
    if _newclass:
        dbid = _swig_property(_gpod._Itdb_Artwork_dbid_get, _gpod._Itdb_Artwork_dbid_set)
    __swig_setmethods__["unk028"] = _gpod._Itdb_Artwork_unk028_set
    __swig_getmethods__["unk028"] = _gpod._Itdb_Artwork_unk028_get
    if _newclass:
        unk028 = _swig_property(_gpod._Itdb_Artwork_unk028_get, _gpod._Itdb_Artwork_unk028_set)
    __swig_setmethods__["rating"] = _gpod._Itdb_Artwork_rating_set
    __swig_getmethods__["rating"] = _gpod._Itdb_Artwork_rating_get
    if _newclass:
        rating = _swig_property(_gpod._Itdb_Artwork_rating_get, _gpod._Itdb_Artwork_rating_set)
    __swig_setmethods__["unk036"] = _gpod._Itdb_Artwork_unk036_set
    __swig_getmethods__["unk036"] = _gpod._Itdb_Artwork_unk036_get
    if _newclass:
        unk036 = _swig_property(_gpod._Itdb_Artwork_unk036_get, _gpod._Itdb_Artwork_unk036_set)
    __swig_setmethods__["creation_date"] = _gpod._Itdb_Artwork_creation_date_set
    __swig_getmethods__["creation_date"] = _gpod._Itdb_Artwork_creation_date_get
    if _newclass:
        creation_date = _swig_property(_gpod._Itdb_Artwork_creation_date_get, _gpod._Itdb_Artwork_creation_date_set)
    __swig_setmethods__["digitized_date"] = _gpod._Itdb_Artwork_digitized_date_set
    __swig_getmethods__["digitized_date"] = _gpod._Itdb_Artwork_digitized_date_get
    if _newclass:
        digitized_date = _swig_property(_gpod._Itdb_Artwork_digitized_date_get, _gpod._Itdb_Artwork_digitized_date_set)
    __swig_setmethods__["artwork_size"] = _gpod._Itdb_Artwork_artwork_size_set
    __swig_getmethods__["artwork_size"] = _gpod._Itdb_Artwork_artwork_size_get
    if _newclass:
        artwork_size = _swig_property(_gpod._Itdb_Artwork_artwork_size_get, _gpod._Itdb_Artwork_artwork_size_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_Artwork_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_Artwork_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_Artwork_reserved_int1_get, _gpod._Itdb_Artwork_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_Artwork_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_Artwork_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_Artwork_reserved_int2_get, _gpod._Itdb_Artwork_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_Artwork_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_Artwork_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_Artwork_reserved1_get, _gpod._Itdb_Artwork_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_Artwork_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_Artwork_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_Artwork_reserved2_get, _gpod._Itdb_Artwork_reserved2_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_Artwork_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_Artwork_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_Artwork_usertype_get, _gpod._Itdb_Artwork_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_Artwork_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_Artwork_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_Artwork_userdata_get, _gpod._Itdb_Artwork_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_Artwork_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_Artwork_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_Artwork_userdata_duplicate_get, _gpod._Itdb_Artwork_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_Artwork_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_Artwork_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_Artwork_userdata_destroy_get, _gpod._Itdb_Artwork_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_Artwork self) -> _Itdb_Artwork"""
        this = _gpod.new__Itdb_Artwork()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_Artwork
    __del__ = lambda self: None
_Itdb_Artwork_swigregister = _gpod._Itdb_Artwork_swigregister
_Itdb_Artwork_swigregister(_Itdb_Artwork)

class _Itdb_PhotoDB(_object):
    """Proxy of C _Itdb_PhotoDB struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_PhotoDB, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_PhotoDB, name)
    __repr__ = _swig_repr
    __swig_setmethods__["photos"] = _gpod._Itdb_PhotoDB_photos_set
    __swig_getmethods__["photos"] = _gpod._Itdb_PhotoDB_photos_get
    if _newclass:
        photos = _swig_property(_gpod._Itdb_PhotoDB_photos_get, _gpod._Itdb_PhotoDB_photos_set)
    __swig_setmethods__["photoalbums"] = _gpod._Itdb_PhotoDB_photoalbums_set
    __swig_getmethods__["photoalbums"] = _gpod._Itdb_PhotoDB_photoalbums_get
    if _newclass:
        photoalbums = _swig_property(_gpod._Itdb_PhotoDB_photoalbums_get, _gpod._Itdb_PhotoDB_photoalbums_set)
    __swig_setmethods__["device"] = _gpod._Itdb_PhotoDB_device_set
    __swig_getmethods__["device"] = _gpod._Itdb_PhotoDB_device_get
    if _newclass:
        device = _swig_property(_gpod._Itdb_PhotoDB_device_get, _gpod._Itdb_PhotoDB_device_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_PhotoDB_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_PhotoDB_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_PhotoDB_reserved_int1_get, _gpod._Itdb_PhotoDB_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_PhotoDB_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_PhotoDB_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_PhotoDB_reserved_int2_get, _gpod._Itdb_PhotoDB_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_PhotoDB_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_PhotoDB_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_PhotoDB_reserved1_get, _gpod._Itdb_PhotoDB_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_PhotoDB_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_PhotoDB_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_PhotoDB_reserved2_get, _gpod._Itdb_PhotoDB_reserved2_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_PhotoDB_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_PhotoDB_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_PhotoDB_usertype_get, _gpod._Itdb_PhotoDB_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_PhotoDB_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_PhotoDB_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_PhotoDB_userdata_get, _gpod._Itdb_PhotoDB_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_PhotoDB_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_PhotoDB_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_PhotoDB_userdata_duplicate_get, _gpod._Itdb_PhotoDB_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_PhotoDB_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_PhotoDB_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_PhotoDB_userdata_destroy_get, _gpod._Itdb_PhotoDB_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_PhotoDB self) -> _Itdb_PhotoDB"""
        this = _gpod.new__Itdb_PhotoDB()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_PhotoDB
    __del__ = lambda self: None
_Itdb_PhotoDB_swigregister = _gpod._Itdb_PhotoDB_swigregister
_Itdb_PhotoDB_swigregister(_Itdb_PhotoDB)

class _Itdb_iTunesDB(_object):
    """Proxy of C _Itdb_iTunesDB struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_iTunesDB, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_iTunesDB, name)
    __repr__ = _swig_repr
    __swig_setmethods__["tracks"] = _gpod._Itdb_iTunesDB_tracks_set
    __swig_getmethods__["tracks"] = _gpod._Itdb_iTunesDB_tracks_get
    if _newclass:
        tracks = _swig_property(_gpod._Itdb_iTunesDB_tracks_get, _gpod._Itdb_iTunesDB_tracks_set)
    __swig_setmethods__["playlists"] = _gpod._Itdb_iTunesDB_playlists_set
    __swig_getmethods__["playlists"] = _gpod._Itdb_iTunesDB_playlists_get
    if _newclass:
        playlists = _swig_property(_gpod._Itdb_iTunesDB_playlists_get, _gpod._Itdb_iTunesDB_playlists_set)
    __swig_setmethods__["filename"] = _gpod._Itdb_iTunesDB_filename_set
    __swig_getmethods__["filename"] = _gpod._Itdb_iTunesDB_filename_get
    if _newclass:
        filename = _swig_property(_gpod._Itdb_iTunesDB_filename_get, _gpod._Itdb_iTunesDB_filename_set)
    __swig_setmethods__["device"] = _gpod._Itdb_iTunesDB_device_set
    __swig_getmethods__["device"] = _gpod._Itdb_iTunesDB_device_get
    if _newclass:
        device = _swig_property(_gpod._Itdb_iTunesDB_device_get, _gpod._Itdb_iTunesDB_device_set)
    __swig_setmethods__["version"] = _gpod._Itdb_iTunesDB_version_set
    __swig_getmethods__["version"] = _gpod._Itdb_iTunesDB_version_get
    if _newclass:
        version = _swig_property(_gpod._Itdb_iTunesDB_version_get, _gpod._Itdb_iTunesDB_version_set)
    __swig_setmethods__["id"] = _gpod._Itdb_iTunesDB_id_set
    __swig_getmethods__["id"] = _gpod._Itdb_iTunesDB_id_get
    if _newclass:
        id = _swig_property(_gpod._Itdb_iTunesDB_id_get, _gpod._Itdb_iTunesDB_id_set)
    __swig_setmethods__["tzoffset"] = _gpod._Itdb_iTunesDB_tzoffset_set
    __swig_getmethods__["tzoffset"] = _gpod._Itdb_iTunesDB_tzoffset_get
    if _newclass:
        tzoffset = _swig_property(_gpod._Itdb_iTunesDB_tzoffset_get, _gpod._Itdb_iTunesDB_tzoffset_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_iTunesDB_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_iTunesDB_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_iTunesDB_reserved_int2_get, _gpod._Itdb_iTunesDB_reserved_int2_set)
    __swig_setmethods__["priv"] = _gpod._Itdb_iTunesDB_priv_set
    __swig_getmethods__["priv"] = _gpod._Itdb_iTunesDB_priv_get
    if _newclass:
        priv = _swig_property(_gpod._Itdb_iTunesDB_priv_get, _gpod._Itdb_iTunesDB_priv_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_iTunesDB_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_iTunesDB_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_iTunesDB_reserved2_get, _gpod._Itdb_iTunesDB_reserved2_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_iTunesDB_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_iTunesDB_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_iTunesDB_usertype_get, _gpod._Itdb_iTunesDB_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_iTunesDB_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_iTunesDB_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_iTunesDB_userdata_get, _gpod._Itdb_iTunesDB_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_iTunesDB_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_iTunesDB_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_iTunesDB_userdata_duplicate_get, _gpod._Itdb_iTunesDB_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_iTunesDB_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_iTunesDB_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_iTunesDB_userdata_destroy_get, _gpod._Itdb_iTunesDB_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_iTunesDB self) -> _Itdb_iTunesDB"""
        this = _gpod.new__Itdb_iTunesDB()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_iTunesDB
    __del__ = lambda self: None
_Itdb_iTunesDB_swigregister = _gpod._Itdb_iTunesDB_swigregister
_Itdb_iTunesDB_swigregister(_Itdb_iTunesDB)

class _Itdb_PhotoAlbum(_object):
    """Proxy of C _Itdb_PhotoAlbum struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_PhotoAlbum, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_PhotoAlbum, name)
    __repr__ = _swig_repr
    __swig_setmethods__["photodb"] = _gpod._Itdb_PhotoAlbum_photodb_set
    __swig_getmethods__["photodb"] = _gpod._Itdb_PhotoAlbum_photodb_get
    if _newclass:
        photodb = _swig_property(_gpod._Itdb_PhotoAlbum_photodb_get, _gpod._Itdb_PhotoAlbum_photodb_set)
    __swig_setmethods__["name"] = _gpod._Itdb_PhotoAlbum_name_set
    __swig_getmethods__["name"] = _gpod._Itdb_PhotoAlbum_name_get
    if _newclass:
        name = _swig_property(_gpod._Itdb_PhotoAlbum_name_get, _gpod._Itdb_PhotoAlbum_name_set)
    __swig_setmethods__["members"] = _gpod._Itdb_PhotoAlbum_members_set
    __swig_getmethods__["members"] = _gpod._Itdb_PhotoAlbum_members_get
    if _newclass:
        members = _swig_property(_gpod._Itdb_PhotoAlbum_members_get, _gpod._Itdb_PhotoAlbum_members_set)
    __swig_setmethods__["album_type"] = _gpod._Itdb_PhotoAlbum_album_type_set
    __swig_getmethods__["album_type"] = _gpod._Itdb_PhotoAlbum_album_type_get
    if _newclass:
        album_type = _swig_property(_gpod._Itdb_PhotoAlbum_album_type_get, _gpod._Itdb_PhotoAlbum_album_type_set)
    __swig_setmethods__["playmusic"] = _gpod._Itdb_PhotoAlbum_playmusic_set
    __swig_getmethods__["playmusic"] = _gpod._Itdb_PhotoAlbum_playmusic_get
    if _newclass:
        playmusic = _swig_property(_gpod._Itdb_PhotoAlbum_playmusic_get, _gpod._Itdb_PhotoAlbum_playmusic_set)
    __swig_setmethods__["repeat"] = _gpod._Itdb_PhotoAlbum_repeat_set
    __swig_getmethods__["repeat"] = _gpod._Itdb_PhotoAlbum_repeat_get
    if _newclass:
        repeat = _swig_property(_gpod._Itdb_PhotoAlbum_repeat_get, _gpod._Itdb_PhotoAlbum_repeat_set)
    __swig_setmethods__["random"] = _gpod._Itdb_PhotoAlbum_random_set
    __swig_getmethods__["random"] = _gpod._Itdb_PhotoAlbum_random_get
    if _newclass:
        random = _swig_property(_gpod._Itdb_PhotoAlbum_random_get, _gpod._Itdb_PhotoAlbum_random_set)
    __swig_setmethods__["show_titles"] = _gpod._Itdb_PhotoAlbum_show_titles_set
    __swig_getmethods__["show_titles"] = _gpod._Itdb_PhotoAlbum_show_titles_get
    if _newclass:
        show_titles = _swig_property(_gpod._Itdb_PhotoAlbum_show_titles_get, _gpod._Itdb_PhotoAlbum_show_titles_set)
    __swig_setmethods__["transition_direction"] = _gpod._Itdb_PhotoAlbum_transition_direction_set
    __swig_getmethods__["transition_direction"] = _gpod._Itdb_PhotoAlbum_transition_direction_get
    if _newclass:
        transition_direction = _swig_property(_gpod._Itdb_PhotoAlbum_transition_direction_get, _gpod._Itdb_PhotoAlbum_transition_direction_set)
    __swig_setmethods__["slide_duration"] = _gpod._Itdb_PhotoAlbum_slide_duration_set
    __swig_getmethods__["slide_duration"] = _gpod._Itdb_PhotoAlbum_slide_duration_get
    if _newclass:
        slide_duration = _swig_property(_gpod._Itdb_PhotoAlbum_slide_duration_get, _gpod._Itdb_PhotoAlbum_slide_duration_set)
    __swig_setmethods__["transition_duration"] = _gpod._Itdb_PhotoAlbum_transition_duration_set
    __swig_getmethods__["transition_duration"] = _gpod._Itdb_PhotoAlbum_transition_duration_get
    if _newclass:
        transition_duration = _swig_property(_gpod._Itdb_PhotoAlbum_transition_duration_get, _gpod._Itdb_PhotoAlbum_transition_duration_set)
    __swig_setmethods__["song_id"] = _gpod._Itdb_PhotoAlbum_song_id_set
    __swig_getmethods__["song_id"] = _gpod._Itdb_PhotoAlbum_song_id_get
    if _newclass:
        song_id = _swig_property(_gpod._Itdb_PhotoAlbum_song_id_get, _gpod._Itdb_PhotoAlbum_song_id_set)
    __swig_setmethods__["unk024"] = _gpod._Itdb_PhotoAlbum_unk024_set
    __swig_getmethods__["unk024"] = _gpod._Itdb_PhotoAlbum_unk024_get
    if _newclass:
        unk024 = _swig_property(_gpod._Itdb_PhotoAlbum_unk024_get, _gpod._Itdb_PhotoAlbum_unk024_set)
    __swig_setmethods__["unk028"] = _gpod._Itdb_PhotoAlbum_unk028_set
    __swig_getmethods__["unk028"] = _gpod._Itdb_PhotoAlbum_unk028_get
    if _newclass:
        unk028 = _swig_property(_gpod._Itdb_PhotoAlbum_unk028_get, _gpod._Itdb_PhotoAlbum_unk028_set)
    __swig_setmethods__["unk044"] = _gpod._Itdb_PhotoAlbum_unk044_set
    __swig_getmethods__["unk044"] = _gpod._Itdb_PhotoAlbum_unk044_get
    if _newclass:
        unk044 = _swig_property(_gpod._Itdb_PhotoAlbum_unk044_get, _gpod._Itdb_PhotoAlbum_unk044_set)
    __swig_setmethods__["unk048"] = _gpod._Itdb_PhotoAlbum_unk048_set
    __swig_getmethods__["unk048"] = _gpod._Itdb_PhotoAlbum_unk048_get
    if _newclass:
        unk048 = _swig_property(_gpod._Itdb_PhotoAlbum_unk048_get, _gpod._Itdb_PhotoAlbum_unk048_set)
    __swig_setmethods__["album_id"] = _gpod._Itdb_PhotoAlbum_album_id_set
    __swig_getmethods__["album_id"] = _gpod._Itdb_PhotoAlbum_album_id_get
    if _newclass:
        album_id = _swig_property(_gpod._Itdb_PhotoAlbum_album_id_get, _gpod._Itdb_PhotoAlbum_album_id_set)
    __swig_setmethods__["prev_album_id"] = _gpod._Itdb_PhotoAlbum_prev_album_id_set
    __swig_getmethods__["prev_album_id"] = _gpod._Itdb_PhotoAlbum_prev_album_id_get
    if _newclass:
        prev_album_id = _swig_property(_gpod._Itdb_PhotoAlbum_prev_album_id_get, _gpod._Itdb_PhotoAlbum_prev_album_id_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_PhotoAlbum_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_PhotoAlbum_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_PhotoAlbum_reserved_int1_get, _gpod._Itdb_PhotoAlbum_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_PhotoAlbum_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_PhotoAlbum_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_PhotoAlbum_reserved_int2_get, _gpod._Itdb_PhotoAlbum_reserved_int2_set)
    __swig_setmethods__["reserved1"] = _gpod._Itdb_PhotoAlbum_reserved1_set
    __swig_getmethods__["reserved1"] = _gpod._Itdb_PhotoAlbum_reserved1_get
    if _newclass:
        reserved1 = _swig_property(_gpod._Itdb_PhotoAlbum_reserved1_get, _gpod._Itdb_PhotoAlbum_reserved1_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_PhotoAlbum_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_PhotoAlbum_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_PhotoAlbum_reserved2_get, _gpod._Itdb_PhotoAlbum_reserved2_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_PhotoAlbum_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_PhotoAlbum_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_PhotoAlbum_usertype_get, _gpod._Itdb_PhotoAlbum_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_PhotoAlbum_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_PhotoAlbum_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_PhotoAlbum_userdata_get, _gpod._Itdb_PhotoAlbum_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_PhotoAlbum_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_PhotoAlbum_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_PhotoAlbum_userdata_duplicate_get, _gpod._Itdb_PhotoAlbum_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_PhotoAlbum_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_PhotoAlbum_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_PhotoAlbum_userdata_destroy_get, _gpod._Itdb_PhotoAlbum_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_PhotoAlbum self) -> _Itdb_PhotoAlbum"""
        this = _gpod.new__Itdb_PhotoAlbum()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_PhotoAlbum
    __del__ = lambda self: None
_Itdb_PhotoAlbum_swigregister = _gpod._Itdb_PhotoAlbum_swigregister
_Itdb_PhotoAlbum_swigregister(_Itdb_PhotoAlbum)

class _Itdb_Playlist(_object):
    """Proxy of C _Itdb_Playlist struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_Playlist, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_Playlist, name)
    __repr__ = _swig_repr
    __swig_setmethods__["itdb"] = _gpod._Itdb_Playlist_itdb_set
    __swig_getmethods__["itdb"] = _gpod._Itdb_Playlist_itdb_get
    if _newclass:
        itdb = _swig_property(_gpod._Itdb_Playlist_itdb_get, _gpod._Itdb_Playlist_itdb_set)
    __swig_setmethods__["name"] = _gpod._Itdb_Playlist_name_set
    __swig_getmethods__["name"] = _gpod._Itdb_Playlist_name_get
    if _newclass:
        name = _swig_property(_gpod._Itdb_Playlist_name_get, _gpod._Itdb_Playlist_name_set)
    __swig_setmethods__["type"] = _gpod._Itdb_Playlist_type_set
    __swig_getmethods__["type"] = _gpod._Itdb_Playlist_type_get
    if _newclass:
        type = _swig_property(_gpod._Itdb_Playlist_type_get, _gpod._Itdb_Playlist_type_set)
    __swig_setmethods__["flag1"] = _gpod._Itdb_Playlist_flag1_set
    __swig_getmethods__["flag1"] = _gpod._Itdb_Playlist_flag1_get
    if _newclass:
        flag1 = _swig_property(_gpod._Itdb_Playlist_flag1_get, _gpod._Itdb_Playlist_flag1_set)
    __swig_setmethods__["flag2"] = _gpod._Itdb_Playlist_flag2_set
    __swig_getmethods__["flag2"] = _gpod._Itdb_Playlist_flag2_get
    if _newclass:
        flag2 = _swig_property(_gpod._Itdb_Playlist_flag2_get, _gpod._Itdb_Playlist_flag2_set)
    __swig_setmethods__["flag3"] = _gpod._Itdb_Playlist_flag3_set
    __swig_getmethods__["flag3"] = _gpod._Itdb_Playlist_flag3_get
    if _newclass:
        flag3 = _swig_property(_gpod._Itdb_Playlist_flag3_get, _gpod._Itdb_Playlist_flag3_set)
    __swig_setmethods__["num"] = _gpod._Itdb_Playlist_num_set
    __swig_getmethods__["num"] = _gpod._Itdb_Playlist_num_get
    if _newclass:
        num = _swig_property(_gpod._Itdb_Playlist_num_get, _gpod._Itdb_Playlist_num_set)
    __swig_setmethods__["members"] = _gpod._Itdb_Playlist_members_set
    __swig_getmethods__["members"] = _gpod._Itdb_Playlist_members_get
    if _newclass:
        members = _swig_property(_gpod._Itdb_Playlist_members_get, _gpod._Itdb_Playlist_members_set)
    __swig_setmethods__["is_spl"] = _gpod._Itdb_Playlist_is_spl_set
    __swig_getmethods__["is_spl"] = _gpod._Itdb_Playlist_is_spl_get
    if _newclass:
        is_spl = _swig_property(_gpod._Itdb_Playlist_is_spl_get, _gpod._Itdb_Playlist_is_spl_set)
    __swig_setmethods__["timestamp"] = _gpod._Itdb_Playlist_timestamp_set
    __swig_getmethods__["timestamp"] = _gpod._Itdb_Playlist_timestamp_get
    if _newclass:
        timestamp = _swig_property(_gpod._Itdb_Playlist_timestamp_get, _gpod._Itdb_Playlist_timestamp_set)
    __swig_setmethods__["id"] = _gpod._Itdb_Playlist_id_set
    __swig_getmethods__["id"] = _gpod._Itdb_Playlist_id_get
    if _newclass:
        id = _swig_property(_gpod._Itdb_Playlist_id_get, _gpod._Itdb_Playlist_id_set)
    __swig_setmethods__["sortorder"] = _gpod._Itdb_Playlist_sortorder_set
    __swig_getmethods__["sortorder"] = _gpod._Itdb_Playlist_sortorder_get
    if _newclass:
        sortorder = _swig_property(_gpod._Itdb_Playlist_sortorder_get, _gpod._Itdb_Playlist_sortorder_set)
    __swig_setmethods__["podcastflag"] = _gpod._Itdb_Playlist_podcastflag_set
    __swig_getmethods__["podcastflag"] = _gpod._Itdb_Playlist_podcastflag_get
    if _newclass:
        podcastflag = _swig_property(_gpod._Itdb_Playlist_podcastflag_get, _gpod._Itdb_Playlist_podcastflag_set)
    __swig_setmethods__["splpref"] = _gpod._Itdb_Playlist_splpref_set
    __swig_getmethods__["splpref"] = _gpod._Itdb_Playlist_splpref_get
    if _newclass:
        splpref = _swig_property(_gpod._Itdb_Playlist_splpref_get, _gpod._Itdb_Playlist_splpref_set)
    __swig_setmethods__["splrules"] = _gpod._Itdb_Playlist_splrules_set
    __swig_getmethods__["splrules"] = _gpod._Itdb_Playlist_splrules_get
    if _newclass:
        splrules = _swig_property(_gpod._Itdb_Playlist_splrules_get, _gpod._Itdb_Playlist_splrules_set)
    __swig_setmethods__["reserved100"] = _gpod._Itdb_Playlist_reserved100_set
    __swig_getmethods__["reserved100"] = _gpod._Itdb_Playlist_reserved100_get
    if _newclass:
        reserved100 = _swig_property(_gpod._Itdb_Playlist_reserved100_get, _gpod._Itdb_Playlist_reserved100_set)
    __swig_setmethods__["reserved101"] = _gpod._Itdb_Playlist_reserved101_set
    __swig_getmethods__["reserved101"] = _gpod._Itdb_Playlist_reserved101_get
    if _newclass:
        reserved101 = _swig_property(_gpod._Itdb_Playlist_reserved101_get, _gpod._Itdb_Playlist_reserved101_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_Playlist_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_Playlist_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_Playlist_reserved_int1_get, _gpod._Itdb_Playlist_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_Playlist_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_Playlist_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_Playlist_reserved_int2_get, _gpod._Itdb_Playlist_reserved_int2_set)
    __swig_setmethods__["priv"] = _gpod._Itdb_Playlist_priv_set
    __swig_getmethods__["priv"] = _gpod._Itdb_Playlist_priv_get
    if _newclass:
        priv = _swig_property(_gpod._Itdb_Playlist_priv_get, _gpod._Itdb_Playlist_priv_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_Playlist_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_Playlist_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_Playlist_reserved2_get, _gpod._Itdb_Playlist_reserved2_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_Playlist_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_Playlist_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_Playlist_usertype_get, _gpod._Itdb_Playlist_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_Playlist_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_Playlist_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_Playlist_userdata_get, _gpod._Itdb_Playlist_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_Playlist_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_Playlist_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_Playlist_userdata_duplicate_get, _gpod._Itdb_Playlist_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_Playlist_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_Playlist_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_Playlist_userdata_destroy_get, _gpod._Itdb_Playlist_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_Playlist self) -> _Itdb_Playlist"""
        this = _gpod.new__Itdb_Playlist()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_Playlist
    __del__ = lambda self: None
_Itdb_Playlist_swigregister = _gpod._Itdb_Playlist_swigregister
_Itdb_Playlist_swigregister(_Itdb_Playlist)

ITDB_PSO_MANUAL = _gpod.ITDB_PSO_MANUAL
ITDB_PSO_TITLE = _gpod.ITDB_PSO_TITLE
ITDB_PSO_ALBUM = _gpod.ITDB_PSO_ALBUM
ITDB_PSO_ARTIST = _gpod.ITDB_PSO_ARTIST
ITDB_PSO_BITRATE = _gpod.ITDB_PSO_BITRATE
ITDB_PSO_GENRE = _gpod.ITDB_PSO_GENRE
ITDB_PSO_FILETYPE = _gpod.ITDB_PSO_FILETYPE
ITDB_PSO_TIME_MODIFIED = _gpod.ITDB_PSO_TIME_MODIFIED
ITDB_PSO_TRACK_NR = _gpod.ITDB_PSO_TRACK_NR
ITDB_PSO_SIZE = _gpod.ITDB_PSO_SIZE
ITDB_PSO_TIME = _gpod.ITDB_PSO_TIME
ITDB_PSO_YEAR = _gpod.ITDB_PSO_YEAR
ITDB_PSO_SAMPLERATE = _gpod.ITDB_PSO_SAMPLERATE
ITDB_PSO_COMMENT = _gpod.ITDB_PSO_COMMENT
ITDB_PSO_TIME_ADDED = _gpod.ITDB_PSO_TIME_ADDED
ITDB_PSO_EQUALIZER = _gpod.ITDB_PSO_EQUALIZER
ITDB_PSO_COMPOSER = _gpod.ITDB_PSO_COMPOSER
ITDB_PSO_PLAYCOUNT = _gpod.ITDB_PSO_PLAYCOUNT
ITDB_PSO_TIME_PLAYED = _gpod.ITDB_PSO_TIME_PLAYED
ITDB_PSO_CD_NR = _gpod.ITDB_PSO_CD_NR
ITDB_PSO_RATING = _gpod.ITDB_PSO_RATING
ITDB_PSO_RELEASE_DATE = _gpod.ITDB_PSO_RELEASE_DATE
ITDB_PSO_BPM = _gpod.ITDB_PSO_BPM
ITDB_PSO_GROUPING = _gpod.ITDB_PSO_GROUPING
ITDB_PSO_CATEGORY = _gpod.ITDB_PSO_CATEGORY
ITDB_PSO_DESCRIPTION = _gpod.ITDB_PSO_DESCRIPTION
ITDB_MEDIATYPE_AUDIO = _gpod.ITDB_MEDIATYPE_AUDIO
ITDB_MEDIATYPE_MOVIE = _gpod.ITDB_MEDIATYPE_MOVIE
ITDB_MEDIATYPE_PODCAST = _gpod.ITDB_MEDIATYPE_PODCAST
ITDB_MEDIATYPE_AUDIOBOOK = _gpod.ITDB_MEDIATYPE_AUDIOBOOK
ITDB_MEDIATYPE_MUSICVIDEO = _gpod.ITDB_MEDIATYPE_MUSICVIDEO
ITDB_MEDIATYPE_TVSHOW = _gpod.ITDB_MEDIATYPE_TVSHOW
ITDB_MEDIATYPE_RINGTONE = _gpod.ITDB_MEDIATYPE_RINGTONE
ITDB_MEDIATYPE_RENTAL = _gpod.ITDB_MEDIATYPE_RENTAL
ITDB_MEDIATYPE_ITUNES_EXTRA = _gpod.ITDB_MEDIATYPE_ITUNES_EXTRA
ITDB_MEDIATYPE_MEMO = _gpod.ITDB_MEDIATYPE_MEMO
ITDB_MEDIATYPE_ITUNES_U = _gpod.ITDB_MEDIATYPE_ITUNES_U
ITDB_MEDIATYPE_EPUB_BOOK = _gpod.ITDB_MEDIATYPE_EPUB_BOOK
class _Itdb_Track(_object):
    """Proxy of C _Itdb_Track struct."""

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, _Itdb_Track, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, _Itdb_Track, name)
    __repr__ = _swig_repr
    __swig_setmethods__["itdb"] = _gpod._Itdb_Track_itdb_set
    __swig_getmethods__["itdb"] = _gpod._Itdb_Track_itdb_get
    if _newclass:
        itdb = _swig_property(_gpod._Itdb_Track_itdb_get, _gpod._Itdb_Track_itdb_set)
    __swig_setmethods__["title"] = _gpod._Itdb_Track_title_set
    __swig_getmethods__["title"] = _gpod._Itdb_Track_title_get
    if _newclass:
        title = _swig_property(_gpod._Itdb_Track_title_get, _gpod._Itdb_Track_title_set)
    __swig_setmethods__["ipod_path"] = _gpod._Itdb_Track_ipod_path_set
    __swig_getmethods__["ipod_path"] = _gpod._Itdb_Track_ipod_path_get
    if _newclass:
        ipod_path = _swig_property(_gpod._Itdb_Track_ipod_path_get, _gpod._Itdb_Track_ipod_path_set)
    __swig_setmethods__["album"] = _gpod._Itdb_Track_album_set
    __swig_getmethods__["album"] = _gpod._Itdb_Track_album_get
    if _newclass:
        album = _swig_property(_gpod._Itdb_Track_album_get, _gpod._Itdb_Track_album_set)
    __swig_setmethods__["artist"] = _gpod._Itdb_Track_artist_set
    __swig_getmethods__["artist"] = _gpod._Itdb_Track_artist_get
    if _newclass:
        artist = _swig_property(_gpod._Itdb_Track_artist_get, _gpod._Itdb_Track_artist_set)
    __swig_setmethods__["genre"] = _gpod._Itdb_Track_genre_set
    __swig_getmethods__["genre"] = _gpod._Itdb_Track_genre_get
    if _newclass:
        genre = _swig_property(_gpod._Itdb_Track_genre_get, _gpod._Itdb_Track_genre_set)
    __swig_setmethods__["filetype"] = _gpod._Itdb_Track_filetype_set
    __swig_getmethods__["filetype"] = _gpod._Itdb_Track_filetype_get
    if _newclass:
        filetype = _swig_property(_gpod._Itdb_Track_filetype_get, _gpod._Itdb_Track_filetype_set)
    __swig_setmethods__["comment"] = _gpod._Itdb_Track_comment_set
    __swig_getmethods__["comment"] = _gpod._Itdb_Track_comment_get
    if _newclass:
        comment = _swig_property(_gpod._Itdb_Track_comment_get, _gpod._Itdb_Track_comment_set)
    __swig_setmethods__["category"] = _gpod._Itdb_Track_category_set
    __swig_getmethods__["category"] = _gpod._Itdb_Track_category_get
    if _newclass:
        category = _swig_property(_gpod._Itdb_Track_category_get, _gpod._Itdb_Track_category_set)
    __swig_setmethods__["composer"] = _gpod._Itdb_Track_composer_set
    __swig_getmethods__["composer"] = _gpod._Itdb_Track_composer_get
    if _newclass:
        composer = _swig_property(_gpod._Itdb_Track_composer_get, _gpod._Itdb_Track_composer_set)
    __swig_setmethods__["grouping"] = _gpod._Itdb_Track_grouping_set
    __swig_getmethods__["grouping"] = _gpod._Itdb_Track_grouping_get
    if _newclass:
        grouping = _swig_property(_gpod._Itdb_Track_grouping_get, _gpod._Itdb_Track_grouping_set)
    __swig_setmethods__["description"] = _gpod._Itdb_Track_description_set
    __swig_getmethods__["description"] = _gpod._Itdb_Track_description_get
    if _newclass:
        description = _swig_property(_gpod._Itdb_Track_description_get, _gpod._Itdb_Track_description_set)
    __swig_setmethods__["podcasturl"] = _gpod._Itdb_Track_podcasturl_set
    __swig_getmethods__["podcasturl"] = _gpod._Itdb_Track_podcasturl_get
    if _newclass:
        podcasturl = _swig_property(_gpod._Itdb_Track_podcasturl_get, _gpod._Itdb_Track_podcasturl_set)
    __swig_setmethods__["podcastrss"] = _gpod._Itdb_Track_podcastrss_set
    __swig_getmethods__["podcastrss"] = _gpod._Itdb_Track_podcastrss_get
    if _newclass:
        podcastrss = _swig_property(_gpod._Itdb_Track_podcastrss_get, _gpod._Itdb_Track_podcastrss_set)
    __swig_setmethods__["chapterdata"] = _gpod._Itdb_Track_chapterdata_set
    __swig_getmethods__["chapterdata"] = _gpod._Itdb_Track_chapterdata_get
    if _newclass:
        chapterdata = _swig_property(_gpod._Itdb_Track_chapterdata_get, _gpod._Itdb_Track_chapterdata_set)
    __swig_setmethods__["subtitle"] = _gpod._Itdb_Track_subtitle_set
    __swig_getmethods__["subtitle"] = _gpod._Itdb_Track_subtitle_get
    if _newclass:
        subtitle = _swig_property(_gpod._Itdb_Track_subtitle_get, _gpod._Itdb_Track_subtitle_set)
    __swig_setmethods__["tvshow"] = _gpod._Itdb_Track_tvshow_set
    __swig_getmethods__["tvshow"] = _gpod._Itdb_Track_tvshow_get
    if _newclass:
        tvshow = _swig_property(_gpod._Itdb_Track_tvshow_get, _gpod._Itdb_Track_tvshow_set)
    __swig_setmethods__["tvepisode"] = _gpod._Itdb_Track_tvepisode_set
    __swig_getmethods__["tvepisode"] = _gpod._Itdb_Track_tvepisode_get
    if _newclass:
        tvepisode = _swig_property(_gpod._Itdb_Track_tvepisode_get, _gpod._Itdb_Track_tvepisode_set)
    __swig_setmethods__["tvnetwork"] = _gpod._Itdb_Track_tvnetwork_set
    __swig_getmethods__["tvnetwork"] = _gpod._Itdb_Track_tvnetwork_get
    if _newclass:
        tvnetwork = _swig_property(_gpod._Itdb_Track_tvnetwork_get, _gpod._Itdb_Track_tvnetwork_set)
    __swig_setmethods__["albumartist"] = _gpod._Itdb_Track_albumartist_set
    __swig_getmethods__["albumartist"] = _gpod._Itdb_Track_albumartist_get
    if _newclass:
        albumartist = _swig_property(_gpod._Itdb_Track_albumartist_get, _gpod._Itdb_Track_albumartist_set)
    __swig_setmethods__["keywords"] = _gpod._Itdb_Track_keywords_set
    __swig_getmethods__["keywords"] = _gpod._Itdb_Track_keywords_get
    if _newclass:
        keywords = _swig_property(_gpod._Itdb_Track_keywords_get, _gpod._Itdb_Track_keywords_set)
    __swig_setmethods__["sort_artist"] = _gpod._Itdb_Track_sort_artist_set
    __swig_getmethods__["sort_artist"] = _gpod._Itdb_Track_sort_artist_get
    if _newclass:
        sort_artist = _swig_property(_gpod._Itdb_Track_sort_artist_get, _gpod._Itdb_Track_sort_artist_set)
    __swig_setmethods__["sort_title"] = _gpod._Itdb_Track_sort_title_set
    __swig_getmethods__["sort_title"] = _gpod._Itdb_Track_sort_title_get
    if _newclass:
        sort_title = _swig_property(_gpod._Itdb_Track_sort_title_get, _gpod._Itdb_Track_sort_title_set)
    __swig_setmethods__["sort_album"] = _gpod._Itdb_Track_sort_album_set
    __swig_getmethods__["sort_album"] = _gpod._Itdb_Track_sort_album_get
    if _newclass:
        sort_album = _swig_property(_gpod._Itdb_Track_sort_album_get, _gpod._Itdb_Track_sort_album_set)
    __swig_setmethods__["sort_albumartist"] = _gpod._Itdb_Track_sort_albumartist_set
    __swig_getmethods__["sort_albumartist"] = _gpod._Itdb_Track_sort_albumartist_get
    if _newclass:
        sort_albumartist = _swig_property(_gpod._Itdb_Track_sort_albumartist_get, _gpod._Itdb_Track_sort_albumartist_set)
    __swig_setmethods__["sort_composer"] = _gpod._Itdb_Track_sort_composer_set
    __swig_getmethods__["sort_composer"] = _gpod._Itdb_Track_sort_composer_get
    if _newclass:
        sort_composer = _swig_property(_gpod._Itdb_Track_sort_composer_get, _gpod._Itdb_Track_sort_composer_set)
    __swig_setmethods__["sort_tvshow"] = _gpod._Itdb_Track_sort_tvshow_set
    __swig_getmethods__["sort_tvshow"] = _gpod._Itdb_Track_sort_tvshow_get
    if _newclass:
        sort_tvshow = _swig_property(_gpod._Itdb_Track_sort_tvshow_get, _gpod._Itdb_Track_sort_tvshow_set)
    __swig_setmethods__["id"] = _gpod._Itdb_Track_id_set
    __swig_getmethods__["id"] = _gpod._Itdb_Track_id_get
    if _newclass:
        id = _swig_property(_gpod._Itdb_Track_id_get, _gpod._Itdb_Track_id_set)
    __swig_setmethods__["size"] = _gpod._Itdb_Track_size_set
    __swig_getmethods__["size"] = _gpod._Itdb_Track_size_get
    if _newclass:
        size = _swig_property(_gpod._Itdb_Track_size_get, _gpod._Itdb_Track_size_set)
    __swig_setmethods__["tracklen"] = _gpod._Itdb_Track_tracklen_set
    __swig_getmethods__["tracklen"] = _gpod._Itdb_Track_tracklen_get
    if _newclass:
        tracklen = _swig_property(_gpod._Itdb_Track_tracklen_get, _gpod._Itdb_Track_tracklen_set)
    __swig_setmethods__["cd_nr"] = _gpod._Itdb_Track_cd_nr_set
    __swig_getmethods__["cd_nr"] = _gpod._Itdb_Track_cd_nr_get
    if _newclass:
        cd_nr = _swig_property(_gpod._Itdb_Track_cd_nr_get, _gpod._Itdb_Track_cd_nr_set)
    __swig_setmethods__["cds"] = _gpod._Itdb_Track_cds_set
    __swig_getmethods__["cds"] = _gpod._Itdb_Track_cds_get
    if _newclass:
        cds = _swig_property(_gpod._Itdb_Track_cds_get, _gpod._Itdb_Track_cds_set)
    __swig_setmethods__["track_nr"] = _gpod._Itdb_Track_track_nr_set
    __swig_getmethods__["track_nr"] = _gpod._Itdb_Track_track_nr_get
    if _newclass:
        track_nr = _swig_property(_gpod._Itdb_Track_track_nr_get, _gpod._Itdb_Track_track_nr_set)
    __swig_setmethods__["tracks"] = _gpod._Itdb_Track_tracks_set
    __swig_getmethods__["tracks"] = _gpod._Itdb_Track_tracks_get
    if _newclass:
        tracks = _swig_property(_gpod._Itdb_Track_tracks_get, _gpod._Itdb_Track_tracks_set)
    __swig_setmethods__["bitrate"] = _gpod._Itdb_Track_bitrate_set
    __swig_getmethods__["bitrate"] = _gpod._Itdb_Track_bitrate_get
    if _newclass:
        bitrate = _swig_property(_gpod._Itdb_Track_bitrate_get, _gpod._Itdb_Track_bitrate_set)
    __swig_setmethods__["samplerate"] = _gpod._Itdb_Track_samplerate_set
    __swig_getmethods__["samplerate"] = _gpod._Itdb_Track_samplerate_get
    if _newclass:
        samplerate = _swig_property(_gpod._Itdb_Track_samplerate_get, _gpod._Itdb_Track_samplerate_set)
    __swig_setmethods__["samplerate_low"] = _gpod._Itdb_Track_samplerate_low_set
    __swig_getmethods__["samplerate_low"] = _gpod._Itdb_Track_samplerate_low_get
    if _newclass:
        samplerate_low = _swig_property(_gpod._Itdb_Track_samplerate_low_get, _gpod._Itdb_Track_samplerate_low_set)
    __swig_setmethods__["year"] = _gpod._Itdb_Track_year_set
    __swig_getmethods__["year"] = _gpod._Itdb_Track_year_get
    if _newclass:
        year = _swig_property(_gpod._Itdb_Track_year_get, _gpod._Itdb_Track_year_set)
    __swig_setmethods__["volume"] = _gpod._Itdb_Track_volume_set
    __swig_getmethods__["volume"] = _gpod._Itdb_Track_volume_get
    if _newclass:
        volume = _swig_property(_gpod._Itdb_Track_volume_get, _gpod._Itdb_Track_volume_set)
    __swig_setmethods__["soundcheck"] = _gpod._Itdb_Track_soundcheck_set
    __swig_getmethods__["soundcheck"] = _gpod._Itdb_Track_soundcheck_get
    if _newclass:
        soundcheck = _swig_property(_gpod._Itdb_Track_soundcheck_get, _gpod._Itdb_Track_soundcheck_set)
    __swig_setmethods__["time_added"] = _gpod._Itdb_Track_time_added_set
    __swig_getmethods__["time_added"] = _gpod._Itdb_Track_time_added_get
    if _newclass:
        time_added = _swig_property(_gpod._Itdb_Track_time_added_get, _gpod._Itdb_Track_time_added_set)
    __swig_setmethods__["time_modified"] = _gpod._Itdb_Track_time_modified_set
    __swig_getmethods__["time_modified"] = _gpod._Itdb_Track_time_modified_get
    if _newclass:
        time_modified = _swig_property(_gpod._Itdb_Track_time_modified_get, _gpod._Itdb_Track_time_modified_set)
    __swig_setmethods__["time_played"] = _gpod._Itdb_Track_time_played_set
    __swig_getmethods__["time_played"] = _gpod._Itdb_Track_time_played_get
    if _newclass:
        time_played = _swig_property(_gpod._Itdb_Track_time_played_get, _gpod._Itdb_Track_time_played_set)
    __swig_setmethods__["bookmark_time"] = _gpod._Itdb_Track_bookmark_time_set
    __swig_getmethods__["bookmark_time"] = _gpod._Itdb_Track_bookmark_time_get
    if _newclass:
        bookmark_time = _swig_property(_gpod._Itdb_Track_bookmark_time_get, _gpod._Itdb_Track_bookmark_time_set)
    __swig_setmethods__["rating"] = _gpod._Itdb_Track_rating_set
    __swig_getmethods__["rating"] = _gpod._Itdb_Track_rating_get
    if _newclass:
        rating = _swig_property(_gpod._Itdb_Track_rating_get, _gpod._Itdb_Track_rating_set)
    __swig_setmethods__["playcount"] = _gpod._Itdb_Track_playcount_set
    __swig_getmethods__["playcount"] = _gpod._Itdb_Track_playcount_get
    if _newclass:
        playcount = _swig_property(_gpod._Itdb_Track_playcount_get, _gpod._Itdb_Track_playcount_set)
    __swig_setmethods__["playcount2"] = _gpod._Itdb_Track_playcount2_set
    __swig_getmethods__["playcount2"] = _gpod._Itdb_Track_playcount2_get
    if _newclass:
        playcount2 = _swig_property(_gpod._Itdb_Track_playcount2_get, _gpod._Itdb_Track_playcount2_set)
    __swig_setmethods__["recent_playcount"] = _gpod._Itdb_Track_recent_playcount_set
    __swig_getmethods__["recent_playcount"] = _gpod._Itdb_Track_recent_playcount_get
    if _newclass:
        recent_playcount = _swig_property(_gpod._Itdb_Track_recent_playcount_get, _gpod._Itdb_Track_recent_playcount_set)
    __swig_setmethods__["transferred"] = _gpod._Itdb_Track_transferred_set
    __swig_getmethods__["transferred"] = _gpod._Itdb_Track_transferred_get
    if _newclass:
        transferred = _swig_property(_gpod._Itdb_Track_transferred_get, _gpod._Itdb_Track_transferred_set)
    __swig_setmethods__["BPM"] = _gpod._Itdb_Track_BPM_set
    __swig_getmethods__["BPM"] = _gpod._Itdb_Track_BPM_get
    if _newclass:
        BPM = _swig_property(_gpod._Itdb_Track_BPM_get, _gpod._Itdb_Track_BPM_set)
    __swig_setmethods__["app_rating"] = _gpod._Itdb_Track_app_rating_set
    __swig_getmethods__["app_rating"] = _gpod._Itdb_Track_app_rating_get
    if _newclass:
        app_rating = _swig_property(_gpod._Itdb_Track_app_rating_get, _gpod._Itdb_Track_app_rating_set)
    __swig_setmethods__["type1"] = _gpod._Itdb_Track_type1_set
    __swig_getmethods__["type1"] = _gpod._Itdb_Track_type1_get
    if _newclass:
        type1 = _swig_property(_gpod._Itdb_Track_type1_get, _gpod._Itdb_Track_type1_set)
    __swig_setmethods__["type2"] = _gpod._Itdb_Track_type2_set
    __swig_getmethods__["type2"] = _gpod._Itdb_Track_type2_get
    if _newclass:
        type2 = _swig_property(_gpod._Itdb_Track_type2_get, _gpod._Itdb_Track_type2_set)
    __swig_setmethods__["compilation"] = _gpod._Itdb_Track_compilation_set
    __swig_getmethods__["compilation"] = _gpod._Itdb_Track_compilation_get
    if _newclass:
        compilation = _swig_property(_gpod._Itdb_Track_compilation_get, _gpod._Itdb_Track_compilation_set)
    __swig_setmethods__["starttime"] = _gpod._Itdb_Track_starttime_set
    __swig_getmethods__["starttime"] = _gpod._Itdb_Track_starttime_get
    if _newclass:
        starttime = _swig_property(_gpod._Itdb_Track_starttime_get, _gpod._Itdb_Track_starttime_set)
    __swig_setmethods__["stoptime"] = _gpod._Itdb_Track_stoptime_set
    __swig_getmethods__["stoptime"] = _gpod._Itdb_Track_stoptime_get
    if _newclass:
        stoptime = _swig_property(_gpod._Itdb_Track_stoptime_get, _gpod._Itdb_Track_stoptime_set)
    __swig_setmethods__["checked"] = _gpod._Itdb_Track_checked_set
    __swig_getmethods__["checked"] = _gpod._Itdb_Track_checked_get
    if _newclass:
        checked = _swig_property(_gpod._Itdb_Track_checked_get, _gpod._Itdb_Track_checked_set)
    __swig_setmethods__["dbid"] = _gpod._Itdb_Track_dbid_set
    __swig_getmethods__["dbid"] = _gpod._Itdb_Track_dbid_get
    if _newclass:
        dbid = _swig_property(_gpod._Itdb_Track_dbid_get, _gpod._Itdb_Track_dbid_set)
    __swig_setmethods__["drm_userid"] = _gpod._Itdb_Track_drm_userid_set
    __swig_getmethods__["drm_userid"] = _gpod._Itdb_Track_drm_userid_get
    if _newclass:
        drm_userid = _swig_property(_gpod._Itdb_Track_drm_userid_get, _gpod._Itdb_Track_drm_userid_set)
    __swig_setmethods__["visible"] = _gpod._Itdb_Track_visible_set
    __swig_getmethods__["visible"] = _gpod._Itdb_Track_visible_get
    if _newclass:
        visible = _swig_property(_gpod._Itdb_Track_visible_get, _gpod._Itdb_Track_visible_set)
    __swig_setmethods__["filetype_marker"] = _gpod._Itdb_Track_filetype_marker_set
    __swig_getmethods__["filetype_marker"] = _gpod._Itdb_Track_filetype_marker_get
    if _newclass:
        filetype_marker = _swig_property(_gpod._Itdb_Track_filetype_marker_get, _gpod._Itdb_Track_filetype_marker_set)
    __swig_setmethods__["artwork_count"] = _gpod._Itdb_Track_artwork_count_set
    __swig_getmethods__["artwork_count"] = _gpod._Itdb_Track_artwork_count_get
    if _newclass:
        artwork_count = _swig_property(_gpod._Itdb_Track_artwork_count_get, _gpod._Itdb_Track_artwork_count_set)
    __swig_setmethods__["artwork_size"] = _gpod._Itdb_Track_artwork_size_set
    __swig_getmethods__["artwork_size"] = _gpod._Itdb_Track_artwork_size_get
    if _newclass:
        artwork_size = _swig_property(_gpod._Itdb_Track_artwork_size_get, _gpod._Itdb_Track_artwork_size_set)
    __swig_setmethods__["samplerate2"] = _gpod._Itdb_Track_samplerate2_set
    __swig_getmethods__["samplerate2"] = _gpod._Itdb_Track_samplerate2_get
    if _newclass:
        samplerate2 = _swig_property(_gpod._Itdb_Track_samplerate2_get, _gpod._Itdb_Track_samplerate2_set)
    __swig_setmethods__["unk126"] = _gpod._Itdb_Track_unk126_set
    __swig_getmethods__["unk126"] = _gpod._Itdb_Track_unk126_get
    if _newclass:
        unk126 = _swig_property(_gpod._Itdb_Track_unk126_get, _gpod._Itdb_Track_unk126_set)
    __swig_setmethods__["unk132"] = _gpod._Itdb_Track_unk132_set
    __swig_getmethods__["unk132"] = _gpod._Itdb_Track_unk132_get
    if _newclass:
        unk132 = _swig_property(_gpod._Itdb_Track_unk132_get, _gpod._Itdb_Track_unk132_set)
    __swig_setmethods__["time_released"] = _gpod._Itdb_Track_time_released_set
    __swig_getmethods__["time_released"] = _gpod._Itdb_Track_time_released_get
    if _newclass:
        time_released = _swig_property(_gpod._Itdb_Track_time_released_get, _gpod._Itdb_Track_time_released_set)
    __swig_setmethods__["unk144"] = _gpod._Itdb_Track_unk144_set
    __swig_getmethods__["unk144"] = _gpod._Itdb_Track_unk144_get
    if _newclass:
        unk144 = _swig_property(_gpod._Itdb_Track_unk144_get, _gpod._Itdb_Track_unk144_set)
    __swig_setmethods__["explicit_flag"] = _gpod._Itdb_Track_explicit_flag_set
    __swig_getmethods__["explicit_flag"] = _gpod._Itdb_Track_explicit_flag_get
    if _newclass:
        explicit_flag = _swig_property(_gpod._Itdb_Track_explicit_flag_get, _gpod._Itdb_Track_explicit_flag_set)
    __swig_setmethods__["unk148"] = _gpod._Itdb_Track_unk148_set
    __swig_getmethods__["unk148"] = _gpod._Itdb_Track_unk148_get
    if _newclass:
        unk148 = _swig_property(_gpod._Itdb_Track_unk148_get, _gpod._Itdb_Track_unk148_set)
    __swig_setmethods__["unk152"] = _gpod._Itdb_Track_unk152_set
    __swig_getmethods__["unk152"] = _gpod._Itdb_Track_unk152_get
    if _newclass:
        unk152 = _swig_property(_gpod._Itdb_Track_unk152_get, _gpod._Itdb_Track_unk152_set)
    __swig_setmethods__["skipcount"] = _gpod._Itdb_Track_skipcount_set
    __swig_getmethods__["skipcount"] = _gpod._Itdb_Track_skipcount_get
    if _newclass:
        skipcount = _swig_property(_gpod._Itdb_Track_skipcount_get, _gpod._Itdb_Track_skipcount_set)
    __swig_setmethods__["recent_skipcount"] = _gpod._Itdb_Track_recent_skipcount_set
    __swig_getmethods__["recent_skipcount"] = _gpod._Itdb_Track_recent_skipcount_get
    if _newclass:
        recent_skipcount = _swig_property(_gpod._Itdb_Track_recent_skipcount_get, _gpod._Itdb_Track_recent_skipcount_set)
    __swig_setmethods__["last_skipped"] = _gpod._Itdb_Track_last_skipped_set
    __swig_getmethods__["last_skipped"] = _gpod._Itdb_Track_last_skipped_get
    if _newclass:
        last_skipped = _swig_property(_gpod._Itdb_Track_last_skipped_get, _gpod._Itdb_Track_last_skipped_set)
    __swig_setmethods__["has_artwork"] = _gpod._Itdb_Track_has_artwork_set
    __swig_getmethods__["has_artwork"] = _gpod._Itdb_Track_has_artwork_get
    if _newclass:
        has_artwork = _swig_property(_gpod._Itdb_Track_has_artwork_get, _gpod._Itdb_Track_has_artwork_set)
    __swig_setmethods__["skip_when_shuffling"] = _gpod._Itdb_Track_skip_when_shuffling_set
    __swig_getmethods__["skip_when_shuffling"] = _gpod._Itdb_Track_skip_when_shuffling_get
    if _newclass:
        skip_when_shuffling = _swig_property(_gpod._Itdb_Track_skip_when_shuffling_get, _gpod._Itdb_Track_skip_when_shuffling_set)
    __swig_setmethods__["remember_playback_position"] = _gpod._Itdb_Track_remember_playback_position_set
    __swig_getmethods__["remember_playback_position"] = _gpod._Itdb_Track_remember_playback_position_get
    if _newclass:
        remember_playback_position = _swig_property(_gpod._Itdb_Track_remember_playback_position_get, _gpod._Itdb_Track_remember_playback_position_set)
    __swig_setmethods__["flag4"] = _gpod._Itdb_Track_flag4_set
    __swig_getmethods__["flag4"] = _gpod._Itdb_Track_flag4_get
    if _newclass:
        flag4 = _swig_property(_gpod._Itdb_Track_flag4_get, _gpod._Itdb_Track_flag4_set)
    __swig_setmethods__["dbid2"] = _gpod._Itdb_Track_dbid2_set
    __swig_getmethods__["dbid2"] = _gpod._Itdb_Track_dbid2_get
    if _newclass:
        dbid2 = _swig_property(_gpod._Itdb_Track_dbid2_get, _gpod._Itdb_Track_dbid2_set)
    __swig_setmethods__["lyrics_flag"] = _gpod._Itdb_Track_lyrics_flag_set
    __swig_getmethods__["lyrics_flag"] = _gpod._Itdb_Track_lyrics_flag_get
    if _newclass:
        lyrics_flag = _swig_property(_gpod._Itdb_Track_lyrics_flag_get, _gpod._Itdb_Track_lyrics_flag_set)
    __swig_setmethods__["movie_flag"] = _gpod._Itdb_Track_movie_flag_set
    __swig_getmethods__["movie_flag"] = _gpod._Itdb_Track_movie_flag_get
    if _newclass:
        movie_flag = _swig_property(_gpod._Itdb_Track_movie_flag_get, _gpod._Itdb_Track_movie_flag_set)
    __swig_setmethods__["mark_unplayed"] = _gpod._Itdb_Track_mark_unplayed_set
    __swig_getmethods__["mark_unplayed"] = _gpod._Itdb_Track_mark_unplayed_get
    if _newclass:
        mark_unplayed = _swig_property(_gpod._Itdb_Track_mark_unplayed_get, _gpod._Itdb_Track_mark_unplayed_set)
    __swig_setmethods__["unk179"] = _gpod._Itdb_Track_unk179_set
    __swig_getmethods__["unk179"] = _gpod._Itdb_Track_unk179_get
    if _newclass:
        unk179 = _swig_property(_gpod._Itdb_Track_unk179_get, _gpod._Itdb_Track_unk179_set)
    __swig_setmethods__["unk180"] = _gpod._Itdb_Track_unk180_set
    __swig_getmethods__["unk180"] = _gpod._Itdb_Track_unk180_get
    if _newclass:
        unk180 = _swig_property(_gpod._Itdb_Track_unk180_get, _gpod._Itdb_Track_unk180_set)
    __swig_setmethods__["pregap"] = _gpod._Itdb_Track_pregap_set
    __swig_getmethods__["pregap"] = _gpod._Itdb_Track_pregap_get
    if _newclass:
        pregap = _swig_property(_gpod._Itdb_Track_pregap_get, _gpod._Itdb_Track_pregap_set)
    __swig_setmethods__["samplecount"] = _gpod._Itdb_Track_samplecount_set
    __swig_getmethods__["samplecount"] = _gpod._Itdb_Track_samplecount_get
    if _newclass:
        samplecount = _swig_property(_gpod._Itdb_Track_samplecount_get, _gpod._Itdb_Track_samplecount_set)
    __swig_setmethods__["unk196"] = _gpod._Itdb_Track_unk196_set
    __swig_getmethods__["unk196"] = _gpod._Itdb_Track_unk196_get
    if _newclass:
        unk196 = _swig_property(_gpod._Itdb_Track_unk196_get, _gpod._Itdb_Track_unk196_set)
    __swig_setmethods__["postgap"] = _gpod._Itdb_Track_postgap_set
    __swig_getmethods__["postgap"] = _gpod._Itdb_Track_postgap_get
    if _newclass:
        postgap = _swig_property(_gpod._Itdb_Track_postgap_get, _gpod._Itdb_Track_postgap_set)
    __swig_setmethods__["unk204"] = _gpod._Itdb_Track_unk204_set
    __swig_getmethods__["unk204"] = _gpod._Itdb_Track_unk204_get
    if _newclass:
        unk204 = _swig_property(_gpod._Itdb_Track_unk204_get, _gpod._Itdb_Track_unk204_set)
    __swig_setmethods__["mediatype"] = _gpod._Itdb_Track_mediatype_set
    __swig_getmethods__["mediatype"] = _gpod._Itdb_Track_mediatype_get
    if _newclass:
        mediatype = _swig_property(_gpod._Itdb_Track_mediatype_get, _gpod._Itdb_Track_mediatype_set)
    __swig_setmethods__["season_nr"] = _gpod._Itdb_Track_season_nr_set
    __swig_getmethods__["season_nr"] = _gpod._Itdb_Track_season_nr_get
    if _newclass:
        season_nr = _swig_property(_gpod._Itdb_Track_season_nr_get, _gpod._Itdb_Track_season_nr_set)
    __swig_setmethods__["episode_nr"] = _gpod._Itdb_Track_episode_nr_set
    __swig_getmethods__["episode_nr"] = _gpod._Itdb_Track_episode_nr_get
    if _newclass:
        episode_nr = _swig_property(_gpod._Itdb_Track_episode_nr_get, _gpod._Itdb_Track_episode_nr_set)
    __swig_setmethods__["unk220"] = _gpod._Itdb_Track_unk220_set
    __swig_getmethods__["unk220"] = _gpod._Itdb_Track_unk220_get
    if _newclass:
        unk220 = _swig_property(_gpod._Itdb_Track_unk220_get, _gpod._Itdb_Track_unk220_set)
    __swig_setmethods__["unk224"] = _gpod._Itdb_Track_unk224_set
    __swig_getmethods__["unk224"] = _gpod._Itdb_Track_unk224_get
    if _newclass:
        unk224 = _swig_property(_gpod._Itdb_Track_unk224_get, _gpod._Itdb_Track_unk224_set)
    __swig_setmethods__["unk228"] = _gpod._Itdb_Track_unk228_set
    __swig_getmethods__["unk228"] = _gpod._Itdb_Track_unk228_get
    if _newclass:
        unk228 = _swig_property(_gpod._Itdb_Track_unk228_get, _gpod._Itdb_Track_unk228_set)
    __swig_setmethods__["unk232"] = _gpod._Itdb_Track_unk232_set
    __swig_getmethods__["unk232"] = _gpod._Itdb_Track_unk232_get
    if _newclass:
        unk232 = _swig_property(_gpod._Itdb_Track_unk232_get, _gpod._Itdb_Track_unk232_set)
    __swig_setmethods__["unk236"] = _gpod._Itdb_Track_unk236_set
    __swig_getmethods__["unk236"] = _gpod._Itdb_Track_unk236_get
    if _newclass:
        unk236 = _swig_property(_gpod._Itdb_Track_unk236_get, _gpod._Itdb_Track_unk236_set)
    __swig_setmethods__["unk240"] = _gpod._Itdb_Track_unk240_set
    __swig_getmethods__["unk240"] = _gpod._Itdb_Track_unk240_get
    if _newclass:
        unk240 = _swig_property(_gpod._Itdb_Track_unk240_get, _gpod._Itdb_Track_unk240_set)
    __swig_setmethods__["unk244"] = _gpod._Itdb_Track_unk244_set
    __swig_getmethods__["unk244"] = _gpod._Itdb_Track_unk244_get
    if _newclass:
        unk244 = _swig_property(_gpod._Itdb_Track_unk244_get, _gpod._Itdb_Track_unk244_set)
    __swig_setmethods__["gapless_data"] = _gpod._Itdb_Track_gapless_data_set
    __swig_getmethods__["gapless_data"] = _gpod._Itdb_Track_gapless_data_get
    if _newclass:
        gapless_data = _swig_property(_gpod._Itdb_Track_gapless_data_get, _gpod._Itdb_Track_gapless_data_set)
    __swig_setmethods__["unk252"] = _gpod._Itdb_Track_unk252_set
    __swig_getmethods__["unk252"] = _gpod._Itdb_Track_unk252_get
    if _newclass:
        unk252 = _swig_property(_gpod._Itdb_Track_unk252_get, _gpod._Itdb_Track_unk252_set)
    __swig_setmethods__["gapless_track_flag"] = _gpod._Itdb_Track_gapless_track_flag_set
    __swig_getmethods__["gapless_track_flag"] = _gpod._Itdb_Track_gapless_track_flag_get
    if _newclass:
        gapless_track_flag = _swig_property(_gpod._Itdb_Track_gapless_track_flag_get, _gpod._Itdb_Track_gapless_track_flag_set)
    __swig_setmethods__["gapless_album_flag"] = _gpod._Itdb_Track_gapless_album_flag_set
    __swig_getmethods__["gapless_album_flag"] = _gpod._Itdb_Track_gapless_album_flag_get
    if _newclass:
        gapless_album_flag = _swig_property(_gpod._Itdb_Track_gapless_album_flag_get, _gpod._Itdb_Track_gapless_album_flag_set)
    __swig_setmethods__["obsolete"] = _gpod._Itdb_Track_obsolete_set
    __swig_getmethods__["obsolete"] = _gpod._Itdb_Track_obsolete_get
    if _newclass:
        obsolete = _swig_property(_gpod._Itdb_Track_obsolete_get, _gpod._Itdb_Track_obsolete_set)
    __swig_setmethods__["artwork"] = _gpod._Itdb_Track_artwork_set
    __swig_getmethods__["artwork"] = _gpod._Itdb_Track_artwork_get
    if _newclass:
        artwork = _swig_property(_gpod._Itdb_Track_artwork_get, _gpod._Itdb_Track_artwork_set)
    __swig_setmethods__["mhii_link"] = _gpod._Itdb_Track_mhii_link_set
    __swig_getmethods__["mhii_link"] = _gpod._Itdb_Track_mhii_link_get
    if _newclass:
        mhii_link = _swig_property(_gpod._Itdb_Track_mhii_link_get, _gpod._Itdb_Track_mhii_link_set)
    __swig_setmethods__["reserved_int1"] = _gpod._Itdb_Track_reserved_int1_set
    __swig_getmethods__["reserved_int1"] = _gpod._Itdb_Track_reserved_int1_get
    if _newclass:
        reserved_int1 = _swig_property(_gpod._Itdb_Track_reserved_int1_get, _gpod._Itdb_Track_reserved_int1_set)
    __swig_setmethods__["reserved_int2"] = _gpod._Itdb_Track_reserved_int2_set
    __swig_getmethods__["reserved_int2"] = _gpod._Itdb_Track_reserved_int2_get
    if _newclass:
        reserved_int2 = _swig_property(_gpod._Itdb_Track_reserved_int2_get, _gpod._Itdb_Track_reserved_int2_set)
    __swig_setmethods__["reserved_int3"] = _gpod._Itdb_Track_reserved_int3_set
    __swig_getmethods__["reserved_int3"] = _gpod._Itdb_Track_reserved_int3_get
    if _newclass:
        reserved_int3 = _swig_property(_gpod._Itdb_Track_reserved_int3_get, _gpod._Itdb_Track_reserved_int3_set)
    __swig_setmethods__["reserved_int4"] = _gpod._Itdb_Track_reserved_int4_set
    __swig_getmethods__["reserved_int4"] = _gpod._Itdb_Track_reserved_int4_get
    if _newclass:
        reserved_int4 = _swig_property(_gpod._Itdb_Track_reserved_int4_get, _gpod._Itdb_Track_reserved_int4_set)
    __swig_setmethods__["reserved_int5"] = _gpod._Itdb_Track_reserved_int5_set
    __swig_getmethods__["reserved_int5"] = _gpod._Itdb_Track_reserved_int5_get
    if _newclass:
        reserved_int5 = _swig_property(_gpod._Itdb_Track_reserved_int5_get, _gpod._Itdb_Track_reserved_int5_set)
    __swig_setmethods__["reserved_int6"] = _gpod._Itdb_Track_reserved_int6_set
    __swig_getmethods__["reserved_int6"] = _gpod._Itdb_Track_reserved_int6_get
    if _newclass:
        reserved_int6 = _swig_property(_gpod._Itdb_Track_reserved_int6_get, _gpod._Itdb_Track_reserved_int6_set)
    __swig_setmethods__["priv"] = _gpod._Itdb_Track_priv_set
    __swig_getmethods__["priv"] = _gpod._Itdb_Track_priv_get
    if _newclass:
        priv = _swig_property(_gpod._Itdb_Track_priv_get, _gpod._Itdb_Track_priv_set)
    __swig_setmethods__["reserved2"] = _gpod._Itdb_Track_reserved2_set
    __swig_getmethods__["reserved2"] = _gpod._Itdb_Track_reserved2_get
    if _newclass:
        reserved2 = _swig_property(_gpod._Itdb_Track_reserved2_get, _gpod._Itdb_Track_reserved2_set)
    __swig_setmethods__["reserved3"] = _gpod._Itdb_Track_reserved3_set
    __swig_getmethods__["reserved3"] = _gpod._Itdb_Track_reserved3_get
    if _newclass:
        reserved3 = _swig_property(_gpod._Itdb_Track_reserved3_get, _gpod._Itdb_Track_reserved3_set)
    __swig_setmethods__["reserved4"] = _gpod._Itdb_Track_reserved4_set
    __swig_getmethods__["reserved4"] = _gpod._Itdb_Track_reserved4_get
    if _newclass:
        reserved4 = _swig_property(_gpod._Itdb_Track_reserved4_get, _gpod._Itdb_Track_reserved4_set)
    __swig_setmethods__["reserved5"] = _gpod._Itdb_Track_reserved5_set
    __swig_getmethods__["reserved5"] = _gpod._Itdb_Track_reserved5_get
    if _newclass:
        reserved5 = _swig_property(_gpod._Itdb_Track_reserved5_get, _gpod._Itdb_Track_reserved5_set)
    __swig_setmethods__["reserved6"] = _gpod._Itdb_Track_reserved6_set
    __swig_getmethods__["reserved6"] = _gpod._Itdb_Track_reserved6_get
    if _newclass:
        reserved6 = _swig_property(_gpod._Itdb_Track_reserved6_get, _gpod._Itdb_Track_reserved6_set)
    __swig_setmethods__["usertype"] = _gpod._Itdb_Track_usertype_set
    __swig_getmethods__["usertype"] = _gpod._Itdb_Track_usertype_get
    if _newclass:
        usertype = _swig_property(_gpod._Itdb_Track_usertype_get, _gpod._Itdb_Track_usertype_set)
    __swig_setmethods__["userdata"] = _gpod._Itdb_Track_userdata_set
    __swig_getmethods__["userdata"] = _gpod._Itdb_Track_userdata_get
    if _newclass:
        userdata = _swig_property(_gpod._Itdb_Track_userdata_get, _gpod._Itdb_Track_userdata_set)
    __swig_setmethods__["userdata_duplicate"] = _gpod._Itdb_Track_userdata_duplicate_set
    __swig_getmethods__["userdata_duplicate"] = _gpod._Itdb_Track_userdata_duplicate_get
    if _newclass:
        userdata_duplicate = _swig_property(_gpod._Itdb_Track_userdata_duplicate_get, _gpod._Itdb_Track_userdata_duplicate_set)
    __swig_setmethods__["userdata_destroy"] = _gpod._Itdb_Track_userdata_destroy_set
    __swig_getmethods__["userdata_destroy"] = _gpod._Itdb_Track_userdata_destroy_get
    if _newclass:
        userdata_destroy = _swig_property(_gpod._Itdb_Track_userdata_destroy_get, _gpod._Itdb_Track_userdata_destroy_set)

    def __init__(self):
        """__init__(_Itdb_Track self) -> _Itdb_Track"""
        this = _gpod.new__Itdb_Track()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _gpod.delete__Itdb_Track
    __del__ = lambda self: None
_Itdb_Track_swigregister = _gpod._Itdb_Track_swigregister
_Itdb_Track_swigregister(_Itdb_Track)

ITDB_FILE_ERROR_SEEK = _gpod.ITDB_FILE_ERROR_SEEK
ITDB_FILE_ERROR_CORRUPT = _gpod.ITDB_FILE_ERROR_CORRUPT
ITDB_FILE_ERROR_NOTFOUND = _gpod.ITDB_FILE_ERROR_NOTFOUND
ITDB_FILE_ERROR_RENAME = _gpod.ITDB_FILE_ERROR_RENAME
ITDB_FILE_ERROR_ITDB_CORRUPT = _gpod.ITDB_FILE_ERROR_ITDB_CORRUPT
ITDB_ERROR_SEEK = _gpod.ITDB_ERROR_SEEK
ITDB_ERROR_CORRUPT = _gpod.ITDB_ERROR_CORRUPT
ITDB_ERROR_NOTFOUND = _gpod.ITDB_ERROR_NOTFOUND
ITDB_ERROR_RENAME = _gpod.ITDB_ERROR_RENAME
ITDB_ERROR_ITDB_CORRUPT = _gpod.ITDB_ERROR_ITDB_CORRUPT
ITDB_ERROR_SQLITE = _gpod.ITDB_ERROR_SQLITE

def itdb_file_error_quark():
    """itdb_file_error_quark() -> GQuark"""
    return _gpod.itdb_file_error_quark()

def itdb_parse(mp, error):
    """itdb_parse(gchar const * mp, GError ** error) -> _Itdb_iTunesDB"""
    return _gpod.itdb_parse(mp, error)

def itdb_parse_file(filename, error):
    """itdb_parse_file(gchar const * filename, GError ** error) -> _Itdb_iTunesDB"""
    return _gpod.itdb_parse_file(filename, error)

def itdb_write(itdb, error):
    """itdb_write(_Itdb_iTunesDB itdb, GError ** error) -> gboolean"""
    return _gpod.itdb_write(itdb, error)

def itdb_write_file(itdb, filename, error):
    """itdb_write_file(_Itdb_iTunesDB itdb, gchar const * filename, GError ** error) -> gboolean"""
    return _gpod.itdb_write_file(itdb, filename, error)

def itdb_shuffle_write(itdb, error):
    """itdb_shuffle_write(_Itdb_iTunesDB itdb, GError ** error) -> gboolean"""
    return _gpod.itdb_shuffle_write(itdb, error)

def itdb_shuffle_write_file(itdb, filename, error):
    """itdb_shuffle_write_file(_Itdb_iTunesDB itdb, gchar const * filename, GError ** error) -> gboolean"""
    return _gpod.itdb_shuffle_write_file(itdb, filename, error)

def itdb_start_sync(itdb):
    """itdb_start_sync(_Itdb_iTunesDB itdb) -> gboolean"""
    return _gpod.itdb_start_sync(itdb)

def itdb_stop_sync(itdb):
    """itdb_stop_sync(_Itdb_iTunesDB itdb) -> gboolean"""
    return _gpod.itdb_stop_sync(itdb)

def itdb_new():
    """itdb_new() -> _Itdb_iTunesDB"""
    return _gpod.itdb_new()

def itdb_free(itdb):
    """itdb_free(_Itdb_iTunesDB itdb)"""
    return _gpod.itdb_free(itdb)

def itdb_duplicate(itdb):
    """itdb_duplicate(_Itdb_iTunesDB itdb) -> _Itdb_iTunesDB"""
    return _gpod.itdb_duplicate(itdb)

def itdb_tracks_number(itdb):
    """itdb_tracks_number(_Itdb_iTunesDB itdb) -> guint32"""
    return _gpod.itdb_tracks_number(itdb)

def itdb_tracks_number_nontransferred(itdb):
    """itdb_tracks_number_nontransferred(_Itdb_iTunesDB itdb) -> guint32"""
    return _gpod.itdb_tracks_number_nontransferred(itdb)

def itdb_playlists_number(itdb):
    """itdb_playlists_number(_Itdb_iTunesDB itdb) -> guint32"""
    return _gpod.itdb_playlists_number(itdb)

def itdb_musicdirs_number(itdb):
    """itdb_musicdirs_number(_Itdb_iTunesDB itdb) -> gint"""
    return _gpod.itdb_musicdirs_number(itdb)

def itdb_resolve_path(root, components):
    """itdb_resolve_path(gchar const * root, gchar const *const * components) -> gchar *"""
    return _gpod.itdb_resolve_path(root, components)

def itdb_rename_files(mp, error):
    """itdb_rename_files(gchar const * mp, GError ** error) -> gboolean"""
    return _gpod.itdb_rename_files(mp, error)

def itdb_cp_get_dest_filename(track, mountpoint, filename, error):
    """itdb_cp_get_dest_filename(_Itdb_Track track, gchar const * mountpoint, gchar const * filename, GError ** error) -> gchar *"""
    return _gpod.itdb_cp_get_dest_filename(track, mountpoint, filename, error)

def itdb_cp(from_file, to_file, error):
    """itdb_cp(gchar const * from_file, gchar const * to_file, GError ** error) -> gboolean"""
    return _gpod.itdb_cp(from_file, to_file, error)

def itdb_cp_finalize(track, mountpoint, dest_filename, error):
    """itdb_cp_finalize(_Itdb_Track track, gchar const * mountpoint, gchar const * dest_filename, GError ** error) -> _Itdb_Track"""
    return _gpod.itdb_cp_finalize(track, mountpoint, dest_filename, error)

def itdb_cp_track_to_ipod(track, filename, error):
    """itdb_cp_track_to_ipod(_Itdb_Track track, gchar const * filename, GError ** error) -> gboolean"""
    return _gpod.itdb_cp_track_to_ipod(track, filename, error)

def itdb_filename_fs2ipod(filename):
    """itdb_filename_fs2ipod(gchar * filename)"""
    return _gpod.itdb_filename_fs2ipod(filename)

def itdb_filename_ipod2fs(ipod_file):
    """itdb_filename_ipod2fs(gchar * ipod_file)"""
    return _gpod.itdb_filename_ipod2fs(ipod_file)

def itdb_filename_on_ipod(track):
    """itdb_filename_on_ipod(_Itdb_Track track) -> gchar *"""
    return _gpod.itdb_filename_on_ipod(track)

def itdb_set_mountpoint(itdb, mp):
    """itdb_set_mountpoint(_Itdb_iTunesDB itdb, gchar const * mp)"""
    return _gpod.itdb_set_mountpoint(itdb, mp)

def itdb_get_mountpoint(itdb):
    """itdb_get_mountpoint(_Itdb_iTunesDB itdb) -> gchar const *"""
    return _gpod.itdb_get_mountpoint(itdb)

def itdb_get_control_dir(mountpoint):
    """itdb_get_control_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_control_dir(mountpoint)

def itdb_get_itunes_dir(mountpoint):
    """itdb_get_itunes_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_itunes_dir(mountpoint)

def itdb_get_music_dir(mountpoint):
    """itdb_get_music_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_music_dir(mountpoint)

def itdb_get_artwork_dir(mountpoint):
    """itdb_get_artwork_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_artwork_dir(mountpoint)

def itdb_get_photos_dir(mountpoint):
    """itdb_get_photos_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_photos_dir(mountpoint)

def itdb_get_photos_thumb_dir(mountpoint):
    """itdb_get_photos_thumb_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_photos_thumb_dir(mountpoint)

def itdb_get_device_dir(mountpoint):
    """itdb_get_device_dir(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_device_dir(mountpoint)

def itdb_get_itunesdb_path(mountpoint):
    """itdb_get_itunesdb_path(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_itunesdb_path(mountpoint)

def itdb_get_itunescdb_path(mountpoint):
    """itdb_get_itunescdb_path(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_itunescdb_path(mountpoint)

def itdb_get_itunessd_path(mountpoint):
    """itdb_get_itunessd_path(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_itunessd_path(mountpoint)

def itdb_get_artworkdb_path(mountpoint):
    """itdb_get_artworkdb_path(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_artworkdb_path(mountpoint)

def itdb_get_photodb_path(mountpoint):
    """itdb_get_photodb_path(gchar const * mountpoint) -> gchar *"""
    return _gpod.itdb_get_photodb_path(mountpoint)

def itdb_get_path(dir, file):
    """itdb_get_path(gchar const * dir, gchar const * file) -> gchar *"""
    return _gpod.itdb_get_path(dir, file)

def itdb_device_new():
    """itdb_device_new() -> Itdb_Device *"""
    return _gpod.itdb_device_new()

def itdb_device_free(device):
    """itdb_device_free(Itdb_Device * device)"""
    return _gpod.itdb_device_free(device)

def itdb_device_set_mountpoint(device, mp):
    """itdb_device_set_mountpoint(Itdb_Device * device, gchar const * mp)"""
    return _gpod.itdb_device_set_mountpoint(device, mp)

def itdb_device_read_sysinfo(device):
    """itdb_device_read_sysinfo(Itdb_Device * device) -> gboolean"""
    return _gpod.itdb_device_read_sysinfo(device)

def itdb_device_write_sysinfo(device, error):
    """itdb_device_write_sysinfo(Itdb_Device * device, GError ** error) -> gboolean"""
    return _gpod.itdb_device_write_sysinfo(device, error)

def itdb_device_get_sysinfo(device, field):
    """itdb_device_get_sysinfo(Itdb_Device const * device, gchar const * field) -> gchar *"""
    return _gpod.itdb_device_get_sysinfo(device, field)

def itdb_device_set_sysinfo(device, field, value):
    """itdb_device_set_sysinfo(Itdb_Device * device, gchar const * field, gchar const * value)"""
    return _gpod.itdb_device_set_sysinfo(device, field, value)

def itdb_device_get_ipod_info(device):
    """itdb_device_get_ipod_info(Itdb_Device const * device) -> _Itdb_IpodInfo"""
    return _gpod.itdb_device_get_ipod_info(device)

def itdb_info_get_ipod_info_table():
    """itdb_info_get_ipod_info_table() -> _Itdb_IpodInfo"""
    return _gpod.itdb_info_get_ipod_info_table()

def itdb_device_supports_artwork(device):
    """itdb_device_supports_artwork(Itdb_Device const * device) -> gboolean"""
    return _gpod.itdb_device_supports_artwork(device)

def itdb_device_supports_chapter_image(device):
    """itdb_device_supports_chapter_image(Itdb_Device const * device) -> gboolean"""
    return _gpod.itdb_device_supports_chapter_image(device)

def itdb_device_supports_video(device):
    """itdb_device_supports_video(Itdb_Device const * device) -> gboolean"""
    return _gpod.itdb_device_supports_video(device)

def itdb_device_supports_photo(device):
    """itdb_device_supports_photo(Itdb_Device const * device) -> gboolean"""
    return _gpod.itdb_device_supports_photo(device)

def itdb_device_supports_podcast(device):
    """itdb_device_supports_podcast(Itdb_Device const * device) -> gboolean"""
    return _gpod.itdb_device_supports_podcast(device)

def itdb_info_get_ipod_model_name_string(model):
    """itdb_info_get_ipod_model_name_string(Itdb_IpodModel model) -> gchar const *"""
    return _gpod.itdb_info_get_ipod_model_name_string(model)

def itdb_info_get_ipod_generation_string(generation):
    """itdb_info_get_ipod_generation_string(Itdb_IpodGeneration generation) -> gchar const *"""
    return _gpod.itdb_info_get_ipod_generation_string(generation)

def itdb_device_get_uuid(device):
    """itdb_device_get_uuid(Itdb_Device const * device) -> gchar *"""
    return _gpod.itdb_device_get_uuid(device)

def itdb_track_new():
    """itdb_track_new() -> _Itdb_Track"""
    return _gpod.itdb_track_new()

def itdb_track_free(track):
    """itdb_track_free(_Itdb_Track track)"""
    return _gpod.itdb_track_free(track)

def itdb_track_add(itdb, track, pos):
    """itdb_track_add(_Itdb_iTunesDB itdb, _Itdb_Track track, gint32 pos)"""
    return _gpod.itdb_track_add(itdb, track, pos)

def itdb_track_remove(track):
    """itdb_track_remove(_Itdb_Track track)"""
    return _gpod.itdb_track_remove(track)

def itdb_track_unlink(track):
    """itdb_track_unlink(_Itdb_Track track)"""
    return _gpod.itdb_track_unlink(track)

def itdb_track_duplicate(tr):
    """itdb_track_duplicate(_Itdb_Track tr) -> _Itdb_Track"""
    return _gpod.itdb_track_duplicate(tr)

def itdb_track_by_id(itdb, id):
    """itdb_track_by_id(_Itdb_iTunesDB itdb, guint32 id) -> _Itdb_Track"""
    return _gpod.itdb_track_by_id(itdb, id)

def itdb_track_id_tree_create(itdb):
    """itdb_track_id_tree_create(_Itdb_iTunesDB itdb) -> GTree *"""
    return _gpod.itdb_track_id_tree_create(itdb)

def itdb_track_id_tree_destroy(idtree):
    """itdb_track_id_tree_destroy(GTree * idtree)"""
    return _gpod.itdb_track_id_tree_destroy(idtree)

def itdb_track_id_tree_by_id(idtree, id):
    """itdb_track_id_tree_by_id(GTree * idtree, guint32 id) -> _Itdb_Track"""
    return _gpod.itdb_track_id_tree_by_id(idtree, id)

def itdb_playlist_new(title, spl):
    """itdb_playlist_new(gchar const * title, gboolean spl) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_new(title, spl)

def itdb_playlist_free(pl):
    """itdb_playlist_free(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_free(pl)

def itdb_playlist_add(itdb, pl, pos):
    """itdb_playlist_add(_Itdb_iTunesDB itdb, _Itdb_Playlist pl, gint32 pos)"""
    return _gpod.itdb_playlist_add(itdb, pl, pos)

def itdb_playlist_move(pl, pos):
    """itdb_playlist_move(_Itdb_Playlist pl, gint32 pos)"""
    return _gpod.itdb_playlist_move(pl, pos)

def itdb_playlist_remove(pl):
    """itdb_playlist_remove(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_remove(pl)

def itdb_playlist_unlink(pl):
    """itdb_playlist_unlink(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_unlink(pl)

def itdb_playlist_duplicate(pl):
    """itdb_playlist_duplicate(_Itdb_Playlist pl) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_duplicate(pl)

def itdb_playlist_exists(itdb, pl):
    """itdb_playlist_exists(_Itdb_iTunesDB itdb, _Itdb_Playlist pl) -> gboolean"""
    return _gpod.itdb_playlist_exists(itdb, pl)

def itdb_playlist_add_track(pl, track, pos):
    """itdb_playlist_add_track(_Itdb_Playlist pl, _Itdb_Track track, gint32 pos)"""
    return _gpod.itdb_playlist_add_track(pl, track, pos)

def itdb_playlist_by_id(itdb, id):
    """itdb_playlist_by_id(_Itdb_iTunesDB itdb, guint64 id) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_by_id(itdb, id)

def itdb_playlist_by_nr(itdb, num):
    """itdb_playlist_by_nr(_Itdb_iTunesDB itdb, guint32 num) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_by_nr(itdb, num)

def itdb_playlist_by_name(itdb, name):
    """itdb_playlist_by_name(_Itdb_iTunesDB itdb, gchar * name) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_by_name(itdb, name)

def itdb_playlist_contains_track(pl, track):
    """itdb_playlist_contains_track(_Itdb_Playlist pl, _Itdb_Track track) -> gboolean"""
    return _gpod.itdb_playlist_contains_track(pl, track)

def itdb_playlist_contain_track_number(tr):
    """itdb_playlist_contain_track_number(_Itdb_Track tr) -> guint32"""
    return _gpod.itdb_playlist_contain_track_number(tr)

def itdb_playlist_remove_track(pl, track):
    """itdb_playlist_remove_track(_Itdb_Playlist pl, _Itdb_Track track)"""
    return _gpod.itdb_playlist_remove_track(pl, track)

def itdb_playlist_tracks_number(pl):
    """itdb_playlist_tracks_number(_Itdb_Playlist pl) -> guint32"""
    return _gpod.itdb_playlist_tracks_number(pl)

def itdb_playlist_randomize(pl):
    """itdb_playlist_randomize(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_randomize(pl)

def itdb_playlist_mpl(itdb):
    """itdb_playlist_mpl(_Itdb_iTunesDB itdb) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_mpl(itdb)

def itdb_playlist_is_mpl(pl):
    """itdb_playlist_is_mpl(_Itdb_Playlist pl) -> gboolean"""
    return _gpod.itdb_playlist_is_mpl(pl)

def itdb_playlist_set_mpl(pl):
    """itdb_playlist_set_mpl(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_set_mpl(pl)

def itdb_playlist_podcasts(itdb):
    """itdb_playlist_podcasts(_Itdb_iTunesDB itdb) -> _Itdb_Playlist"""
    return _gpod.itdb_playlist_podcasts(itdb)

def itdb_playlist_is_podcasts(pl):
    """itdb_playlist_is_podcasts(_Itdb_Playlist pl) -> gboolean"""
    return _gpod.itdb_playlist_is_podcasts(pl)

def itdb_playlist_set_podcasts(pl):
    """itdb_playlist_set_podcasts(_Itdb_Playlist pl)"""
    return _gpod.itdb_playlist_set_podcasts(pl)

def itdb_playlist_is_audiobooks(pl):
    """itdb_playlist_is_audiobooks(_Itdb_Playlist pl) -> gboolean"""
    return _gpod.itdb_playlist_is_audiobooks(pl)

def itdb_splr_get_field_type(splr):
    """itdb_splr_get_field_type(_Itdb_SPLRule splr) -> ItdbSPLFieldType"""
    return _gpod.itdb_splr_get_field_type(splr)

def itdb_splr_get_action_type(splr):
    """itdb_splr_get_action_type(_Itdb_SPLRule splr) -> ItdbSPLActionType"""
    return _gpod.itdb_splr_get_action_type(splr)

def itdb_splr_validate(splr):
    """itdb_splr_validate(_Itdb_SPLRule splr)"""
    return _gpod.itdb_splr_validate(splr)

def itdb_splr_remove(pl, splr):
    """itdb_splr_remove(_Itdb_Playlist pl, _Itdb_SPLRule splr)"""
    return _gpod.itdb_splr_remove(pl, splr)

def itdb_splr_new():
    """itdb_splr_new() -> _Itdb_SPLRule"""
    return _gpod.itdb_splr_new()

def itdb_splr_add(pl, splr, pos):
    """itdb_splr_add(_Itdb_Playlist pl, _Itdb_SPLRule splr, gint pos)"""
    return _gpod.itdb_splr_add(pl, splr, pos)

def itdb_splr_add_new(pl, pos):
    """itdb_splr_add_new(_Itdb_Playlist pl, gint pos) -> _Itdb_SPLRule"""
    return _gpod.itdb_splr_add_new(pl, pos)

def itdb_spl_copy_rules(dest, src):
    """itdb_spl_copy_rules(_Itdb_Playlist dest, _Itdb_Playlist src)"""
    return _gpod.itdb_spl_copy_rules(dest, src)

def itdb_splr_eval(splr, track):
    """itdb_splr_eval(_Itdb_SPLRule splr, _Itdb_Track track) -> gboolean"""
    return _gpod.itdb_splr_eval(splr, track)

def itdb_spl_update(spl):
    """itdb_spl_update(_Itdb_Playlist spl)"""
    return _gpod.itdb_spl_update(spl)

def itdb_spl_update_all(itdb):
    """itdb_spl_update_all(_Itdb_iTunesDB itdb)"""
    return _gpod.itdb_spl_update_all(itdb)

def itdb_spl_update_live(itdb):
    """itdb_spl_update_live(_Itdb_iTunesDB itdb)"""
    return _gpod.itdb_spl_update_live(itdb)

def itdb_track_set_thumbnails(track, filename):
    """itdb_track_set_thumbnails(_Itdb_Track track, gchar const * filename) -> gboolean"""
    return _gpod.itdb_track_set_thumbnails(track, filename)

def itdb_track_set_thumbnails_from_data(track, image_data, image_data_len):
    """itdb_track_set_thumbnails_from_data(_Itdb_Track track, guchar const * image_data, gsize image_data_len) -> gboolean"""
    return _gpod.itdb_track_set_thumbnails_from_data(track, image_data, image_data_len)

def itdb_track_set_thumbnails_from_pixbuf(track, pixbuf):
    """itdb_track_set_thumbnails_from_pixbuf(_Itdb_Track track, gpointer pixbuf) -> gboolean"""
    return _gpod.itdb_track_set_thumbnails_from_pixbuf(track, pixbuf)

def itdb_track_has_thumbnails(track):
    """itdb_track_has_thumbnails(_Itdb_Track track) -> gboolean"""
    return _gpod.itdb_track_has_thumbnails(track)

def itdb_track_remove_thumbnails(track):
    """itdb_track_remove_thumbnails(_Itdb_Track track)"""
    return _gpod.itdb_track_remove_thumbnails(track)

def itdb_track_get_thumbnail(track, width, height):
    """itdb_track_get_thumbnail(_Itdb_Track track, gint width, gint height) -> gpointer"""
    return _gpod.itdb_track_get_thumbnail(track, width, height)

def itdb_photodb_parse(mp, error):
    """itdb_photodb_parse(gchar const * mp, GError ** error) -> _Itdb_PhotoDB"""
    return _gpod.itdb_photodb_parse(mp, error)

def itdb_photodb_add_photo(db, filename, position, rotation, error):
    """itdb_photodb_add_photo(_Itdb_PhotoDB db, gchar const * filename, gint position, gint rotation, GError ** error) -> _Itdb_Artwork"""
    return _gpod.itdb_photodb_add_photo(db, filename, position, rotation, error)

def itdb_photodb_add_photo_from_data(db, image_data, image_data_len, position, rotation, error):
    """itdb_photodb_add_photo_from_data(_Itdb_PhotoDB db, guchar const * image_data, gsize image_data_len, gint position, gint rotation, GError ** error) -> _Itdb_Artwork"""
    return _gpod.itdb_photodb_add_photo_from_data(db, image_data, image_data_len, position, rotation, error)

def itdb_photodb_add_photo_from_pixbuf(db, pixbuf, position, rotation, error):
    """itdb_photodb_add_photo_from_pixbuf(_Itdb_PhotoDB db, gpointer pixbuf, gint position, gint rotation, GError ** error) -> _Itdb_Artwork"""
    return _gpod.itdb_photodb_add_photo_from_pixbuf(db, pixbuf, position, rotation, error)

def itdb_photodb_photoalbum_add_photo(db, album, photo, position):
    """itdb_photodb_photoalbum_add_photo(_Itdb_PhotoDB db, _Itdb_PhotoAlbum album, _Itdb_Artwork photo, gint position)"""
    return _gpod.itdb_photodb_photoalbum_add_photo(db, album, photo, position)

def itdb_photodb_photoalbum_create(db, albumname, pos):
    """itdb_photodb_photoalbum_create(_Itdb_PhotoDB db, gchar const * albumname, gint pos) -> _Itdb_PhotoAlbum"""
    return _gpod.itdb_photodb_photoalbum_create(db, albumname, pos)

def itdb_photodb_create(mountpoint):
    """itdb_photodb_create(gchar const * mountpoint) -> _Itdb_PhotoDB"""
    return _gpod.itdb_photodb_create(mountpoint)

def itdb_photodb_photoalbum_new(albumname):
    """itdb_photodb_photoalbum_new(gchar const * albumname) -> _Itdb_PhotoAlbum"""
    return _gpod.itdb_photodb_photoalbum_new(albumname)

def itdb_photodb_photoalbum_free(album):
    """itdb_photodb_photoalbum_free(_Itdb_PhotoAlbum album)"""
    return _gpod.itdb_photodb_photoalbum_free(album)

def itdb_photodb_photoalbum_add(db, album, pos):
    """itdb_photodb_photoalbum_add(_Itdb_PhotoDB db, _Itdb_PhotoAlbum album, gint pos)"""
    return _gpod.itdb_photodb_photoalbum_add(db, album, pos)

def itdb_photodb_free(photodb):
    """itdb_photodb_free(_Itdb_PhotoDB photodb)"""
    return _gpod.itdb_photodb_free(photodb)

def itdb_photodb_write(photodb, error):
    """itdb_photodb_write(_Itdb_PhotoDB photodb, GError ** error) -> gboolean"""
    return _gpod.itdb_photodb_write(photodb, error)

def itdb_photodb_remove_photo(db, album, photo):
    """itdb_photodb_remove_photo(_Itdb_PhotoDB db, _Itdb_PhotoAlbum album, _Itdb_Artwork photo)"""
    return _gpod.itdb_photodb_remove_photo(db, album, photo)

def itdb_photodb_photoalbum_remove(db, album, remove_pics):
    """itdb_photodb_photoalbum_remove(_Itdb_PhotoDB db, _Itdb_PhotoAlbum album, gboolean remove_pics)"""
    return _gpod.itdb_photodb_photoalbum_remove(db, album, remove_pics)

def itdb_photodb_photoalbum_unlink(album):
    """itdb_photodb_photoalbum_unlink(_Itdb_PhotoAlbum album)"""
    return _gpod.itdb_photodb_photoalbum_unlink(album)

def itdb_photodb_photoalbum_by_name(db, albumname):
    """itdb_photodb_photoalbum_by_name(_Itdb_PhotoDB db, gchar const * albumname) -> _Itdb_PhotoAlbum"""
    return _gpod.itdb_photodb_photoalbum_by_name(db, albumname)

def itdb_artwork_new():
    """itdb_artwork_new() -> _Itdb_Artwork"""
    return _gpod.itdb_artwork_new()

def itdb_artwork_duplicate(artwork):
    """itdb_artwork_duplicate(_Itdb_Artwork artwork) -> _Itdb_Artwork"""
    return _gpod.itdb_artwork_duplicate(artwork)

def itdb_artwork_free(artwork):
    """itdb_artwork_free(_Itdb_Artwork artwork)"""
    return _gpod.itdb_artwork_free(artwork)

def itdb_artwork_set_thumbnail(artwork, filename, rotation, error):
    """itdb_artwork_set_thumbnail(_Itdb_Artwork artwork, gchar const * filename, gint rotation, GError ** error) -> gboolean"""
    return _gpod.itdb_artwork_set_thumbnail(artwork, filename, rotation, error)

def itdb_artwork_set_thumbnail_from_data(artwork, image_data, image_data_len, rotation, error):
    """itdb_artwork_set_thumbnail_from_data(_Itdb_Artwork artwork, guchar const * image_data, gsize image_data_len, gint rotation, GError ** error) -> gboolean"""
    return _gpod.itdb_artwork_set_thumbnail_from_data(artwork, image_data, image_data_len, rotation, error)

def itdb_artwork_set_thumbnail_from_pixbuf(artwork, pixbuf, rotation, error):
    """itdb_artwork_set_thumbnail_from_pixbuf(_Itdb_Artwork artwork, gpointer pixbuf, gint rotation, GError ** error) -> gboolean"""
    return _gpod.itdb_artwork_set_thumbnail_from_pixbuf(artwork, pixbuf, rotation, error)

def itdb_artwork_remove_thumbnails(artwork):
    """itdb_artwork_remove_thumbnails(_Itdb_Artwork artwork)"""
    return _gpod.itdb_artwork_remove_thumbnails(artwork)

def itdb_artwork_get_pixbuf(device, artwork, width, height):
    """itdb_artwork_get_pixbuf(Itdb_Device * device, _Itdb_Artwork artwork, gint width, gint height) -> gpointer"""
    return _gpod.itdb_artwork_get_pixbuf(device, artwork, width, height)

def itdb_thumb_duplicate(thumb):
    """itdb_thumb_duplicate(Itdb_Thumb * thumb) -> Itdb_Thumb *"""
    return _gpod.itdb_thumb_duplicate(thumb)

def itdb_thumb_to_pixbuf_at_size(device, thumb, width, height):
    """itdb_thumb_to_pixbuf_at_size(Itdb_Device * device, Itdb_Thumb * thumb, gint width, gint height) -> gpointer"""
    return _gpod.itdb_thumb_to_pixbuf_at_size(device, thumb, width, height)

def itdb_thumb_to_pixbufs(device, thumb):
    """itdb_thumb_to_pixbufs(Itdb_Device * device, Itdb_Thumb * thumb) -> GList *"""
    return _gpod.itdb_thumb_to_pixbufs(device, thumb)

def itdb_thumb_free(thumb):
    """itdb_thumb_free(Itdb_Thumb * thumb)"""
    return _gpod.itdb_thumb_free(thumb)

def itdb_chapterdata_new():
    """itdb_chapterdata_new() -> _Itdb_Chapterdata"""
    return _gpod.itdb_chapterdata_new()

def itdb_chapterdata_free(chapterdata):
    """itdb_chapterdata_free(_Itdb_Chapterdata chapterdata)"""
    return _gpod.itdb_chapterdata_free(chapterdata)

def itdb_chapterdata_duplicate(chapterdata):
    """itdb_chapterdata_duplicate(_Itdb_Chapterdata chapterdata) -> _Itdb_Chapterdata"""
    return _gpod.itdb_chapterdata_duplicate(chapterdata)

def itdb_chapterdata_remove_chapter(chapterdata, chapter):
    """itdb_chapterdata_remove_chapter(_Itdb_Chapterdata chapterdata, _Itdb_Chapter chapter)"""
    return _gpod.itdb_chapterdata_remove_chapter(chapterdata, chapter)

def itdb_chapterdata_unlink_chapter(chapterdata, chapter):
    """itdb_chapterdata_unlink_chapter(_Itdb_Chapterdata chapterdata, _Itdb_Chapter chapter)"""
    return _gpod.itdb_chapterdata_unlink_chapter(chapterdata, chapter)

def itdb_chapterdata_remove_chapters(chapterdata):
    """itdb_chapterdata_remove_chapters(_Itdb_Chapterdata chapterdata)"""
    return _gpod.itdb_chapterdata_remove_chapters(chapterdata)

def itdb_chapter_new():
    """itdb_chapter_new() -> _Itdb_Chapter"""
    return _gpod.itdb_chapter_new()

def itdb_chapter_free(chapter):
    """itdb_chapter_free(_Itdb_Chapter chapter)"""
    return _gpod.itdb_chapter_free(chapter)

def itdb_chapter_duplicate(chapter):
    """itdb_chapter_duplicate(_Itdb_Chapter chapter) -> _Itdb_Chapter"""
    return _gpod.itdb_chapter_duplicate(chapter)

def itdb_chapterdata_add_chapter(chapterdata, startpos, chaptertitle):
    """itdb_chapterdata_add_chapter(_Itdb_Chapterdata chapterdata, guint32 startpos, gchar * chaptertitle) -> gboolean"""
    return _gpod.itdb_chapterdata_add_chapter(chapterdata, startpos, chaptertitle)

def itdb_time_get_mac_time():
    """itdb_time_get_mac_time() -> time_t"""
    return _gpod.itdb_time_get_mac_time()

def itdb_time_mac_to_host(time):
    """itdb_time_mac_to_host(time_t time) -> time_t"""
    return _gpod.itdb_time_mac_to_host(time)

def itdb_time_host_to_mac(time):
    """itdb_time_host_to_mac(time_t time) -> time_t"""
    return _gpod.itdb_time_host_to_mac(time)

def itdb_init_ipod(mountpoint, model_number, ipod_name, error):
    """itdb_init_ipod(gchar const * mountpoint, gchar const * model_number, gchar const * ipod_name, GError ** error) -> gboolean"""
    return _gpod.itdb_init_ipod(mountpoint, model_number, ipod_name, error)
# This file is compatible with both classic and new-style classes.


