/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.frames;

import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;

public class GoAwayFrame
extends ControlFrame {
    private final int lastStreamId;
    private final int statusCode;

    public GoAwayFrame(short version, int lastStreamId, int statusCode) {
        super(version, ControlFrameType.GO_AWAY, (byte)0);
        this.lastStreamId = lastStreamId;
        this.statusCode = statusCode;
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        SessionStatus sessionStatus = SessionStatus.from(this.getStatusCode());
        return String.format("%s last_stream=%d status=%s", super.toString(), this.getLastStreamId(), sessionStatus == null ? Integer.valueOf(this.getStatusCode()) : sessionStatus);
    }
}

