/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend.bcel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;

public class AncestorAnalyzer
extends AbstractAnalyzer {
    public AncestorAnalyzer() {
        block2: {
            try {
                new ClassParser("force");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block2;
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        int maxCount;
        HashSet<String> dependencies = new HashSet<String>();
        HashSet<File> containers = new HashSet<File>();
        HashSet toAnalyze = new HashSet();
        HashSet<String> nextAnalyze = new HashSet<String>();
        Enumeration e = this.getRootClasses();
        while (e.hasMoreElements()) {
            toAnalyze.add(e.nextElement());
        }
        int count = 0;
        int n = maxCount = this.isClosureRequired() ? 1000 : 2;
        while (!toAnalyze.isEmpty() && count++ < maxCount) {
            nextAnalyze.clear();
            for (String classname : toAnalyze) {
                dependencies.add(classname);
                try {
                    String superClass;
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.add(container);
                    ClassParser parser = container.getName().endsWith(".class") ? new ClassParser(container.getPath()) : new ClassParser(container.getPath(), classname.replace('.', '/') + ".class");
                    JavaClass javaClass = parser.parse();
                    for (String interfaceName : javaClass.getInterfaceNames()) {
                        if (dependencies.contains(interfaceName)) continue;
                        nextAnalyze.add(interfaceName);
                    }
                    if (!javaClass.isClass() || dependencies.contains(superClass = javaClass.getSuperclassName())) continue;
                    nextAnalyze.add(superClass);
                }
                catch (IOException iOException) {}
            }
            HashSet temp = toAnalyze;
            toAnalyze = nextAnalyze;
            nextAnalyze = temp;
        }
        files.clear();
        files.addAll(containers);
        classes.clear();
        classes.addAll(dependencies);
    }

    protected boolean supportsFileDependencies() {
        return true;
    }
}

