/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GMonthDayType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GMonthDayType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            block14: {
                char c = value.charAt(i);
                if (c < '0' || c > '9') {
                    switch (state) {
                        case 0: {
                            if (c != '-') break;
                            switch (i) {
                                case 0: {
                                    break block14;
                                }
                                case 1: {
                                    state = 1;
                                    start = i + 1;
                                    break block14;
                                }
                                default: {
                                    throw new DatatypeException(i, "illegal GMonthDay type");
                                }
                            }
                        }
                        case 1: {
                            if (c != '-') break;
                            if (i - start != 2) {
                                throw new DatatypeException(i, "illegal GMonthDay type");
                            }
                            state = 2;
                            start = i + 1;
                            break block14;
                        }
                    }
                    throw new DatatypeException(i, "illegal GMonthDay type");
                }
            }
            ++i;
        }
        switch (state) {
            case 2: {
                if (len - start == 2) break;
                throw new DatatypeException("illegal GMonthDay type");
            }
            default: {
                throw new DatatypeException("illegal GMonthDay type");
            }
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            GMonthDay ret = new GMonthDay();
            ret.month = Integer.parseInt(literal.substring(2, 5));
            ret.day = Integer.parseInt(literal.substring(6));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GMonthDay
    implements Comparable {
        int month;
        int day;

        GMonthDay() {
        }

        public int hashCode() {
            return this.month * 31 + this.day;
        }

        public boolean equals(Object other) {
            if (other instanceof GMonthDay) {
                GMonthDay gmd = (GMonthDay)other;
                return gmd.month == this.month && gmd.day == this.day;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof GMonthDay) {
                GMonthDay gmd = (GMonthDay)other;
                if (gmd.month == this.month) {
                    if (gmd.day == this.day) {
                        return 0;
                    }
                    return this.day < gmd.day ? -1 : 1;
                }
                return this.month < gmd.month ? -1 : 1;
            }
            return 0;
        }
    }
}

