/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private AttributeSet attributes;
    private float longestWord;
    private boolean nowrap;

    public InlineView(Element element) {
        super(element);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        StyleSheet ss = this.getStyleSheet();
        this.attributes = ss.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
        this.setPropertiesFromAttributes();
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            StyleSheet ss = this.getStyleSheet();
            this.attributes = ss.getViewAttributes(this);
        }
        return this.attributes;
    }

    public int getBreakWeight(int axis, float pos, float len) {
        int weight = this.nowrap ? 0 : super.getBreakWeight(axis, pos, len);
        return weight;
    }

    public View breakView(int axis, int offset, float pos, float len) {
        return super.breakView(axis, offset, pos, len);
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet atts = this.getAttributes();
        Object o = atts.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean b = false;
        if (o != null && o.toString().contains("underline")) {
            b = true;
        }
        this.setUnderline(b);
        b = false;
        if (o != null && o.toString().contains("line-through")) {
            b = true;
        }
        this.setStrikeThrough(b);
        o = atts.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        b = false;
        if (o != null && o.toString().contains("sub")) {
            b = true;
        }
        this.setSubscript(b);
        b = false;
        if (o != null && o.toString().contains("sup")) {
            b = true;
        }
        this.setSuperscript(b);
        o = atts.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = o != null && o.equals("nowrap");
    }

    protected StyleSheet getStyleSheet() {
        Document doc = this.getDocument();
        StyleSheet styleSheet = null;
        if (doc instanceof HTMLDocument) {
            styleSheet = ((HTMLDocument)doc).getStyleSheet();
        }
        return styleSheet;
    }

    public float getMinimumSpan(int axis) {
        float min = super.getMinimumSpan(axis);
        if (axis == 0) {
            min = Math.max(this.getLongestWord(), min);
        }
        return min;
    }

    private float getLongestWord() {
        if (this.longestWord == -1.0f) {
            this.longestWord = this.calculateLongestWord();
        }
        return this.longestWord;
    }

    private float calculateLongestWord() {
        float span = 0.0f;
        try {
            Document doc = this.getDocument();
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            Segment s = new Segment();
            doc.getText(p0, p1 - p0, s);
            BreakIterator iter = BreakIterator.getWordInstance();
            iter.setText(s);
            int wordStart = p0;
            int wordEnd = p0;
            int start = iter.first();
            int end = iter.next();
            while (end != -1) {
                if (end - start > wordEnd - wordStart) {
                    wordStart = start;
                    wordEnd = end;
                }
                start = end;
                end = iter.next();
            }
            if (wordEnd - wordStart > 0) {
                FontMetrics fm = this.getFontMetrics();
                int offset = s.offset + wordStart - s.getBeginIndex();
                span = fm.charsWidth(s.array, offset, wordEnd - wordStart);
            }
        }
        catch (BadLocationException badLocationException) {}
        return span;
    }
}

