import React, { Component } from 'react';

const xCount = 50;
const yCount = 50;

function Cell({ x, y, flipIndex }) {
  const index = (y * xCount) + x;
  const bgColor1 = getColor(x, y);
  return (
    <div className={`login-bg__item ${flipIndex === index ? 'login-bg-flip' : ''}`} key={index} style={{background: bgColor1}} />
  );
}

function getRandomInt(min, max) {
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min)) + min; //The maximum is exclusive and the minimum is inclusive
}

export default class LoginBackground extends Component<any, any> {
  cancelInterval: any;

  constructor(props) {
    super(props);

    this.state = {
      flipIndex: null,
    };

    this.flipElements = this.flipElements.bind(this);
  }

  flipElements() {
    const elementIndexToFlip = getRandomInt(0, (xCount * yCount) - 1);
    this.setState(prevState => {
      return {
        ...prevState,
        flipIndex: elementIndexToFlip,
      };
    });
  }

  componentWillMount() {
    this.cancelInterval = setInterval(this.flipElements, 3000);
  }

  componentWillUnmount() {
    clearInterval(this.cancelInterval);
  }

  render() {
    console.log('re-render!', this.state.flipIndex);

    return (
      <div className="login-bg">
        {Array.from(Array(yCount)).map((el, y) => {
          return (
            <div className="login-bg__row">
              {Array.from(Array(xCount)).map((el2, x) => {
                return (
                  <Cell y={y} x={x} flipIndex={this.state.flipIndex} />
                );
              })}
            </div>
          );
        })}
      </div>
    );
  }
}

function getColor(x, y) {
  const colors = [
    '#14161A',
    '#111920',
    '#121E27',
    '#13212B',
    '#122029',
    '#101C24',
    '#0F1B23',
    '#0F1B22',
    '#111C24',
    '#101A22',
    '#101A21',
    '#111D25',
    '#101E27',
    '#101D26',
    '#101B23',
    '#11191E',
    '#131519',
    '#131518',
    '#101B21',
    '#121F29',
    '#10232D',
    '#11212B',
    '#0E1C25',
    '#0E1C24',
    '#111F29',
    '#11222B',
    '#101E28',
    '#102028',
    '#111F2A',
    '#11202A',
    '#11191F',
    '#121417',
    '#12191D',
    '#101D25',
    '#11212C',
    '#10242F',
    '#0F212B',
    '#0F1E27',
    '#0F1D26',
    '#0F1F29',
    '#0F2029',
    '#11232E',
    '#10212B',
    '#10222C',
    '#0F202A',
    '#112530',
    '#10252F',
    '#0F242E',
    '#10222D',
    '#10202A',
    '#0F1C24',
    '#0F1E28',
    '#0F212A',
    '#0F222B',
    '#14171A',
    '#0F1A20',
    '#0F1C25',
    '#10232E',
    '#0E202A',
    '#0E1E27',
    '#0E1D26',
    '#0F202B',
    '#11232F',
    '#102632',
    '#102530',
    '#122430',
    '#0F1B21',
    '#0F212C',
    '#0E1F29',
    '#112531',
    '#0F2734',
    '#0F2835',
    '#0D1B23',
    '#0F1A21',
    '#0F1A23',
    '#0F1D27',
    '#0F222D',
    '#102430',
    '#102531',
    '#10222E',
    '#0F232D',
    '#0E2633',
    '#0E2734',
    '#0F2834',
    '#0E2835',
    '#0F2633',
    '#0F2532',
    '#0E1A22',
    '#0D1C24',
    '#0F2735',
    '#0F2937',
    '#102A38',
    '#112938',
    '#102A39',
    '#0F2A38',
    '#102836',
    '#0E1B23',
    '#0F2938',
    '#102A3A',
    '#102D3D',
    '#0F3040',
    '#102D3E',
    '#0F2E3E',
    '#112C3B',
    '#102B3B',
    '#102B3A',
    '#102D3C',
    '#0F2A39',
    '#0F2634',
    '#0E2029',
    '#0E1A21',
    '#0F2B39',
    '#0F2D3D',
    '#0F2F40',
    '#0E3142',
    '#113445',
    '#122431',
    '#102E3E',
    '#0F3345',
    '#0E2F40',
    '#0F3143',
    '#102C3C',
    '#0F2B3A',
    '#0F1F28',
    '#0F3344',
    '#113548',
    '#113C51',
    '#144258',
    '#103A4E',
    '#103A4F',
    '#103547',
    '#10364A',
    '#103649',
    '#0F3448',
    '#102C3A',
    '#0F2836',
    '#103447',
    '#0F384C',
    '#123F55',
    '#15445A',
    '#133F55',
    '#103B50',
    '#113E54',
    '#103446',
    '#0F3A4F',
    '#0F3548',
    '#0D3142',
    '#102C3B',
    '#0E2937',
    '#103D52',
    '#0E3544',
    '#184C65',
    '#154760',
    '#14435B',
    '#15465F',
    '#124159',
    '#0F3D53',
    '#103C51',
    '#0F3447',
    '#0E3243',
    '#113143',
    '#113D53',
    '#184B64',
    '#184D67',
    '#184C66',
    '#174A63',
    '#15455C',
    '#13425A',
    '#14445A',
    '#10384C',
    '#0E3446',
    '#10181E',
    '#103243',
    '#0F384D',
    '#14455C',
    '#164761',
    '#164C66',
    '#1D627D',
    '#12425A',
    '#164A63',
    '#14465D',
    '#13435A',
    '#0A2B38',
    '#0F3446',
    '#0D2F40',
    '#0D2F3F',
    '#0F2531',
    '#102937',
    '#10384B',
    '#0F3649',
    '#184E68',
    '#1A5472',
    '#184D68',
    '#154A63',
    '#19506B',
    '#19536F',
    '#1A4F69',
    '#144760',
    '#114058',
    '#0E3A4F',
    '#0E3547',
    '#0C3042',
    '#0E1B24',
    '#11222C',
    '#154C65',
    '#1A5776',
    '#1B5675',
    '#113847',
    '#1A5371',
    '#194E68',
    '#0E2D3D',
    '#112D3B',
    '#113D52',
    '#18516D',
    '#1A5979',
    '#1B5878',
    '#19526E',
    '#1A526E',
    '#13435B',
    '#0F3E55',
    '#0B374C',
    '#0E3448',
    '#0D2E3F',
    '#0F2B3B',
    '#112E3E',
    '#113B50',
    '#15465D',
    '#1A526F',
    '#1E5E81',
    '#1D5B7B',
    '#1A5777',
    '#154456',
    '#113949',
    '#0D394E',
    '#0F3549',
    '#0F2C3B',
    '#0E2733',
    '#112E3D',
    '#123D52',
    '#10394C',
    '#1B5674',
    '#1A5370',
    '#144861',
    '#104058',
    '#104159',
    '#0E384C',
    '#0D2D3D',
    '#0E2533',
    '#112C3A',
    '#1B5979',
    '#1B5C7D',
    '#1A5675',
    '#104057',
    '#0F3C51',
    '#11425A',
    '#0E394D',
    '#0C3243',
    '#0E2735',
    '#112F3E',
    '#134158',
    '#1D5E7F',
    '#1D6083',
    '#1C5877',
    '#1A5573',
    '#184D66',
    '#164962',
    '#0F3D54',
    '#0E3D53',
    '#0E3447',
    '#0F2A3A',
    '#0F2936',
    '#101F28',
    '#103040',
    '#124056',
    '#164E69',
    '#144B64',
    '#164D66',
    '#0F3E54',
    '#0E3B51',
    '#0D3346',
    '#0E1F27',
    '#124158',
    '#164961',
    '#0E3C52',
    '#19506C',
    '#0F2C3C',
    '#0E3244',
    '#0E2A39',
    '#0E2938',
    '#113040',
    '#134057',
    '#1A5471',
    '#154B63',
    '#1C597A',
    '#164760',
    '#10374B',
    '#0E374C',
    '#0E384D',
    '#11242F',
    '#10394D',
    '#18526E',
    '#154B65',
    '#103F55',
    '#0D3345',
    '#102532',
    '#102029',
    '#113142',
    '#1B5973',
    '#1A516B',
    '#1C5979',
    '#1C5A7A',
    '#184A65',
    '#164C65',
    '#0D3041',
    '#123142',
    '#123E54',
    '#1B5877',
    '#1A5574',
    '#1C5878',
    '#13435C',
    '#0F374B',
    '#0C3143',
    '#112F40',
    '#123C51',
    '#174E68',
    '#1D5C7D',
    '#14465F',
    '#0F3F56',
    '#0B3041',
    '#123243',
    '#15435B',
    '#19516D',
    '#1D5D7E',
    '#1C5C7D',
    '#184F69',
    '#11374B',
    '#103E54',
    '#0E3143',
    '#0F2D3C',
    '#11242E',
    '#133445',
    '#1A5674',
    '#1D6184',
    '#1F658B',
    '#0D3A50',
    '#0C374B',
    '#154862',
    '#164B64',
    '#154961',
    '#0D384D',
    '#102631',
    '#113242',
    '#134259',
    '#185270',
    '#1D6386',
    '#1E678C',
    '#1C5978',
    '#0D3549',
    '#0F2632',
    '#184961',
    '#1D5E80',
    '#1E6488',
    '#1F678D',
    '#1E5B7C',
    '#164862',
    '#19526D',
    '#113C52',
    '#15455E',
    '#0F2F3F',
    '#144259',
    '#194D67',
    '#1D6991',
    '#195777',
    '#19516C',
    '#103F56',
    '#144660',
    '#0D2E3E',
    '#10212A',
    '#113141',
    '#16455C',
    '#1D5B7C',
    '#1F6589',
    '#1E668C',
    '#1E5F81',
    '#0F3B50',
    '#0D3244',
    '#164A64',
    '#184E69',
    '#0E364A',
    '#0E2E3E',
    '#10222B',
    '#19475E',
    '#1B5A7B',
    '#1E5D7F',
    '#1E678D',
    '#1E6184',
    '#19506A',
    '#1B5370',
    '#1B5573',
    '#0E3041',
    '#122E3E',
    '#16455B',
    '#195370',
    '#1D6489',
    '#1D6B93',
    '#164A65',
    '#154A64',
    '#1A5572',
    '#1D6082',
    '#1F6286',
    '#1D6C94',
    '#1E709A',
    '#174A65',
    '#1B526F',
    '#1E6589',
    '#1D6384',
    '#0D3143',
    '#0E2F3F',
    '#174760',
    '#1F6487',
    '#1D668C',
    '#0D2F41',
    '#103B4F',
    '#1C5C7E',
    '#1F688F',
    '#1C5B7C',
    '#164D68',
    '#1D6285',
    '#0D364A',
    '#1D5A7A',
    '#1E6990',
    '#1D6488',
    '#18516B',
    '#1A506B',
    '#0E3B50',
    '#0E3548',
    '#124259',
    '#13455C',
    '#14485F',
    '#1E5C7D',
    '#122D3C',
    '#1E6E98',
    '#1E6A91',
    '#1E6286',
    '#1E6C95',
    '#1D6990',
    '#101F29',
    '#174A62',
    '#10394E',
    '#1D6D96',
    '#1E688E',
    '#1D6E97',
    '#1E6C94',
    '#0E394E',
    '#112B39',
    '#195270',
    '#1E668B',
    '#1E6386',
    '#1D6385',
    '#0C3142',
    '#1E6083',
    '#1E729C',
    '#1F709A',
    '#1E6F98',
    '#1D5F81',
    '#1F688D',
    '#1C6488',
    '#1D6588',
    '#1C6A93',
    '#1E658B',
    '#1F6C95',
    '#0D3C52',
    '#1C6385',
    '#1E5F82',
    '#0E3D54',
    '#0F3244',
    '#18485F',
    '#1E6991',
    '#1C5B7B',
    '#1F6082',
    '#0F3346',
    '#18536F',
    '#114056',
    '#1D6B92',
    '#1B5776',
    '#0F3C52',
    '#1E6890',
    '#1F688E',
    '#0C394E',
    '#0F1D25',
    '#1F6386',
    '#1E688D',
    '#1F6488',
    '#20668C',
    '#1D5978',
    '#0F3D52',
    '#0F1E26',
    '#13465F',
    '#0D374C',
    '#1B5C7C',
    '#0E1A23',
    '#0F374A',
    '#1B5574',
    '#0F394C',
    '#0E2A38',
    '#102A37',
    '#18506B',
    '#1E5A7A',
    '#0F3245',
    '#0E2E3F',
    '#1E678E',
    '#1C5D7E',
    '#1A5A7A',
    '#0E2837',
    '#102733',
    '#0F3B51',
    '#15475E',
    '#1E6B93',
    '#1E648A',
    '#194961',
    '#0F3A4E',
    '#0E1D25',
    '#194F69',
    '#103345',
    '#0F394D',
    '#102B39',
    '#103E55',
    '#1B5572',
    '#164861',
    '#174861',
    '#113B4F',
    '#102936',
    '#0F3041',
    '#174961',
    '#113E53',
    '#134056',
    '#124057',
    '#194B63',
    '#0E364B',
    '#15445B',
    '#16475E',
    '#102F3F',
    '#16485F',
    '#0F2E3D',
    '#101920',
    '#12222C',
    '#122C3B',
    '#144157',
    '#123B50',
    '#16465D',
    '#184960',
    '#112B3A',
    '#12232F',
    '#132430',
    '#113344',
    '#11394C',
    '#113649',
    '#11364A',
    '#133F56',
    '#121D25',
    '#112733',
    '#112A38',
    '#0F1F2A',
    '#113447',
    '#113A4E',
    '#0F222C',
    '#13222B',
    '#112836',
    '#102F3E',
    '#113243',
    '#123445',
    '#12374B',
    '#121E26',
    '#122531',
    '#11303F',
    '#0D1D25',
    '#102835',
    '#112834',
    '#101C23',
    '#111C23',
    '#12212B',
    '#11222D',
    '#0E1B22',
    '#0E1D27',
    '#121C22',
    '#12202A',
    '#101A20',
    '#13191E',
    '#111E28',
    '#11212D',
    '#0F1B24',
    '#0F1C23',
    '#13181D',
    '#15171A',
    '#121D23',
    '#121F27',
    '#111E27',
    '#101B22',
    '#121F28',
    '#111E26',
    '#101D24',
    '#111C22',
    '#12161E',
    '#101925',
    '#121E2D',
    '#112033',
    '#111E2F',
    '#0F1B29',
    '#0F1A28',
    '#101B2A',
    '#0E1A27',
    '#101C2B',
    '#111D2D',
    '#111D2B',
    '#0F1B28',
    '#101923',
    '#13161D',
    '#13161C',
    '#0F1A26',
    '#101E2F',
    '#112235',
    '#102031',
    '#0F1B2A',
    '#112031',
    '#102032',
    '#101D2E',
    '#121F2F',
    '#112133',
    '#101E30',
    '#101F30',
    '#102336',
    '#101B2C',
    '#0F1C2B',
    '#111E2E',
    '#0F2134',
    '#102236',
    '#0F2133',
    '#101F31',
    '#0F2438',
    '#102337',
    '#102235',
    '#102133',
    '#11171E',
    '#101F2F',
    '#102030',
    '#102234',
    '#102132',
    '#12181F',
    '#0F1A25',
    '#0F2135',
    '#0F1F30',
    '#0F1C2D',
    '#101D2C',
    '#0F2033',
    '#0E2338',
    '#0F2237',
    '#0F2236',
    '#0B243B',
    '#0D2338',
    '#0E1A26',
    '#0F1D2E',
    '#0F2032',
    '#0D2339',
    '#0B253F',
    '#0A253F',
    '#0A253E',
    '#0C2439',
    '#0E1925',
    '#0E2135',
    '#0F2235',
    '#0A243A',
    '#08253E',
    '#09253E',
    '#0A263F',
    '#0A243C',
    '#0B233B',
    '#0E1A28',
    '#0D1A26',
    '#09253F',
    '#0A2743',
    '#0B2844',
    '#0B2641',
    '#0A2744',
    '#0A2844',
    '#0B2743',
    '#092745',
    '#0F2337',
    '#101D2D',
    '#092743',
    '#092846',
    '#0E2B4C',
    '#102E4F',
    '#0E2C4D',
    '#0B2A49',
    '#082947',
    '#0D2B4B',
    '#0C2A4A',
    '#092946',
    '#082845',
    '#0C2B4B',
    '#0F2D4E',
    '#103051',
    '#133257',
    '#0E2D4E',
    '#143156',
    '#112F51',
    '#0B243A',
    '#082744',
    '#092844',
    '#123054',
    '#143359',
    '#173A64',
    '#183F6E',
    '#173F6D',
    '#153961',
    '#163962',
    '#133358',
    '#15345B',
    '#14345A',
    '#102F50',
    '#0A2948',
    '#082844',
    '#092641',
    '#16375F',
    '#193C69',
    '#174170',
    '#173E6B',
    '#163A63',
    '#173D69',
    '#183D6A',
    '#15365E',
    '#112E50',
    '#0A2A49',
    '#082743',
    '#0E1927',
    '#173C68',
    '#13487E',
    '#164476',
    '#174375',
    '#193F6F',
    '#173B66',
    '#163B65',
    '#082A48',
    '#0A2641',
    '#09243C',
    '#174171',
    '#14477C',
    '#124980',
    '#14487F',
    '#174374',
    '#15467B',
    '#184172',
    '#17406F',
    '#184070',
    '#163C67',
    '#16355D',
    '#123256',
    '#0E1B29',
    '#0F1923',
    '#113052',
    '#184274',
    '#164579',
    '#13477C',
    '#193E6D',
    '#0A243E',
    '#0B233A',
    '#0D1A29',
    '#0B2742',
    '#17365E',
    '#163860',
    '#124A84',
    '#095191',
    '#114A83',
    '#0D4D8A',
    '#0C4D8C',
    '#104B85',
    '#15477E',
    '#174477',
    '#183862',
    '#0A233A',
    '#092947',
    '#09243D',
    '#173963',
    '#194173',
    '#085396',
    '#085394',
    '#114B87',
    '#144983',
    '#094F8E',
    '#075090',
    '#0F4C89',
    '#215287',
    '#0E1A29',
    '#184376',
    '#0C4D8B',
    '#07549A',
    '#0A4E8D',
    '#0F4C88',
    '#0A4E8C',
    '#174273',
    '#193C6A',
    '#0B2948',
    '#0B2C4B',
    '#0C4E8D',
    '#1259A4',
    '#0C579E',
    '#0D4D8B',
    '#095397',
    '#085397',
    '#085295',
    '#144880',
    '#173861',
    '#15335A',
    '#0F2C4D',
    '#0C2949',
    '#0B4E8D',
    '#08559C',
    '#07508F',
    '#154578',
    '#17365F',
    '#122F53',
    '#111D2C',
    '#092A48',
    '#08559D',
    '#08559E',
    '#0C56A1',
    '#164271',
    '#163E6A',
    '#194071',
    '#082642',
    '#0F1E30',
    '#0D2D4D',
    '#114C87',
    '#0E59A3',
    '#135BA6',
    '#085498',
    '#085497',
    '#095192',
    '#0E4D8B',
    '#0C4E8A',
    '#134982',
    '#17457B',
    '#121F2E',
    '#183E6C',
    '#153E69',
    '#07508E',
    '#173F6C',
    '#193D6B',
    '#112D4F',
    '#0A243B',
    '#072946',
    '#111E2D',
    '#0B2740',
    '#10497F',
    '#17406E',
    '#084F8D',
    '#104A80',
    '#0E2E4F',
    '#143358',
    '#16365D',
    '#0A2742',
    '#13477B',
    '#154474',
    '#104C86',
    '#095291',
    '#0B4F8E',
    '#114A80',
    '#095090',
    '#075296',
    '#163760',
    '#2D6DB5',
    '#0C2843',
    '#0C233A',
    '#153A62',
    '#14467A',
    '#075498',
    '#085293',
    '#09263F',
    '#122030',
    '#09559D',
    '#0F4B83',
    '#08549A',
    '#14375D',
    '#085499',
    '#075499',
    '#0A243D',
    '#143E68',
    '#10497E',
    '#074F8E',
    '#085496',
    '#0C58A3',
    '#065499',
    '#085190',
    '#0A2B4A',
    '#104C88',
    '#0D4F8E',
    '#0F58A2',
    '#0B569B',
    '#0D58A1',
    '#134A81',
    '#09559C',
    '#0A5293',
    '#114B86',
    '#0D2C4C',
    '#103255',
    '#16457A',
    '#074F8C',
    '#07559C',
    '#185DA9',
    '#1D61AD',
    '#175CA8',
    '#16406D',
    '#153C65',
    '#0E243A',
    '#144679',
    '#085192',
    '#1A5EAC',
    '#1D61AE',
    '#11497F',
    '#12487E',
    '#0C243C',
    '#123155',
    '#0F59A3',
    '#1B5FAB',
    '#1E61AD',
    '#145CA4',
    '#0E599F',
    '#11497E',
    '#094F8D',
    '#15345A',
    '#134A85',
    '#165CA8',
    '#2263AF',
    '#124466',
    '#0A518F',
    '#08569D',
    '#16416F',
    '#0B2B4A',
    '#124A83',
    '#0C57A2',
    '#1E60AD',
    '#1E62AE',
    '#165DA8',
    '#1059A4',
    '#15406C',
    '#0A4F8E',
    '#12365A',
    '#0A5191',
    '#16355C',
    '#1C5EAB',
    '#155CA7',
    '#085292',
    '#174478',
    '#153258',
    '#111F2F',
    '#174272',
    '#1159A5',
    '#1C5EAC',
    '#2F74BB',
    '#0C58A2',
    '#0D59A3',
    '#14477D',
    '#132F53',
    '#155BA6',
    '#195FAA',
    '#2366B1',
    '#2967B2',
    '#14477E',
    '#1B5EAB',
    '#175DA8',
    '#0F4C86',
    '#065090',
    '#1C5FAC',
    '#185CA8',
    '#0D58A3',
    '#0C4E8C',
    '#134981',
    '#14416D',
    '#0F5AA5',
    '#1F63AF',
    '#114B88',
    '#09508E',
    '#0A569D',
    '#195DAA',
    '#0F1D2F',
    '#1059A2',
    '#0E599E',
    '#2063AF',
    '#1F63AE',
    '#1A5EAA',
    '#0C57A0',
    '#195EAA',
    '#1A5EA9',
    '#0E4E8A',
    '#12487D',
    '#185DAA',
    '#175EAA',
    '#0A508E',
    '#1559A6',
    '#0E58A3',
    '#095399',
    '#0B4E8B',
    '#0B569F',
    '#0C57A1',
    '#2967B1',
    '#2365B0',
    '#2163AE',
    '#1A5DAA',
    '#195EAB',
    '#1E5FAC',
    '#2564AF',
    '#2767B1',
    '#2766B1',
    '#0D5A9F',
    '#2062AE',
    '#1F61AD',
    '#195FAB',
    '#0D4E8D',
    '#173760',
    '#111D2E',
    '#09518F',
    '#1A5FAC',
    '#135BA7',
    '#085291',
    '#183761',
    '#0B2845',
    '#113457',
    '#075393',
    '#185EA9',
    '#2B69B3',
    '#2A67B2',
    '#2867B1',
    '#155DA8',
    '#135CA6',
    '#135AA5',
    '#114980',
    '#2566B1',
    '#2064AF',
    '#2364AF',
    '#13365B',
    '#154475',
    '#08549B',
    '#164373',
    '#085392',
    '#144576',
    '#12497E',
    '#0E5392',
    '#135BA3',
    '#0C5395',
    '#0C5291',
    '#0E579C',
    '#0E5290',
    '#134C83',
    '#2163AC',
    '#195CA6',
    '#0D4E8C',
    '#082945',
    '#133256',
    '#0E2F50',
    '#105AA6',
    '#134677',
    '#144475',
    '#145BA7',
    '#154270',
    '#1D60AD',
    '#09569B',
    '#09243E',
    '#134A86',
    '#0E59A4',
    '#0A4E8B',
    '#0E4B83',
    '#1D5EAC',
    '#101C2A',
    '#134A84',
    '#0E518F',
    '#145CA7',
    '#0E5699',
    '#145BA5',
    '#095292',
    '#15416E',
    '#153D67',
    '#153F6B',
    '#125AA5',
    '#16406E',
    '#0E1B27',
    '#0D4F8C',
    '#0F58A3',
    '#114A82',
    '#09569C',
    '#0C2339',
    '#0E1B28',
    '#0D59A4',
    '#07559D',
    '#08569E',
    '#095190',
    '#0B253E',
    '#0C2B49',
    '#2264AF',
    '#09549A',
    '#09569F',
    '#163D68',
    '#0C263F',
    '#143960',
    '#183A65',
    '#075496',
    '#0C579F',
    '#085191',
    '#102438',
    '#075295',
    '#082946',
    '#102437',
    '#0C2642',
    '#101C29',
    '#0C253E',
    '#15355C',
    '#0B2E4D',
    '#0F3253',
    '#154577',
    '#16335B',
    '#0F1925',
    '#0C2742',
    '#0B2946',
    '#0E2C4B',
    '#0E2B48',
    '#0E2237',
    '#102237',
    '#0B253D',
    '#0A2946',
    '#0C2841',
    '#0D2A47',
    '#0C2C4A',
    '#08253F',
    '#08243D',
    '#111C2B',
    '#0C2844',
    '#0C2945',
    '#0D243A',
    '#122134',
    '#0B2642',
    '#113154',
    '#113255',
    '#0A2642',
    '#0A2945',
    '#0B263F',
    '#0D2E4E',
    '#0F1E2E',
    '#0A2845',
    '#0D2439',
    '#0F1A29',
    '#101C2E',
    '#111923',
    '#13181F',
    '#111D2F',
    '#111F30',
    '#121E30',
    '#121E2E',
    '#101B27',
    '#101A27',
    '#13171F',
  ];

  // let randX = getRandomInt(0, x);
  // let randY = getRandomInt(0, y);
  // let randIndex = randY * xCount + randX;

  return colors[(y*xCount + x) % colors.length];
}
