/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnUtils;
import java.util.Arrays;
import java.util.List;

public class SwitchNode
extends TargetInsnNode {
    private final Object[] keys;
    private final int[] targets;
    private final int def;
    private BlockNode[] targetBlocks;
    private BlockNode defTargetBlock;

    public SwitchNode(InsnArg arg, Object[] keys, int[] targets, int def) {
        super(InsnType.SWITCH, 1);
        this.keys = keys;
        this.targets = targets;
        this.def = def;
        this.addArg(arg);
    }

    public int getCasesCount() {
        return this.keys.length;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public int[] getTargets() {
        return this.targets;
    }

    public int getDefaultCaseOffset() {
        return this.def;
    }

    public BlockNode[] getTargetBlocks() {
        return this.targetBlocks;
    }

    public BlockNode getDefTargetBlock() {
        return this.defTargetBlock;
    }

    @Override
    public void initBlocks(BlockNode curBlock) {
        List<BlockNode> successors = curBlock.getSuccessors();
        int len = this.targets.length;
        this.targetBlocks = new BlockNode[len];
        for (int i = 0; i < len; ++i) {
            this.targetBlocks[i] = BlockUtils.getBlockByOffset(this.targets[i], successors);
        }
        this.defTargetBlock = BlockUtils.getBlockByOffset(this.def, successors);
    }

    @Override
    public boolean replaceTargetBlock(BlockNode origin, BlockNode replace) {
        int count = 0;
        int len = this.targetBlocks.length;
        for (int i = 0; i < len; ++i) {
            if (this.targetBlocks[i] != origin) continue;
            this.targetBlocks[i] = replace;
            ++count;
        }
        if (this.defTargetBlock == origin) {
            this.defTargetBlock = replace;
            ++count;
        }
        return count > 0;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SwitchNode) || !super.isSame(obj)) {
            return false;
        }
        SwitchNode other = (SwitchNode)obj;
        return this.def == other.def && Arrays.equals(this.keys, other.keys) && Arrays.equals(this.targets, other.targets);
    }

    @Override
    public String toString() {
        StringBuilder targ = new StringBuilder();
        targ.append('[');
        for (int i = 0; i < this.targets.length; ++i) {
            targ.append(InsnUtils.formatOffset(this.targets[i]));
            if (i >= this.targets.length - 1) continue;
            targ.append(", ");
        }
        targ.append(']');
        return super.toString() + " k:" + Arrays.toString(this.keys) + " t:" + targ;
    }
}

