/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public final class CompletableCache
extends Completable
implements CompletableObserver {
    static final InnerCompletableCache[] EMPTY = new InnerCompletableCache[0];
    static final InnerCompletableCache[] TERMINATED = new InnerCompletableCache[0];
    final CompletableSource source;
    final AtomicReference<InnerCompletableCache[]> observers;
    final AtomicBoolean once;
    Throwable error;

    public CompletableCache(CompletableSource source) {
        this.source = source;
        this.observers = new AtomicReference<InnerCompletableCache[]>(EMPTY);
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        InnerCompletableCache inner = new InnerCompletableCache(s);
        s.onSubscribe(inner);
        if (this.add(inner)) {
            if (inner.isDisposed()) {
                this.remove(inner);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                s.onError(ex);
            } else {
                s.onComplete();
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        for (InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.actual.onError(e);
        }
    }

    @Override
    public void onComplete() {
        for (InnerCompletableCache inner : this.observers.getAndSet(TERMINATED)) {
            if (inner.get()) continue;
            inner.actual.onComplete();
        }
    }

    boolean add(InnerCompletableCache inner) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new InnerCompletableCache[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(InnerCompletableCache inner) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new InnerCompletableCache[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    final class InnerCompletableCache
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 8943152917179642732L;
        final CompletableObserver actual;

        InnerCompletableCache(CompletableObserver actual) {
            this.actual = actual;
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                CompletableCache.this.remove(this);
            }
        }
    }
}

