/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.ResourceFile;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.BackgroundWorker;
import jadx.gui.jobs.DecompileJob;
import jadx.gui.jobs.IndexJob;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsWindow;
import jadx.gui.treemodel.JCertificate;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.AboutDialog;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.LogViewer;
import jadx.gui.ui.MainDropTarget;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.ui.SearchDialog;
import jadx.gui.ui.TabbedPane;
import jadx.gui.update.JadxUpdate;
import jadx.gui.update.data.Release;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.Position;
import jadx.gui.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    private static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_OPEN = Utils.openIcon("folder");
    private static final ImageIcon ICON_SAVE_ALL = Utils.openIcon("disk_multiple");
    private static final ImageIcon ICON_EXPORT = Utils.openIcon("database_save");
    private static final ImageIcon ICON_CLOSE = Utils.openIcon("cross");
    private static final ImageIcon ICON_SYNC = Utils.openIcon("sync");
    private static final ImageIcon ICON_FLAT_PKG = Utils.openIcon("empty_logical_package_obj");
    private static final ImageIcon ICON_SEARCH = Utils.openIcon("wand");
    private static final ImageIcon ICON_FIND = Utils.openIcon("magnifier");
    private static final ImageIcon ICON_BACK = Utils.openIcon("icon_back");
    private static final ImageIcon ICON_FORWARD = Utils.openIcon("icon_forward");
    private static final ImageIcon ICON_PREF = Utils.openIcon("wrench");
    private static final ImageIcon ICON_DEOBF = Utils.openIcon("lock_edit");
    private static final ImageIcon ICON_LOG = Utils.openIcon("report");
    private final transient JadxWrapper wrapper;
    private final transient JadxSettings settings;
    private final transient CacheObject cacheObject;
    private JPanel mainPanel;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private boolean isFlattenPackage;
    private JToggleButton flatPkgButton;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton deobfToggleBtn;
    private JCheckBoxMenuItem deobfMenuItem;
    private transient Link updateLink;
    private transient ProgressPanel progressPane;
    private transient BackgroundWorker backgroundWorker;
    private transient Theme editorTheme;

    public MainWindow(JadxSettings settings) {
        this.wrapper = new JadxWrapper(settings);
        this.settings = settings;
        this.cacheObject = new CacheObject();
        this.resetCache();
        this.initUI();
        this.initMenuAndToolbar();
        this.applySettings();
        this.checkForUpdate();
    }

    private void applySettings() {
        this.setFont(this.settings.getFont());
        this.setEditorTheme(this.settings.getEditorThemePath());
        this.loadSettings();
    }

    public void open() {
        this.pack();
        this.setLocationAndPosition();
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        if (this.settings.getFiles().isEmpty()) {
            this.openFile();
        } else {
            this.openFile(new File(this.settings.getFiles().get(0)));
        }
    }

    private void checkForUpdate() {
        if (!this.settings.isCheckForUpdates()) {
            return;
        }
        JadxUpdate.check(new JadxUpdate.IUpdateCallback(){

            @Override
            public void onUpdate(final Release r) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.updateLink.setText(String.format(NLS.str("menu.update_label"), r.getName()));
                        MainWindow.this.updateLink.setVisible(true);
                    }
                });
            }
        });
    }

    public void openFile() {
        int ret;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        Object[] exts = new String[]{"apk", "dex", "jar", "class", "zip", "aar", "arsc"};
        String description = "supported files: " + Arrays.toString(exts).replace('[', '(').replace(']', ')');
        fileChooser.setFileFilter(new FileNameExtensionFilter(description, (String[])exts));
        fileChooser.setToolTipText(NLS.str("file.open_action"));
        String currentDirectory = this.settings.getLastOpenFilePath();
        if (!currentDirectory.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        if ((ret = fileChooser.showDialog(this.mainPanel, NLS.str("file.open_title"))) == 0) {
            this.settings.setLastOpenFilePath(fileChooser.getCurrentDirectory().getPath());
            this.openFile(fileChooser.getSelectedFile());
        }
    }

    public void openFile(File file) {
        this.tabbedPane.closeAllTabs();
        this.resetCache();
        this.wrapper.openFile(file);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.settings.addRecentFile(file.getAbsolutePath());
        this.initTree();
        this.setTitle("jadx-gui - " + file.getName());
        this.runBackgroundJobs();
    }

    protected void resetCache() {
        this.cacheObject.reset();
        int threadsCount = 1;
        this.cacheObject.setDecompileJob(new DecompileJob(this.wrapper, threadsCount));
        this.cacheObject.setIndexJob(new IndexJob(this.wrapper, this.cacheObject, threadsCount));
    }

    private synchronized void runBackgroundJobs() {
        this.cancelBackgroundJobs();
        this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
        if (this.settings.isAutoStartJobs()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MainWindow.this.backgroundWorker.exec();
                }
            }, 1000L);
        }
    }

    public synchronized void cancelBackgroundJobs() {
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
            this.backgroundWorker = new BackgroundWorker(this.cacheObject, this.progressPane);
            this.resetCache();
        }
    }

    public void reOpenFile() {
        File openedFile = this.wrapper.getOpenFile();
        if (openedFile != null) {
            this.openFile(openedFile);
        }
    }

    private void saveAll(boolean export) {
        int ret;
        this.settings.setExportAsGradleProject(export);
        if (export) {
            this.settings.setSkipSources(false);
            this.settings.setSkipResources(false);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setToolTipText(NLS.str("file.save_all_msg"));
        String currentDirectory = this.settings.getLastSaveFilePath();
        if (!currentDirectory.isEmpty()) {
            fileChooser.setCurrentDirectory(new File(currentDirectory));
        }
        if ((ret = fileChooser.showDialog(this.mainPanel, NLS.str("file.select"))) == 0) {
            this.settings.setLastSaveFilePath(fileChooser.getCurrentDirectory().getPath());
            ProgressMonitor progressMonitor = new ProgressMonitor(this.mainPanel, NLS.str("msg.saving_sources"), "", 0, 100);
            progressMonitor.setMillisToPopup(0);
            this.wrapper.saveAll(fileChooser.getSelectedFile(), progressMonitor);
        }
    }

    private void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.reloadTree();
    }

    private void reloadTree() {
        this.treeModel.reload();
        this.tree.expandRow(1);
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        this.settings.setFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.reloadTree();
        }
    }

    private void toggleDeobfuscation() {
        boolean deobfOn = !this.settings.isDeobfuscationOn();
        this.settings.setDeobfuscationOn(deobfOn);
        this.settings.sync();
        this.deobfToggleBtn.setSelected(deobfOn);
        this.deobfMenuItem.setState(deobfOn);
        this.reOpenFile();
    }

    private void treeClickAction() {
        try {
            JNode node;
            JClass cls;
            Object obj = this.tree.getLastSelectedPathComponent();
            if (obj instanceof JResource) {
                JResource res = (JResource)obj;
                ResourceFile resFile = res.getResFile();
                if (resFile != null && JResource.isSupportedForView(resFile.getType())) {
                    this.tabbedPane.showResource(res);
                }
            } else if (obj instanceof JCertificate) {
                JCertificate cert = (JCertificate)obj;
                this.tabbedPane.showCertificate(cert);
            } else if (obj instanceof JNode && (cls = (node = (JNode)obj).getRootClass()) != null) {
                this.tabbedPane.codeJump(new Position(cls, node.getLine()));
            }
        }
        catch (Exception e) {
            LOG.error("Content loading error", (Throwable)e);
        }
    }

    private void syncWithEditor() {
        ContentPanel selectedContentPanel = this.tabbedPane.getSelectedCodePanel();
        if (selectedContentPanel == null) {
            return;
        }
        JNode node = selectedContentPanel.getNode();
        if (node.getParent() == null && this.treeRoot != null && (node = this.treeRoot.searchClassInTree(node)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.requestFocus();
    }

    private void initMenuAndToolbar() {
        AbstractAction openAction = new AbstractAction(NLS.str("file.open_action"), ICON_OPEN){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.openFile();
            }
        };
        openAction.putValue("ShortDescription", NLS.str("file.open"));
        openAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 128));
        AbstractAction saveAllAction = new AbstractAction(NLS.str("file.save_all"), ICON_SAVE_ALL){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(false);
            }
        };
        saveAllAction.putValue("ShortDescription", NLS.str("file.save_all"));
        saveAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        AbstractAction exportAction = new AbstractAction(NLS.str("file.export_gradle"), ICON_EXPORT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(true);
            }
        };
        exportAction.putValue("ShortDescription", NLS.str("file.export_gradle"));
        exportAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 128));
        JMenu recentFiles = new JMenu(NLS.str("menu.recent_files"));
        recentFiles.addMenuListener(new RecentFilesMenuListener(recentFiles));
        AbstractAction prefsAction = new AbstractAction(NLS.str("menu.preferences"), ICON_PREF){

            @Override
            public void actionPerformed(ActionEvent e) {
                new JadxSettingsWindow(MainWindow.this, MainWindow.this.settings).setVisible(true);
            }
        };
        prefsAction.putValue("ShortDescription", NLS.str("menu.preferences"));
        prefsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 192));
        AbstractAction exitAction = new AbstractAction(NLS.str("file.exit"), ICON_CLOSE){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.dispose();
            }
        };
        this.isFlattenPackage = this.settings.isFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten"), ICON_FLAT_PKG);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        AbstractAction syncAction = new AbstractAction(NLS.str("menu.sync"), ICON_SYNC){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        };
        syncAction.putValue("ShortDescription", NLS.str("menu.sync"));
        syncAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 128));
        AbstractAction textSearchAction = new AbstractAction(NLS.str("menu.text_search"), ICON_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, true).setVisible(true);
            }
        };
        textSearchAction.putValue("ShortDescription", NLS.str("menu.text_search"));
        textSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 192));
        AbstractAction clsSearchAction = new AbstractAction(NLS.str("menu.class_search"), ICON_FIND){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog(MainWindow.this, false).setVisible(true);
            }
        };
        clsSearchAction.putValue("ShortDescription", NLS.str("menu.class_search"));
        clsSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
        AbstractAction deobfAction = new AbstractAction(NLS.str("menu.deobfuscation"), ICON_DEOBF){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleDeobfuscation();
            }
        };
        deobfAction.putValue("ShortDescription", NLS.str("preferences.deobfuscation"));
        deobfAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 640));
        this.deobfToggleBtn = new JToggleButton(deobfAction);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.deobfToggleBtn.setText("");
        this.deobfMenuItem = new JCheckBoxMenuItem(deobfAction);
        this.deobfMenuItem.setState(this.settings.isDeobfuscationOn());
        AbstractAction logAction = new AbstractAction(NLS.str("menu.log"), ICON_LOG){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LogViewer(MainWindow.this).setVisible(true);
            }
        };
        logAction.putValue("ShortDescription", NLS.str("menu.log"));
        logAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 192));
        AbstractAction aboutAction = new AbstractAction(NLS.str("menu.about")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog().setVisible(true);
            }
        };
        AbstractAction backAction = new AbstractAction(NLS.str("nav.back"), ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navBack();
            }
        };
        backAction.putValue("ShortDescription", NLS.str("nav.back"));
        backAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 640));
        AbstractAction forwardAction = new AbstractAction(NLS.str("nav.forward"), ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navForward();
            }
        };
        forwardAction.putValue("ShortDescription", NLS.str("nav.forward"));
        forwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 640));
        JMenu file = new JMenu(NLS.str("menu.file"));
        file.setMnemonic(70);
        file.add(openAction);
        file.add(saveAllAction);
        file.add(exportAction);
        file.addSeparator();
        file.add(recentFiles);
        file.addSeparator();
        file.add(prefsAction);
        file.addSeparator();
        file.add(exitAction);
        JMenu view = new JMenu(NLS.str("menu.view"));
        view.setMnemonic(86);
        view.add(this.flatPkgMenuItem);
        view.add(syncAction);
        JMenu nav = new JMenu(NLS.str("menu.navigation"));
        nav.setMnemonic(78);
        nav.add(textSearchAction);
        nav.add(clsSearchAction);
        nav.addSeparator();
        nav.add(backAction);
        nav.add(forwardAction);
        JMenu tools = new JMenu(NLS.str("menu.tools"));
        tools.setMnemonic(84);
        tools.add(this.deobfMenuItem);
        tools.add(logAction);
        JMenu help = new JMenu(NLS.str("menu.help"));
        help.setMnemonic(72);
        help.add(aboutAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(nav);
        menuBar.add(tools);
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = e -> this.toggleFlattenPackage();
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten"));
        this.updateLink = new Link("", "https://github.com/skylot/jadx/releases");
        this.updateLink.setVisible(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(openAction);
        toolbar.add(saveAllAction);
        toolbar.add(exportAction);
        toolbar.addSeparator();
        toolbar.add(syncAction);
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        toolbar.add(textSearchAction);
        toolbar.add(clsSearchAction);
        toolbar.addSeparator();
        toolbar.add(backAction);
        toolbar.add(forwardAction);
        toolbar.addSeparator();
        toolbar.add(this.deobfToggleBtn);
        toolbar.addSeparator();
        toolbar.add(logAction);
        toolbar.addSeparator();
        toolbar.add(prefsAction);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.15);
        this.mainPanel.add(splitPane);
        DefaultMutableTreeNode treeRootNode = new DefaultMutableTreeNode(NLS.str("msg.open_file"));
        this.treeModel = new DefaultTreeModel(treeRootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainWindow.this.treeClickAction();
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.treeClickAction();
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    this.setIcon(((JNode)value).getIcon());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JLoadableNode) {
                    ((JLoadableNode)node).loadNode();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.progressPane = new ProgressPanel(this, true);
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.add((Component)new JScrollPane(this.tree), "Center");
        leftPane.add((Component)this.progressPane, "Last");
        splitPane.setLeftComponent(leftPane);
        this.tabbedPane = new TabbedPane(this);
        splitPane.setRightComponent(this.tabbedPane);
        new DropTarget(this, 1, new MainDropTarget(this));
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    public void setLocationAndPosition() {
        if (this.settings.loadWindowPos(this)) {
            return;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        this.setLocation((int)((double)w * 0.15), (int)((double)h * 0.15));
        this.setSize((int)((double)w * 0.7), (int)((double)h * 0.7));
    }

    public void updateFont(Font font) {
        this.setFont(font);
    }

    public void setEditorTheme(String editorThemePath) {
        try {
            this.editorTheme = Theme.load((InputStream)this.getClass().getResourceAsStream(editorThemePath));
        }
        catch (Exception e) {
            LOG.error("Can't load editor theme from classpath: {}", (Object)editorThemePath);
            try {
                this.editorTheme = Theme.load((InputStream)new FileInputStream(editorThemePath));
            }
            catch (Exception e2) {
                LOG.error("Can't load editor theme from file: {}", (Object)editorThemePath);
            }
        }
    }

    public Theme getEditorTheme() {
        return this.editorTheme;
    }

    public void loadSettings() {
        this.tabbedPane.loadSettings();
    }

    @Override
    public void dispose() {
        this.settings.saveWindowPos(this);
        this.cancelBackgroundJobs();
        super.dispose();
    }

    public JadxWrapper getWrapper() {
        return this.wrapper;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JadxSettings getSettings() {
        return this.settings;
    }

    public CacheObject getCacheObject() {
        return this.cacheObject;
    }

    public BackgroundWorker getBackgroundWorker() {
        return this.backgroundWorker;
    }

    private class RecentFilesMenuListener
    implements MenuListener {
        private final JMenu recentFiles;

        public RecentFilesMenuListener(JMenu recentFiles) {
            this.recentFiles = recentFiles;
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            this.recentFiles.removeAll();
            File openFile = MainWindow.this.wrapper.getOpenFile();
            String currentFile = openFile == null ? "" : openFile.getAbsolutePath();
            for (String file : MainWindow.this.settings.getRecentFiles()) {
                if (file.equals(currentFile)) continue;
                JMenuItem menuItem = new JMenuItem(file);
                this.recentFiles.add(menuItem);
                menuItem.addActionListener(e -> MainWindow.this.openFile(new File(file)));
            }
            if (this.recentFiles.getItemCount() == 0) {
                this.recentFiles.add(new JMenuItem(NLS.str("menu.no_recent_files")));
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

