"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var log = require("../log");
var spec_1 = require("../spec");
var concat_1 = require("./concat");
var facet_1 = require("./facet");
var layer_1 = require("./layer");
var repeat_1 = require("./repeat");
var unit_1 = require("./unit");
function buildModel(spec, parent, parentGivenName, unitSize, repeater, config, fit) {
    if (spec_1.isFacetSpec(spec)) {
        return new facet_1.FacetModel(spec, parent, parentGivenName, repeater, config);
    }
    if (spec_1.isLayerSpec(spec)) {
        return new layer_1.LayerModel(spec, parent, parentGivenName, unitSize, repeater, config, fit);
    }
    if (spec_1.isUnitSpec(spec)) {
        return new unit_1.UnitModel(spec, parent, parentGivenName, unitSize, repeater, config, fit);
    }
    if (spec_1.isRepeatSpec(spec)) {
        return new repeat_1.RepeatModel(spec, parent, parentGivenName, repeater, config);
    }
    if (spec_1.isConcatSpec(spec)) {
        return new concat_1.ConcatModel(spec, parent, parentGivenName, repeater, config);
    }
    throw new Error(log.message.INVALID_SPEC);
}
exports.buildModel = buildModel;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVpbGRtb2RlbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21waWxlL2J1aWxkbW9kZWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFDQSw0QkFBOEI7QUFDOUIsZ0NBQTJIO0FBQzNILG1DQUFxQztBQUNyQyxpQ0FBbUM7QUFDbkMsaUNBQW1DO0FBRW5DLG1DQUFxQztBQUVyQywrQkFBaUM7QUFFakMsb0JBQTJCLElBQW9CLEVBQUUsTUFBYSxFQUFFLGVBQXVCLEVBQ3JGLFFBQTBCLEVBQUUsUUFBdUIsRUFBRSxNQUFjLEVBQUUsR0FBWTtJQUNqRixJQUFJLGtCQUFXLENBQUMsSUFBSSxDQUFDLEVBQUU7UUFDckIsT0FBTyxJQUFJLGtCQUFVLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxlQUFlLEVBQUUsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO0tBQ3hFO0lBRUQsSUFBSSxrQkFBVyxDQUFDLElBQUksQ0FBQyxFQUFFO1FBQ3JCLE9BQU8sSUFBSSxrQkFBVSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsZUFBZSxFQUFFLFFBQVEsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0tBQ3ZGO0lBRUQsSUFBSSxpQkFBVSxDQUFDLElBQUksQ0FBQyxFQUFFO1FBQ3BCLE9BQU8sSUFBSSxnQkFBUyxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsZUFBZSxFQUFFLFFBQVEsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0tBQ3RGO0lBRUQsSUFBSSxtQkFBWSxDQUFDLElBQUksQ0FBQyxFQUFFO1FBQ3RCLE9BQU8sSUFBSSxvQkFBVyxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsZUFBZSxFQUFFLFFBQVEsRUFBRSxNQUFNLENBQUMsQ0FBQztLQUN6RTtJQUVELElBQUksbUJBQVksQ0FBQyxJQUFJLENBQUMsRUFBRTtRQUN0QixPQUFPLElBQUksb0JBQVcsQ0FBQyxJQUFJLEVBQUUsTUFBTSxFQUFFLGVBQWUsRUFBRSxRQUFRLEVBQUUsTUFBTSxDQUFDLENBQUM7S0FDekU7SUFFRCxNQUFNLElBQUksS0FBSyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7QUFDNUMsQ0FBQztBQXZCRCxnQ0F1QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge0NvbmZpZ30gZnJvbSAnLi4vY29uZmlnJztcbmltcG9ydCAqIGFzIGxvZyBmcm9tICcuLi9sb2cnO1xuaW1wb3J0IHtpc0NvbmNhdFNwZWMsIGlzRmFjZXRTcGVjLCBpc0xheWVyU3BlYywgaXNSZXBlYXRTcGVjLCBpc1VuaXRTcGVjLCBMYXlvdXRTaXplTWl4aW5zLCBOb3JtYWxpemVkU3BlY30gZnJvbSAnLi4vc3BlYyc7XG5pbXBvcnQge0NvbmNhdE1vZGVsfSBmcm9tICcuL2NvbmNhdCc7XG5pbXBvcnQge0ZhY2V0TW9kZWx9IGZyb20gJy4vZmFjZXQnO1xuaW1wb3J0IHtMYXllck1vZGVsfSBmcm9tICcuL2xheWVyJztcbmltcG9ydCB7TW9kZWx9IGZyb20gJy4vbW9kZWwnO1xuaW1wb3J0IHtSZXBlYXRNb2RlbH0gZnJvbSAnLi9yZXBlYXQnO1xuaW1wb3J0IHtSZXBlYXRlclZhbHVlfSBmcm9tICcuL3JlcGVhdGVyJztcbmltcG9ydCB7VW5pdE1vZGVsfSBmcm9tICcuL3VuaXQnO1xuXG5leHBvcnQgZnVuY3Rpb24gYnVpbGRNb2RlbChzcGVjOiBOb3JtYWxpemVkU3BlYywgcGFyZW50OiBNb2RlbCwgcGFyZW50R2l2ZW5OYW1lOiBzdHJpbmcsXG4gIHVuaXRTaXplOiBMYXlvdXRTaXplTWl4aW5zLCByZXBlYXRlcjogUmVwZWF0ZXJWYWx1ZSwgY29uZmlnOiBDb25maWcsIGZpdDogYm9vbGVhbik6IE1vZGVsIHtcbiAgaWYgKGlzRmFjZXRTcGVjKHNwZWMpKSB7XG4gICAgcmV0dXJuIG5ldyBGYWNldE1vZGVsKHNwZWMsIHBhcmVudCwgcGFyZW50R2l2ZW5OYW1lLCByZXBlYXRlciwgY29uZmlnKTtcbiAgfVxuXG4gIGlmIChpc0xheWVyU3BlYyhzcGVjKSkge1xuICAgIHJldHVybiBuZXcgTGF5ZXJNb2RlbChzcGVjLCBwYXJlbnQsIHBhcmVudEdpdmVuTmFtZSwgdW5pdFNpemUsIHJlcGVhdGVyLCBjb25maWcsIGZpdCk7XG4gIH1cblxuICBpZiAoaXNVbml0U3BlYyhzcGVjKSkge1xuICAgIHJldHVybiBuZXcgVW5pdE1vZGVsKHNwZWMsIHBhcmVudCwgcGFyZW50R2l2ZW5OYW1lLCB1bml0U2l6ZSwgcmVwZWF0ZXIsIGNvbmZpZywgZml0KTtcbiAgfVxuXG4gIGlmIChpc1JlcGVhdFNwZWMoc3BlYykpIHtcbiAgICByZXR1cm4gbmV3IFJlcGVhdE1vZGVsKHNwZWMsIHBhcmVudCwgcGFyZW50R2l2ZW5OYW1lLCByZXBlYXRlciwgY29uZmlnKTtcbiAgfVxuXG4gIGlmIChpc0NvbmNhdFNwZWMoc3BlYykpIHtcbiAgICByZXR1cm4gbmV3IENvbmNhdE1vZGVsKHNwZWMsIHBhcmVudCwgcGFyZW50R2l2ZW5OYW1lLCByZXBlYXRlciwgY29uZmlnKTtcbiAgfVxuXG4gIHRocm93IG5ldyBFcnJvcihsb2cubWVzc2FnZS5JTlZBTElEX1NQRUMpO1xufVxuIl19