/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import org.logstash.tcp.Decoder;

public final class InputLoop
implements Runnable,
Closeable {
    private final EventLoopGroup boss;
    private final EventLoopGroup worker = new NioEventLoopGroup();
    private final ChannelFuture future;

    public InputLoop(String host, int port, Decoder decoder, boolean keepAlive) {
        this.boss = new NioEventLoopGroup(1);
        this.future = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.boss, this.worker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).childOption(ChannelOption.SO_KEEPALIVE, keepAlive).childHandler(new InputHandler(decoder)).bind(host, port);
    }

    @Override
    public void run() {
        try {
            this.future.sync().channel().closeFuture().sync();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.boss.shutdownGracefully().sync();
            this.worker.shutdownGracefully().sync();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static final class InputHandler
    extends ChannelInitializer<SocketChannel> {
        private final Decoder decoder;

        InputHandler(Decoder decoder) {
            this.decoder = decoder;
        }

        @Override
        protected void initChannel(SocketChannel channel) throws Exception {
            Decoder localCopy = this.decoder.copy();
            channel.pipeline().addLast(new DecoderAdapter(localCopy));
            channel.closeFuture().addListener(new FlushOnCloseListener(localCopy));
        }

        private static final class DecoderAdapter
        extends ChannelInboundHandlerAdapter {
            private final Decoder decoder;

            DecoderAdapter(Decoder decoder) {
                this.decoder = decoder;
            }

            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.decoder.decode(ctx.channel().remoteAddress(), (ByteBuf)msg);
            }

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                ctx.close();
            }
        }

        private static final class FlushOnCloseListener
        implements GenericFutureListener<Future<Void>> {
            private final Decoder decoder;

            FlushOnCloseListener(Decoder decoder) {
                this.decoder = decoder;
            }

            @Override
            public void operationComplete(Future future) throws Exception {
                this.decoder.flush();
            }
        }
    }
}

