/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.zip.CRC32;
import org.logstash.ackedqueue.Checkpoint;
import org.logstash.ackedqueue.io.CheckpointIO;

public class FileCheckpointIO
implements CheckpointIO {
    public static final int BUFFER_SIZE = 34;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(34);
    private final CRC32 crc32 = new CRC32();
    private static final String HEAD_CHECKPOINT = "checkpoint.head";
    private static final String TAIL_CHECKPOINT = "checkpoint.";
    private final Path dirPath;

    public FileCheckpointIO(Path dirPath) {
        this.dirPath = dirPath;
    }

    @Override
    public Checkpoint read(String fileName) throws IOException {
        return FileCheckpointIO.read(ByteBuffer.wrap(Files.readAllBytes(this.dirPath.resolve(fileName))));
    }

    @Override
    public Checkpoint write(String fileName, int pageNum, int firstUnackedPageNum, long firstUnackedSeqNum, long minSeqNum, int elementCount) throws IOException {
        Checkpoint checkpoint = new Checkpoint(pageNum, firstUnackedPageNum, firstUnackedSeqNum, minSeqNum, elementCount);
        this.write(fileName, checkpoint);
        return checkpoint;
    }

    @Override
    public void write(String fileName, Checkpoint checkpoint) throws IOException {
        this.write(checkpoint, this.buffer);
        this.buffer.flip();
        Path tmpPath = this.dirPath.resolve(fileName + ".tmp");
        try (FileOutputStream out = new FileOutputStream(tmpPath.toFile());){
            out.getChannel().write(this.buffer);
            out.getFD().sync();
        }
        Files.move(tmpPath, this.dirPath.resolve(fileName), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void purge(String fileName) throws IOException {
        Path path = this.dirPath.resolve(fileName);
        Files.delete(path);
    }

    @Override
    public String headFileName() {
        return HEAD_CHECKPOINT;
    }

    @Override
    public String tailFileName(int pageNum) {
        return TAIL_CHECKPOINT + pageNum;
    }

    public static Checkpoint read(ByteBuffer data) throws IOException {
        short version = data.getShort();
        int pageNum = data.getInt();
        int firstUnackedPageNum = data.getInt();
        long firstUnackedSeqNum = data.getLong();
        long minSeqNum = data.getLong();
        int elementCount = data.getInt();
        CRC32 crc32 = new CRC32();
        crc32.update(data.array(), 0, 30);
        int calcCrc32 = (int)crc32.getValue();
        int readCrc32 = data.getInt();
        if (readCrc32 != calcCrc32) {
            throw new IOException(String.format("Checkpoint checksum mismatch, expected: %d, actual: %d", calcCrc32, readCrc32));
        }
        if (version != 1) {
            throw new IOException("Unknown file format version: " + version);
        }
        return new Checkpoint(pageNum, firstUnackedPageNum, firstUnackedSeqNum, minSeqNum, elementCount);
    }

    private void write(Checkpoint checkpoint, ByteBuffer buf) {
        this.crc32.reset();
        buf.clear();
        buf.putShort((short)1);
        buf.putInt(checkpoint.getPageNum());
        buf.putInt(checkpoint.getFirstUnackedPageNum());
        buf.putLong(checkpoint.getFirstUnackedSeqNum());
        buf.putLong(checkpoint.getMinSeqNum());
        buf.putInt(checkpoint.getElementCount());
        buf.flip();
        this.crc32.update(buf);
        buf.position(30).limit(34);
        buf.putInt((int)this.crc32.getValue());
    }
}

