/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.launchers.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StreamUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.helper.JavaCompatibleProperties;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.launchers.LauncherProperties;
import org.netbeans.installer.utils.system.launchers.LauncherResource;
import org.netbeans.installer.utils.system.launchers.impl.CommonLauncher;

public class ShLauncher
extends CommonLauncher {
    public static final String SH_LAUNCHER_STUB_NAME = "launcher.sh";
    public static final String DEFAULT_UNIX_RESOURCE_SUFFIX = "native/launcher/unix/";
    public static final String I18N = "i18n";
    public static final String SH_LAUNCHER_STUB = "native/launcher/unix/launcher.sh";
    public static final String DEFAULT_UNIX_RESOURCE_I18N = "native/launcher/unix/i18n/";
    public static final String DEFAULT_UNIX_RESOURCE_I18N_BUNDLE_NAME = "launcher";
    private static final String SH_EXT = ".sh";
    private static final int SH_BLOCK = 1024;
    private static final String SH_INDENT = "        ";
    private static final String SH_LINE_SEPARATOR = "\n";
    private static final String SH_COMMENT = "#";
    public static final String MIN_JAVA_VERSION_UNIX = "1.5.0_03";
    public static final String MIN_IBM_JAVA_VERSION = "1.5.0";
    private static final String[] JAVA_COMMON_LOCATIONS = new String[]{"/usr/java*", "/usr/java/*", "/usr/jdk*", "/usr/jdk/*", "/usr/j2se", "/usr/j2se/*", "/usr/j2sdk", "/usr/j2sdk/*", "/usr/java/jdk*", "/usr/java/jdk/*", "/usr/jdk/instances", "/usr/jdk/instances/*", "/usr/local/java", "/usr/local/java/*", "/usr/local/jdk*", "/usr/local/jdk/*", "/usr/local/j2se", "/usr/local/j2se/*", "/usr/local/j2sdk", "/usr/local/j2sdk/*", "/opt/java*", "/opt/java/*", "/opt/jdk*", "/opt/jdk/*", "/opt/j2sdk", "/opt/j2sdk/*", "/opt/j2se", "/opt/j2se/*", "/usr/lib/jvm", "/usr/lib/jvm/*", "/usr/lib/jdk*", "/export/jdk*", "/export/jdk/*", "/export/java", "/export/java/*", "/export/j2se", "/export/j2se/*", "/export/j2sdk", "/export/j2sdk/*"};

    public ShLauncher(LauncherProperties props) {
        super(props);
    }

    @Override
    public void initialize() throws IOException {
        LogManager.log("Checking SH launcher parameters...");
        this.checkAllParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File create(Progress progress) throws IOException {
        FileOutputStream fos = null;
        try {
            progress.setPercentage(0);
            long total = this.getBundledFilesSize();
            fos = new FileOutputStream(this.outputFile, false);
            StringBuilder sb = new StringBuilder(this.getStubString());
            this.addShInitialComment(sb);
            this.addPossibleJavaLocations(sb);
            this.addI18NStrings(sb);
            this.addTestJVMFile(sb);
            this.addClasspathJars(sb);
            this.addJavaCompatible(sb);
            this.addOtherResources(sb);
            this.addNumberVariable(sb, "TOTAL_BUNDLED_FILES_SIZE", this.getBundledFilesSize());
            this.addNumberVariable(sb, "TOTAL_BUNDLED_FILES_NUMBER", this.getBundledFilesNumber());
            LogManager.log("Main Class : " + this.mainClass);
            this.addStringVariable(sb, "MAIN_CLASS", this.mainClass);
            LogManager.log("TestJVM Class : " + this.testJVMClass);
            this.addStringVariable(sb, "TEST_JVM_CLASS", this.testJVMClass);
            this.addNumberVariable(sb, "JVM_ARGUMENTS_NUMBER", this.jvmArguments.size());
            int counter = 0;
            for (String arg : this.jvmArguments) {
                this.addStringVariable(sb, "JVM_ARGUMENT_" + counter, this.escapeVarSign(this.escapeSlashes(arg)));
                LogManager.log("... jvm argument [" + counter + "] = " + arg);
                ++counter;
            }
            this.addNumberVariable(sb, "APP_ARGUMENTS_NUMBER", this.appArguments.size());
            counter = 0;
            for (String arg : this.appArguments) {
                this.addStringVariable(sb, "APP_ARGUMENT_" + counter, this.escapeVarSign(this.escapeSlashes(arg)));
                LogManager.log("... app argument [" + counter + "] = " + arg);
                ++counter;
            }
            String token = "_^_^_^_^_^_^_^_^";
            sb.append("LAUNCHER_STUB_SIZE=" + token + SH_LINE_SEPARATOR);
            sb.append("entryPoint \"$@\"\n");
            this.nextLine(sb);
            long size = sb.length();
            long fullBlocks = (size - size % 1024L) / 1024L + 1L;
            String str = Long.toString(fullBlocks);
            int spaces = token.length() - str.length();
            for (int j = 0; j < spaces; ++j) {
                str = str + " ";
            }
            sb.replace(sb.indexOf(token), sb.indexOf(token) + token.length(), str);
            long pads = fullBlocks * 1024L - size;
            for (long i = 0L; i < pads; ++i) {
                sb.append(SH_COMMENT);
            }
            this.addStringBuilder(fos, sb, false);
            this.addBundledData(fos, progress, total);
        }
        catch (IOException ex) {
            LogManager.log(ex);
            try {
                fos.close();
            }
            catch (IOException e) {
                LogManager.log(e);
            }
            try {
                FileUtils.deleteFile(this.outputFile);
            }
            catch (IOException e) {
                LogManager.log(e);
            }
            fos = null;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LogManager.log(ex);
                    throw ex;
                }
            }
            progress.setPercentage(100);
        }
        return this.outputFile;
    }

    @Override
    public String[] getExecutionCommand() {
        return new String[]{this.outputFile.getAbsolutePath()};
    }

    @Override
    public List<JavaCompatibleProperties> getDefaultCompatibleJava(Version version) {
        if (version.equals(Version.getVersion("1.5"))) {
            ArrayList<JavaCompatibleProperties> list = new ArrayList<JavaCompatibleProperties>();
            list.add(new JavaCompatibleProperties(MIN_JAVA_VERSION_UNIX, null, null, null, null));
            list.add(new JavaCompatibleProperties(MIN_IBM_JAVA_VERSION, null, "IBM Corporation", null, null));
            return list;
        }
        return super.getDefaultCompatibleJava(version);
    }

    protected void addOtherResources(StringBuilder sb) throws IOException {
        int counter = 0;
        this.addNumberVariable(sb, "OTHER_RESOURCES_NUMBER", this.otherResources.size());
        for (LauncherResource resource : this.otherResources) {
            this.addLauncherResource(sb, resource, "OTHER_RESOURCE_" + counter);
            ++counter;
        }
    }

    private void addLauncherResource(StringBuilder sb, LauncherResource resource, String id) throws IOException {
        String path;
        long type = resource.getPathType().toLong();
        this.addNumberVariable(sb, id + "_TYPE", type);
        if (resource.isBundled()) {
            long size = resource.getSize();
            path = resource.isBasedOnResource() ? resource.getPathType().getPathString(ResourceUtils.getResourceFileName(resource.getPath())) : resource.getAbsolutePath();
            this.addNumberVariable(sb, id + "_SIZE", size);
            this.addStringVariable(sb, id + "_MD5", resource.getMD5());
        } else {
            path = resource.getAbsolutePath();
        }
        this.addStringVariable(sb, id + "_PATH", this.escapeVarSign(this.escapeSlashesAndChars(path)));
    }

    @Override
    public String getI18NResourcePrefix() {
        return this.i18nPrefix != null ? this.i18nPrefix : DEFAULT_UNIX_RESOURCE_I18N;
    }

    @Override
    public String getI18NBundleBaseName() {
        return this.i18nBundleBaseName != null ? this.i18nBundleBaseName : DEFAULT_UNIX_RESOURCE_I18N_BUNDLE_NAME;
    }

    @Override
    public String getExtension() {
        return SH_EXT;
    }

    private String escapeChars(String str) {
        return str == null ? "" : str.replace(SH_LINE_SEPARATOR, "\\n").replace("\t", "\\\\t").replace("\r", "\\\\r").replace("`", "\\`").replaceAll("\"", "\\\\\"");
    }

    private String escapeSlashesAndChars(String str) {
        return this.escapeSlashes(this.escapeChars(str));
    }

    private String escapeVarSign(String str) {
        return str == null ? "" : str.replace("$", "\\$");
    }

    private String escapeSlashes(String str) {
        return str == null ? "" : str.replace("\\", "\\\\");
    }

    private String getUTF8(String str, boolean changePropertyCounterStyle) throws UnsupportedEncodingException {
        if (!changePropertyCounterStyle) {
            return this.getUTF8(str);
        }
        String string = "";
        int maxCounter = 0;
        while (str.indexOf(this.getJavaCounter(maxCounter)) != -1) {
            ++maxCounter;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean con = false;
            for (int j = 0; j < maxCounter; ++j) {
                String jc = this.getJavaCounter(j);
                if (str.indexOf(jc) != i) continue;
                string = string + "$" + (j + 1);
                i += jc.length();
                con = true;
                break;
            }
            if (con) continue;
            string = string + this.getUTF8(str.substring(i, i + 1));
        }
        return string;
    }

    private String getStubString() throws IOException {
        InputStream stubStream;
        if (this.stubFile != null) {
            this.checkParameter("stub file", this.stubFile);
            stubStream = new FileInputStream(this.stubFile);
        } else {
            stubStream = ResourceUtils.getResource(SH_LAUNCHER_STUB);
        }
        CharSequence cs = StreamUtils.readStream(stubStream);
        stubStream.close();
        Object[] strings = StringUtils.splitByLines(cs);
        String stubString = StringUtils.asString(strings, SH_LINE_SEPARATOR);
        return stubString;
    }

    private String getUTF8(String str) throws UnsupportedEncodingException {
        String repr = "";
        for (byte oneByte : str.getBytes("UTF-8")) {
            repr = repr + "\\" + Integer.toOctalString(256 + oneByte);
        }
        return repr;
    }

    private String changePropertyCounterStyle(String string) {
        String jp;
        int counter = 0;
        String str = string;
        while (str.indexOf(jp = this.getJavaCounter(counter)) != -1) {
            str = str.replace(jp, "$" + (counter + 1));
            ++counter;
        }
        return str;
    }

    private void addVersionVariable(StringBuilder sb, String name, Version version) {
        String str = version != null ? version.toJdkStyle() : "";
        sb.append(name + "=" + "\"" + str + "\"" + SH_LINE_SEPARATOR);
    }

    private void addStringVariable(StringBuilder sb, String name, String value) {
        String str = value != null ? value : "";
        sb.append(name + "=" + "\"" + str + "\"" + SH_LINE_SEPARATOR);
    }

    private void addNumberVariable(StringBuilder sb, String name, long value) {
        sb.append(name + "=" + value + SH_LINE_SEPARATOR);
    }

    private void nextLine(StringBuilder sb) {
        sb.append(SH_LINE_SEPARATOR);
    }

    private void addJavaCompatible(StringBuilder sb) throws IOException {
        this.nextLine(sb);
        LogManager.log("Total compatible java properties : " + this.compatibleJava.size());
        this.addNumberVariable(sb, "JAVA_COMPATIBLE_PROPERTIES_NUMBER", this.compatibleJava.size());
        for (int i = 0; i < this.compatibleJava.size(); ++i) {
            this.nextLine(sb);
            sb.append("setJavaCompatibilityProperties_" + i + "() {" + SH_LINE_SEPARATOR);
            JavaCompatibleProperties prop = (JavaCompatibleProperties)this.compatibleJava.get(i);
            LogManager.log("... adding compatible jvm [" + i + "] : " + prop.toString());
            this.addVersionVariable(sb, "JAVA_COMP_VERSION_MIN", prop.getMinVersion());
            this.addVersionVariable(sb, "JAVA_COMP_VERSION_MAX", prop.getMaxVersion());
            this.addStringVariable(sb, "JAVA_COMP_VENDOR", prop.getVendor());
            this.addStringVariable(sb, "JAVA_COMP_OSNAME", prop.getOsName());
            this.addStringVariable(sb, "JAVA_COMP_OSARCH", prop.getOsArch());
            sb.append("}");
            this.nextLine(sb);
        }
    }

    private void addTestJVMFile(StringBuilder sb) throws IOException {
        this.nextLine(sb);
        this.addLauncherResource(sb, this.testJVMFile, "TEST_JVM_FILE");
    }

    private void addClasspathJars(StringBuilder sb) throws IOException {
        this.nextLine(sb);
        this.addNumberVariable(sb, "JARS_NUMBER", this.jars.size());
        int counter = 0;
        for (LauncherResource jarFile : this.jars) {
            this.addLauncherResource(sb, jarFile, "JAR_" + counter);
            ++counter;
        }
        this.nextLine(sb);
    }

    private void addI18NStrings(StringBuilder sb) throws IOException {
        int i;
        Object[] locales = this.i18nMap.keySet().toArray();
        this.addNumberVariable(sb, "LAUNCHER_LOCALES_NUMBER", locales.length);
        for (i = 0; i < locales.length; ++i) {
            this.addStringVariable(sb, "LAUNCHER_LOCALE_NAME_" + i, locales[i].toString());
        }
        this.nextLine(sb);
        for (i = 0; i < locales.length; ++i) {
            String locale = locales[i].toString();
            sb.append("getLocalizedMessage_" + locale + "() {" + SH_LINE_SEPARATOR);
            sb.append("        arg=$1\n");
            sb.append("        shift\n");
            sb.append("        case $arg in\n");
            PropertyResourceBundle rb = (PropertyResourceBundle)this.i18nMap.get(locales[i]);
            Enumeration<String> en = rb.getKeys();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                String value = rb.getString(name);
                sb.append("        \"" + name + "\")" + SH_LINE_SEPARATOR);
                String printString = value;
                printString = Arrays.equals(printString.getBytes("ISO-8859-1"), printString.getBytes("UTF-8")) ? this.escapeChars(this.changePropertyCounterStyle(printString)) : this.getUTF8(printString, true);
                sb.append("                printf \"" + printString + "\\n" + "\"" + SH_LINE_SEPARATOR);
                sb.append("                ;;\n");
            }
            sb.append("        *)\n");
            sb.append("                printf \"$arg\\n\"\n");
            sb.append("                ;;\n");
            sb.append("        esac\n");
            sb.append("}\n");
            this.nextLine(sb);
        }
    }

    private void addShInitialComment(StringBuilder sb) throws IOException {
        this.nextLine(sb);
        this.nextLine(sb);
        for (int i = 0; i < 80; ++i) {
            sb.append(SH_COMMENT);
        }
        this.nextLine(sb);
        sb.append("# Added by the bundle builder\n");
        this.addNumberVariable(sb, "FILE_BLOCK_SIZE", 1024L);
        this.nextLine(sb);
    }

    private int addJavaPaths(int count, StringBuilder sb, List<LauncherResource> list) throws IOException {
        int counter = count;
        for (LauncherResource location : list) {
            this.addLauncherResource(sb, location, "JAVA_LOCATION_" + counter);
            ++counter;
        }
        return counter;
    }

    private int addJavaPaths(int count, StringBuilder sb, String[] paths) throws IOException {
        ArrayList<LauncherResource> list = new ArrayList<LauncherResource>();
        for (String path : paths) {
            list.add(new LauncherResource(LauncherResource.Type.ABSOLUTE, path));
        }
        return this.addJavaPaths(count, sb, list);
    }

    protected String[] getCommonSystemJavaLocations() {
        return JAVA_COMMON_LOCATIONS;
    }

    private void addPossibleJavaLocations(StringBuilder sb) throws IOException {
        int total = 0;
        total = this.addJavaPaths(total, sb, this.jvms);
        total = this.addJavaPaths(total, sb, this.getCommonSystemJavaLocations());
        this.addNumberVariable(sb, "JAVA_LOCATION_NUMBER", total);
        this.nextLine(sb);
    }

    private void fillWithPads(FileOutputStream fos, long sz) throws IOException {
        long d = (1024L - sz % 1024L) % 1024L;
        int i = 0;
        while ((long)i < d) {
            this.addString(fos, SH_LINE_SEPARATOR, false);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLauncherResourceData(FileOutputStream fos, LauncherResource resource, Progress progress, long total) throws IOException {
        if (resource.isBundled()) {
            LogManager.log("Bundle testJVM file...");
            InputStream is = null;
            try {
                String path = resource.getPath();
                LogManager.log("... path is " + path);
                is = resource.getInputStream();
                this.addData(fos, is, progress, total);
                this.fillWithPads(fos, resource.getSize());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    LogManager.log(ex);
                }
            }
            LogManager.log("... done bundle launcher resource file");
        }
    }

    private void addBundledData(FileOutputStream fos, Progress progress, long total) throws IOException {
        this.addLauncherResourceData(fos, this.testJVMFile, progress, total);
        for (LauncherResource jvm : this.jvms) {
            this.addLauncherResourceData(fos, jvm, progress, total);
        }
        for (LauncherResource jar : this.jars) {
            this.addLauncherResourceData(fos, jar, progress, total);
        }
        for (LauncherResource other : this.otherResources) {
            this.addLauncherResourceData(fos, other, progress, total);
        }
    }
}

