/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class CndPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    protected CndPanelGUI gui;
    protected final Object guiLock = new Object();
    protected final Project project;
    protected final SourceGroup[] folders;
    protected final WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    protected WizardDescriptor wizard;
    private static final String PROHIBITED = "\"$#'*{}[]()";

    public CndPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel) {
        this.folders = folders;
        this.project = project;
        this.bottomPanel = bottomPanel;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isValid() {
        return this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedTarget, targetName);
        Object substitute = this.gui.getClientProperty("NewFileWizard_Title");
        if (substitute != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"LBL_TemplatesPanel_Name"), NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)settings);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(settings.getValue())) {
            return;
        }
        if (!settings.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
            String name;
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)settings);
            }
            if ((name = this.gui.getTargetName()).indexOf(47) > 0) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            FileObject fo = this.getTargetFolderFromGUI();
            try {
                Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)fo);
            }
            catch (IllegalArgumentException iae) {
                ErrorManager.getDefault().annotate((Throwable)iae, 4096, null, NbBundle.getMessage(NewCndFileChooserPanel.class, (String)"MSG_Cannot_Create_Folder", (Object)this.gui.getTargetFolder()), null, null);
                throw iae;
            }
            Templates.setTargetName((WizardDescriptor)settings, (String)name);
            this.doStoreSettings(settings);
        }
        settings.putProperty("NewFileWizard_Title", null);
    }

    protected abstract void doStoreSettings(WizardDescriptor var1);

    @Override
    public void stateChanged(ChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.fireChange();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CndPanel.this.changeSupport.fireChange();
                }
            });
        }
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject targetFolder;
        FileObject rootFolder = this.gui.getTargetGroup().getRootFolder();
        String folderName = this.gui.getTargetFolder();
        String newObject = this.gui.getTargetName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            folderName = folderName == null || "".equals(folderName) ? path : folderName + '/' + path;
        }
        if ((targetFolder = folderName == null || folderName.length() == 0 ? rootFolder : rootFolder.getFileObject(folderName)) == null) {
            try {
                targetFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return targetFolder;
    }

    protected void setInfoMessage(String message) {
        this.wizard.putProperty("WizardPanel_infoMessage", (Object)message);
    }

    protected void setErrorMessage(String message) {
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, boolean allowFileSeparator) {
        String relFileName = folderName + "/" + newObjectName;
        boolean allowSlash = false;
        boolean allowBackslash = false;
        int errorVariant = 0;
        if (allowFileSeparator) {
            char separatorChar = File.separatorChar;
            if (targetFolder != null) {
                separatorChar = FileSystemProvider.getFileSeparatorChar((FileObject)targetFolder);
            }
            if (separatorChar == '\\') {
                errorVariant = 3;
                allowBackslash = true;
                allowSlash = true;
            } else {
                errorVariant = 1;
                allowSlash = true;
            }
        }
        if (!allowSlash && newObjectName.indexOf(47) != -1 || !allowBackslash && newObjectName.indexOf(92) != -1) {
            assert (errorVariant == 0 || errorVariant == 1) : "Invalid error variant: " + errorVariant;
            return NbBundle.getMessage(CndPanel.class, (String)"MSG_not_valid_filename", (Object)newObjectName, (Object)errorVariant);
        }
        if (!CndPanel.isValidName(newObjectName)) {
            return NbBundle.getMessage(CndPanel.class, (String)"MSG_Invalid_File_Name");
        }
        if (targetFolder == null) {
            return NbBundle.getMessage(CndPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!targetFolder.canWrite()) {
            return NbBundle.getMessage(CndPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (CndPanel.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(CndPanel.class, (String)"MSG_file_already_exist", (Object)newObjectName);
        }
        return null;
    }

    static boolean existFileName(FileObject targetFolder, String relFileName) {
        if (targetFolder.isValid()) {
            FileObject fo = targetFolder.getFileObject(relFileName);
            return fo != null && fo.isValid();
        }
        return false;
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (!Character.isISOControl(c) && PROHIBITED.indexOf(c) <= -1) continue;
            return false;
        }
        return true;
    }
}

