/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.highlighting;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenChange;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class Highlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private static final Logger LOG = Logger.getLogger(Highlighting.class.getName());
    public static final String LAYER_ID = "org.netbeans.modules.javadoc.highlighting";
    private final AttributeSet fontColor;
    private final Document document;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    public Highlighting(Document doc) {
        AttributeSet firstLineFontColor = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getTokenFontColors("javadoc-first-sentence");
        AttributeSet commentFontColor = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getTokenFontColors("comment");
        if (firstLineFontColor != null && commentFontColor != null) {
            LinkedList<Object> attrs = new LinkedList<Object>();
            Enumeration<?> e = firstLineFontColor.getAttributeNames();
            while (e.hasMoreElements()) {
                Object value;
                Object key = e.nextElement();
                if (commentFontColor.containsAttribute(key, value = firstLineFontColor.getAttribute(key))) continue;
                attrs.add(key);
                attrs.add(value);
            }
            this.fontColor = AttributesUtilities.createImmutable((Object[])attrs.toArray());
        } else {
            this.fontColor = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[0]);
            LOG.warning("FontColorSettings for javadoc-first-sentence or comment are not available.");
        }
        this.document = doc;
        this.hierarchy = TokenHierarchy.get((Document)this.document);
        if (this.hierarchy != null) {
            this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        Highlighting highlighting = this;
        synchronized (highlighting) {
            if (this.hierarchy.isActive()) {
                return new HSImpl(this.version, this.hierarchy, startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        TokenChange tc = evt.tokenChange();
        int[] affectedArea = null;
        TokenSequence seq = tc.currentTokenSequence();
        if (seq.language().equals((Object)JavadocTokenId.language())) {
            int[] firstSentence = this.findFirstSentence((TokenSequence<? extends TokenId>)seq);
            if (firstSentence != null) {
                if (tc.offset() <= firstSentence[1]) {
                    affectedArea = firstSentence;
                }
            } else {
                affectedArea = new int[]{tc.offset(), evt.affectedEndOffset()};
            }
        } else {
            affectedArea = new int[]{tc.offset(), evt.affectedEndOffset()};
        }
        if (affectedArea != null) {
            Highlighting highlighting = this;
            synchronized (highlighting) {
                ++this.version;
            }
            this.fireHighlightsChange(affectedArea[0], affectedArea[1]);
        }
    }

    private int[] findFirstSentence(TokenSequence<? extends TokenId> seq) {
        seq.moveStart();
        if (seq.moveNext()) {
            int start = seq.offset();
            do {
                if (seq.token().id() == JavadocTokenId.DOT) {
                    if (!seq.moveNext()) continue;
                    if (Highlighting.isWhiteSpace((Token<? extends TokenId>)seq.token())) {
                        return new int[]{start, seq.offset()};
                    }
                    seq.movePrevious();
                    continue;
                }
                if (seq.token().id() != JavadocTokenId.TAG) continue;
                if (seq.movePrevious() && !seq.token().text().toString().trim().endsWith("{")) {
                    return new int[]{start, seq.offset()};
                }
                seq.moveNext();
            } while (seq.moveNext());
        }
        return null;
    }

    private static boolean isWhiteSpace(Token<? extends TokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        String ws = " \t\n";
        return ws.indexOf(token.text().charAt(0)) >= 0;
    }

    private final class HSImpl
    implements HighlightsSequence {
        private long version;
        private TokenHierarchy<? extends Document> scanner;
        private List<TokenSequence<? extends TokenId>> sequences;
        private int startOffset;
        private int endOffset;
        private List<Integer> lines = null;
        private int linesIdx = -1;

        public HSImpl(long version, TokenHierarchy<? extends Document> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sequences = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            Highlighting highlighting = Highlighting.this;
            synchronized (highlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    TokenSequence tokenSequence = this.scanner.tokenSequence();
                    if (tokenSequence == null) {
                        return false;
                    }
                    TokenSequence seq = tokenSequence.subSequence(this.startOffset, this.endOffset);
                    this.sequences = new ArrayList<TokenSequence<? extends TokenId>>();
                    this.sequences.add((TokenSequence<? extends TokenId>)seq);
                }
                if (this.lines != null) {
                    if (this.linesIdx + 2 < this.lines.size()) {
                        this.linesIdx += 2;
                        return true;
                    }
                    this.lines = null;
                    this.linesIdx = -1;
                }
                while (!this.sequences.isEmpty()) {
                    boolean hasNextToken;
                    TokenSequence<? extends TokenId> seq = this.sequences.get(this.sequences.size() - 1);
                    if (seq.language().equals((Object)JavadocTokenId.language())) {
                        int[] firstSentence = Highlighting.this.findFirstSentence((TokenSequence<? extends TokenId>)seq);
                        this.sequences.remove(this.sequences.size() - 1);
                        if (firstSentence == null) continue;
                        this.lines = this.splitByLines(firstSentence[0], firstSentence[1]);
                        if (this.lines == null) continue;
                        this.linesIdx = 0;
                        return true;
                    }
                    while (hasNextToken = seq.moveNext()) {
                        TokenSequence embeddedSeq = seq.embedded();
                        if (embeddedSeq == null) continue;
                        this.sequences.add(this.sequences.size(), (TokenSequence<? extends TokenId>)embeddedSeq);
                        break;
                    }
                    if (hasNextToken) continue;
                    this.sequences.remove(this.sequences.size() - 1);
                }
                return false;
            }
        }

        public int getStartOffset() {
            Highlighting highlighting = Highlighting.this;
            synchronized (highlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.lines != null) {
                    return this.lines.get(this.linesIdx);
                }
                throw new NoSuchElementException();
            }
        }

        public int getEndOffset() {
            Highlighting highlighting = Highlighting.this;
            synchronized (highlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.lines != null) {
                    return this.lines.get(this.linesIdx + 1);
                }
                throw new NoSuchElementException();
            }
        }

        public AttributeSet getAttributes() {
            Highlighting highlighting = Highlighting.this;
            synchronized (highlighting) {
                this.checkVersion();
                if (this.sequences == null) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.lines != null) {
                    return Highlighting.this.fontColor;
                }
                throw new NoSuchElementException();
            }
        }

        private void checkVersion() {
            if (this.version != Highlighting.this.version) {
                throw new ConcurrentModificationException();
            }
        }

        private List<Integer> splitByLines(int sentenceStart, int sentenceEnd) {
            ArrayList<Integer> lines = new ArrayList<Integer>();
            int offset = sentenceStart;
            try {
                while (offset < sentenceEnd) {
                    int idx;
                    Element lineElement = Highlighting.this.document.getDefaultRootElement().getElement(Highlighting.this.document.getDefaultRootElement().getElementIndex(offset));
                    int rowStart = offset == sentenceStart ? offset : lineElement.getStartOffset();
                    int rowEnd = lineElement.getEndOffset();
                    String line = Highlighting.this.document.getText(rowStart, rowEnd - rowStart);
                    for (idx = 0; idx < line.length() && (line.charAt(idx) == ' ' || line.charAt(idx) == '\t' || line.charAt(idx) == '*'); ++idx) {
                    }
                    if (rowStart + idx < rowEnd) {
                        lines.add(rowStart + idx);
                        lines.add(Math.min(rowEnd, sentenceEnd));
                    }
                    offset = rowEnd + 1;
                }
            }
            catch (BadLocationException e) {
                LOG.log(Level.WARNING, "Can't determine javadoc first sentence", e);
            }
            return lines.isEmpty() ? null : lines;
        }
    }
}

