/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class WebFragmentProvider {
    private static final Logger LOG = Logger.getLogger(WebFragmentProvider.class.getName());
    private static WebFragmentProvider instance;

    private WebFragmentProvider() {
    }

    public static WebFragmentProvider getDefault() {
        if (instance == null) {
            instance = new WebFragmentProvider();
        }
        return instance;
    }

    public WebFragment getWebFragmentRoot(FileObject fo) throws IOException, FileNotFoundException {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        try {
            String version = WebParseUtils.getVersion(fo);
            SAXParseException error = WebParseUtils.parse(fo);
            if (error != null) {
                throw error;
            }
            return this.createWebFragment(fo, version);
        }
        catch (SAXException ex) {
            LOG.log(Level.INFO, "Parsing failed!", ex);
            throw new IOException("Parsing failed: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebFragment createWebFragment(FileObject fo, String version) throws IOException, SAXException {
        try {
            if ("3.0".equals(version)) {
                InputStream inputStream = fo.getInputStream();
                try {
                    org.netbeans.modules.j2ee.dd.impl.web.model_3_0_frag.WebFragment webFragment = org.netbeans.modules.j2ee.dd.impl.web.model_3_0_frag.WebFragment.createGraph(inputStream);
                    return webFragment;
                }
                finally {
                    inputStream.close();
                }
            }
            if (!"3.1".equals(version)) throw new IOException("Unsupported version of web-fragment.xml found! Version: " + version);
            InputStream inputStream = fo.getInputStream();
            try {
                org.netbeans.modules.j2ee.dd.impl.web.model_3_1_frag.WebFragment webFragment = org.netbeans.modules.j2ee.dd.impl.web.model_3_1_frag.WebFragment.createGraph(inputStream);
                return webFragment;
            }
            finally {
                inputStream.close();
            }
        }
        catch (RuntimeException ex) {
            throw new SAXException(ex);
        }
    }
}

