/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;

public final class TypeResolverImpl
implements TypeResolver {
    private static final Logger LOG = Logger.getLogger(TypeResolverImpl.class.getName());
    private final String typeName;

    public static Set<TypeResolver> parseTypes(String typeSignature) {
        HashSet<TypeResolver> retval = new HashSet<TypeResolver>();
        if (typeSignature != null && typeSignature.length() > 0) {
            String regexp = String.format("\\%s", PhpElementImpl.Separator.PIPE.toString());
            for (String typeName : typeSignature.split(regexp)) {
                String encodedTypeName;
                if (TypeResolverImpl.isResolvedImpl(typeName)) {
                    encodedTypeName = ParameterElementImpl.encode(typeName);
                } else {
                    EnumSet<PhpElementImpl.Separator> separators = PhpElementImpl.Separator.toEnumSet();
                    separators.remove((Object)PhpElementImpl.Separator.COLON);
                    encodedTypeName = ParameterElementImpl.encode(typeName, separators);
                }
                if (typeName.equals(encodedTypeName)) {
                    retval.add(new TypeResolverImpl(typeName));
                    continue;
                }
                TypeResolverImpl.log(String.format("wrong typename: \"%s\" parsed from \"%s\"", typeSignature, typeName), Level.FINE);
            }
        }
        return retval;
    }

    public static Set<TypeResolver> forNames(Collection<QualifiedName> names) {
        HashSet<TypeResolver> retval = new HashSet<TypeResolver>();
        for (QualifiedName qualifiedName : names) {
            String typeName = qualifiedName.toString();
            if (typeName.equals(ParameterElementImpl.encode(typeName))) {
                retval.add(new TypeResolverImpl(typeName));
                continue;
            }
            TypeResolverImpl.log(String.format("wrong typename: \"%s\"", typeName), Level.FINE);
        }
        return retval;
    }

    TypeResolverImpl(String semiTypeName) {
        this.typeName = semiTypeName;
    }

    public String getSignature() {
        return this.getRawTypeName();
    }

    @Override
    public boolean isResolved() {
        return TypeResolverImpl.isResolvedImpl(this.typeName);
    }

    private static boolean isResolvedImpl(String typeName) {
        return typeName != null && !VariousUtils.isSemiType(typeName);
    }

    @Override
    public boolean canBeResolved() {
        return this.isResolved();
    }

    @Override
    public synchronized QualifiedName getTypeName(boolean resolve) {
        return this.isResolved() ? QualifiedName.create(this.typeName) : null;
    }

    @Override
    public String getRawTypeName() {
        return this.typeName;
    }

    private static void log(String message, Level level) {
        if (LOG.isLoggable(level)) {
            LOG.log(level, message);
        }
    }
}

