/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FormalParameter
extends ASTNode {
    private Expression parameterType;
    private Expression parameterName;
    private Expression defaultValue;

    public FormalParameter(int start, int end, Expression type, Expression parameterName, Expression defaultValue) {
        super(start, end);
        this.parameterName = parameterName;
        this.parameterType = type;
        this.defaultValue = defaultValue;
    }

    public FormalParameter(int start, int end, Expression type, Reference parameterName, Expression defaultValue) {
        this(start, end, type, (Expression)parameterName, defaultValue);
    }

    public FormalParameter(int start, int end, Expression type, Expression parameterName) {
        this(start, end, type, parameterName, null);
    }

    public FormalParameter(int start, int end, Expression type, Reference parameterName) {
        this(start, end, type, (Expression)parameterName, null);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.getDefaultValue() == null && !this.isVariadic();
    }

    public boolean isOptional() {
        return !this.isMandatory();
    }

    public boolean isVariadic() {
        if (this.isReference()) {
            return ((Reference)this.getParameterName()).getExpression() instanceof Variadic;
        }
        return this.getParameterName() instanceof Variadic;
    }

    public boolean isReference() {
        return this.getParameterName() instanceof Reference;
    }

    public Expression getParameterName() {
        return this.parameterName;
    }

    public Expression getParameterType() {
        return this.parameterType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getParameterType() + " " + this.getParameterName() + (this.isMandatory() ? "" : " = " + this.getDefaultValue());
    }
}

