/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String[] artifactTypes;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;
    private static final String LAST_USED_ARTIFACT_FOLDER = "lastUsedArtifactFolder";

    public AntArtifactChooser(String[] artifactTypes, JFileChooser chooser) {
        this.artifactTypes = artifactTypes;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        chooser.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.jLabelName.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        this.jLabelJarFiles.setLabelFor(this.jListArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJarFiles, (String)NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelJarFiles, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        this.jListArtifacts.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            File dir = chooser.getSelectedFile();
            Project project = this.getProject(dir);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File projectDir) {
        if (projectDir == null) {
            return null;
        }
        try {
            File normProjectDir = FileUtil.normalizeFile((File)projectDir);
            FileObject fo = FileUtil.toFileObject((File)normProjectDir);
            if (fo != null) {
                return ProjectManager.getDefault().findProject(fo);
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel model = (DefaultListModel)this.jListArtifacts.getModel();
        model.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            ArrayList<AntArtifact> artifacts = new ArrayList<AntArtifact>();
            for (int i = 0; i < this.artifactTypes.length; ++i) {
                artifacts.addAll(Arrays.asList(AntArtifactQuery.findArtifactsByType((Project)project, (String)this.artifactTypes[i])));
            }
            for (AntArtifact artifact : artifacts) {
                URI[] uris = artifact.getArtifactLocations();
                for (int y = 0; y < uris.length; ++y) {
                    model.addElement(new AntArtifactItem(artifact, uris[y]));
                }
            }
            this.jListArtifacts.setSelectionInterval(0, model.size());
        }
    }

    static AntArtifactItem[] showDialog(String[] artifactTypes, Project master, Component parent) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        chooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AntArtifactChooser.class, (String)"AD_AACH_SelectProject"));
        AntArtifactChooser accessory = new AntArtifactChooser(artifactTypes, chooser);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 380));
        File defaultFolder = null;
        FileObject defFo = master.getProjectDirectory();
        if (defFo != null && (defFo = defFo.getParent()) != null) {
            defaultFolder = FileUtil.toFile((FileObject)defFo);
        }
        chooser.setCurrentDirectory(AntArtifactChooser.getLastUsedArtifactFolder(defaultFolder));
        int option = chooser.showOpenDialog(parent);
        if (option == 0) {
            File dir = chooser.getSelectedFile();
            Project selectedProject = accessory.getProject(dir = FileUtil.normalizeFile((File)dir));
            if (selectedProject == null) {
                return null;
            }
            if (selectedProject.getProjectDirectory().equals(master.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_RefToItself"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)master, (Project)selectedProject)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                return null;
            }
            boolean noSuitableOutput = true;
            for (String type : artifactTypes) {
                if (AntArtifactQuery.findArtifactsByType((Project)selectedProject, (String)type).length <= 0) continue;
                noSuitableOutput = false;
                break;
            }
            if (noSuitableOutput) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_NO_JAR_OUTPUT")));
                return null;
            }
            AntArtifactChooser.setLastUsedArtifactFolder(FileUtil.normalizeFile((File)chooser.getCurrentDirectory()));
            Object[] tmp = new Object[accessory.jListArtifacts.getModel().getSize()];
            int count = 0;
            for (int i = 0; i < tmp.length; ++i) {
                if (!accessory.jListArtifacts.isSelectedIndex(i)) continue;
                tmp[count] = accessory.jListArtifacts.getModel().getElementAt(i);
                ++count;
            }
            AntArtifactItem[] artifactItems = new AntArtifactItem[count];
            System.arraycopy(tmp, 0, artifactItems, 0, count);
            return artifactItems;
        }
        return null;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(AntArtifactChooser.class);
    }

    private static File getLastUsedArtifactFolder(File defaultValue) {
        String val = AntArtifactChooser.getPreferences().get(LAST_USED_ARTIFACT_FOLDER, null);
        if (val != null) {
            return FileUtil.normalizeFile((File)new File(val));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return FileUtil.normalizeFile((File)new File(System.getProperty("user.home")));
    }

    private static void setLastUsedArtifactFolder(File folder) {
        assert (folder != null) : "Folder can not be null";
        String path = folder.getAbsolutePath();
        AntArtifactChooser.getPreferences().put(LAST_USED_ARTIFACT_FOLDER, path);
    }
}

