/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.AbstractParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;

public class ListTypeTreeNode
extends AbstractParameterTreeNode {
    private URLClassLoader urlClassLoader;

    public ListTypeTreeNode(TypeNodeData userObject, URLClassLoader inClassLoader) {
        super(userObject);
        this.urlClassLoader = inClassLoader;
    }

    @Override
    public void updateValueFromChildren(TypeNodeData inData) {
        TypeNodeData data = (TypeNodeData)this.getUserObject();
        Collection c = (Collection)data.getTypeValue();
        if (c == null) {
            return;
        }
        c.clear();
        for (int ii = 0; ii < this.getChildCount(); ++ii) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.getChildAt(ii);
            TypeNodeData childData = (TypeNodeData)childNode.getUserObject();
            if (null == childData.getTypeValue()) continue;
            c.add(childData.getTypeValue());
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getParent();
        if (parentNode != null && parentNode instanceof ParameterTreeNode) {
            ((ParameterTreeNode)((Object)parentNode)).updateValueFromChildren(data);
        }
    }

    @Override
    public void updateChildren() {
        TypeNodeData thisData = (TypeNodeData)this.getUserObject();
        Collection childCollection = (Collection)thisData.getTypeValue();
        this.removeAllChildren();
        String structureType = thisData.getGenericType();
        if (structureType == null || structureType.length() == 0) {
            structureType = "java.lang.Object";
        }
        Iterator iter = childCollection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DefaultMutableTreeNode childNode;
            TypeNodeData data = ReflectionHelper.createTypeData(structureType, "[" + i + "]", iter.next());
            data.setAssignable(thisData.isAssignable());
            if (ReflectionHelper.isComplexType(data.getTypeClass(), this.urlClassLoader)) {
                childNode = new StructureTypeTreeNode(data, this.urlClassLoader);
                ((StructureTypeTreeNode)childNode).updateChildren();
                this.add(childNode);
            } else if (ReflectionHelper.isCollection(data.getTypeClass(), this.urlClassLoader)) {
                childNode = new ListTypeTreeNode(data, this.urlClassLoader);
                ((ListTypeTreeNode)childNode).updateChildren();
                this.add(childNode);
            } else {
                childNode = new DefaultMutableTreeNode(data);
                this.add(childNode);
            }
            ++i;
        }
    }
}

