/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ProjectActionEvent {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private final Project project;
    private final Type type;
    private String executable;
    private volatile MakeConfiguration configuration;
    private final String configurationName;
    private final RunProfile profile;
    private final boolean wait;
    private final Lookup context;
    private boolean isFinalExecutable;
    private String[] runCommandCache = null;
    private static ResourceBundle bundle;

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait) {
        this(project, type, executable, configuration, profile, wait, Lookup.EMPTY);
    }

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait, Lookup context) {
        this.project = project;
        this.type = type;
        this.executable = executable;
        this.configuration = configuration;
        this.configurationName = configuration.getName();
        this.profile = profile;
        this.wait = wait;
        this.context = context;
        if ((type == PredefinedType.PRE_BUILD || type == PredefinedType.BUILD || type == PredefinedType.COMPILE_SINGLE || type == PredefinedType.CLEAN || type == PredefinedType.BUILD_TESTS || type == PredefinedType.TEST) && profile != null && profile.getConsoleType().getValue() != 2) assert (false) : type + " must not be run in " + profile.getConsoleType().getName() + " use OutputWindow instead";
    }

    public Project getProject() {
        return this.project;
    }

    public final Lookup getContext() {
        return this.context;
    }

    public Type getType() {
        return this.type;
    }

    public String getActionName() {
        Type myType = (Type)this.getContext().lookup(Type.class);
        if (myType != null) {
            return myType.getLocalizedName();
        }
        return this.type.getLocalizedName();
    }

    private String getExecutableFromRunCommand() {
        ExecutionEnvironment execEnv;
        PlatformInfo pi;
        String qualifiedCommand;
        String[] runCommand = this.getRunCommand();
        if (runCommand.length == 0) {
            return "";
        }
        String command = runCommand[0];
        if (!FileSystemProvider.isAbsolute((String)command) && !command.contains("/") && (qualifiedCommand = (pi = PlatformInfo.getDefault((ExecutionEnvironment)(execEnv = this.getConfiguration().getDevelopmentHost().getExecutionEnvironment()))).findCommand(command)) != null) {
            command = qualifiedCommand;
        }
        return command;
    }

    public String getExecutable() {
        String result;
        if (this.type == PredefinedType.RUN || this.type == PredefinedType.DEBUG || this.type == PredefinedType.DEBUG_STEPINTO) {
            result = this.getExecutableFromRunCommand();
            if (result != null && result.length() > 0) {
                ExecutionEnvironment execEnv = this.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                if (!CndPathUtilities.isPathAbsolute((CharSequence)result)) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)"getExecutableFromRunCommand() returned non-absolute path", (Object)result);
                    String baseDir = this.getConfiguration().getProfile().getRunDirectory();
                    if (execEnv.isRemote()) {
                        PathMap mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)this.getProject());
                        if (mapper != null) {
                            if ((baseDir = mapper.getRemotePath(baseDir, true)) == null) {
                                baseDir = this.getConfiguration().getProfile().getRunDirectory();
                            }
                        } else {
                            LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{this.getProject(), baseDir});
                        }
                    }
                    result = baseDir + FileSystemProvider.getFileSeparatorChar((ExecutionEnvironment)execEnv) + result;
                }
                result = FileSystemProvider.normalizeAbsolutePath((String)result, (ExecutionEnvironment)execEnv);
            }
        } else {
            result = this.executable;
        }
        return result;
    }

    public String getRunCommandAsString() {
        PathMap mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)this.getProject());
        return ProjectActionEvent.getRunCommandAsString(this.getProfile().getRunCommand().getValue(), this.getConfiguration(), mapper);
    }

    public static String getRunCommandAsString(String command, MakeConfiguration configuration, PathMap mapper) {
        String outputValue = "";
        if (!configuration.isLibraryConfiguration() && configuration.getOutputValue().length() > 0) {
            outputValue = configuration.getAbsoluteOutputValue();
        }
        if (configuration.getPlatformInfo().isLocalhost()) {
            command = CndPathUtilities.expandAllMacroses((String)command, (String)"${OUTPUT_PATH}", (String)outputValue);
        } else {
            if (!outputValue.isEmpty()) {
                if (mapper != null) {
                    String aValue = mapper.getRemotePath(outputValue, true);
                    if (aValue != null) {
                        outputValue = aValue;
                    }
                } else {
                    LOGGER.log(Level.SEVERE, "Path Mapper not found for the project - using local path {0}", new Object[]{outputValue});
                }
            }
            command = CndPathUtilities.expandAllMacroses((String)command, (String)"${OUTPUT_PATH}", (String)outputValue);
        }
        return configuration.expandMacros(command);
    }

    private String[] getRunCommand() {
        if (this.runCommandCache == null || this.runCommandCache.length == 0) {
            assert (this.getConfiguration().getPlatformInfo().isLocalhost() == this.getConfiguration().getDevelopmentHost().isLocalhost());
            this.runCommandCache = Utilities.parseParameters((String)this.getRunCommandAsString());
        }
        return this.runCommandCache;
    }

    public ArrayList<String> getArguments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.type == PredefinedType.RUN) {
            String[] params = this.getRunCommand();
            if (params.length > 1) {
                result.addAll(Arrays.asList(Arrays.copyOfRange(params, 1, params.length)));
            }
        } else if (this.type == PredefinedType.DEBUG || this.type == PredefinedType.DEBUG_STEPINTO) {
            result.addAll(Arrays.asList(this.getProfile().getArgsArray()));
        } else {
            result.addAll(Arrays.asList(this.getProfile().getArgsArray()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MakeConfiguration getConfiguration() {
        String string = this.configurationName;
        synchronized (string) {
            Configuration conf;
            MakeConfigurationDescriptor cd;
            ConfigurationDescriptorProvider pdp;
            if (!this.configuration.isValid() && (pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && (cd = pdp.getConfigurationDescriptor()) != null && (conf = cd.getConfs().getConf(this.configurationName)) != null && conf.isValid()) {
                this.configuration = (MakeConfiguration)conf;
            }
            return this.configuration;
        }
    }

    public RunProfile getProfile() {
        if (this.profile != null) {
            return this.profile;
        }
        return this.getConfiguration().getProfile();
    }

    public boolean getWait() {
        return this.wait;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setFinalExecutable() {
        this.isFinalExecutable = true;
    }

    boolean isFinalExecutable() {
        return this.isFinalExecutable || this.type == PredefinedType.RUN;
    }

    public String toString() {
        return "PAE " + this.type + " " + this.getActionName() + " exec: " + this.getExecutable();
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ProjectActionEvent.class);
        }
        return bundle.getString(s);
    }

    public static enum PredefinedType implements Type
    {
        PRE_BUILD("PreBuild"),
        BUILD("Build"),
        COMPILE_SINGLE("CompileSingle"),
        CLEAN("Clean"),
        RUN("Run"),
        DEBUG("Debug"),
        DEBUG_STEPINTO("Debug"),
        DEBUG_TEST("Debug"),
        DEBUG_STEPINTO_TEST("Debug"),
        ATTACH("Attach"),
        CHECK_EXECUTABLE("CheckExecutable"),
        CUSTOM_ACTION("Custom"),
        BUILD_TESTS("BuildTests"),
        TEST("Test");

        private final String localizedName;

        private PredefinedType(String resourceNamePrefix) {
            this.localizedName = ProjectActionEvent.getString(resourceNamePrefix + "ActionName");
        }

        @Override
        public String getLocalizedName() {
            return this.localizedName;
        }

        @Override
        public void setLocalizedName(String name) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Type {
        public int ordinal();

        public String name();

        public String getLocalizedName();

        public void setLocalizedName(String var1);
    }
}

