/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;

public class Item
implements NativeFileItem,
PropertyChangeListener {
    protected static final Logger LOG = Logger.getLogger("makeproject.folder");
    private final CharSequence path;
    protected Folder folder;
    protected FileObject file = null;
    protected final FileSystem fileSystem;
    private final CharSequence normalizedPath;

    protected Item(FileObject baseDirFileObject, String path) {
        try {
            this.fileSystem = baseDirFileObject.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
        String absPath = CndPathUtilities.toAbsolutePath((FileObject)baseDirFileObject, (String)path);
        this.normalizedPath = FilePathCache.getManager().getString(CharSequences.create((CharSequence)FileSystemProvider.normalizeAbsolutePath((String)absPath, (FileSystem)this.fileSystem)));
        this.path = FilePathCache.getManager().getString(CharSequences.create((CharSequence)CndPathUtilities.normalizeSlashes((String)path)));
    }

    protected Item(FileSystem fileSystem, String path) {
        CndUtils.assertNotNull((Object)path, (String)"Path should not be null");
        this.path = FilePathCache.getManager().getString(CharSequences.create((CharSequence)path));
        this.fileSystem = fileSystem;
        this.normalizedPath = null;
        this.folder = null;
    }

    protected void rename(String newname, boolean nameWithoutExtension) {
        String oldname;
        if (newname == null || newname.length() == 0 || this.getFolder() == null) {
            return;
        }
        if (CharSequenceUtils.contentEquals((CharSequence)this.path, (CharSequence)newname)) {
            return;
        }
        int indexName = CharSequenceUtils.lastIndexOf((CharSequence)this.path, (int)47);
        indexName = indexName < 0 ? 0 : ++indexName;
        int indexDot = CharSequenceUtils.lastIndexOf((CharSequence)this.path, (int)46);
        if (indexDot < indexName || !nameWithoutExtension) {
            indexDot = -1;
        }
        if ((oldname = indexDot >= 0 ? this.path.toString().substring(indexName, indexDot) : this.path.toString().substring(indexName)).equals(newname)) {
            return;
        }
        String newPath = "";
        if (indexName > 0) {
            newPath = this.path.toString().substring(0, indexName);
        }
        newPath = newPath + newname;
        if (indexDot >= 0) {
            newPath = newPath + this.path.toString().substring(indexDot);
        }
        this.renameTo(newPath);
    }

    protected void renameTo(String newPath) {
        Folder f = this.getFolder();
        String oldPath = this.normalizedPath != null ? this.normalizedPath.toString() : CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)this.getAbsPath());
        Item item = f.addItem(ItemFactory.getDefault().createInFileSystem(this.fileSystem, newPath));
        if (item != null && item.getFolder() != null) {
            if (item.getFolder().isProjectFiles()) {
                Item.copyItemConfigurations(this, item);
            }
            f.removeItem(this);
            f.renameItemAction(oldPath, item);
        }
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getAbsolutePath() {
        return this.getNormalizedPath();
    }

    public String getSortName() {
        return this.getName();
    }

    public String getName() {
        return CndPathUtilities.getBaseName((String)this.path.toString());
    }

    public String getPath(boolean norm) {
        String pat = "./";
        if (norm && this.getPath().startsWith(pat)) {
            return this.getPath().substring(2);
        }
        return this.getPath();
    }

    public String getAbsPath() {
        String retPath = null;
        if (CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)this.getPath())) {
            retPath = this.getPath();
        } else if (this.getFolder() != null) {
            retPath = this.getFolder().getConfigurationDescriptor().getBaseDir() + '/' + this.getPath();
        }
        return retPath;
    }

    public void setFolder(Folder folder) {
        if (folder == null && this.file == null) {
            this.ensureFileNotNull();
        }
        this.folder = folder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            String newName = (String)evt.getNewValue();
            boolean nameWithoutExtension = true;
            this.rename(newName, nameWithoutExtension);
        } else if (evt.getPropertyName().equals("valid")) {
            Folder containingFolder;
            if (!((Boolean)evt.getNewValue()).booleanValue() && (containingFolder = this.getFolder()) != null) {
                containingFolder.refresh(this);
            }
        } else if (evt.getPropertyName().equals("primaryFile") && this.getFolder() != null) {
            FileObject fo = (FileObject)evt.getNewValue();
            String newPath = fo.getPath();
            if (!CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)this.getPath())) {
                newPath = CndPathUtilities.toRelativePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)newPath);
            }
            newPath = CndPathUtilities.normalizeSlashes((String)newPath);
            this.renameTo(newPath);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public FSPath getFSPath() {
        return new FSPath(this.fileSystem, this.getNormalizedPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNormalizedPath() {
        Item item = this;
        synchronized (item) {
            if (this.normalizedPath != null) {
                return this.normalizedPath.toString();
            }
        }
        String absPath = this.getAbsPath();
        return FileSystemProvider.normalizeAbsolutePath((String)absPath, (FileSystem)this.fileSystem);
    }

    public String getCanonicalPath() {
        FileObject canonicalFile = this.getCanonicalFile();
        if (canonicalFile != null) {
            return canonicalFile.getPath();
        }
        return this.getNormalizedPath();
    }

    protected void ensureFileNotNull() {
        if (this.file == null) {
            try {
                this.file = CndFileUtils.getCanonicalFileObject((FileObject)this.getFileObject());
            }
            catch (IOException ioe) {
                this.file = this.getFSPath().getFileObject();
            }
        }
        if (this.file == null) {
            LOG.log(Level.SEVERE, "Can not resolve file {0}", this.getAbsPath());
        }
    }

    public FileObject getCanonicalFile() {
        this.ensureFileNotNull();
        return this.file;
    }

    public String getId() {
        return this.getPath();
    }

    public ItemConfiguration getItemConfiguration(Configuration configuration) {
        if (configuration != null) {
            return (ItemConfiguration)configuration.getAuxObject(this.getId());
        }
        return null;
    }

    public ItemConfiguration[] getItemConfigurations() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return new ItemConfiguration[0];
        }
        Configuration[] configurations = makeConfigurationDescriptor.getConfs().toArray();
        ItemConfiguration[] itemConfigurations = new ItemConfiguration[configurations.length];
        for (int i = 0; i < configurations.length; ++i) {
            itemConfigurations[i] = this.getItemConfiguration(configurations[i]);
        }
        return itemConfigurations;
    }

    public void copyConfigurations(Item src) {
        if (src.getFolder() == null) {
            return;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getFolder().getConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return;
        }
        for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
            ItemConfiguration srcItemConfiguration = src.getItemConfiguration(conf);
            ItemConfiguration dstItemConfiguration = this.getItemConfiguration(conf);
            if (srcItemConfiguration == null || dstItemConfiguration == null) continue;
            dstItemConfiguration.assignValues(srcItemConfiguration);
        }
    }

    private static void copyItemConfigurations(Item src, Item dst) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = src.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            for (Configuration conf : makeConfigurationDescriptor.getConfs().toArray()) {
                ItemConfiguration newConf = new ItemConfiguration(conf, dst);
                newConf.assignValues(src.getItemConfiguration(conf));
                conf.addAuxObject(newConf);
            }
        }
    }

    public FileObject getFileObject() {
        FileObject fo = this.getFileObjectImpl();
        if (fo == null) {
            String p = this.normalizedPath != null ? this.normalizedPath.toString() : this.getAbsPath();
            return InvalidFileObjectSupport.getInvalidFileObject((FileSystem)this.fileSystem, (CharSequence)p);
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject getFileObjectImpl() {
        FileObject fileObject;
        PerformanceLogger.PerformaceAction performanceEvent;
        block5: {
            performanceEvent = PerformanceLogger.getLogger().start("GET_ITEM_FILE_OBJECT_PERFORMANCE_EVENT", (Object)this);
            fileObject = null;
            try {
                performanceEvent.setTimeOut(30);
                if (this.normalizedPath != null) {
                    fileObject = this.fileSystem.findResource(this.normalizedPath.toString());
                    break block5;
                }
                Folder f = this.getFolder();
                if (f == null) {
                    String p = this.getPath();
                    if (CndPathUtilities.isPathAbsolute((FileSystem)this.fileSystem, (String)p)) {
                        p = FileSystemProvider.normalizeAbsolutePath((String)p, (FileSystem)this.fileSystem);
                        fileObject = this.fileSystem.findResource(p);
                    }
                    break block5;
                }
                MakeConfigurationDescriptor cfgDescr = f.getConfigurationDescriptor();
                FileObject baseDirFO = cfgDescr.getBaseDirFileObject();
                fileObject = RemoteFileUtil.getFileObject((FileObject)baseDirFO, (String)this.getPath());
            }
            catch (Throwable throwable) {
                performanceEvent.log(new Object[]{fileObject});
                throw throwable;
            }
        }
        performanceEvent.log(new Object[]{fileObject});
        return fileObject;
    }

    public void onOpen() {
    }

    protected void onClose() {
    }

    public String getMIMEType() {
        FileObject fobj = this.getFileObjectImpl();
        String mimeType = fobj == null || !fobj.isValid() ? MIMESupport.getKnownSourceFileMIMETypeByExtension((String)this.getName()) : MIMESupport.getSourceFileMIMEType((FileObject)fobj);
        return mimeType;
    }

    public PredefinedToolKind getDefaultTool() {
        FileObject fobj;
        String mimeType = this.getMIMEType();
        PredefinedToolKind tool = "text/x-c".equals(mimeType) ? PredefinedToolKind.CCompiler : ("text/x-h".equals(mimeType) ? PredefinedToolKind.CustomTool : ("text/x-c++".equals(mimeType) ? PredefinedToolKind.CCCompiler : ("text/x-fortran".equals(mimeType) ? PredefinedToolKind.FortranCompiler : ("text/x-asm".equals(mimeType) ? ((fobj = this.getFileObjectImpl()) != null && "il".equals(fobj.getExt()) ? PredefinedToolKind.CustomTool : PredefinedToolKind.Assembler) : PredefinedToolKind.CustomTool))));
        return tool;
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        if (this.getFolder() == null) {
            return null;
        }
        return this.getFolder().getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor == null) {
            return null;
        }
        return makeConfigurationDescriptor.getActiveConfiguration();
    }

    public NativeProject getNativeProject() {
        Project project;
        Folder curFolder = this.getFolder();
        if (curFolder != null && (project = curFolder.getProject()) != null) {
            return (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return null;
    }

    public List<IncludePath> getSystemIncludePaths() {
        ArrayList<IncludePath> vec = new ArrayList<IncludePath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(IncludePath.toIncludePathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(this.getImportantFlags())));
            } else {
                String importantFlags = NativeProjectProvider.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(IncludePath.toIncludePathList((FileSystem)fs, (Collection)compiler.getSystemIncludeDirectories(importantFlags)));
            }
        }
        return NativeProjectProvider.SPI_ACCESSOR.expandIncludePaths(vec, compilerConfiguration, compiler, makeConfiguration);
    }

    public List<FSPath> getSystemIncludeHeaders() {
        ArrayList<FSPath> vec = new ArrayList<FSPath>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)compiler.getExecutionEnvironment());
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeHeaders(this.getImportantFlags())));
            } else {
                String importantFlags = NativeProjectProvider.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)compiler.getSystemIncludeHeaders(importantFlags)));
            }
        }
        return vec;
    }

    public List<IncludePath> getUserIncludePaths() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return Collections.emptyList();
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return Collections.emptyList();
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                list.add(((CCCCompilerConfiguration)master).getIncludeDirectories().getValue());
                if (((CCCCompilerConfiguration)master).getInheritIncludes().getValue()) continue;
                break;
            }
            ArrayList vec2 = new ArrayList();
            for (int i = list.size() - 1; i >= 0; --i) {
                vec2.addAll((Collection)list.get(i));
            }
            ExecutionEnvironment env = compiler.getExecutionEnvironment();
            NativeProjectProvider.MacroConverter macroConverter = null;
            FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
            FileSystem projectFS = this.fileSystem;
            ArrayList<IncludePath> result = new ArrayList<IncludePath>();
            for (String p : vec2) {
                boolean compilerContext = false;
                if (p.contains("$")) {
                    if (macroConverter == null) {
                        macroConverter = new NativeProjectProvider.MacroConverter(env);
                    }
                    p = macroConverter.expand(p);
                    compilerContext = true;
                }
                if (p.startsWith("///")) {
                    compilerContext = true;
                }
                if (compilerContext && CndPathUtilities.isPathAbsolute((FileSystem)compilerFS, (String)p)) {
                    result.add(IncludePath.toIncludePath((FileSystem)compilerFS, (String)p));
                    continue;
                }
                if (CndPathUtilities.isPathAbsolute((FileSystem)projectFS, (String)p)) {
                    result.add(IncludePath.toIncludePath((FileSystem)projectFS, (String)p));
                    continue;
                }
                String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
                result.add(IncludePath.toIncludePath((FileSystem)projectFS, (String)absPath));
            }
            List<IncludePath> vec3 = new ArrayList<IncludePath>();
            vec3 = NativeProjectProvider.SPI_ACCESSOR.getItemUserIncludePaths(vec3, cccCompilerConfiguration, compiler, makeConfiguration);
            result.addAll(vec3);
            return NativeProjectProvider.SPI_ACCESSOR.expandIncludePaths(result, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return Collections.emptyList();
    }

    public List<FSPath> getIncludeFiles() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return Collections.emptyList();
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return Collections.emptyList();
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                list.add(((CCCCompilerConfiguration)master).getIncludeFiles().getValue());
                if (((CCCCompilerConfiguration)master).getInheritFiles().getValue()) continue;
                break;
            }
            ArrayList vec2 = new ArrayList();
            for (int i = list.size() - 1; i >= 0; --i) {
                vec2.addAll((Collection)list.get(i));
            }
            ExecutionEnvironment env = compiler.getExecutionEnvironment();
            FileSystem compilerFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
            FileSystem projectFS = this.fileSystem;
            NativeProjectProvider.MacroConverter macroConverter = null;
            ArrayList<FSPath> result = new ArrayList<FSPath>();
            for (String p : vec2) {
                boolean compilerContext = false;
                if (p.contains("$")) {
                    if (macroConverter == null) {
                        macroConverter = new NativeProjectProvider.MacroConverter(env);
                    }
                    p = macroConverter.expand(p);
                    compilerContext = true;
                }
                if (p.startsWith("///")) {
                    compilerContext = true;
                }
                if (compilerContext && CndPathUtilities.isPathAbsolute((FileSystem)compilerFS, (String)p)) {
                    result.add(new FSPath(compilerFS, p));
                    continue;
                }
                if (CndPathUtilities.isPathAbsolute((FileSystem)projectFS, (String)p)) {
                    result.add(new FSPath(projectFS, p));
                    continue;
                }
                String absPath = CndPathUtilities.toAbsolutePath((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)p);
                result.add(new FSPath(projectFS, absPath));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<String> getCompilerPreprocessorSymbols() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            vec.addAll(compiler.getSystemPreprocessorSymbols());
        }
        return vec;
    }

    public List<String> getSystemMacroDefinitions() {
        List<String> undefinedMacros;
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0) {
            if (makeConfiguration.isMakefileConfiguration()) {
                vec.addAll(compiler.getSystemPreprocessorSymbols(this.getImportantFlags()));
            } else {
                String importantFlags = NativeProjectProvider.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration);
                vec.addAll(compiler.getSystemPreprocessorSymbols(importantFlags));
            }
        }
        if ((undefinedMacros = this.getUndefinedMacros()).size() > 0) {
            ArrayList<String> out = new ArrayList<String>();
            for (String macro : vec) {
                boolean remove = true;
                for (String undef : undefinedMacros) {
                    if (!macro.equals(undef) && !macro.startsWith(undef + "=")) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                out.add(macro);
            }
            vec = out;
        }
        return vec;
    }

    public List<String> getUserMacroDefinitions() {
        List<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            if (cccCompilerConfiguration.getInheritPreprocessor().getValue()) {
                for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(false)) {
                    this.addToMap(res, ((CCCCompilerConfiguration)master).getPreprocessorConfiguration().getValue(), false);
                    if (((CCCCompilerConfiguration)master).getInheritPreprocessor().getValue()) continue;
                    break;
                }
            }
            this.addToMap(res, cccCompilerConfiguration.getPreprocessorConfiguration().getValue(), true);
            this.addToList(res, vec);
            vec = NativeProjectProvider.SPI_ACCESSOR.getItemUserMacros(vec, cccCompilerConfiguration, compiler, makeConfiguration);
        }
        return vec;
    }

    public List<String> getUndefinedMacros() {
        ArrayList<String> vec = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return vec;
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return vec;
        }
        AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            for (BasicCompilerConfiguration master : cccCompilerConfiguration.getMasters(true)) {
                vec.addAll(((CCCCompilerConfiguration)master).getUndefinedPreprocessorConfiguration().getValue());
                if (((CCCCompilerConfiguration)master).getInheritUndefinedPreprocessor().getValue()) continue;
                break;
            }
        }
        return vec;
    }

    public String getImportantFlags() {
        String res = this.getImportantFlagsImpl();
        if (res.isEmpty()) {
            NativeFileItem.LanguageFlavor languageFlavor = this.getLanguageFlavor();
            switch (languageFlavor) {
                case C11: {
                    res = "-std=c11";
                    break;
                }
                case CPP11: {
                    res = "-std=c++11";
                    break;
                }
                case CPP14: {
                    res = "-std=c++14";
                    break;
                }
            }
        }
        return res;
    }

    private String getImportantFlagsImpl() {
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        ItemConfiguration itemConfiguration = this.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return "";
        }
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return "";
        }
        if (makeConfiguration.isMakefileConfiguration()) {
            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
            if (compilerConfiguration instanceof CCCCompilerConfiguration) {
                CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
                return cccCompilerConfiguration.getImportantFlags().getValue();
            }
        } else {
            String importantFlags;
            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
            if (compilerConfiguration instanceof CCCCompilerConfiguration && compiler != null && compiler.getPath() != null && compiler.getPath().length() > 0 && (importantFlags = NativeProjectProvider.SPI_ACCESSOR.getImportantFlags(compilerConfiguration, compiler, makeConfiguration)) != null) {
                return importantFlags;
            }
        }
        return "";
    }

    private void addToMap(Map<String, String> res, List<String> list, boolean override) {
        list.forEach(macro -> {
            String value;
            String key;
            int i = macro.indexOf(61);
            if (i > 0) {
                key = macro.substring(0, i).trim();
                value = macro.substring(i + 1).trim();
            } else {
                key = macro;
                value = null;
            }
            if (!res.containsKey(key) || override) {
                res.put(key, value);
            }
        });
    }

    private void addToList(Map<String, String> res, List<String> list) {
        res.entrySet().forEach(e -> {
            if (e.getValue() == null) {
                list.add((String)e.getKey());
            } else {
                list.add((String)e.getKey() + "=" + (String)e.getValue());
            }
        });
    }

    public boolean hasHeaderOrSourceExtension(boolean cFiles, boolean ccFiles) {
        String mimeType = this.getMIMEType();
        return "text/x-h".equals(mimeType) || ccFiles && "text/x-c++".equals(mimeType) || cFiles && "text/x-c".equals(mimeType);
    }

    public NativeFileItem.Language getLanguage() {
        PredefinedToolKind tool;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        NativeFileItem.Language language = (tool = itemConfiguration != null ? itemConfiguration.getTool() : this.getDefaultTool()) == PredefinedToolKind.CCompiler ? NativeFileItem.Language.C : (tool == PredefinedToolKind.CCCompiler ? NativeFileItem.Language.CPP : (tool == PredefinedToolKind.FortranCompiler ? NativeFileItem.Language.FORTRAN : (this.hasHeaderOrSourceExtension(true, true) ? NativeFileItem.Language.C_HEADER : NativeFileItem.Language.OTHER)));
        return language;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        CCCompilerConfiguration ccCompilerConfiguration;
        NativeFileItem.LanguageFlavor flavor = NativeFileItem.LanguageFlavor.UNKNOWN;
        ItemConfiguration itemConfiguration = null;
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            itemConfiguration = this.getItemConfiguration(makeConfiguration);
        }
        if (itemConfiguration != null && itemConfiguration.isCompilerToolConfiguration()) {
            Tool tool;
            Object compilerSet;
            flavor = itemConfiguration.getLanguageFlavor();
            if ((flavor == NativeFileItem.LanguageFlavor.UNKNOWN || flavor == NativeFileItem.LanguageFlavor.DEFAULT) && (compilerSet = makeConfiguration.getCompilerSet().getCompilerSet()) != null && (tool = compilerSet.getTool((ToolKind)itemConfiguration.getTool())) instanceof AbstractCompiler) {
                NativeFileItem.LanguageFlavor aFlavor;
                BasicCompilerConfiguration compilerConfiguration;
                AbstractCompiler compiler = (AbstractCompiler)tool;
                if (itemConfiguration.isCompilerToolConfiguration() && (compilerConfiguration = itemConfiguration.getCompilerConfiguration()) != null && (aFlavor = NativeProjectProvider.SPI_ACCESSOR.getLanguageFlavor(compilerConfiguration, compiler, makeConfiguration)) != NativeFileItem.LanguageFlavor.UNKNOWN) {
                    flavor = aFlavor;
                }
            }
            if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN) {
                if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                    switch (itemConfiguration.getCCompilerConfiguration().getInheritedCStandard()) {
                        case 2: {
                            return NativeFileItem.LanguageFlavor.C99;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.C11;
                        }
                        case 1: {
                            return NativeFileItem.LanguageFlavor.C89;
                        }
                        case 0: {
                            for (String macro : this.getCompilerPreprocessorSymbols()) {
                                if (macro.startsWith("_STDC_C99=")) {
                                    return NativeFileItem.LanguageFlavor.C99;
                                }
                                if (!macro.startsWith("_STDC_C11=")) continue;
                                return NativeFileItem.LanguageFlavor.C11;
                            }
                            return NativeFileItem.LanguageFlavor.C89;
                        }
                    }
                } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                    switch (itemConfiguration.getCCCompilerConfiguration().getInheritedCppStandard()) {
                        case 2: {
                            return NativeFileItem.LanguageFlavor.CPP11;
                        }
                        case 3: {
                            return NativeFileItem.LanguageFlavor.CPP14;
                        }
                        case 1: {
                            return NativeFileItem.LanguageFlavor.CPP;
                        }
                        case 0: {
                            for (String macro : this.getCompilerPreprocessorSymbols()) {
                                if (!macro.startsWith("__cplusplus=")) continue;
                                String year = macro.substring(12);
                                if (year.compareTo("2010") > 0) {
                                    if (year.compareTo("2013") > 0) {
                                        return NativeFileItem.LanguageFlavor.CPP14;
                                    }
                                    return NativeFileItem.LanguageFlavor.CPP11;
                                }
                                return NativeFileItem.LanguageFlavor.CPP;
                            }
                            return NativeFileItem.LanguageFlavor.CPP;
                        }
                    }
                }
            }
        }
        if (flavor == NativeFileItem.LanguageFlavor.UNKNOWN && makeConfiguration != null && (ccCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration()) != null) {
            switch (ccCompilerConfiguration.getInheritedCppStandard()) {
                case 2: {
                    return NativeFileItem.LanguageFlavor.CPP11;
                }
                case 3: {
                    return NativeFileItem.LanguageFlavor.CPP14;
                }
            }
        }
        return flavor;
    }

    public boolean isExcluded() {
        ItemConfiguration itemConfiguration = this.getItemConfiguration(this.getMakeConfiguration());
        if (itemConfiguration != null) {
            boolean value = itemConfiguration.getExcluded().getValue();
            if (value) {
                if (this.getMakeConfiguration().getCodeAssistanceConfiguration().includeInCA(this)) {
                    return false;
                }
            } else if (this.getMakeConfiguration().getCodeAssistanceConfiguration().excludeInCA(this)) {
                return true;
            }
            return value;
        }
        return true;
    }

    int getCRC() {
        int res = 0;
        for (IncludePath includePath : this.getUserIncludePaths()) {
            res += 37 * includePath.getFSPath().hashCode();
        }
        for (FSPath fSPath : this.getIncludeFiles()) {
            res += 37 * fSPath.hashCode();
        }
        for (String string : this.getUserMacroDefinitions()) {
            res += 37 * string.hashCode();
        }
        for (String string : this.getUndefinedMacros()) {
            res += 37 * string.hashCode();
        }
        for (IncludePath includePath : this.getSystemIncludePaths()) {
            res += 37 * includePath.getFSPath().hashCode();
        }
        for (FSPath fSPath : this.getSystemIncludeHeaders()) {
            res += 37 * fSPath.getPath().hashCode();
        }
        for (String string : this.getSystemMacroDefinitions()) {
            res += 37 * string.hashCode();
        }
        res += 37 * this.getLanguage().hashCode();
        return res += 37 * this.getLanguageFlavor().hashCode();
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean hasImportantAttributes() {
        for (ItemConfiguration conf : this.getItemConfigurations()) {
            if (conf == null || conf.isDefaultConfiguration()) continue;
            return true;
        }
        return false;
    }

    protected void onAddedToFolder(Folder folder) {
    }

    public static abstract class ItemFactory {
        private static final ItemFactory DEFAULT = new Default();
        private static ItemFactory defaultFactory;

        protected ItemFactory() {
        }

        public static ItemFactory getDefault() {
            if (defaultFactory != null) {
                return defaultFactory;
            }
            defaultFactory = (ItemFactory)Lookup.getDefault().lookup(ItemFactory.class);
            return defaultFactory == null ? DEFAULT : defaultFactory;
        }

        public abstract Item createInBaseDir(FileObject var1, String var2);

        public abstract Item createInFileSystem(FileSystem var1, String var2);

        public abstract Item createDetachedViewItem(FileSystem var1, String var2);

        private static final class Default
        extends ItemFactory {
            private Default() {
            }

            @Override
            public Item createInBaseDir(FileObject baseDirFileObject, String path) {
                return new Item(baseDirFileObject, path);
            }

            @Override
            public Item createInFileSystem(FileSystem fileSystem, String path) {
                return new Item(fileSystem, path);
            }

            @Override
            public Item createDetachedViewItem(FileSystem fileSystem, String path) {
                CndUtils.assertNonUiThread();
                Item out = new Item(fileSystem, path);
                return out;
            }
        }
    }
}

