/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.netbeans.junit.Manager;

public final class NbModuleLogHandler
extends Handler {
    private static StringBuffer text;
    private static Level msg;
    private static Level exc;
    private static final List<String> hexes;
    private static final String integerToHexString = "[0-9a-fA-F]{5,8}";
    private static final Pattern hex;
    private static final AtomicInteger ignoreOOME;

    public static Test registerBuffer(Level msg, Level exc) {
        if (msg == null) {
            msg = Level.OFF;
        }
        if (exc == null) {
            exc = Level.OFF;
        }
        if (exc == Level.OFF && msg == Level.OFF) {
            return null;
        }
        NbModuleLogHandler.msg = msg;
        NbModuleLogHandler.exc = exc;
        text = new StringBuffer();
        Logger l = Logger.getLogger("");
        Level min = msg;
        if (min.intValue() > exc.intValue()) {
            min = exc;
        }
        l.setLevel(min);
        return new FailOnException(msg, exc);
    }

    public static void finish() {
        text = null;
    }

    public static StringBuffer toString(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(record.getLoggerName());
        sb.append("] THREAD: ");
        sb.append(Thread.currentThread().getName());
        sb.append(" MSG: ");
        String txt = record.getMessage();
        ResourceBundle b = record.getResourceBundle();
        if (b != null) {
            try {
                txt = b.getString(txt);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (txt != null && record.getParameters() != null) {
            txt = MessageFormat.format(txt, record.getParameters());
        }
        sb.append(txt);
        Throwable t = record.getThrown();
        if (t != null) {
            sb.append('\n');
            StringWriter w = new StringWriter();
            t.printStackTrace(new PrintWriter(w));
            sb.append(w.toString().replace("\tat ", "  ").replace("\t... ", "  ... "));
        }
        sb.append('\n');
        return sb;
    }

    public static synchronized String normalize(StringBuffer txt, String workDirPath) {
        Matcher m = hex.matcher(txt.toString().replace(workDirPath, "WORKDIR"));
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            String id = m.group().toLowerCase(Locale.ENGLISH);
            int i = hexes.indexOf(id);
            if (i == -1) {
                i = hexes.size();
                hexes.add(id);
            }
            m.appendReplacement(b, Integer.toHexString(i));
        }
        m.appendTail(b);
        return b.toString();
    }

    public static void whileIgnoringOOME(Runnable run) {
        ignoreOOME.incrementAndGet();
        try {
            run.run();
        }
        finally {
            ignoreOOME.decrementAndGet();
        }
    }

    @Override
    public void publish(LogRecord record) {
        StringBuffer t = text;
        if (t == null) {
            return;
        }
        if (record.getThrown() != null) {
            if (ignoreOOME.get() > 0 && record.getThrown() instanceof OutOfMemoryError) {
                return;
            }
            if (exc.intValue() <= record.getLevel().intValue()) {
                t.append(NbModuleLogHandler.toString(record));
            }
        } else if (msg.intValue() <= record.getLevel().intValue()) {
            t.append(NbModuleLogHandler.toString(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFailures(TestCase test, TestResult res, String workDirPath) {
        StringBuffer t = text;
        if (t == null) {
            return;
        }
        StringBuffer stringBuffer = t;
        synchronized (stringBuffer) {
            if (t.length() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("NbModuleSuite has been started with failOnMessage(");
                sb.append(msg);
                sb.append(") and failOnException(").append(exc);
                sb.append("). The following failures have been captured:\n");
                sb.append(NbModuleLogHandler.normalize(text, workDirPath));
                res.addFailure((Test)test, new AssertionFailedError(sb.toString()));
                t.setLength(0);
            }
        }
    }

    static {
        hexes = new ArrayList<String>();
        hex = Pattern.compile("(?<=@(?:[0-9a-fA-F]{5,8}:)?)[0-9a-fA-F]{5,8}");
        ignoreOOME = new AtomicInteger();
    }

    private static final class FailOnException
    extends TestCase {
        private final Level msg;
        private final Level exc;

        private FailOnException(Level msg, Level exc) {
            super("testNoWarningsReportedDuringExecution");
            this.msg = msg;
            this.exc = exc;
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult res) {
            NbModuleLogHandler.checkFailures(this, res, Manager.getWorkDirPath());
        }
    }
}

