/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy;

public final class Packet {
    public static final short NO_FLAGS = 0;
    public static final short REPLY = 128;
    public static final short REPLY_NO_ERROR = 0;
    private static int uID = -2147483647;
    static final byte[] nullData = new byte[0];
    int id = Packet.uniqID();
    short flags = 0;
    short commandSet;
    short command;
    short errorCode;
    byte[] data = new byte[1024];
    volatile boolean replied = false;
    int readIndex = 0;
    int writeIndex = 0;

    public static synchronized int uniqID() {
        return uID++;
    }

    public boolean hasFlags() {
        return this.flags != 0;
    }

    public boolean isReplyPacket() {
        return (this.flags & 0x80) != 0;
    }

    public int getLength() {
        return this.writeIndex;
    }

    public void setData(byte[] byArray) {
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        this.writeIndex = byArray.length;
        this.readIndex = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.commandSet).append("/").append(this.command).append("/").append(this.errorCode).append("\n--->\n");
        for (byte by : this.data) {
            stringBuffer.append(Integer.toHexString((int)((long)by & 0xFFL))).append(".");
        }
        stringBuffer.append("\n<----\n");
        return stringBuffer.toString();
    }
}

