/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SymbolTable;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.jrefmask.AppletTable;
import com.sun.javacard.jcasm.mask.jrefmask.CardMemory;
import com.sun.javacard.jcasm.mask.jrefmask.ExceptionInfo;
import com.sun.javacard.jcasm.mask.jrefmask.MethodFormatter;
import com.sun.javacard.jcasm.mask.jrefmask.ObjectTable;
import com.sun.javacard.jcasm.mask.jrefmask.TransactionBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class PersistentState {
    CardMemory cardMemoryInfo;
    ObjectTable objectInfo;
    TransactionBuffer transactionBufferInfo;
    AppletTable maskAppletInfo;
    ExceptionInfo maskExceptionInfo;
    com.sun.javacard.jcasm.mask.jrefmask.SymbolTable maskSymbols;
    static short nativeToken;
    Vector<String> suppressionVector;
    Vector<ExportComponent> exportVector;
    protected PackageDirectory packageDirectory;
    private static final int ARRAY_HEADER_SIZE = 6;
    private Properties mappingTable;

    public PersistentState(Properties properties) {
        String string;
        int n = 0;
        this.objectInfo = new ObjectTable();
        this.transactionBufferInfo = new TransactionBuffer();
        this.maskAppletInfo = new AppletTable();
        this.maskExceptionInfo = new ExceptionInfo();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        this.exportVector = new Vector();
        this.mappingTable = properties;
        try {
            string = (String)this.mappingTable.get("ROMSIZE");
            if (string != null) {
                n = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.warn("jref.3", null);
            ++Globals.errors;
        }
        this.cardMemoryInfo = new CardMemory(n);
        string = (String)this.mappingTable.get("NOEXPORTCOMPONENT");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.suppressionVector.addElement(stringTokenizer.nextToken().trim());
            }
        }
    }

    void formatPS(RomMask romMask) {
        this.initializeSymbolTable(romMask);
        this.pass1(romMask);
        if (Globals.errors == 0) {
            this.pass2(romMask);
        }
    }

    void initializeSymbolTable(RomMask romMask) {
        this.maskSymbols = new com.sun.javacard.jcasm.mask.jrefmask.SymbolTable(romMask.getSymbolCount());
    }

    void pass1(RomMask romMask) {
        int n = 0;
        int n2 = this.cardMemoryInfo.getE2Base();
        nativeToken = 0;
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = enumeration.nextElement();
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                Object object2;
                Object object3;
                JCClass jCClass = enumeration2.nextElement();
                jCClass.relocate(n);
                this.maskSymbols.addField("CLASS:" + jCClass.getName(), this.toHexString((short)jCClass.getRelocAddr()));
                String string = (String)this.mappingTable.get(jCClass.getName());
                if (string != null) {
                    this.maskSymbols.addField("CLASS:" + string, this.toHexString((short)jCClass.getRelocAddr()));
                }
                n += jCClass.size();
                if (Modifier.isInterface(jCClass.getAttributes())) continue;
                Enumeration<Member> enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    Object[] objectArray;
                    object3 = enumeration3.nextElement();
                    if (!Modifier.isStatic(((Member)object3).getAttributes())) continue;
                    object2 = ((Field)object3).getDescriptor();
                    if (Modifier.isFinal(((Member)object3).getAttributes()) && ((FieldDescriptor)object2).isPrimitive()) continue;
                    ((Member)object3).relocate(n2);
                    n2 += ((Field)object3).size();
                    this.maskSymbols.addField("FIELD:" + ((Member)object3).getName(), this.toHexString((short)((Member)object3).getRelocAddr()));
                    string = (String)this.mappingTable.get(((Member)object3).getName());
                    if (string != null) {
                        this.maskSymbols.addField("FIELD:" + string, this.toHexString((short)((Member)object3).getRelocAddr()));
                    }
                    if ((object = ((Field)object3).getFieldInitializer()) == null || ((StaticFieldInitializer)object).isPrimitive()) continue;
                    if (jCPackage.appletCount() == 0) {
                        objectArray = new Object[]{((Member)object3).getName(), jCPackage.getName()};
                        Msg.error("mlink.17", objectArray);
                        continue;
                    }
                    objectArray = ((FieldDescriptor)object2).getDescriptorString();
                    int[] nArray = ((StaticFieldInitializer)object).getArrayData();
                    if (objectArray.equals("[B") || objectArray.equals("[Z")) {
                        n2 += 6 + nArray.length;
                        continue;
                    }
                    if (objectArray.equals("[S")) {
                        n2 += 6 + nArray.length * 2;
                        continue;
                    }
                    if (objectArray.equals("[I")) {
                        n2 += 6 + nArray.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
                enumeration3 = jCClass.methodElements();
                while (enumeration3.hasMoreElements()) {
                    object2 = (JCMethod)enumeration3.nextElement();
                    ((Member)object2).relocate(n);
                    n += ((JCMethod)object2).size();
                    if (Modifier.isNative(((Member)object2).getAttributes())) {
                        n += 2;
                        object = ((JCMethod)object2).getMethodIdentifier();
                        ((JCMethod)object2).setNativeToken(nativeToken);
                        object3 = this.toHexString(nativeToken);
                        this.maskSymbols.addField((String)object3, "METHOD:" + ((Member)object2).getName());
                        string = (String)this.mappingTable.get(((Member)object2).getName());
                        if (string != null) {
                            this.maskSymbols.addField(((Member)object2).getName(), string);
                        }
                        nativeToken = (short)(nativeToken + 1);
                    }
                    this.maskSymbols.addField("METHOD:" + ((Member)object2).getName(), this.toHexString((short)((Member)object2).getRelocAddr()));
                    string = (String)this.mappingTable.get(((Member)object2).getName());
                    if (string == null) continue;
                    this.maskSymbols.addField("METHOD:" + string, this.toHexString((short)((Member)object2).getRelocAddr()));
                }
            }
        }
    }

    String toHexString(short s) {
        int n = s & 0xFFFF;
        if (n > 4095) {
            return Integer.toHexString(n);
        }
        if (n > 255) {
            return "0" + Integer.toHexString(n);
        }
        if (n > 15) {
            return "00" + Integer.toHexString(n);
        }
        return "000" + Integer.toHexString(n);
    }

    void pass2(RomMask romMask) {
        int n = 0;
        Enumeration<JCPackage> enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = enumeration.nextElement();
            PackageIdentifier packageIdentifier = jCPackage.getIdentifier();
            this.packageDirectory.addPackage(packageIdentifier);
            boolean bl = this.suppressionVector.contains(jCPackage.getName());
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            Enumeration<JCClass> enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                JCClass jCClass = enumeration2.nextElement();
                byte[] byArray = jCClass.toByteArray();
                if (!Modifier.isInterface(jCClass.getAttributes())) {
                    byte by = 0;
                    for (object = jCClass; object != null; object = ((JCClass)object).getSuperClass()) {
                        by = (byte)(by + (byte)((JCClass)object).getInstanceSize());
                    }
                    byArray[3] = by;
                }
                this.cardMemoryInfo.addToRom(byArray);
                this.outputE2(packageIdentifier, jCClass, romMask);
                object = jCClass.methodElements();
                while (object.hasMoreElements()) {
                    JCMethod jCMethod = (JCMethod)object.nextElement();
                    MethodFormatter methodFormatter = new MethodFormatter(jCMethod);
                    byte[] byArray2 = methodFormatter.toByteArray();
                    this.cardMemoryInfo.addToRom(byArray2);
                    if (jCMethod.getExceptionTable() == null) continue;
                    this.maskExceptionInfo.addmethodExceptionInfo(jCMethod.getExceptionTable().toByteArray());
                }
                if (bl) continue;
                exportComponent.add(jCClass);
            }
            this.exportVector.add(exportComponent);
            if (jCPackage.appletCount() > 0) {
                jCPackage.resolveAppletInstallAddrs(romMask.getMethodSymbolTable());
                this.maskAppletInfo.addAppletData(jCPackage.getAppletTableByteArray((byte)n));
            }
            ++n;
        }
        this.maskExceptionInfo.addExcTableToROM(this.cardMemoryInfo);
        this.formatExportOutput();
    }

    void outputE2(PackageIdentifier packageIdentifier, JCClass jCClass, RomMask romMask) {
        Enumeration<Field> enumeration = jCClass.fieldElements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray;
            Field field = enumeration.nextElement();
            int n = field.getAttributes();
            if (!Modifier.isStatic(n)) continue;
            FieldDescriptor fieldDescriptor = field.getDescriptor();
            if (Modifier.isFinal(field.getAttributes()) && fieldDescriptor.isPrimitive()) continue;
            StaticFieldInitializer staticFieldInitializer = field.getFieldInitializer();
            if (staticFieldInitializer != null && staticFieldInitializer.isPrimitive()) {
                byte[] byArray2;
                int n2 = staticFieldInitializer.getPrimitiveData();
                switch (field.size()) {
                    case 1: {
                        byArray2 = new byte[]{(byte)n2};
                        break;
                    }
                    case 2: {
                        byArray2 = new byte[]{(byte)(n2 >> 8), (byte)n2};
                        break;
                    }
                    case 4: {
                        byArray2 = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.cardMemoryInfo.addToE2(byArray2);
                continue;
            }
            if (staticFieldInitializer != null && !staticFieldInitializer.isPrimitive()) {
                int n3;
                byte[] byArray3;
                int n4 = field.getRelocAddr() + 2;
                byte[] byArray4 = new byte[]{(byte)(n4 >> 8), (byte)n4};
                this.cardMemoryInfo.addToE2(byArray4);
                SymbolTable<Object, JCClass> symbolTable = romMask.getClassSymbolTable();
                String string = fieldDescriptor.getDescriptorString();
                int[] nArray = staticFieldInitializer.getArrayData();
                if (string.equals("[B")) {
                    byArray3 = new byte[nArray.length + 6];
                    byArray3[0] = -128;
                    n4 = ((JCClass)symbolTable.get("[B")).getRelocAddr();
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        byArray3[6 + n3] = (byte)nArray[n3];
                    }
                } else if (string.equals("[Z")) {
                    byArray3 = new byte[nArray.length + 6];
                    byArray3[0] = 96;
                    n4 = ((JCClass)symbolTable.get("[Z")).getRelocAddr();
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        byArray3[6 + n3] = (byte)nArray[n3];
                    }
                } else if (string.equals("[S")) {
                    byArray3 = new byte[nArray.length * 2 + 6];
                    byArray3[0] = -96;
                    n4 = ((JCClass)symbolTable.get("[S")).getRelocAddr();
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        byArray3[6 + n3 * 2] = (byte)(nArray[n3] >> 8);
                        byArray3[6 + n3 * 2 + 1] = (byte)nArray[n3];
                    }
                } else if (string.equals("[I")) {
                    byArray3 = new byte[nArray.length * 4 + 6];
                    byArray3[0] = -64;
                    n4 = ((JCClass)symbolTable.get("[I")).getRelocAddr();
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        byArray3[6 + n3 * 4] = (byte)(nArray[n3] >> 24);
                        byArray3[6 + n3 * 4 + 1] = (byte)(nArray[n3] >> 16);
                        byArray3[6 + n3 * 4 + 2] = (byte)(nArray[n3] >> 8);
                        byArray3[6 + n3 * 4 + 3] = (byte)nArray[n3];
                    }
                } else {
                    throw new InternalError();
                }
                byArray3[1] = (byte)(this.packageDirectory.indexOf(packageIdentifier) << 4);
                byArray3[2] = (byte)(n4 >> 8);
                byArray3[3] = (byte)n4;
                byArray3[4] = (byte)(nArray.length >> 8);
                byArray3[5] = (byte)nArray.length;
                this.cardMemoryInfo.addToE2(byArray3);
                this.objectInfo.addObjectAddresses((short)((short)field.getRelocAddr() + 2));
                continue;
            }
            switch (field.size()) {
                case 1: {
                    byArray = new byte[]{0};
                    break;
                }
                case 2: {
                    byArray = new byte[]{0, 0};
                    break;
                }
                case 4: {
                    byArray = new byte[]{0, 0, 0, 0};
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            this.cardMemoryInfo.addToE2(byArray);
        }
    }

    void formatExportOutput() {
        for (int i = 0; i < this.exportVector.size(); ++i) {
            ExportComponent exportComponent = this.exportVector.elementAt(i);
            JCPackage jCPackage = exportComponent.getParentPackage();
            short s = this.cardMemoryInfo.getNextRomAddr();
            jCPackage.getIdentifier().setECA(s);
            this.cardMemoryInfo.addToRom(exportComponent.toByteArray());
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        this.cardMemoryInfo.write(dataOutputStream);
        this.objectInfo.write(dataOutputStream);
        this.transactionBufferInfo.write(dataOutputStream);
        dataOutputStream.write(this.packageDirectory.toByteArray());
        this.maskAppletInfo.write(dataOutputStream);
        this.maskExceptionInfo.write(dataOutputStream);
        this.maskSymbols.write(dataOutputStream);
    }
}

