/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public static String lpad(String string, int n, char c) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static String[] getTokensInReverseOrder(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static String replace(String string, String string2, String string3) {
        int n = -1;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = (string = stringBuffer.toString()).indexOf(string2, n2)) != -1) {
            stringBuffer.replace(n, n + string2.length(), string3);
            n2 = n + string2.length();
        }
        return stringBuffer.toString();
    }

    public static String readFromFile(String string) {
        return StringUtils.readFromFile(new File(string));
    }

    public static String readFromFile(File file) {
        String string = "";
        try {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            string = new String(byArray);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void writeToFile(String string, String string2) {
        StringUtils.writeToFile(string, new File(string2));
    }

    public static void writeToFile(String string, File file) {
        try {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String indentString(int n) {
        return StringUtils.indentString(n, 4);
    }

    public static String indentString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(StringUtils.getSpaces(n2));
        }
        return stringBuffer.toString();
    }

    public static String getSpaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String arrayListToString(ArrayList<?> arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    public static ArrayList<String> stringToArrayList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = StringUtils.getTokens(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static String escapeString(String string) {
        string = string.replaceAll("\\\\n", "\n");
        string = string.replaceAll("\\\\t", "\t");
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(JAVA_KEYWORDS.length);
        System.out.println(StringUtils.isValidClassName("int"));
        System.out.println(StringUtils.isValidClassName("com.sun.Abcd"));
    }

    public static final boolean isValidClassName(String string) {
        int n;
        if (string == null || string.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (n = 1; n < string.length(); ++n) {
            if (Character.isJavaIdentifierPart(string.charAt(n)) || string.charAt(n) == '.') continue;
            return false;
        }
        n = Arrays.asList(JAVA_KEYWORDS).contains(string) ? 1 : 0;
        return n == 0;
    }

    public static String getRIDFromAID(String string) {
        String string2 = string.substring(6, string.lastIndexOf("/"));
        return string2;
    }
}

