/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter
implements Exporter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private File outputdir;
    private Configuration configuration;
    protected String[] templatePaths = new String[0];
    private TemplateHelper vh;
    private Properties properties = new Properties();
    private ArtifactCollector collector = new ArtifactCollector();
    private Iterator iterator;
    private Cfg2HbmTool c2h = new Cfg2HbmTool();
    private Cfg2JavaTool c2j = new Cfg2JavaTool();

    public AbstractExporter(Configuration cfg, File outputdir) {
        this();
        this.setConfiguration(cfg);
        this.setOutputDirectory(outputdir);
    }

    public AbstractExporter() {
    }

    @Override
    public void setOutputDirectory(File outputdir) {
        this.outputdir = outputdir;
    }

    @Override
    public void setConfiguration(Configuration cfg) {
        this.configuration = cfg;
    }

    protected File getFileForClassName(File baseDir, String className, String extension) {
        String filename = StringHelper.unqualify((String)className) + extension;
        String packagename = StringHelper.qualifier((String)className);
        return new File(this.getDirForPackage(baseDir, packagename), filename);
    }

    private File getDirForPackage(File baseDir, String packageName) {
        File dir = null;
        String p = packageName == null ? "" : packageName;
        dir = new File(baseDir, p.replace('.', File.separatorChar));
        return dir;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputdir;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void start() {
        this.setTemplateHelper(new TemplateHelper());
        this.setupTemplates();
        this.setupContext();
        this.doStart();
        this.cleanUpContext();
        this.setTemplateHelper(null);
        this.getArtifactCollector().formatFiles();
    }

    protected abstract void doStart();

    public String[] getTemplatePaths() {
        return this.templatePaths;
    }

    @Override
    public void setTemplatePath(String[] templatePaths) {
        this.templatePaths = templatePaths;
    }

    @Override
    public String[] getTemplatePath() {
        return this.templatePaths;
    }

    static String toString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            buf.append(String.valueOf(a[i]));
        }
        buf.append("]");
        return buf.toString();
    }

    protected void setupTemplates() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getClass().getName() + " outputdir:" + this.getOutputDirectory() + " path: " + AbstractExporter.toString(this.templatePaths));
        }
        this.getTemplateHelper().init(this.getOutputDirectory(), this.templatePaths);
    }

    protected void setupContext() {
        this.getTemplateHelper().setupContext();
        this.getTemplateHelper().putInContext("exporter", this);
        this.getTemplateHelper().putInContext("c2h", this.getCfg2HbmTool());
        this.getTemplateHelper().putInContext("c2j", this.getCfg2JavaTool());
        if (this.getOutputDirectory() != null) {
            this.getTemplateHelper().putInContext("outputdir", this.getOutputDirectory());
        }
        if (this.getTemplatePaths() != null) {
            this.getTemplateHelper().putInContext("template_path", this.getTemplatePaths());
        }
        if (this.getProperties() != null) {
            for (Map.Entry entry : this.getProperties().entrySet()) {
                String key = entry.getKey().toString();
                Object value = this.transformValue(entry.getValue());
                this.getTemplateHelper().putInContext(key, value);
                if (!key.startsWith("hibernatetool.")) continue;
                this.getTemplateHelper().putInContext(key.substring("hibernatetool.".length()), value);
                if (!key.endsWith(".toolclass")) continue;
                try {
                    Class toolClass = ReflectHelper.classForName((String)value.toString(), this.getClass());
                    Object object = toolClass.newInstance();
                    this.getTemplateHelper().putInContext(key.substring("hibernatetool.".length(), key.length() - ".toolclass".length()), object);
                }
                catch (Exception e) {
                    throw new ExporterException("Exception when instantiating tool " + entry.getKey() + " with " + value, e);
                }
            }
        }
        this.getTemplateHelper().putInContext("artifacts", this.collector);
        if (this.getConfiguration() != null) {
            this.getTemplateHelper().putInContext("cfg", this.getConfiguration());
        }
    }

    private Object transformValue(Object value) {
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        return value;
    }

    protected void cleanUpContext() {
        if (this.getProperties() != null) {
            for (Map.Entry entry : this.getProperties().entrySet()) {
                Object value = this.transformValue(entry.getValue());
                String key = entry.getKey().toString();
                if (key.startsWith("hibernatetool.")) {
                    this.getTemplateHelper().removeFromContext(key.substring("hibernatetool.".length()), value);
                }
                this.getTemplateHelper().removeFromContext(key, value);
            }
        }
        if (this.getOutputDirectory() != null) {
            this.getTemplateHelper().removeFromContext("outputdir", this.getOutputDirectory());
        }
        if (this.getTemplatePaths() != null) {
            this.getTemplateHelper().removeFromContext("template_path", this.getTemplatePaths());
        }
        this.getTemplateHelper().removeFromContext("exporter", this);
        this.getTemplateHelper().removeFromContext("artifacts", this.collector);
        if (this.getConfiguration() != null) {
            this.getTemplateHelper().removeFromContext("cfg", this.getConfiguration());
        }
        this.getTemplateHelper().removeFromContext("c2h", this.getCfg2HbmTool());
        this.getTemplateHelper().removeFromContext("c2j", this.getCfg2JavaTool());
    }

    protected void setTemplateHelper(TemplateHelper vh) {
        this.vh = vh;
    }

    protected TemplateHelper getTemplateHelper() {
        return this.vh;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setArtifactCollector(ArtifactCollector collector) {
        this.collector = collector;
    }

    @Override
    public ArtifactCollector getArtifactCollector() {
        return this.collector;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Cfg2HbmTool getCfg2HbmTool() {
        return this.c2h;
    }

    public Cfg2JavaTool getCfg2JavaTool() {
        return this.c2j;
    }
}

