/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.clone;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ClonePanel
extends JPanel
implements ActionListener {
    private final VCSFileProxy repository;
    private JButton browseButton;
    private JLabel destinationLabel;
    private JLabel fromLabel;
    private JTextField fromTextField;
    private JTextField toCloneField;
    private JLabel toLabel;
    private JLabel toNameLabel;
    final JTextField toTextField = new JTextField();

    public ClonePanel(VCSFileProxy repo, VCSFileProxy to) {
        this.repository = repo;
        this.initComponents();
        this.browseButton.addActionListener(this);
        this.fromTextField.setText(repo.getPath());
        this.toTextField.setText(to.getParentFile().getPath());
        this.toCloneField.setText(to.getName());
    }

    public VCSFileProxy getTargetDir() {
        return VCSFileProxySupport.getResource((VCSFileProxy)this.repository, (String)(this.toTextField.getText() + "/" + this.toCloneField.getText()));
    }

    private void initComponents() {
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        this.browseButton = new JButton();
        this.fromTextField = new JTextField();
        this.toNameLabel = new JLabel();
        this.toCloneField = new JTextField();
        this.destinationLabel = new JLabel();
        this.fromLabel.setLabelFor(this.fromTextField);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.fromLabel.text"));
        this.toLabel.setLabelFor(this.toTextField);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.browseButton.text"));
        this.fromTextField.setEditable(false);
        this.toNameLabel.setLabelFor(this.toCloneField);
        Mnemonics.setLocalizedText((JLabel)this.toNameLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toName.text"));
        Mnemonics.setLocalizedText((JLabel)this.destinationLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"destinationLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.destinationLabel).addComponent(this.fromLabel).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toNameLabel).addComponent(this.toLabel)))).addGap(94, 94, 94).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fromTextField, -1, 272, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.toCloneField, -1, 167, Short.MAX_VALUE).addComponent(this.toTextField, -1, 167, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fromLabel).addComponent(this.fromTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.destinationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.toTextField, -2, -1, -2).addComponent(this.toLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.toCloneField, -2, -1, -2).addComponent(this.toNameLabel)).addGap(31, 31, 31)));
        this.toTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_Browse"));
        this.fromTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_fromTextField"));
        this.toCloneField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toCloneField"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseButton) {
            this.onBrowseClick();
        }
    }

    private void onBrowseClick() {
        VCSFileProxy oldFile = this.defaultWorkingDirectory();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(ClonePanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ClonePanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(ClonePanel.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            this.toTextField.setText(f.getPath());
        }
    }

    private VCSFileProxy defaultWorkingDirectory() {
        VCSFileProxy defaultDir = null;
        String current = this.toTextField.getText();
        if (current != null && !current.trim().equals("")) {
            VCSFileProxy currentFile;
            for (currentFile = VCSFileProxySupport.getResource((VCSFileProxy)this.repository, (String)current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null) {
            defaultDir = VCSFileProxySupport.getHome((VCSFileProxy)this.repository);
        }
        return defaultDir;
    }
}

