/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.HgFileNode;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.diff.Setup;
import org.netbeans.modules.mercurial.remote.ui.status.OpenInEditorAction;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileNode;
import org.netbeans.modules.remotefs.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;

class DiffNode
extends VCSStatusNode<HgFileNode> {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_LOCATION = "location";
    private final Setup setup;
    private String htmlDisplayName;
    private String location;
    private DataObject dobj;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public DiffNode(Setup setup, HgFileNode node) {
        super((VCSFileNode)node, DiffNode.getLookupFor(setup, node.getLookupObjects()));
        this.setup = setup;
        this.setName(setup.getBaseFile().getName());
        this.initProperties();
        this.refreshHtmlDisplayName();
        FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                this.dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    String getLocation() {
        if (this.location == null) {
            this.location = HgUtils.getRelativePath(this.setup.getBaseFile());
        }
        return this.location;
    }

    public VCSFileProxy getFile() {
        return this.setup.getBaseFile();
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.setup.getInfo();
        int status = info.getStatus();
        if (status == 128) {
            status = 64;
        }
        this.htmlDisplayName = Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(this.setup.getBaseFile().getName(), info, null);
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        return new Action[0];
    }

    public Action getNodeAction() {
        return new OpenInEditorAction();
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
        if (fo != null && this.dobj != null && fo.equals(this.dobj.getPrimaryFile())) {
            return this.dobj.getCookie(klass);
        }
        return super.getCookie(klass);
    }

    public Image getIcon(int type) {
        if (this.dobj != null && this.dobj.isValid()) {
            return this.dobj.getNodeDelegate().getIcon(type);
        }
        return super.getIcon(type);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new LocationProperty());
        ps.put((Node.Property)new StatusProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static Lookup getLookupFor(Setup setup, Object[] lookupObjects) {
        Object[] allLookupObjects;
        EditorCookie eCookie = DiffUtils.getEditorCookie((AbstractDiffSetup)setup);
        if (eCookie == null) {
            allLookupObjects = new Object[lookupObjects.length + 1];
        } else {
            allLookupObjects = new Object[lookupObjects.length + 2];
            allLookupObjects[allLookupObjects.length - 1] = eCookie;
        }
        allLookupObjects[0] = setup;
        System.arraycopy(lookupObjects, 0, allLookupObjects, 1, lookupObjects.length);
        DiffLookup lkp = new DiffLookup();
        lkp.setData(allLookupObjects);
        return lkp;
    }

    private static class DiffPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public DiffPropertyEditor(Object value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            Object val = this.getValue();
            if (val instanceof Date) {
                val = DateFormat.getDateTimeInstance().format((Date)val);
            }
            renderer.setText(val.toString());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class StatusProperty
    extends DiffNodeProperty {
        public StatusProperty() {
            super(DiffNode.COLUMN_NAME_STATUS, String.class, DiffNode.COLUMN_NAME_STATUS, DiffNode.COLUMN_NAME_STATUS);
            String shortPath = HgUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            String sortable = Integer.toString(HgUtils.getComparableStatus(DiffNode.this.setup.getInfo().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + DiffNode.this.getName().toUpperCase(Locale.getDefault()));
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.setup.getInfo().getStatusText();
        }
    }

    private class LocationProperty
    extends DiffNodeProperty {
        public LocationProperty() {
            super(DiffNode.COLUMN_NAME_LOCATION, String.class, DiffNode.COLUMN_NAME_LOCATION, DiffNode.COLUMN_NAME_LOCATION);
            this.setValue("sortkey", DiffNode.this.getLocation() + "\t" + DiffNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.getLocation();
        }
    }

    private class NameProperty
    extends DiffNodeProperty {
        public NameProperty() {
            super(DiffNode.COLUMN_NAME_NAME, String.class, DiffNode.COLUMN_NAME_NAME, DiffNode.COLUMN_NAME_NAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.getName();
        }
    }

    private abstract class DiffNodeProperty
    extends PropertySupport.ReadOnly {
        protected DiffNodeProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new DiffPropertyEditor(this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }
}

