/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.queues.FinishPatch;
import org.netbeans.modules.mercurial.remote.ui.queues.QPatch;
import org.netbeans.modules.mercurial.remote.ui.queues.QUtils;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.hooks.HgHookContext;
import org.netbeans.modules.remotefs.versioning.hooks.HgQueueHook;
import org.netbeans.modules.remotefs.versioning.hooks.HgQueueHookContext;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class QFinishPatchesAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QFinishPatches";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        final VCSFileProxy[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                if (QUtils.isMQEnabledExtension(root)) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String patchName;
                            FinishPatch finishPatch = new FinishPatch(root);
                            if (finishPatch.showDialog() && (patchName = finishPatch.getSelectedPatch()) != null) {
                                QFinishPatchesAction.this.finishPatch(root, roots, patchName);
                            }
                        }
                    });
                }
            }
        });
    }

    public void finishPatch(final VCSFileProxy root, final VCSFileProxy[] roots, final String patchName) {
        new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_TITLE_SEP"));
                    List<QPatch> toFinish = this.getPatchesToFinish(patchName, root);
                    if (toFinish.isEmpty()) {
                        logger.output(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_NOTHING_TO_FINISH"));
                        return;
                    }
                    Collection hooks = VCSHooks.getInstance().getHooks(HgQueueHook.class);
                    for (QPatch patch : toFinish) {
                        if (this.isCanceled()) {
                            return;
                        }
                        this.setDisplayName(patch.getId());
                        logger.output(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_INFO_SEP", (Object)patch.getId(), (Object)root.getPath()));
                        logger.output("");
                        HgQueueHookContext hooksCtx = new HgQueueHookContext(roots, null, patch.getId(), new HgHookContext.LogEntry[0]);
                        for (HgQueueHook hgHook : hooks) {
                            try {
                                hgHook.beforePatchFinish(hooksCtx);
                            }
                            catch (IOException iOException) {}
                        }
                        HgLogMessage message = this.getRevision(patch.getId());
                        if (message == null) {
                            logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_ERR_NOSUCHREVISION", (Object)patch.getId()));
                            break;
                        }
                        HgCommand.qFinishPatches(root, patch.getId(), logger);
                        HgModuleConfig.getDefault(root).setLastUsedQPatchMessage(patch.getId(), null);
                        message = this.getRevision(message.getRevisionNumber());
                        if (message == null) {
                            logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_ERR_NOSUCHREVISION", (Object)patch.getId()));
                            break;
                        }
                        HgUtils.logHgLog(message, logger);
                        hooksCtx = new HgQueueHookContext(roots, null, patch.getId(), new HgHookContext.LogEntry[]{new HgHookContext.LogEntry(message.getMessage(), message.getAuthor(), message.getCSetShortID(), message.getDate())});
                        for (HgQueueHook hgHook : hooks) {
                            this.setDisplayName(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_QFinishPatchesAction.progress.hooks", (Object)patch.getId()));
                            hgHook.afterPatchFinish(hooksCtx);
                        }
                    }
                }
                catch (HgException.HgCommandCanceledException toFinish) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    logger.outputInRed(NbBundle.getMessage(QFinishPatchesAction.class, (String)"MSG_FINISH_DONE"));
                    logger.output("");
                }
            }

            private List<QPatch> getPatchesToFinish(String patchName2, VCSFileProxy root2) throws HgException {
                QPatch[] patches = HgCommand.qListSeries(root2);
                LinkedList<QPatch> toFinish = new LinkedList<QPatch>();
                boolean containsTarget = false;
                for (QPatch patch : patches) {
                    if (!patch.isApplied()) break;
                    toFinish.add(patch);
                    if (!patchName2.contains(patch.getId())) continue;
                    containsTarget = true;
                    break;
                }
                return containsTarget ? toFinish : Collections.emptyList();
            }

            private HgLogMessage getRevision(String revisionId) {
                HgLogMessage[] messages = HgCommand.getLogMessagesNoFileInfo(root, null, revisionId, revisionId, true, -1, Collections.emptyList(), this.getLogger());
                return messages.length == 0 ? null : messages[0];
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QFinishPatchesAction.class, (String)"LBL_QFinishPatchAction.progress"));
    }
}

