/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.update;

import java.util.logging.Level;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConflictResolvedAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        return cache.containsFileOfStatus(context, 64, false);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_MarkResolved";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ConflictResolvedAction.resolved(context);
    }

    public static void resolved(VCSContext ctx) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        VCSFileProxy[] files = cache.listFiles(ctx, 64);
        VCSFileProxy root = HgUtils.getRootFile(ctx);
        if (root == null || files == null || files.length == 0) {
            return;
        }
        ConflictResolvedAction.conflictResolved(root, files);
    }

    public static void conflictResolved(VCSFileProxy repository, final VCSFileProxy[] files) {
        if (repository == null || files == null || files.length == 0) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                for (VCSFileProxy file : files) {
                    if (this.isCanceled()) {
                        return;
                    }
                    VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(file);
                    ConflictResolvedAction.perform(file, repository, logger);
                }
            }
        };
        support.start(rp, repository, NbBundle.getMessage(ConflictResolvedAction.class, (String)"MSG_ConflictResolved_Progress"));
    }

    private static void perform(VCSFileProxy file, VCSFileProxy repository, OutputLogger logger) {
        if (file == null) {
            return;
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        file = file.normalizeFile();
        try {
            HgCommand.markAsResolved(repository, file, logger);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        HgCommand.deleteConflictFile(file);
        Mercurial.LOG.log(Level.FINE, "ConflictResolvedAction.perform(): DELETE CONFLICT File: {0}", new Object[]{file.getPath() + ".conflict~"});
        cache.refresh(file);
    }

    public static void resolved(final VCSFileProxy file) {
        if (file == null) {
            return;
        }
        final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(file);
        if (repository == null) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                ConflictResolvedAction.perform(file, repository, this.getLogger());
            }
        };
        support.start(rp, repository, NbBundle.getMessage(ConflictResolvedAction.class, (String)"MSG_ConflictResolved_Progress"));
    }
}

