/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.spi.EngineCapabilityProvider;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;

public final class GdbEngineCapabilityProvider
implements EngineCapabilityProvider {
    static final String ID = "gdb";
    private static final EngineType GDB_ENGINE_TYPE = EngineTypeManager.create((String)"gdb", (String)Catalog.get("GdbEngineDisplayName"));

    public boolean hasCapability(EngineType et, EngineCapability capability) {
        if (ID.equals(et.getDebuggerID())) {
            switch (capability) {
                case DERIVE_EXECUTABLE: 
                case RTC_SUPPORT: {
                    return false;
                }
                case RUN_AUTOSTART: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public EngineType engineType() {
        return GDB_ENGINE_TYPE;
    }

    public static EngineType getGdbEngineType() {
        return GDB_ENGINE_TYPE;
    }

    static boolean isSupportedImpl(ToolchainManager.DebuggerDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        String id = descriptor.getID();
        return "GNU".equalsIgnoreCase(id);
    }

    public boolean isSupported(ToolchainManager.DebuggerDescriptor descriptor) {
        return GdbEngineCapabilityProvider.isSupportedImpl(descriptor);
    }

    public String debuggerProfileID() {
        return "dbx_gdbdebugger";
    }
}

