/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbLocal;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public final class GdbFrame
extends Frame {
    private MITList MIframe;
    private final List<GdbLocal> argsArray = new ArrayList<GdbLocal>();
    private String fullname;

    public GdbFrame(GdbDebuggerImpl debugger, MIValue frame, MIResult frameargs, Thread thread) {
        super((NativeDebugger)debugger, thread);
        if (frame == null) {
            return;
        }
        this.MIframe = frame.asTuple();
        if (this.MIframe == null) {
            return;
        }
        this.frameno = this.MIframe.getConstValue("level");
        this.pc = this.MIframe.getConstValue("addr");
        this.func = this.MIframe.getConstValue("func");
        this.lineno = this.MIframe.getConstValue("line");
        this.source = this.MIframe.getConstValue("file", this.MIframe.getConstValue("from"));
        this.fullname = this.MIframe.getConstValue("fullname", null);
        MITList args_list = (MITList)this.MIframe.valueOf("args");
        if (args_list != null && frameargs != null) {
            System.out.println("GdbFrame Impossible ");
        }
        if (frameargs != null) {
            args_list = (MITList)frameargs.value().asTuple().valueOf("args");
        }
        if (args_list != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" (");
            if (debugger.getVerboseStack()) {
                int args_count = args_list.size();
                for (int vx = 0; vx < args_count; ++vx) {
                    MIValue arg = (MIValue)args_list.get(vx);
                    if (vx != 0) {
                        sb.append(", ");
                    }
                    sb.append(arg.asTuple().getConstValue("name"));
                    MIValue value = arg.asTuple().valueOf("value");
                    if (value == null) continue;
                    this.argsArray.add(new GdbLocal(arg));
                    sb.append("=");
                    sb.append(value.asConst().value());
                }
            }
            sb.append(")");
            this.args = sb.toString();
        }
        this.range_of_hidden = false;
        this.current = false;
        this.optimized = false;
        this.attr_user_call = false;
        this.attr_sig = 0;
        this.attr_signame = "";
    }

    public MITList getMIframe() {
        return this.MIframe;
    }

    public List<GdbLocal> getArgsList() {
        return this.argsArray;
    }

    public String getFullPath() {
        return this.debugger.remoteToLocal("Gdb frame", this.debugger.fmap().engineToWorld(this.fullname));
    }

    public String getEngineFullName() {
        return this.fullname;
    }

    void varUpdated(String name, String value) {
        for (GdbLocal var : this.argsArray) {
            if (!var.getName().equals(name)) continue;
            var.setValue(value);
        }
    }
}

