/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.options;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfileXMLCodec;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetXMLCodec;
import org.xml.sax.Attributes;

public class GdbProfileXMLCodec
extends DbgProfileXMLCodec {
    private static final int thisversion = 1;
    private final OptionSetXMLCodec optionsXMLCodec;
    static final String TAG_ENGINE = "gdb_engine";
    static final String TAG_HOST = "gdb_host";
    static final String TAG_OPTIONS = "gdb_options";
    static final String TAG_OPTION = "gdb_option";
    static final String ATTR_OPTION_NAME = "gdb_name";
    static final String ATTR_OPTION_VALUE = "gdb_value";
    static final String TAG_INTERCEPTLIST = "gdb_interceptlist";
    static final String TAG_INTERCEPT_OPTIONS = "gdbinterceptoptions";
    static final String ATTR_INTERCEPT_ALL = "gdb_all";
    static final String ATTR_INTERCEPT_UNHANDLED = "gdb_unhandled";
    static final String ATTR_INTERCEPT_UNEXPECTED = "gdb_unexpected";
    static final String TAG_INTERCEPT = "gdb_intercept";
    static final String TAG_EXCLUDED = "gdb_excluded";
    static final String TAG_SIGNALS = "gdb_signals";
    static final String TAG_SIGNAL = "gdb_signal";
    static final String ATTR_SIGNAL_SIGNAME = "gdb_signame";
    static final String ATTR_SIGNAL_CAUGHT = "gdb_caught";
    static final String ATTR_SIGNAL_CAUGHT_BY_DEFAULT = "gdb_caught_by_default";
    static final String TAG_PATHMAP = "gdb_pathmap";
    static final String TAG_PATHMAPS = "gdb_pathmaps";
    static final String ATTR_PATHMAP_FROM = "gdb_from";
    static final String ATTR_PATHMAP_TO = "gdb_to";
    static final String TAG_BUILDFIRST = "gdb_buildfirst";
    static final String ATTR_BUILDFIRST_OVERRIDEN = "gdb_buildfirst_overriden";
    static final String ATTR_BUILDFIRST_OLD = "gdb_buildfirst_old";
    private final List<Pathmap.Item> pathmaps = new ArrayList<Pathmap.Item>();
    private final Vector<String> interceptlist = new Vector();
    private final Vector<String> interceptexlist = new Vector();
    private boolean unhandled;
    private boolean unexpected;
    private boolean all;
    private final Vector<Signals.InitialSignalInfo> signals = new Vector();

    public GdbProfileXMLCodec(DbgProfile profile) {
        super(profile);
        this.optionsXMLCodec = new OptionSetXMLCodec(profile.getOptions());
        this.registerXMLDecoder((XMLDecoder)this.optionsXMLCodec);
    }

    public void startElement(String element, Attributes atts) {
        if (element.equals(TAG_PATHMAPS)) {
            // empty if block
        }
        if (element.equals(TAG_PATHMAP)) {
            Pathmap.Item pathmap = new Pathmap.Item(atts.getValue(ATTR_PATHMAP_FROM), atts.getValue(ATTR_PATHMAP_TO), false);
            this.pathmaps.add(pathmap);
        }
        if (element.equals(TAG_BUILDFIRST)) {
            String isBuildFirstOverridenStr = atts.getValue(ATTR_BUILDFIRST_OVERRIDEN);
            this.profile.setBuildFirstOverriden(Boolean.parseBoolean(isBuildFirstOverridenStr));
            String isSavedBuildFirstStr = atts.getValue(ATTR_BUILDFIRST_OLD);
            this.profile.setSavedBuildFirst(Boolean.parseBoolean(isSavedBuildFirstStr));
        }
        if (element.equals(TAG_INTERCEPTLIST)) {
            // empty if block
        }
        if (element.equals(TAG_INTERCEPT_OPTIONS)) {
            this.unhandled = atts.getValue(ATTR_INTERCEPT_UNHANDLED).equals("true");
            this.unexpected = atts.getValue(ATTR_INTERCEPT_UNEXPECTED).equals("true");
            this.all = atts.getValue(ATTR_INTERCEPT_ALL).equals("true");
        }
        if (element.equals(TAG_INTERCEPT)) {
            // empty if block
        }
        if (element.equals(TAG_EXCLUDED)) {
            // empty if block
        }
        if (element.equals(TAG_SIGNALS)) {
            // empty if block
        }
        if (element.equals(TAG_SIGNAL)) {
            Signals.InitialSignalInfo signal = new Signals.InitialSignalInfo(0, atts.getValue(ATTR_SIGNAL_SIGNAME), null, atts.getValue(ATTR_SIGNAL_CAUGHT_BY_DEFAULT).equals("true"), atts.getValue(ATTR_SIGNAL_CAUGHT).equals("true"));
            this.signals.add(signal);
        }
        if (element.equals(TAG_OPTION)) {
            String optname = atts.getValue(ATTR_OPTION_NAME);
            String optvalue = atts.getValue(ATTR_OPTION_VALUE);
            if (optname == null) {
                return;
            }
            if (optname.equals(TAG_HOST)) {
                this.profile.setHost(optvalue);
            } else {
                this.optionsXMLCodec.startElement(element, atts);
            }
        }
    }

    public void endElement(String element, String currentText) {
        if (Log.XML.debug) {
            System.out.println("  endElement: " + element);
            System.out.println("  endElement: " + currentText);
        }
        if (element.equals(TAG_PATHMAPS)) {
            Pathmap.Item[] vars = new Pathmap.Item[this.pathmaps.size()];
            this.profile.pathmap().setPathmap(this.pathmaps.toArray(vars));
            this.pathmaps.clear();
        } else if (!element.equals(TAG_PATHMAP)) {
            if (element.equals(TAG_INTERCEPTLIST)) {
                String[] ilist = new String[this.interceptlist.size()];
                String[] xlist = new String[this.interceptexlist.size()];
                this.profile.exceptions().setInterceptList(this.interceptlist.toArray(ilist), this.interceptexlist.toArray(xlist), this.all, this.unhandled, this.unexpected);
                this.interceptlist.clear();
                this.interceptexlist.clear();
            } else if (!element.equals(TAG_INTERCEPT_OPTIONS)) {
                if (element.equals(TAG_INTERCEPT)) {
                    this.interceptlist.add(currentText);
                } else if (element.equals(TAG_EXCLUDED)) {
                    this.interceptexlist.add(currentText);
                } else if (!element.equals(TAG_SIGNAL) && element.equals(TAG_SIGNALS)) {
                    Signals.InitialSignalInfo[] vars = new Signals.InitialSignalInfo[this.signals.size()];
                    this.profile.signals().setXMLSignal(this.signals.toArray(vars));
                    this.signals.clear();
                }
            }
        }
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(this.tag(), 1);
        this.writePathmapsBlock(xes);
        this.writeExceptionsBlock(xes);
        this.writeSignalsBlock(xes);
        this.writeOptionsBlock(xes);
        this.writeBuildfirstBlock(xes);
        xes.elementClose(this.tag());
    }

    private void writeOptionsBlock(XMLEncoderStream xes) {
        xes.elementOpen(TAG_OPTIONS);
        this.optionsXMLCodec.encode(xes);
        xes.elementClose(TAG_OPTIONS);
    }

    private void writeBuildfirstBlock(XMLEncoderStream xes) {
        AttrValuePair[] buildfirstAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_BUILDFIRST_OVERRIDEN, Boolean.toString(this.profile.isBuildFirstOverriden())), new AttrValuePair(ATTR_BUILDFIRST_OLD, Boolean.toString(this.profile.isSavedBuildFirst()))};
        xes.element(TAG_BUILDFIRST, buildfirstAttrs);
    }

    private void writePathmapsBlock(XMLEncoderStream xes) {
        Pathmap.Item[] pm = this.profile.pathmap().getPathmap();
        if (pm == null) {
            return;
        }
        xes.elementOpen(TAG_PATHMAPS);
        int size = pm.length;
        for (int i = 0; i < size; ++i) {
            AttrValuePair[] pathmapAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_PATHMAP_FROM, pm[i].from()), new AttrValuePair(ATTR_PATHMAP_TO, pm[i].to())};
            xes.element(TAG_PATHMAP, pathmapAttrs);
        }
        xes.elementClose(TAG_PATHMAPS);
    }

    private void writeExceptionsBlock(XMLEncoderStream xes) {
        String[] xlist;
        xes.elementOpen(TAG_INTERCEPTLIST);
        AttrValuePair[] exceptionAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_INTERCEPT_ALL, Boolean.toString(this.profile.exceptions().isAll())), new AttrValuePair(ATTR_INTERCEPT_UNHANDLED, Boolean.toString(this.profile.exceptions().isInterceptUnhandled())), new AttrValuePair(ATTR_INTERCEPT_UNEXPECTED, Boolean.toString(this.profile.exceptions().isInterceptUnexpected()))};
        xes.element(TAG_INTERCEPT_OPTIONS, exceptionAttrs);
        String[] elist = this.profile.exceptions().getInterceptList();
        if (elist != null) {
            int size = elist.length;
            for (int i = 0; i < size; ++i) {
                xes.element(TAG_INTERCEPT, elist[i]);
            }
        }
        if ((xlist = this.profile.exceptions().getInterceptExceptList()) != null) {
            int size = xlist.length;
            for (int i = 0; i < size; ++i) {
                xes.element(TAG_EXCLUDED, xlist[i]);
            }
        }
        xes.elementClose(TAG_INTERCEPTLIST);
    }

    private void writeSignalsBlock(XMLEncoderStream xes) {
        int size = this.profile.signals().count();
        if (size == 0) {
            return;
        }
        xes.elementOpen(TAG_SIGNALS);
        for (int i = 0; i < size; ++i) {
            Signals.InitialSignalInfo sig = this.profile.signals().getSignal(i);
            if (sig.isCaught() == sig.isCaughtByDefault()) continue;
            AttrValuePair[] signalAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_SIGNAL_SIGNAME, sig.name()), new AttrValuePair(ATTR_SIGNAL_CAUGHT, Boolean.toString(sig.isCaught())), new AttrValuePair(ATTR_SIGNAL_CAUGHT_BY_DEFAULT, Boolean.toString(sig.isCaughtByDefault()))};
            xes.element(TAG_SIGNAL, signalAttrs);
        }
        xes.elementClose(TAG_SIGNALS);
    }
}

