/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.LTOKind;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.FreeBSD;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.MipsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class FreebsdStatics {

    public static class Linker
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"freebsd::Linker"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Arg A;
                FreeBSD ToolChain2 = (FreeBSD)this.getToolChain();
                Driver D = ToolChain2.getDriver();
                Triple.ArchType Arch = ToolChain2.getArch();
                boolean IsPIE = !Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) && (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue())) || ToolChain2.isPIEDefault());
                ArgStringList CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"--sysroot=", (std.string)D.SysRoot))));
                }
                if (IsPIE) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bshareable"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/libexec/ld-elf.so.1"));
                    }
                    if (Unsigned.$greatereq_uint((int)ToolChain2.getTriple().getOSMajorVersion(), (int)9) && (Arch == Triple.ArchType.arm || Arch == Triple.ArchType.sparc || Arch == Triple.ArchType.x86 || Arch == Triple.ArchType.x86_64)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--hash-style=both"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"--enable-new-dtags"));
                }
                if (Arch == Triple.ArchType.x86) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"elf_i386_fbsd"));
                }
                if (Arch == Triple.ArchType.ppc) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"elf32ppc_fbsd"));
                }
                if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_G.getValue()))) != null && (ToolChain2.getArch() == Triple.ArchType.mips || ToolChain2.getArch() == Triple.ArchType.mipsel || ToolChain2.getArch() == Triple.ArchType.mips64 || ToolChain2.getArch() == Triple.ArchType.mips64el)) {
                    StringRef v = new StringRef(A.getValue());
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((String)"-G", (StringRef)v)));
                    A.claim();
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    char.ptr crt1 = null;
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        crt1 = Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"gcrt1.o")) : (IsPIE ? Native.$tryClone((char.ptr)NativePointer.$((String)"Scrt1.o")) : Native.$tryClone((char.ptr)NativePointer.$((String)"crt1.o")));
                    }
                    if (crt1 != null) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crt1))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crti.o")))));
                    char.ptr crtbegin = null;
                    crtbegin = Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"crtbeginT.o")) : (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || IsPIE ? Native.$tryClone((char.ptr)NativePointer.$((String)"crtbeginS.o")) : Native.$tryClone((char.ptr)NativePointer.$((String)"crtbegin.o")));
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crtbegin))));
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                ToolChain2.AddFilePathLibArgs(Args, CmdArgs);
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_e.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_s.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_t.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_r.getValue()));
                if (D.isUsingLTO()) {
                    ToolsStatics.AddGoldPlugin(ToolChain2, Args, CmdArgs, D.getLTOMode() == LTOKind.LTOK_Thin);
                }
                boolean NeedsSanitizerDeps = ToolsStatics.addSanitizerRuntimes(ToolChain2, Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    ToolsStatics.addOpenMPRuntime(CmdArgs, ToolChain2, Args);
                    if (D.CCCIsCXX()) {
                        ToolChain2.AddCXXStdlibLibArgs(Args, CmdArgs);
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                        }
                    }
                    if (NeedsSanitizerDeps) {
                        ToolsStatics.linkSanitizerRuntimeDeps(ToolChain2, CmdArgs);
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue()))) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                    } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh_p"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                    }
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || IsPIE) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtendS.o")))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtend.o")))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtn.o")))));
                }
                ToolChain2.addProfileRTLibs(Args, CmdArgs);
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetLinkerPath())));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"freebsd::Assembler"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                ArgStringList CmdArgs = new ArgStringList();
                block1 : switch (this.getToolChain().getArch()) {
                    default: {
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-a32"));
                        break;
                    }
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        StringRef CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        MipsStatics.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                        CmdArgs.push_back((Object)CPUName.data());
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(ABIName).data());
                        if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_G.getValue()));
                        if (A != null) {
                            StringRef v = new StringRef(A.getValue());
                            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((String)"-G", (StringRef)v)));
                            A.claim();
                        }
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case arm: 
                    case armeb: 
                    case thumb: 
                    case thumbeb: {
                        ArmStatics.FloatABI ABI = ArmStatics.getARMFloatABI(this.getToolChain(), Args);
                        if (ABI == ArmStatics.FloatABI.Hard) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=vfp"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=softvfp"));
                        }
                        switch (this.getToolChain().getTriple().getEnvironment()) {
                            case GNUEABIHF: 
                            case GNUEABI: 
                            case EABI: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"-meabi=5"));
                                break block1;
                            }
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-matpcs"));
                        break;
                    }
                    case sparc: 
                    case sparcel: 
                    case sparcv9: {
                        std.string CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef(CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

