/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.modules.dlight.sendto.api.OutputMode;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class CachedIOProvider {
    private static final Object lock = new Object();
    private static final Collection<InputOutputData> cache = new ArrayList<InputOutputData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getIO(String tabName, Action[] actions, AtomicReference<Process> procRef, OutputMode outputMode) {
        Object object = lock;
        synchronized (object) {
            Iterator<InputOutputData> it = cache.iterator();
            while (it.hasNext()) {
                Process process;
                InputOutputData cachedData = it.next();
                if (!cachedData.title.equals(tabName) || (process = (Process)cachedData.procRef.get()) == null || ProcessUtils.isAlive((Process)process) || process.exitValue() != 0) continue;
                cachedData.io.closeInputOutput();
                it.remove();
            }
            IOProvider term = null;
            if (OutputMode.INTERNAL_TERMINAL == outputMode) {
                term = IOProvider.get((String)"Terminal");
            }
            if (term == null) {
                term = IOProvider.getDefault();
            }
            InputOutput io = term.getIO(tabName, actions);
            cache.add(new InputOutputData(tabName, io, procRef));
            return io;
        }
    }

    private static final class InputOutputData {
        private final InputOutput io;
        private final AtomicReference<Process> procRef;
        private final String title;

        private InputOutputData(String title, InputOutput io, AtomicReference<Process> procRef) {
            this.title = title;
            this.io = io;
            this.procRef = procRef;
        }
    }
}

