/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.remote.client.parser.SvnWcUtils;
import org.netbeans.modules.subversion.remote.config.KVFile;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class PropertiesClient {
    private final VCSFileProxy file;

    public PropertiesClient(VCSFileProxy file) {
        assert (file != null);
        this.file = file;
    }

    public Map<String, byte[]> getBaseProperties(boolean contactServer) throws IOException {
        if (PropertiesClient.hasOldMetadata(this.file)) {
            VCSFileProxy store;
            try {
                store = this.getPropertyFile(true);
            }
            catch (SVNClientException ex) {
                throw new IOException(ex.getMessage());
            }
            if (store != null && store.isFile()) {
                KVFile kv = new KVFile(store);
                return kv.getNormalizedMap();
            }
            return new HashMap<String, byte[]>();
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            if (contactServer) {
                ISVNInfo info;
                SvnClient client = Subversion.getInstance().getClient(this.file);
                if (client != null && (info = SvnUtils.getInfoFromWorkingCopy(client, this.file)) != null && (info.getUrl() != null || info.getCopyUrl() != null) && info.getRevision() != null && info.getRevision().getNumber() > -1L) {
                    ISVNProperty[] props;
                    for (ISVNProperty prop : props = client.getProperties(info.getCopyUrl() == null ? info.getUrl() : info.getCopyUrl(), SVNRevision.getRevision(info.getRevision().toString()), SVNRevision.getRevision(info.getRevision().toString()), false)) {
                        map.put(prop.getName(), prop.getData());
                    }
                }
            } else {
                return this.getProperties();
            }
            return map;
        }
        catch (SVNClientException ex) {
            return map;
        }
        catch (ParseException ex) {
            return map;
        }
    }

    public Map<String, byte[]> getProperties() throws IOException {
        if (PropertiesClient.hasOldMetadata(this.file)) {
            VCSFileProxy store;
            try {
                store = this.getPropertyFile(false);
                if (store == null) {
                    store = this.getPropertyFile(true);
                }
            }
            catch (SVNClientException ex) {
                throw new IOException(ex.getMessage());
            }
            if (store != null && store.isFile()) {
                KVFile kv = new KVFile(store);
                return kv.getNormalizedMap();
            }
            return new HashMap<String, byte[]>();
        }
        try {
            SvnClient client = Subversion.getInstance().getClient(false, new Context(this.file));
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            if (client != null) {
                ISVNProperty[] props;
                for (ISVNProperty prop : props = client.getProperties(this.file)) {
                    map.put(prop.getName(), prop.getData());
                }
            }
            return map;
        }
        catch (SVNClientException ex) {
            return new HashMap<String, byte[]>();
        }
    }

    private VCSFileProxy getPropertyFile(boolean base) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false, new Context(this.file));
        ISVNInfo info = null;
        info = SvnUtils.getInfoFromWorkingCopy(client, this.file);
        if (info instanceof ParserSvnInfo) {
            if (base) {
                return ((ParserSvnInfo)info).getBasePropertyFile();
            }
            return ((ParserSvnInfo)info).getPropertyFile();
        }
        return SvnWcUtils.getPropertiesFile(this.file, base);
    }

    private static boolean hasOldMetadata(VCSFileProxy file) {
        if (file.isDirectory() && VCSFileProxySupport.canRead((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)".svn/entries"))) {
            return true;
        }
        VCSFileProxy parent = file.getParentFile();
        return parent != null && VCSFileProxySupport.canRead((VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)".svn/entries")) && !VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)".svn/wc.db").exists();
    }
}

