/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class SvnClientRefreshHandler
implements ISVNNotifyListener {
    private final Set<VCSFileProxy> filesToRefresh = new HashSet<VCSFileProxy>();

    @Override
    public void setCommand(ISVNNotifyListener.Command arg0) {
    }

    @Override
    public void logCommandLine(String arg0) {
    }

    @Override
    public void logMessage(String arg0) {
    }

    @Override
    public void logError(String arg0) {
    }

    @Override
    public void logRevision(long arg0, String arg1) {
    }

    @Override
    public void logCompleted(String arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotify(VCSFileProxy file, SVNNodeKind kind) {
        if (file == null) {
            return;
        }
        file = file.normalizeFile();
        Set<VCSFileProxy> set = this.filesToRefresh;
        synchronized (set) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine("scheduling for refresh: [" + file + "]");
            }
            this.filesToRefresh.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        VCSFileProxy[] fileArray;
        Set<VCSFileProxy> set = this.filesToRefresh;
        synchronized (set) {
            fileArray = this.filesToRefresh.toArray(new VCSFileProxy[this.filesToRefresh.size()]);
            this.filesToRefresh.clear();
        }
        this.refresh(fileArray);
    }

    private void refresh(VCSFileProxy ... files) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            for (VCSFileProxy file : files) {
                Subversion.LOG.fine("refreshing: [" + file + "]");
            }
        }
        Subversion.getInstance().getStatusCache().refreshAsync(files);
    }
}

