/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.notifications;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.ui.diff.DiffAction;
import org.netbeans.modules.subversion.remote.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.versioning.util.VCSNotificationDisplayer;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class NotificationsManager {
    private static NotificationsManager instance;
    private static final Logger LOG;
    private static final Set<VCSFileProxy> alreadySeen;
    private static final String CMD_DIFF = "cmd.diff";
    private final HashSet<VCSFileProxy> files;
    private final RequestProcessor rp;
    private final RequestProcessor.Task notificationTask;
    private final FileStatusCache cache;
    private Boolean enabled;
    private final Map<VCSFileProxy, Long> notifiedFiles = Collections.synchronizedMap(new HashMap());

    private NotificationsManager() {
        this.files = new HashSet();
        this.rp = new RequestProcessor("SubversionNotifications", 1, true);
        this.notificationTask = this.rp.create((Runnable)new NotificationTask());
        this.cache = Subversion.getInstance().getStatusCache();
    }

    public static synchronized NotificationsManager getInstance() {
        if (instance == null) {
            instance = new NotificationsManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFor(VCSFileProxy file) {
        boolean refresh;
        if (this.isSeen(file) || !this.isUpToDate(file) || !this.isEnabled(file, false)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "File {0} is {1} up to date, notifications enabled: {2}", new Object[]{file.getPath(), this.isUpToDate(file) ? "" : "not ", this.isEnabled(file, false)});
            }
            return;
        }
        HashSet<VCSFileProxy> hashSet = this.files;
        synchronized (hashSet) {
            int size = this.files.size();
            this.files.add(file);
            refresh = this.files.size() != size;
        }
        if (refresh) {
            this.notificationTask.schedule(1000);
        }
    }

    public void notfied(VCSFileProxy[] files, Long revision) {
        for (VCSFileProxy file : files) {
            this.notifiedFiles.put(file, revision);
        }
    }

    public void setupPane(JTextPane pane, final VCSFileProxy[] files, String fileNames, final VCSFileProxy projectDir, final String url, final String revision) {
        String msg = revision == null ? NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_DeleteDescription", (Object)fileNames, (Object)CMD_DIFF) : NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_Description", (Object)fileNames, (Object)url, (Object)CMD_DIFF);
        pane.setText(msg);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (NotificationsManager.CMD_DIFF.equals(e.getDescription())) {
                        Context ctx = new Context(files);
                        DiffAction.diff(ctx, 1, NbBundle.getMessage(NotificationsManager.class, (String)"LBL_Remote_Changes", (Object)projectDir.getName()), false);
                    } else if (revision != null) {
                        try {
                            SearchHistoryAction.openSearch(new SVNUrl(url), projectDir, Long.parseLong(revision));
                        }
                        catch (MalformedURLException ex) {
                            LOG.log(Level.WARNING, null, ex);
                        }
                    }
                }
            }
        });
    }

    private boolean isEnabled(VCSFileProxy file, boolean checkUrl) {
        if (this.enabled == null) {
            this.enabled = !"false".equals(System.getProperty("subversion.notificationsEnabled", "true"));
        }
        boolean retval = false;
        if (this.enabled.booleanValue() && !checkUrl) {
            retval = true;
        }
        return retval;
    }

    private boolean isUpToDate(VCSFileProxy file) {
        boolean upToDate = false;
        FileInformation info = this.cache.getCachedStatus(file);
        if (info == null || (info.getStatus() & 8) != 0 && !info.isDirectory()) {
            upToDate = true;
        }
        return upToDate;
    }

    private boolean isSeen(VCSFileProxy file) {
        return alreadySeen.contains(file) || this.notifiedFiles.containsKey(file);
    }

    static {
        LOG = Logger.getLogger(NotificationsManager.class.getName());
        alreadySeen = Collections.synchronizedSet(new WeakSet());
    }

    private class NotificationTask
    extends VCSNotificationDisplayer
    implements Runnable {
        private NotificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<VCSFileProxy> filesToScan;
            HashSet hashSet = NotificationsManager.this.files;
            synchronized (hashSet) {
                filesToScan = new HashSet<VCSFileProxy>(NotificationsManager.this.files);
                NotificationsManager.this.files.clear();
            }
            this.removeDirectories(filesToScan);
            this.removeSeenFiles(filesToScan);
            this.removeNotEnabled(filesToScan);
        }

        @Override
        protected void setupPane(JTextPane pane, VCSFileProxy[] files, VCSFileProxy projectDir, String url, String revision) {
            NotificationsManager.this.setupPane(pane, files, this.getFileNames(files), projectDir, url, revision);
        }

        private void removeDirectories(Collection<VCSFileProxy> filesToScan) {
            Iterator<VCSFileProxy> it = filesToScan.iterator();
            while (it.hasNext()) {
                VCSFileProxy file = it.next();
                if (file.isFile()) continue;
                it.remove();
            }
        }

        private void removeNotEnabled(Collection<VCSFileProxy> filesToScan) {
            Iterator<VCSFileProxy> it = filesToScan.iterator();
            while (it.hasNext()) {
                VCSFileProxy file = it.next();
                if (NotificationsManager.this.isEnabled(file, true)) continue;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "File {0} is probably not from kenai, notifications disabled", new Object[]{file.getPath()});
                }
                it.remove();
            }
        }

        private void removeSeenFiles(Collection<VCSFileProxy> filesToScan) {
            Iterator<VCSFileProxy> it = filesToScan.iterator();
            while (it.hasNext()) {
                VCSFileProxy file = it.next();
                if (!NotificationsManager.this.isSeen(file)) continue;
                it.remove();
            }
        }
    }
}

