/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.export;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.ui.export.ExportPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class Export
implements DocumentListener,
FocusListener,
ActionListener {
    private static final String SCAN_AFTER_EXPORT = "scan_after_export";
    private static final String EXPORT_FROM_DIRECTORY = "exportFromDirectory";
    private final VCSFileProxy fromFile;
    private final ExportPanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final DialogDescriptor dialogDescriptor;
    private final FileSystem fileSystem;

    public Export(VCSFileProxy fromFile, boolean localChanges) {
        this.fromFile = fromFile;
        this.fileSystem = VCSFileProxySupport.getFileSystem((VCSFileProxy)fromFile);
        this.panel = new ExportPanel();
        this.panel.scanCheckBox.setSelected(SvnModuleConfig.getDefault(this.fileSystem).getPreferences().getBoolean(SCAN_AFTER_EXPORT, false));
        this.panel.exportFromTextField.setText(fromFile.getPath());
        this.panel.browseToFolderButton.addActionListener(this);
        this.panel.exportToTextField.getDocument().addDocumentListener(this);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        this.okButton = new JButton(NbBundle.getMessage(Export.class, (String)"CTL_Export"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_Export"));
        this.cancelButton = new JButton(NbBundle.getMessage(Export.class, (String)"CTL_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_Cancel"));
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"), true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, null, null);
        this.okButton.setEnabled(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        this.validateUserInput();
    }

    private void validateUserInput() {
        String toPath = this.panel.exportToTextField.getText().trim();
        if (toPath.equals("")) {
            this.okButton.setEnabled(false);
            this.setErrorText(NbBundle.getMessage(Export.class, (String)"MSG_MISSING_TO_FOLDER"));
            return;
        }
        this.resetErrorText();
        this.okButton.setEnabled(true);
    }

    void setErrorText(String txt) {
        this.panel.invalidValuesLabel.setVisible(true);
        this.panel.invalidValuesLabel.setText(txt);
    }

    private void resetErrorText() {
        this.panel.invalidValuesLabel.setVisible(false);
        this.panel.invalidValuesLabel.setText("");
    }

    VCSFileProxy getToFile() {
        return VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)this.panel.exportToTextField.getText());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.validateUserInput();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseToFolderButton) {
            this.onBrowse();
        }
    }

    boolean showDialog() {
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Export.class, (String)"CTL_ExportDialog_Title"));
        dialog.setVisible(true);
        return this.dialogDescriptor.getValue() == this.okButton;
    }

    private void onBrowse() {
        VCSFileProxy defaultDir = this.defaultWorkingDirectory();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)defaultDir);
        fileChooser.setDialogTitle(NbBundle.getMessage(Export.class, (String)"BK0010"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(Export.class, (String)"BK0009"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        this.panel.exportToTextField.setText(f.getPath());
    }

    private VCSFileProxy defaultWorkingDirectory() {
        String coDir;
        VCSFileProxy defaultDir = null;
        String current = this.panel.exportFromTextField.getText();
        if (current != null && !current.trim().equals("")) {
            VCSFileProxy currentFile;
            for (currentFile = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (coDir = SvnModuleConfig.getDefault(this.fileSystem).getPreferences().get(EXPORT_FROM_DIRECTORY, null)) != null) {
            defaultDir = VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)coDir);
        }
        if (defaultDir == null) {
            defaultDir = VCSFileProxySupport.getHome((VCSFileProxy)this.fromFile);
        }
        return defaultDir;
    }

    VCSFileProxy getFromFile() {
        return this.fromFile;
    }

    boolean getScanAfterExport() {
        return this.panel.scanCheckBox.isSelected();
    }
}

